/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.compiler.truffle.runtime.hotspot.libgraal;

import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.Formatter;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Consumer;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import jdk.vm.ci.code.InstalledCode;
import jdk.vm.ci.hotspot.HotSpotSpeculationLog;
import jdk.vm.ci.meta.JavaConstant;
import jdk.vm.ci.meta.JavaKind;
import jdk.vm.ci.meta.ResolvedJavaField;
import jdk.vm.ci.meta.ResolvedJavaMethod;
import jdk.vm.ci.meta.ResolvedJavaType;
import org.graalvm.compiler.truffle.common.CompilableTruffleAST;
import org.graalvm.compiler.truffle.common.OptimizedAssumptionDependency;
import org.graalvm.compiler.truffle.common.TruffleCallNode;
import org.graalvm.compiler.truffle.common.TruffleCompilationTask;
import org.graalvm.compiler.truffle.common.TruffleCompilerListener;
import org.graalvm.compiler.truffle.common.TruffleCompilerRuntime;
import org.graalvm.compiler.truffle.common.TruffleInliningPlan;
import org.graalvm.compiler.truffle.common.TruffleMetaAccessProvider;
import org.graalvm.compiler.truffle.common.TruffleSourceLanguagePosition;
import org.graalvm.compiler.truffle.common.hotspot.HotSpotTruffleCompilerRuntime;
import org.graalvm.compiler.truffle.common.hotspot.libgraal.TruffleFromLibGraal;
import org.graalvm.compiler.truffle.runtime.OptimizedCallTarget;
import org.graalvm.compiler.truffle.runtime.hotspot.libgraal.LibGraalCompilationResultInfo;
import org.graalvm.compiler.truffle.runtime.hotspot.libgraal.LibGraalGraphInfo;
import org.graalvm.compiler.truffle.runtime.hotspot.libgraal.LibGraalStringSupplier;
import org.graalvm.libgraal.LibGraal;

final class TruffleFromLibGraalEntryPoints {
    private static final Map<Integer, JavaKind> JAVA_KINDS;

    TruffleFromLibGraalEntryPoints() {
    }

    @TruffleFromLibGraal(value=TruffleFromLibGraal.Id.ConsumeOptimizedAssumptionDependency)
    static void consumeOptimizedAssumptionDependency(Consumer<OptimizedAssumptionDependency> consumer, Object dep) {
        consumer.accept((OptimizedAssumptionDependency)dep);
    }

    @TruffleFromLibGraal(value=TruffleFromLibGraal.Id.GetCallTargetForCallNode)
    static long getCallTargetForCallNode(Object truffleRuntime, long callNodeHandle) {
        JavaConstant callNode = LibGraal.unhand(JavaConstant.class, callNodeHandle);
        JavaConstant callTarget = ((HotSpotTruffleCompilerRuntime)truffleRuntime).getCallTargetForCallNode(callNode);
        return LibGraal.translate(callTarget);
    }

    @TruffleFromLibGraal(value=TruffleFromLibGraal.Id.IsTruffleBoundary)
    static boolean isTruffleBoundary(Object truffleRuntime, long methodHandle) {
        ResolvedJavaMethod method = LibGraal.unhand(ResolvedJavaMethod.class, methodHandle);
        return ((HotSpotTruffleCompilerRuntime)truffleRuntime).isTruffleBoundary(method);
    }

    @TruffleFromLibGraal(value=TruffleFromLibGraal.Id.IsValueType)
    static boolean isValueType(Object truffleRuntime, long typeHandle) {
        ResolvedJavaType type = LibGraal.unhand(ResolvedJavaType.class, typeHandle);
        return ((HotSpotTruffleCompilerRuntime)truffleRuntime).isValueType(type);
    }

    @TruffleFromLibGraal(value=TruffleFromLibGraal.Id.GetInlineKind)
    static int getInlineKind(Object truffleRuntime, long methodHandle, boolean duringPartialEvaluation) {
        ResolvedJavaMethod method = LibGraal.unhand(ResolvedJavaMethod.class, methodHandle);
        TruffleCompilerRuntime.InlineKind inlineKind = ((HotSpotTruffleCompilerRuntime)truffleRuntime).getInlineKind(method, duringPartialEvaluation);
        return inlineKind.ordinal();
    }

    @TruffleFromLibGraal(value=TruffleFromLibGraal.Id.GetLoopExplosionKind)
    static int getLoopExplosionKind(Object truffleRuntime, long methodHandle) {
        ResolvedJavaMethod method = LibGraal.unhand(ResolvedJavaMethod.class, methodHandle);
        TruffleCompilerRuntime.LoopExplosionKind loopExplosionKind = ((HotSpotTruffleCompilerRuntime)truffleRuntime).getLoopExplosionKind(method);
        return loopExplosionKind.ordinal();
    }

    @TruffleFromLibGraal(value=TruffleFromLibGraal.Id.GetConstantFieldInfo)
    static int getConstantFieldInfo(Object truffleRuntime, long typeHandle, boolean isStatic, int fieldIndex) {
        ResolvedJavaType enclosing = LibGraal.unhand(ResolvedJavaType.class, typeHandle);
        ResolvedJavaField[] declaredFields = isStatic ? enclosing.getStaticFields() : enclosing.getInstanceFields(false);
        ResolvedJavaField field = declaredFields[fieldIndex];
        TruffleCompilerRuntime.ConstantFieldInfo constantFieldInfo = ((HotSpotTruffleCompilerRuntime)truffleRuntime).getConstantFieldInfo(field);
        if (constantFieldInfo == null) {
            return Integer.MIN_VALUE;
        }
        if (constantFieldInfo.isChildren()) {
            return -2;
        }
        if (constantFieldInfo.isChild()) {
            return -1;
        }
        return constantFieldInfo.getDimensions();
    }

    @TruffleFromLibGraal(value=TruffleFromLibGraal.Id.GetJavaKindForFrameSlotKind)
    static int getJavaKindForFrameSlotKind(Object truffleRuntime, int frameSlotKindTag) {
        JavaKind kind = ((HotSpotTruffleCompilerRuntime)truffleRuntime).getJavaKindForFrameSlotKind(frameSlotKindTag);
        return kind.getBasicType();
    }

    @TruffleFromLibGraal(value=TruffleFromLibGraal.Id.GetFrameSlotKindTagsCount)
    static int getFrameSlotKindTagsCount(Object truffleRuntime) {
        return ((HotSpotTruffleCompilerRuntime)truffleRuntime).getFrameSlotKindTagsCount();
    }

    @TruffleFromLibGraal(value=TruffleFromLibGraal.Id.GetTruffleCallBoundaryMethods)
    static long[] getTruffleCallBoundaryMethods(Object truffleRuntime) {
        ArrayList<ResolvedJavaMethod> source;
        Iterable<ResolvedJavaMethod> iterable = ((HotSpotTruffleCompilerRuntime)truffleRuntime).getTruffleCallBoundaryMethods();
        if (iterable instanceof Collection) {
            source = (ArrayList<ResolvedJavaMethod>)iterable;
        } else {
            source = new ArrayList<ResolvedJavaMethod>();
            for (ResolvedJavaMethod m : iterable) {
                source.add(m);
            }
        }
        long[] res = new long[source.size()];
        int i = 0;
        for (ResolvedJavaMethod m : source) {
            res[i++] = LibGraal.translate(m);
        }
        return res;
    }

    @TruffleFromLibGraal(value=TruffleFromLibGraal.Id.GetFrameSlotKindTagForJavaKind)
    static int getFrameSlotKindTagForJavaKind(Object truffleRuntime, int basicType) {
        JavaKind kind = TruffleFromLibGraalEntryPoints.getJavaKind(basicType);
        return ((HotSpotTruffleCompilerRuntime)truffleRuntime).getFrameSlotKindTagForJavaKind(kind);
    }

    @TruffleFromLibGraal(value=TruffleFromLibGraal.Id.Log)
    static void log(Object truffleRuntime, Object compilable, String message) {
        ((HotSpotTruffleCompilerRuntime)truffleRuntime).log((CompilableTruffleAST)compilable, message);
    }

    @TruffleFromLibGraal(value=TruffleFromLibGraal.Id.CreateInliningPlan)
    static Object createInliningPlan(Object truffleRuntime, Object compilable, Object task) {
        return ((HotSpotTruffleCompilerRuntime)truffleRuntime).createInliningPlan((CompilableTruffleAST)compilable, (TruffleCompilationTask)task);
    }

    @TruffleFromLibGraal(value=TruffleFromLibGraal.Id.RegisterOptimizedAssumptionDependency)
    static Consumer<OptimizedAssumptionDependency> registerOptimizedAssumptionDependency(Object truffleRuntime, long optimizedAssumptionHandle) {
        JavaConstant optimizedAssumption = LibGraal.unhand(JavaConstant.class, optimizedAssumptionHandle);
        return ((HotSpotTruffleCompilerRuntime)truffleRuntime).registerOptimizedAssumptionDependency(optimizedAssumption);
    }

    @TruffleFromLibGraal(value=TruffleFromLibGraal.Id.AsCompilableTruffleAST)
    static Object asCompilableTruffleAST(Object truffleRuntime, long constantHandle) {
        JavaConstant constant = LibGraal.unhand(JavaConstant.class, constantHandle);
        return ((HotSpotTruffleCompilerRuntime)truffleRuntime).asCompilableTruffleAST(constant);
    }

    @TruffleFromLibGraal(value=TruffleFromLibGraal.Id.FindDecision)
    static Object findDecision(Object inliningPlan, long callNodeHandle) {
        JavaConstant callNode = LibGraal.unhand(JavaConstant.class, callNodeHandle);
        return ((TruffleInliningPlan)inliningPlan).findDecision(callNode);
    }

    @TruffleFromLibGraal(value=TruffleFromLibGraal.Id.GetPosition)
    static Object getPosition(Object inliningPlan, long callNodeHandle) {
        JavaConstant callNode = LibGraal.unhand(JavaConstant.class, callNodeHandle);
        return ((TruffleInliningPlan)inliningPlan).getPosition(callNode);
    }

    @TruffleFromLibGraal(value=TruffleFromLibGraal.Id.GetNodeRewritingAssumption)
    static long getNodeRewritingAssumption(Object decision) {
        JavaConstant assumption = ((TruffleInliningPlan.Decision)decision).getNodeRewritingAssumption();
        return LibGraal.translate(assumption);
    }

    @TruffleFromLibGraal(value=TruffleFromLibGraal.Id.GetNodeRewritingAssumptionConstant)
    static long getNodeRewritingAssumptionConstant(Object compilable) {
        JavaConstant assumption = ((CompilableTruffleAST)compilable).getNodeRewritingAssumptionConstant();
        return LibGraal.translate(assumption);
    }

    @TruffleFromLibGraal(value=TruffleFromLibGraal.Id.GetURI)
    static String getURI(Object position) {
        URI uri = ((TruffleSourceLanguagePosition)position).getURI();
        return uri == null ? null : uri.toString();
    }

    @TruffleFromLibGraal(value=TruffleFromLibGraal.Id.AsJavaConstant)
    static long asJavaConstant(Object compilable) {
        JavaConstant constant = ((CompilableTruffleAST)compilable).asJavaConstant();
        return LibGraal.translate(constant);
    }

    @TruffleFromLibGraal(value=TruffleFromLibGraal.Id.OnCodeInstallation)
    static void onCodeInstallation(Object truffleRuntime, Object compilable, long installedCodeHandle) {
        InstalledCode installedCode = LibGraal.unhand(InstalledCode.class, installedCodeHandle);
        ((HotSpotTruffleCompilerRuntime)truffleRuntime).onCodeInstallation((CompilableTruffleAST)compilable, installedCode);
    }

    @TruffleFromLibGraal(value=TruffleFromLibGraal.Id.GetFailedSpeculationsAddress)
    static long getFailedSpeculationsAddress(Object compilable) {
        OptimizedCallTarget callTarget = (OptimizedCallTarget)compilable;
        HotSpotSpeculationLog log = (HotSpotSpeculationLog)callTarget.getSpeculationLog();
        return LibGraal.getFailedSpeculationsAddress(log);
    }

    private static JavaKind getJavaKind(int basicType) {
        JavaKind javaKind = JAVA_KINDS.get(basicType);
        if (javaKind == null) {
            throw new IllegalArgumentException("Unknown JavaKind basic type: " + basicType);
        }
        return javaKind;
    }

    @TruffleFromLibGraal(value=TruffleFromLibGraal.Id.CreateStringSupplier)
    static Supplier<String> createStringSupplier(long handle) {
        return new LibGraalStringSupplier(handle);
    }

    @TruffleFromLibGraal(value=TruffleFromLibGraal.Id.GetSuppliedString)
    static String getSuppliedString(Supplier<String> supplier) {
        return supplier.get();
    }

    @TruffleFromLibGraal(value=TruffleFromLibGraal.Id.IsCancelled)
    static boolean isCancelled(Object task) {
        return ((TruffleCompilationTask)task).isCancelled();
    }

    @TruffleFromLibGraal(value=TruffleFromLibGraal.Id.IsLastTier)
    static boolean isLastTier(Object task) {
        return ((TruffleCompilationTask)task).isLastTier();
    }

    @TruffleFromLibGraal(value=TruffleFromLibGraal.Id.CompilableToString)
    static String compilableToString(Object compilable) {
        return ((CompilableTruffleAST)compilable).toString();
    }

    @TruffleFromLibGraal(value=TruffleFromLibGraal.Id.GetCompilableName)
    static String getCompilableName(Object compilable) {
        return ((CompilableTruffleAST)compilable).getName();
    }

    @TruffleFromLibGraal(value=TruffleFromLibGraal.Id.GetDescription)
    static String getDescription(Object pos) {
        return ((TruffleSourceLanguagePosition)pos).getDescription();
    }

    @TruffleFromLibGraal(value=TruffleFromLibGraal.Id.GetLanguage)
    static String getLanguage(Object pos) {
        return ((TruffleSourceLanguagePosition)pos).getLanguage();
    }

    @TruffleFromLibGraal(value=TruffleFromLibGraal.Id.GetLineNumber)
    static int getLineNumber(Object pos) {
        return ((TruffleSourceLanguagePosition)pos).getLineNumber();
    }

    @TruffleFromLibGraal(value=TruffleFromLibGraal.Id.GetOffsetEnd)
    static int getOffsetEnd(Object pos) {
        return ((TruffleSourceLanguagePosition)pos).getOffsetEnd();
    }

    @TruffleFromLibGraal(value=TruffleFromLibGraal.Id.GetOffsetStart)
    static int getOffsetStart(Object pos) {
        return ((TruffleSourceLanguagePosition)pos).getOffsetStart();
    }

    @TruffleFromLibGraal(value=TruffleFromLibGraal.Id.GetTargetName)
    static String getTargetName(Object decision) {
        return ((TruffleInliningPlan.Decision)decision).getTargetName();
    }

    @TruffleFromLibGraal(value=TruffleFromLibGraal.Id.IsTargetStable)
    static boolean isTargetStable(Object decision) {
        return ((TruffleInliningPlan.Decision)decision).isTargetStable();
    }

    @TruffleFromLibGraal(value=TruffleFromLibGraal.Id.OnCompilationFailed)
    static void onCompilationFailed(Object compilable, Supplier<String> serializedException, boolean bailout, boolean permanentBailout) {
        ((CompilableTruffleAST)compilable).onCompilationFailed(serializedException, bailout, permanentBailout);
    }

    @TruffleFromLibGraal(value=TruffleFromLibGraal.Id.OnSuccess)
    static void onSuccess(Object listener, Object compilable, Object plan, long graphInfoHandle, long compilationResultInfoHandle) {
        try (LibGraalGraphInfo graphInfo = new LibGraalGraphInfo(graphInfoHandle);
             LibGraalCompilationResultInfo compilationResultInfo = new LibGraalCompilationResultInfo(compilationResultInfoHandle);){
            ((TruffleCompilerListener)listener).onSuccess((CompilableTruffleAST)compilable, (TruffleInliningPlan)plan, graphInfo, compilationResultInfo);
        }
    }

    @TruffleFromLibGraal(value=TruffleFromLibGraal.Id.OnFailure)
    static void onFailure(Object listener, Object compilable, String reason, boolean bailout, boolean permanentBailout) {
        ((TruffleCompilerListener)listener).onFailure((CompilableTruffleAST)compilable, reason, bailout, permanentBailout);
    }

    @TruffleFromLibGraal(value=TruffleFromLibGraal.Id.OnGraalTierFinished)
    static void onGraalTierFinished(Object listener, Object compilable, long graphInfoHandle) {
        try (LibGraalGraphInfo graphInfo = new LibGraalGraphInfo(graphInfoHandle);){
            ((TruffleCompilerListener)listener).onGraalTierFinished((CompilableTruffleAST)compilable, graphInfo);
        }
    }

    @TruffleFromLibGraal(value=TruffleFromLibGraal.Id.OnTruffleTierFinished)
    static void onTruffleTierFinished(Object listener, Object compilable, Object plan, long graphInfoHandle) {
        try (LibGraalGraphInfo graphInfo = new LibGraalGraphInfo(graphInfoHandle);){
            ((TruffleCompilerListener)listener).onTruffleTierFinished((CompilableTruffleAST)compilable, (TruffleInliningPlan)plan, graphInfo);
        }
    }

    @TruffleFromLibGraal(value=TruffleFromLibGraal.Id.ShouldInline)
    static boolean shouldInline(Object decision) {
        return ((TruffleInliningPlan.Decision)decision).shouldInline();
    }

    @TruffleFromLibGraal(value=TruffleFromLibGraal.Id.CancelCompilation)
    static boolean cancelCompilation(Object compilableTruffleAST, String reason) {
        return ((CompilableTruffleAST)compilableTruffleAST).cancelCompilation(reason);
    }

    @TruffleFromLibGraal(value=TruffleFromLibGraal.Id.FindCallNode)
    static Object findCallNode(Object provider, long callNodeHandle) {
        JavaConstant callNode = LibGraal.unhand(JavaConstant.class, callNodeHandle);
        return ((TruffleMetaAccessProvider)provider).findCallNode(callNode);
    }

    @TruffleFromLibGraal(value=TruffleFromLibGraal.Id.GetCallCount)
    static int getCallCount(Object callNode) {
        return ((TruffleCallNode)callNode).getCallCount();
    }

    @TruffleFromLibGraal(value=TruffleFromLibGraal.Id.GetCurrentCallTarget)
    static Object getCurrentCallTarget(Object truffleCallNode) {
        return ((TruffleCallNode)truffleCallNode).getCurrentCallTarget();
    }

    @TruffleFromLibGraal(value=TruffleFromLibGraal.Id.IsInliningForced)
    static boolean isInliningForced(Object truffleCallNode) {
        return ((TruffleCallNode)truffleCallNode).isInliningForced();
    }

    @TruffleFromLibGraal(value=TruffleFromLibGraal.Id.CallNodeHashCode)
    static int callNodeHashCode(Object truffleCallNode) {
        return ((TruffleCallNode)truffleCallNode).hashCode();
    }

    @TruffleFromLibGraal(value=TruffleFromLibGraal.Id.GetCompilableCallCount)
    static int getCompilableCallCount(Object compilableTruffleAST) {
        return ((CompilableTruffleAST)compilableTruffleAST).getCallCount();
    }

    @TruffleFromLibGraal(value=TruffleFromLibGraal.Id.GetCallNodes)
    static Object[] getCallNodes(Object compilableTruffleAST) {
        return ((CompilableTruffleAST)compilableTruffleAST).getCallNodes();
    }

    @TruffleFromLibGraal(value=TruffleFromLibGraal.Id.GetKnownCallSiteCount)
    static int getKnownCallSiteCount(Object compilableTruffleAST) {
        return ((CompilableTruffleAST)compilableTruffleAST).getKnownCallSiteCount();
    }

    @TruffleFromLibGraal(value=TruffleFromLibGraal.Id.IsSameOrSplit)
    static boolean isSameOrSplit(Object compilableTruffleAST1, Object compilableTruffleAST2) {
        return ((CompilableTruffleAST)compilableTruffleAST1).isSameOrSplit((CompilableTruffleAST)compilableTruffleAST2);
    }

    @TruffleFromLibGraal(value=TruffleFromLibGraal.Id.GetNonTrivialNodeCount)
    static int getNonTrivialNodeCount(Object compilableTruffleAST) {
        return ((CompilableTruffleAST)compilableTruffleAST).getNonTrivialNodeCount();
    }

    @TruffleFromLibGraal(value=TruffleFromLibGraal.Id.AddTargetToDequeue)
    static void addTargetToDequeue(Object inliningPlan, Object compilableTruffleAST) {
        ((TruffleInliningPlan)inliningPlan).addTargetToDequeue((CompilableTruffleAST)compilableTruffleAST);
    }

    @TruffleFromLibGraal(value=TruffleFromLibGraal.Id.DequeueTargets)
    static void dequeueTargets(Object inliningPlan) {
        ((TruffleInliningPlan)inliningPlan).dequeueTargets();
    }

    private static boolean checkHotSpotCalls() {
        EnumSet<TruffleFromLibGraal.Id> unimplemented = EnumSet.allOf(TruffleFromLibGraal.Id.class);
        for (Method method : TruffleFromLibGraalEntryPoints.class.getDeclaredMethods()) {
            TruffleFromLibGraal a;
            if (!Modifier.isStatic(method.getModifiers()) || (a = method.getAnnotation(TruffleFromLibGraal.class)) == null) continue;
            TruffleFromLibGraal.Id id = a.value();
            unimplemented.remove(id);
            TruffleFromLibGraalEntryPoints.check(id, id.getMethodName().equals(method.getName()), "Expected name \"%s\", got \"%s\"", id.getMethodName(), method.getName());
            TruffleFromLibGraalEntryPoints.check(id, id.getReturnType().equals(method.getReturnType()), "Expected return type %s, got %s", id.getReturnType().getName(), method.getReturnType().getName());
            TruffleFromLibGraalEntryPoints.checkParameters(id, method.getParameterTypes());
        }
        TruffleFromLibGraalEntryPoints.check(null, unimplemented.isEmpty(), "Missing implementations:%n%s", unimplemented.stream().map(TruffleFromLibGraalEntryPoints::missingImpl).sorted().collect(Collectors.joining(System.lineSeparator())));
        return true;
    }

    private static void checkParameters(TruffleFromLibGraal.Id id, Class<?>[] types) {
        Class<?>[] idTypes = id.getParameterTypes();
        TruffleFromLibGraalEntryPoints.check(id, idTypes.length == types.length, "Expected %d parameters, got %d", idTypes.length, types.length);
        for (int i = 0; i < types.length; ++i) {
            TruffleFromLibGraalEntryPoints.check(id, idTypes[i].equals(types[i]), "Parameter %d has wrong type, expected %s, got %s", i, idTypes[i].getName(), types[i].getName());
        }
    }

    private static String missingImpl(TruffleFromLibGraal.Id id) {
        Formatter buf = new Formatter();
        buf.format("    @%s(%s)%n", TruffleFromLibGraal.class.getSimpleName(), id.name());
        buf.format("    static %s %s(%s) {%n    }%n", id.getReturnType().getSimpleName(), id.getMethodName(), Stream.of(id.getParameterTypes()).map(c -> c.getSimpleName()).collect(Collectors.joining(", ")));
        return buf.toString();
    }

    private static void check(TruffleFromLibGraal.Id id, boolean condition, String format, Object ... args) {
        if (!condition) {
            String msg = String.format(format, args);
            if (id != null) {
                System.err.printf("ERROR: %s.%s: %s%n", TruffleFromLibGraalEntryPoints.class.getName(), id, msg);
            } else {
                System.err.printf("ERROR: %s: %s%n", TruffleFromLibGraalEntryPoints.class.getName(), msg);
            }
            System.exit(99);
        }
    }

    static {
        HashMap<Integer, JavaKind> m = new HashMap<Integer, JavaKind>();
        for (JavaKind jk : JavaKind.values()) {
            m.put(jk.getBasicType(), jk);
        }
        JAVA_KINDS = Collections.unmodifiableMap(m);
        assert (TruffleFromLibGraalEntryPoints.checkHotSpotCalls());
    }
}

