/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.compiler.truffle.runtime.hotspot.libgraal;

import java.io.IOException;
import java.io.OutputStream;
import java.util.Map;
import jdk.vm.ci.hotspot.HotSpotJVMCIRuntime;
import jdk.vm.ci.hotspot.HotSpotResolvedJavaType;
import jdk.vm.ci.meta.MetaAccessProvider;
import org.graalvm.compiler.truffle.common.hotspot.HotSpotTruffleCompiler;
import org.graalvm.compiler.truffle.options.PolyglotCompilerOptions;
import org.graalvm.compiler.truffle.runtime.OptimizedCallTarget;
import org.graalvm.compiler.truffle.runtime.hotspot.AbstractHotSpotTruffleRuntime;
import org.graalvm.compiler.truffle.runtime.hotspot.libgraal.LibGraalHotSpotTruffleCompiler;
import org.graalvm.compiler.truffle.runtime.hotspot.libgraal.TruffleToLibGraalCalls;
import org.graalvm.libgraal.LibGraal;
import org.graalvm.libgraal.LibGraalObject;
import org.graalvm.libgraal.LibGraalScope;
import org.graalvm.util.OptionsEncoder;

final class LibGraalTruffleRuntime
extends AbstractHotSpotTruffleRuntime {
    LibGraalTruffleRuntime() {
        HotSpotJVMCIRuntime.runtime().registerNativeMethods(TruffleToLibGraalCalls.class);
    }

    long handle() {
        try (LibGraalScope scope = new LibGraalScope();){
            long l = scope.getIsolate().getSingleton(Handle.class, () -> {
                MetaAccessProvider metaAccess = HotSpotJVMCIRuntime.runtime().getHostJVMCIBackend().getMetaAccess();
                HotSpotResolvedJavaType type = (HotSpotResolvedJavaType)metaAccess.lookupJavaType(this.getClass());
                long classLoaderDelegate = LibGraal.translate(type);
                return new Handle(TruffleToLibGraalCalls.initializeRuntime(LibGraalScope.getIsolateThread(), this, classLoaderDelegate));
            }).getHandle();
            return l;
        }
    }

    @Override
    public HotSpotTruffleCompiler newTruffleCompiler() {
        try (LibGraalScope scope = new LibGraalScope();){
            LibGraalHotSpotTruffleCompiler libGraalHotSpotTruffleCompiler = new LibGraalHotSpotTruffleCompiler(this);
            return libGraalHotSpotTruffleCompiler;
        }
    }

    @Override
    protected String initLazyCompilerConfigurationName() {
        try (LibGraalScope scope = new LibGraalScope();){
            String string = TruffleToLibGraalCalls.getCompilerConfigurationFactoryName(LibGraalScope.getIsolateThread(), this.handle());
            return string;
        }
    }

    @Override
    protected AutoCloseable openCompilerThreadScope() {
        return new LibGraalScope(LibGraalScope.DetachAction.DETACH_RUNTIME_AND_RELEASE);
    }

    @Override
    protected long getCompilerIdleDelay(OptimizedCallTarget callTarget) {
        return callTarget.getOptionValue(PolyglotCompilerOptions.CompilerIdleDelay);
    }

    @Override
    protected Map<String, Object> createInitialOptions() {
        try (LibGraalScope scope = new LibGraalScope();){
            byte[] serializedOptions = TruffleToLibGraalCalls.getInitialOptions(LibGraalScope.getIsolateThread(), this.handle());
            Map<String, Object> map = OptionsEncoder.decode(serializedOptions);
            return map;
        }
    }

    @Override
    protected OutputStream getDefaultLogStream() {
        try (LibGraalScope scope = new LibGraalScope();){
            OutputStream outputStream = scope.getIsolate().getSingleton(TTYStream.class, () -> new TTYStream());
            return outputStream;
        }
    }

    static final class TTYStream
    extends OutputStream {
        private final ThreadLocal<LibGraalScope> localScope = new ThreadLocal<LibGraalScope>(){

            @Override
            protected LibGraalScope initialValue() {
                return new LibGraalScope();
            }
        };

        TTYStream() {
        }

        private long isolateThread() {
            return this.localScope.get().getIsolateThreadAddress();
        }

        @Override
        public void write(int b) {
            TruffleToLibGraalCalls.ttyWriteByte(this.isolateThread(), b);
        }

        @Override
        public void write(byte[] b, int off, int len) {
            TruffleToLibGraalCalls.ttyWriteBytes(this.isolateThread(), b, off, len);
        }

        @Override
        public void close() throws IOException {
            this.localScope.get().close();
            this.localScope.remove();
        }
    }

    static final class Handle
    extends LibGraalObject {
        Handle(long handle) {
            super(handle);
        }
    }
}

