/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.compiler.truffle.runtime.hotspot.java;

import java.io.OutputStream;
import java.util.HashMap;
import java.util.Map;
import org.graalvm.collections.EconomicMap;
import org.graalvm.collections.UnmodifiableEconomicMap;
import org.graalvm.collections.UnmodifiableMapCursor;
import org.graalvm.compiler.debug.TTY;
import org.graalvm.compiler.hotspot.CompilerConfigurationFactory;
import org.graalvm.compiler.hotspot.HotSpotGraalOptionValues;
import org.graalvm.compiler.options.OptionDescriptors;
import org.graalvm.compiler.options.OptionKey;
import org.graalvm.compiler.options.OptionValues;
import org.graalvm.compiler.options.OptionsParser;
import org.graalvm.compiler.truffle.common.TruffleCompiler;
import org.graalvm.compiler.truffle.compiler.hotspot.HotSpotTruffleCompilerImpl;
import org.graalvm.compiler.truffle.runtime.hotspot.AbstractHotSpotTruffleRuntime;

final class HotSpotTruffleRuntime
extends AbstractHotSpotTruffleRuntime {
    HotSpotTruffleRuntime() {
    }

    @Override
    public <T> T getOptions(Class<T> optionValuesType) {
        if (optionValuesType == OptionValues.class) {
            return optionValuesType.cast(HotSpotGraalOptionValues.defaultOptions());
        }
        return (T)super.getOptions(optionValuesType);
    }

    @Override
    public <T> T convertOptions(Class<T> optionValuesType, Map<String, Object> map) {
        if (optionValuesType == OptionValues.class) {
            EconomicMap<OptionKey<?>, Object> values = OptionValues.newOptionMap();
            Iterable<OptionDescriptors> loader = OptionsParser.getOptionsLoader();
            for (Map.Entry<String, Object> e : map.entrySet()) {
                String optionName = e.getKey();
                Object optionValue = e.getValue();
                OptionsParser.parseOption(optionName, optionValue, values, loader);
            }
            return optionValuesType.cast(new OptionValues((UnmodifiableEconomicMap<OptionKey<?>, Object>)values));
        }
        return (T)super.convertOptions(optionValuesType, map);
    }

    @Override
    public Map<String, Object> createInitialOptions() {
        UnmodifiableMapCursor optionValues = this.getOptions(OptionValues.class).getMap().getEntries();
        HashMap<String, Object> res = new HashMap<String, Object>();
        while (optionValues.advance()) {
            OptionKey key = (OptionKey)optionValues.getKey();
            Object value = optionValues.getValue();
            res.put(key.getName(), value);
        }
        return res;
    }

    @Override
    protected String initLazyCompilerConfigurationName() {
        OptionValues options = this.getOptions(OptionValues.class);
        String factoryName = HotSpotTruffleCompilerImpl.Options.TruffleCompilerConfiguration.getValue(options);
        CompilerConfigurationFactory compilerConfigurationFactory = CompilerConfigurationFactory.selectFactory(factoryName, options);
        return compilerConfigurationFactory.getName();
    }

    @Override
    public TruffleCompiler newTruffleCompiler() {
        return HotSpotTruffleCompilerImpl.create(this);
    }

    @Override
    protected OutputStream getDefaultLogStream() {
        return TTY.out;
    }
}

