/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.compiler.truffle.runtime.debug;

import org.graalvm.compiler.truffle.common.TruffleCompilerListener;
import org.graalvm.compiler.truffle.options.PolyglotCompilerOptions;
import org.graalvm.compiler.truffle.runtime.AbstractGraalTruffleRuntimeListener;
import org.graalvm.compiler.truffle.runtime.GraalTruffleRuntime;
import org.graalvm.compiler.truffle.runtime.OptimizedCallTarget;
import org.graalvm.compiler.truffle.runtime.TruffleInlining;
import org.graalvm.compiler.truffle.runtime.TruffleInliningDecision;
import org.graalvm.compiler.truffle.runtime.TruffleInliningProfile;

public final class TraceInliningListener
extends AbstractGraalTruffleRuntimeListener {
    private TraceInliningListener(GraalTruffleRuntime runtime) {
        super(runtime);
    }

    public static void install(GraalTruffleRuntime runtime) {
        runtime.addListener(new TraceInliningListener(runtime));
    }

    @Override
    public void onCompilationTruffleTierFinished(OptimizedCallTarget target, TruffleInlining inliningDecision, TruffleCompilerListener.GraphInfo graph) {
        if (target.getOptionValue(PolyglotCompilerOptions.LanguageAgnosticInlining).booleanValue() || !target.getOptionValue(PolyglotCompilerOptions.TraceInlining).booleanValue() || inliningDecision == null) {
            return;
        }
        if (!target.getOptionValue(PolyglotCompilerOptions.Inlining).booleanValue()) {
            this.runtime.logEvent(target, 0, "TruffleFunctionInlining is set to false", "", null, null);
            return;
        }
        this.runtime.logEvent(target, 0, "inline start", target.getDebugProperties(null));
        this.logInliningDecisionRecursive(target, inliningDecision, 1);
        this.runtime.logEvent(target, 0, "inline done", target.getDebugProperties(inliningDecision));
    }

    private void logInliningDecisionRecursive(OptimizedCallTarget target, TruffleInlining inliningDecision, int depth) {
        for (TruffleInliningDecision decision : inliningDecision) {
            TruffleInliningProfile profile = decision.getProfile();
            boolean inlined = decision.shouldInline();
            String msg = inlined ? "inline success" : "inline failed";
            this.runtime.logEvent(target, depth, msg, decision.getProfile().getCallNode().getCurrentCallTarget().toString(), profile.getDebugProperties(), null);
            if (!inlined) continue;
            this.logInliningDecisionRecursive(target, decision, depth + 1);
        }
    }
}

