/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.compiler.truffle.runtime.debug;

import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.NodeClass;
import com.oracle.truffle.api.nodes.NodeFieldAccessor;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.List;
import org.graalvm.compiler.truffle.common.TruffleCompilerListener;
import org.graalvm.compiler.truffle.options.PolyglotCompilerOptions;
import org.graalvm.compiler.truffle.runtime.AbstractGraalTruffleRuntimeListener;
import org.graalvm.compiler.truffle.runtime.GraalTruffleRuntime;
import org.graalvm.compiler.truffle.runtime.OptimizedCallTarget;
import org.graalvm.compiler.truffle.runtime.TruffleInlining;

public final class TraceASTCompilationListener
extends AbstractGraalTruffleRuntimeListener {
    private TraceASTCompilationListener(GraalTruffleRuntime runtime) {
        super(runtime);
    }

    public static void install(GraalTruffleRuntime runtime) {
        runtime.addListener(new TraceASTCompilationListener(runtime));
    }

    @Override
    public void onCompilationSuccess(OptimizedCallTarget target, TruffleInlining inliningDecision, TruffleCompilerListener.GraphInfo graphInfo, TruffleCompilerListener.CompilationResultInfo compilationResultInfo) {
        if (target.getOptionValue(PolyglotCompilerOptions.TraceCompilationAST).booleanValue()) {
            StringWriter logMessage = new StringWriter();
            try (PrintWriter out = new PrintWriter(logMessage);){
                TraceASTCompilationListener.printCompactTree(out, target, inliningDecision);
            }
            this.runtime.logEvent(target, 0, "opt AST", target.toString(), target.getDebugProperties(inliningDecision), logMessage.toString());
        }
    }

    private static void printCompactTree(final PrintWriter out, OptimizedCallTarget target, TruffleInlining inliningDecision) {
        target.accept(new TruffleInlining.CallTreeNodeVisitor(){
            private boolean newLine = false;

            @Override
            public boolean visit(List<TruffleInlining> decisionStack, Node node) {
                if (node == null) {
                    return true;
                }
                int level = TruffleInlining.CallTreeNodeVisitor.getNodeDepth(decisionStack, node);
                StringBuilder indent = new StringBuilder();
                for (int i = 0; i < level; ++i) {
                    indent.append("  ");
                }
                Node parent = node.getParent();
                if (this.newLine) {
                    out.println();
                } else {
                    this.newLine = true;
                }
                if (parent == null) {
                    out.printf("%s%s", indent, node.getClass().getSimpleName());
                } else {
                    String fieldName = this.getFieldName(parent, node);
                    out.printf("%s%s = %s", indent, fieldName, node.getClass().getSimpleName());
                }
                return true;
            }

            private String getFieldName(Node parent, Node node) {
                for (NodeFieldAccessor field : NodeClass.get((Node)parent).getFields()) {
                    Object value = field.loadValue(parent);
                    if (value == node) {
                        return field.getName();
                    }
                    if (!(value instanceof Node[])) continue;
                    int index = 0;
                    for (Node arrayNode : (Node[])value) {
                        if (arrayNode == node) {
                            return field.getName() + "[" + index + "]";
                        }
                        ++index;
                    }
                }
                return "unknownField";
            }
        }, inliningDecision);
    }
}

