/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.compiler.truffle.runtime.debug;

import com.oracle.truffle.api.TruffleLogger;
import com.oracle.truffle.api.nodes.DirectCallNode;
import com.oracle.truffle.api.nodes.IndirectCallNode;
import com.oracle.truffle.api.nodes.LoopNode;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.NodeCost;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.IntSummaryStatistics;
import java.util.List;
import java.util.LongSummaryStatistics;
import java.util.Map;
import java.util.TreeSet;
import java.util.function.Function;
import java.util.logging.Level;
import org.graalvm.compiler.truffle.common.TruffleCompilerListener;
import org.graalvm.compiler.truffle.runtime.AbstractGraalTruffleRuntimeListener;
import org.graalvm.compiler.truffle.runtime.EngineData;
import org.graalvm.compiler.truffle.runtime.GraalTruffleRuntime;
import org.graalvm.compiler.truffle.runtime.OptimizedCallTarget;
import org.graalvm.compiler.truffle.runtime.OptimizedDirectCallNode;
import org.graalvm.compiler.truffle.runtime.TruffleInlining;
import org.graalvm.compiler.truffle.runtime.TruffleInliningDecision;

public final class StatisticsListener
extends AbstractGraalTruffleRuntimeListener {
    private long firstCompilation;
    private int compilations;
    private int invalidations;
    private int failures;
    private int success;
    private int queues;
    private int dequeues;
    private int splits;
    private final LongSummaryStatistics timeToQueue = new LongSummaryStatistics();
    private final LongSummaryStatistics timeToCompilation = new LongSummaryStatistics();
    private final IntSummaryStatistics nodeCount = new IntSummaryStatistics();
    private final IntSummaryStatistics nodeCountTrivial = new IntSummaryStatistics();
    private final IntSummaryStatistics nodeCountNonTrivial = new IntSummaryStatistics();
    private final IntSummaryStatistics nodeCountMonomorphic = new IntSummaryStatistics();
    private final IntSummaryStatistics nodeCountPolymorphic = new IntSummaryStatistics();
    private final IntSummaryStatistics nodeCountMegamorphic = new IntSummaryStatistics();
    private final IdentityStatistics<Class<?>> nodeStatistics = new IdentityStatistics();
    private final IntSummaryStatistics callCount = new IntSummaryStatistics();
    private final IntSummaryStatistics callCountIndirect = new IntSummaryStatistics();
    private final IntSummaryStatistics callCountDirect = new IntSummaryStatistics();
    private final IntSummaryStatistics callCountDirectDispatched = new IntSummaryStatistics();
    private final IntSummaryStatistics callCountDirectInlined = new IntSummaryStatistics();
    private final IntSummaryStatistics callCountDirectCloned = new IntSummaryStatistics();
    private final IntSummaryStatistics callCountDirectNotCloned = new IntSummaryStatistics();
    private final IntSummaryStatistics loopCount = new IntSummaryStatistics();
    private final LongSummaryStatistics compilationTime = new LongSummaryStatistics();
    private final LongSummaryStatistics compilationTimeTruffleTier = new LongSummaryStatistics();
    private final LongSummaryStatistics compilationTimeGraalTier = new LongSummaryStatistics();
    private final LongSummaryStatistics compilationTimeCodeInstallation = new LongSummaryStatistics();
    private final IntSummaryStatistics truffleTierNodeCount = new IntSummaryStatistics();
    private final IdentityStatistics<String> truffleTierNodeStatistics = new IdentityStatistics();
    private final IntSummaryStatistics graalTierNodeCount = new IntSummaryStatistics();
    private final IdentityStatistics<String> graalTierNodeStatistics = new IdentityStatistics();
    private final IntSummaryStatistics compilationResultCodeSize = new IntSummaryStatistics();
    private final IntSummaryStatistics compilationResultExceptionHandlers = new IntSummaryStatistics();
    private final IntSummaryStatistics compilationResultInfopoints = new IntSummaryStatistics();
    private final IdentityStatistics<String> compilationResultInfopointStatistics = new IdentityStatistics();
    private final IntSummaryStatistics compilationResultMarks = new IntSummaryStatistics();
    private final IntSummaryStatistics compilationResultTotalFrameSize = new IntSummaryStatistics();
    private final IntSummaryStatistics compilationResultDataPatches = new IntSummaryStatistics();
    private final ThreadLocal<Times> compilationTimes = new ThreadLocal();

    private StatisticsListener(GraalTruffleRuntime runtime) {
        super(runtime);
    }

    public static void install(GraalTruffleRuntime runtime) {
        runtime.addListener(new StatisticsDispatcher(runtime));
    }

    public static StatisticsListener createEngineListener(GraalTruffleRuntime runtime) {
        return new StatisticsListener(runtime);
    }

    @Override
    public synchronized void onCompilationSplit(OptimizedDirectCallNode callNode) {
        ++this.splits;
    }

    @Override
    public synchronized void onCompilationQueued(OptimizedCallTarget target) {
        long timeStamp;
        ++this.queues;
        if (this.firstCompilation == 0L) {
            this.firstCompilation = System.nanoTime();
        }
        if ((timeStamp = target.getInitializedTimestamp()) != 0L) {
            this.timeToQueue.accept(System.nanoTime() - timeStamp);
        }
    }

    @Override
    public synchronized void onCompilationDequeued(OptimizedCallTarget target, Object source, CharSequence reason) {
        ++this.dequeues;
    }

    @Override
    public synchronized void onCompilationInvalidated(OptimizedCallTarget target, Object source, CharSequence reason) {
        ++this.invalidations;
    }

    @Override
    public synchronized void onCompilationStarted(OptimizedCallTarget target) {
        ++this.compilations;
        Times times = new Times();
        this.compilationTimes.set(times);
        long timeStamp = target.getInitializedTimestamp();
        if (timeStamp != 0L) {
            this.timeToCompilation.accept(times.compilationStarted - timeStamp);
        }
    }

    @Override
    public synchronized void onCompilationTruffleTierFinished(OptimizedCallTarget target, TruffleInlining inliningDecision, TruffleCompilerListener.GraphInfo graph) {
        Times times = this.compilationTimes.get();
        times.truffleTierFinished = System.nanoTime();
        this.nodeStatistics.accept(StatisticsListener.nodeClasses(target, inliningDecision));
        CallTargetNodeStatistics callTargetStat = new CallTargetNodeStatistics(target, inliningDecision);
        this.nodeCount.accept(callTargetStat.getNodeCount());
        this.nodeCountTrivial.accept(callTargetStat.getNodeCountTrivial());
        this.nodeCountNonTrivial.accept(callTargetStat.getNodeCountNonTrivial());
        this.nodeCountMonomorphic.accept(callTargetStat.getNodeCountMonomorphic());
        this.nodeCountPolymorphic.accept(callTargetStat.getNodeCountPolymorphic());
        this.nodeCountMegamorphic.accept(callTargetStat.getNodeCountMegamorphic());
        this.callCount.accept(callTargetStat.getCallCount());
        this.callCountIndirect.accept(callTargetStat.getCallCountIndirect());
        this.callCountDirect.accept(callTargetStat.getCallCountDirect());
        this.callCountDirectDispatched.accept(callTargetStat.getCallCountDirectDispatched());
        this.callCountDirectInlined.accept(callTargetStat.getCallCountDirectInlined());
        this.callCountDirectCloned.accept(callTargetStat.getCallCountDirectCloned());
        this.callCountDirectNotCloned.accept(callTargetStat.getCallCountDirectNotCloned());
        this.loopCount.accept(callTargetStat.getLoopCount());
        this.truffleTierNodeCount.accept(graph.getNodeCount());
        if (target.engine.callTargetStatisticDetails) {
            this.truffleTierNodeStatistics.accept(Arrays.asList(graph.getNodeTypes(true)));
        }
    }

    private static Collection<Class<?>> nodeClasses(OptimizedCallTarget target, TruffleInlining inliningDecision) {
        ArrayList nodeClasses = new ArrayList();
        for (Node node : target.nodeIterable(inliningDecision)) {
            if (node == null) continue;
            nodeClasses.add(node.getClass());
        }
        return nodeClasses;
    }

    @Override
    public synchronized void onCompilationGraalTierFinished(OptimizedCallTarget target, TruffleCompilerListener.GraphInfo graph) {
        Times times = this.compilationTimes.get();
        times.graalTierFinished = System.nanoTime();
        this.graalTierNodeCount.accept(graph.getNodeCount());
        if (target.engine.callTargetStatisticDetails) {
            this.graalTierNodeStatistics.accept(Arrays.asList(graph.getNodeTypes(true)));
        }
    }

    @Override
    public synchronized void onCompilationSuccess(OptimizedCallTarget target, TruffleInlining inliningDecision, TruffleCompilerListener.GraphInfo graph, TruffleCompilerListener.CompilationResultInfo result) {
        ++this.success;
        long compilationDone = System.nanoTime();
        Times times = this.compilationTimes.get();
        this.compilationTime.accept(compilationDone - times.compilationStarted);
        this.compilationTimeTruffleTier.accept(times.truffleTierFinished - times.compilationStarted);
        this.compilationTimeGraalTier.accept(times.graalTierFinished - times.truffleTierFinished);
        this.compilationTimeCodeInstallation.accept(compilationDone - times.graalTierFinished);
        this.compilationResultCodeSize.accept(result.getTargetCodeSize());
        this.compilationResultTotalFrameSize.accept(result.getTotalFrameSize());
        this.compilationResultExceptionHandlers.accept(result.getExceptionHandlersCount());
        this.compilationResultInfopoints.accept(result.getInfopointsCount());
        this.compilationResultInfopointStatistics.accept(Arrays.asList(result.getInfopoints()));
        this.compilationResultMarks.accept(result.getMarksCount());
        this.compilationResultDataPatches.accept(result.getDataPatchesCount());
    }

    @Override
    public void onCompilationFailed(OptimizedCallTarget target, String reason, boolean bailout, boolean permanentBailout) {
        ++this.failures;
        Times times = this.compilationTimes.get();
        this.compilationTime.accept(System.nanoTime() - times.compilationStarted);
    }

    @Override
    public void onEngineClosed(EngineData runtimeData) {
        this.printStatistics(runtimeData);
    }

    private void printStatistics(EngineData runtimeData) {
        GraalTruffleRuntime rt = this.runtime;
        long endTime = System.nanoTime();
        StringWriter logMessage = new StringWriter();
        try (PrintWriter out = new PrintWriter(logMessage);){
            out.print("Truffle runtime statistics for engine " + runtimeData.id);
            StatisticsListener.printStatistic(out, "Compilations", this.compilations);
            StatisticsListener.printStatistic(out, "  Success", this.success);
            StatisticsListener.printStatistic(out, "  Failed", this.failures);
            StatisticsListener.printStatistic(out, "  Interrupted", this.compilations - (this.success + this.failures));
            StatisticsListener.printStatistic(out, "Invalidated", this.invalidations);
            StatisticsListener.printStatistic(out, "Queues", this.queues);
            StatisticsListener.printStatistic(out, "Dequeues", this.dequeues);
            StatisticsListener.printStatistic(out, "Splits", this.splits);
            StatisticsListener.printStatistic(out, "Compilation Accuracy", 1.0 - (double)this.invalidations / (double)this.compilations);
            StatisticsListener.printStatistic(out, "Queue Accuracy", 1.0 - (double)this.dequeues / (double)this.queues);
            StatisticsListener.printStatistic(out, "Compilation Utilization", (double)this.compilationTime.getSum() / (double)(endTime - this.firstCompilation));
            StatisticsListener.printStatistic(out, "Remaining Compilation Queue", rt.getCompilationQueueSize());
            StatisticsListener.printStatisticTime(out, "Time to queue", this.timeToQueue);
            StatisticsListener.printStatisticTime(out, "Time to compilation", this.timeToCompilation);
            StatisticsListener.printStatisticTime(out, "Compilation time", this.compilationTime);
            StatisticsListener.printStatisticTime(out, "  Truffle Tier", this.compilationTimeTruffleTier);
            StatisticsListener.printStatisticTime(out, "  Graal Tier", this.compilationTimeGraalTier);
            StatisticsListener.printStatisticTime(out, "  Code Installation", this.compilationTimeCodeInstallation);
            StatisticsListener.printStatistic(out, "Truffle node count", this.nodeCount);
            StatisticsListener.printStatistic(out, "  Trivial", this.nodeCountTrivial);
            StatisticsListener.printStatistic(out, "  Non Trivial", this.nodeCountNonTrivial);
            StatisticsListener.printStatistic(out, "    Monomorphic", this.nodeCountMonomorphic);
            StatisticsListener.printStatistic(out, "    Polymorphic", this.nodeCountPolymorphic);
            StatisticsListener.printStatistic(out, "    Megamorphic", this.nodeCountMegamorphic);
            StatisticsListener.printStatistic(out, "Truffle call count", this.callCount);
            StatisticsListener.printStatistic(out, "  Indirect", this.callCountIndirect);
            StatisticsListener.printStatistic(out, "  Direct", this.callCountDirect);
            StatisticsListener.printStatistic(out, "    Dispatched", this.callCountDirectDispatched);
            StatisticsListener.printStatistic(out, "    Inlined", this.callCountDirectInlined);
            StatisticsListener.printStatistic(out, "    ----------");
            StatisticsListener.printStatistic(out, "    Cloned", this.callCountDirectCloned);
            StatisticsListener.printStatistic(out, "    Not Cloned", this.callCountDirectNotCloned);
            StatisticsListener.printStatistic(out, "Truffle loops", this.loopCount);
            StatisticsListener.printStatistic(out, "Graal node count");
            StatisticsListener.printStatistic(out, "  After Truffle Tier", this.truffleTierNodeCount);
            StatisticsListener.printStatistic(out, "  After Graal Tier", this.graalTierNodeCount);
            StatisticsListener.printStatistic(out, "Graal compilation result");
            StatisticsListener.printStatistic(out, "  Code size", this.compilationResultCodeSize);
            StatisticsListener.printStatistic(out, "  Total frame size", this.compilationResultTotalFrameSize);
            StatisticsListener.printStatistic(out, "  Exception handlers", this.compilationResultExceptionHandlers);
            StatisticsListener.printStatistic(out, "  Infopoints", this.compilationResultInfopoints);
            this.compilationResultInfopointStatistics.printStatistics(out, Function.identity());
            StatisticsListener.printStatistic(out, "  Marks", this.compilationResultMarks);
            StatisticsListener.printStatistic(out, "  Data references", this.compilationResultDataPatches);
            if (runtimeData.callTargetStatisticDetails) {
                StatisticsListener.printStatistic(out, "Truffle nodes");
                this.nodeStatistics.printStatistics(out, Class::getSimpleName);
                StatisticsListener.printStatistic(out, "Graal nodes after Truffle tier");
                this.truffleTierNodeStatistics.printStatistics(out, Function.identity());
                StatisticsListener.printStatistic(out, "Graal nodes after Graal tier");
                this.graalTierNodeStatistics.printStatistics(out, Function.identity());
            }
        }
        TruffleLogger logger = runtimeData.getLogger();
        logger.log(Level.INFO, logMessage.toString());
    }

    private static void printStatistic(PrintWriter out, String label) {
        out.printf("%n  %-50s:", label);
    }

    private static void printStatistic(PrintWriter out, String label, int value) {
        out.printf("%n  %-50s: %d", label, value);
    }

    private static void printStatistic(PrintWriter out, String label, double value) {
        out.printf("%n  %-50s: %f", label, value);
    }

    private static void printStatistic(PrintWriter out, String label, IntSummaryStatistics value) {
        out.printf("%n  %-50s: count=%4d, sum=%8d, min=%8d, average=%12.2f, max=%8d", label, value.getCount(), value.getSum(), value.getMin(), value.getAverage(), value.getMax());
    }

    private static void printStatisticTime(PrintWriter out, String label, LongSummaryStatistics value) {
        out.printf("%n  %-50s: count=%4d, sum=%8d, min=%8d, average=%12.2f, max=%8d (milliseconds)", label, value.getCount(), value.getSum() / 1000000L, value.getMin() / 1000000L, value.getAverage() / 1000000.0, value.getMax() / 1000000L);
    }

    private static final class StatisticsDispatcher
    extends AbstractGraalTruffleRuntimeListener {
        private StatisticsDispatcher(GraalTruffleRuntime runtime) {
            super(runtime);
        }

        @Override
        public void onCompilationQueued(OptimizedCallTarget target) {
            StatisticsListener listener = target.engine.statisticsListener;
            if (listener != null) {
                listener.onCompilationQueued(target);
            }
        }

        @Override
        public void onCompilationStarted(OptimizedCallTarget target) {
            StatisticsListener listener = target.engine.statisticsListener;
            if (listener != null) {
                listener.onCompilationStarted(target);
            }
        }

        @Override
        public void onCompilationSplit(OptimizedDirectCallNode callNode) {
            StatisticsListener listener = callNode.getCallTarget().engine.statisticsListener;
            if (listener != null) {
                listener.onCompilationSplit(callNode);
            }
        }

        @Override
        public void onCompilationSplitFailed(OptimizedDirectCallNode callNode, CharSequence reason) {
            StatisticsListener listener = callNode.getCallTarget().engine.statisticsListener;
            if (listener != null) {
                listener.onCompilationSplitFailed(callNode, reason);
            }
        }

        @Override
        public void onCompilationDequeued(OptimizedCallTarget target, Object source, CharSequence reason) {
            StatisticsListener listener = target.engine.statisticsListener;
            if (listener != null) {
                listener.onCompilationDequeued(target, source, reason);
            }
        }

        @Override
        public void onCompilationInvalidated(OptimizedCallTarget target, Object source, CharSequence reason) {
            StatisticsListener listener = target.engine.statisticsListener;
            if (listener != null) {
                listener.onCompilationInvalidated(target, source, reason);
            }
        }

        @Override
        public void onCompilationTruffleTierFinished(OptimizedCallTarget target, TruffleInlining inliningDecision, TruffleCompilerListener.GraphInfo graph) {
            StatisticsListener listener = target.engine.statisticsListener;
            if (listener != null) {
                listener.onCompilationTruffleTierFinished(target, inliningDecision, graph);
            }
        }

        @Override
        public void onCompilationGraalTierFinished(OptimizedCallTarget target, TruffleCompilerListener.GraphInfo graph) {
            StatisticsListener listener = target.engine.statisticsListener;
            if (listener != null) {
                listener.onCompilationGraalTierFinished(target, graph);
            }
        }

        @Override
        public void onCompilationSuccess(OptimizedCallTarget target, TruffleInlining inliningDecision, TruffleCompilerListener.GraphInfo graph, TruffleCompilerListener.CompilationResultInfo result) {
            StatisticsListener listener = target.engine.statisticsListener;
            if (listener != null) {
                listener.onCompilationSuccess(target, inliningDecision, graph, result);
            }
        }

        @Override
        public void onCompilationFailed(OptimizedCallTarget target, String reason, boolean bailout, boolean permanentBailout) {
            StatisticsListener listener = target.engine.statisticsListener;
            if (listener != null) {
                listener.onCompilationFailed(target, reason, bailout, permanentBailout);
            }
        }

        @Override
        public void onEngineClosed(EngineData runtimeData) {
            StatisticsListener listener = runtimeData.statisticsListener;
            if (listener != null) {
                listener.onEngineClosed(runtimeData);
            }
        }
    }

    static class Times {
        final long compilationStarted = System.nanoTime();
        long truffleTierFinished;
        long graalTierFinished;

        Times() {
        }
    }

    private static final class CallTargetNodeStatistics {
        private int nodeCountTrivial;
        private int nodeCountNonTrivial;
        private int nodeCountMonomorphic;
        private int nodeCountPolymorphic;
        private int nodeCountMegamorphic;
        private int callCountIndirect;
        private int callCountDirectDispatched;
        private int callCountDirectInlined;
        private int callCountDirectCloned;
        private int callCountDirectNotCloned;
        private int loopCount;

        CallTargetNodeStatistics(OptimizedCallTarget target, TruffleInlining inliningDecision) {
            target.accept(this::visitNode, inliningDecision);
        }

        private boolean visitNode(List<TruffleInlining> stack, Node node) {
            if (node == null) {
                return true;
            }
            NodeCost cost = node.getCost();
            if (cost.isTrivial()) {
                ++this.nodeCountTrivial;
            } else {
                ++this.nodeCountNonTrivial;
                if (cost == NodeCost.MONOMORPHIC) {
                    ++this.nodeCountMonomorphic;
                } else if (cost == NodeCost.POLYMORPHIC) {
                    ++this.nodeCountPolymorphic;
                } else if (cost == NodeCost.MEGAMORPHIC) {
                    ++this.nodeCountMegamorphic;
                }
            }
            if (node instanceof DirectCallNode) {
                TruffleInliningDecision decision = TruffleInlining.CallTreeNodeVisitor.getCurrentInliningDecision(stack);
                if (decision != null && decision.getProfile().getCallNode() == node && decision.shouldInline()) {
                    ++this.callCountDirectInlined;
                } else {
                    ++this.callCountDirectDispatched;
                }
                if (decision != null && decision.getProfile().getCallNode().isCallTargetCloned()) {
                    ++this.callCountDirectCloned;
                } else {
                    ++this.callCountDirectNotCloned;
                }
            } else if (node instanceof IndirectCallNode) {
                ++this.callCountIndirect;
            } else if (node instanceof LoopNode) {
                ++this.loopCount;
            }
            return true;
        }

        public int getCallCountDirectCloned() {
            return this.callCountDirectCloned;
        }

        public int getCallCountDirectNotCloned() {
            return this.callCountDirectNotCloned;
        }

        public int getNodeCount() {
            return this.nodeCountTrivial + this.nodeCountNonTrivial;
        }

        public int getCallCount() {
            return this.getCallCountDirect() + this.callCountIndirect;
        }

        public int getCallCountDirect() {
            return this.callCountDirectDispatched + this.callCountDirectInlined;
        }

        public int getNodeCountTrivial() {
            return this.nodeCountTrivial;
        }

        public int getNodeCountNonTrivial() {
            return this.nodeCountNonTrivial;
        }

        public int getNodeCountMonomorphic() {
            return this.nodeCountMonomorphic;
        }

        public int getNodeCountPolymorphic() {
            return this.nodeCountPolymorphic;
        }

        public int getNodeCountMegamorphic() {
            return this.nodeCountMegamorphic;
        }

        public int getCallCountIndirect() {
            return this.callCountIndirect;
        }

        public int getCallCountDirectDispatched() {
            return this.callCountDirectDispatched;
        }

        public int getCallCountDirectInlined() {
            return this.callCountDirectInlined;
        }

        public int getLoopCount() {
            return this.loopCount;
        }
    }

    private static final class IdentityStatistics<T> {
        final Map<T, IntSummaryStatistics> types = new HashMap<T, IntSummaryStatistics>();

        private IdentityStatistics() {
        }

        public void printStatistics(PrintWriter out, Function<T, String> toStringFunction) {
            TreeSet<Object> sortedSet = new TreeSet<Object>(Comparator.comparing(c -> -this.types.get(c).getSum()));
            sortedSet.addAll(this.types.keySet());
            sortedSet.forEach(c -> StatisticsListener.printStatistic(out, String.format("    %s", toStringFunction.apply(c)), this.types.get(c)));
        }

        public void accept(Collection<T> elements) {
            HashMap<Object, Integer> histogram = new HashMap<Object, Integer>();
            for (T t : elements) {
                histogram.compute(t, (key, count) -> count == null ? 1 : count + 1);
            }
            for (Map.Entry entry : histogram.entrySet()) {
                Object element = entry.getKey();
                Integer count2 = (Integer)entry.getValue();
                this.types.computeIfAbsent(element, key -> new IntSummaryStatistics()).accept(count2);
            }
        }
    }
}

