/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.compiler.truffle.runtime.debug;

import com.oracle.truffle.api.frame.Frame;
import com.oracle.truffle.api.nodes.Node;
import java.util.Iterator;
import java.util.concurrent.atomic.AtomicLong;
import org.graalvm.compiler.truffle.common.TruffleCompilerListener;
import org.graalvm.compiler.truffle.jfr.CompilationEvent;
import org.graalvm.compiler.truffle.jfr.CompilationStatisticsEvent;
import org.graalvm.compiler.truffle.jfr.DeoptimizationEvent;
import org.graalvm.compiler.truffle.jfr.EventFactory;
import org.graalvm.compiler.truffle.jfr.InvalidationEvent;
import org.graalvm.compiler.truffle.runtime.AbstractGraalTruffleRuntimeListener;
import org.graalvm.compiler.truffle.runtime.GraalTruffleRuntime;
import org.graalvm.compiler.truffle.runtime.OptimizedCallTarget;
import org.graalvm.compiler.truffle.runtime.OptimizedDirectCallNode;
import org.graalvm.compiler.truffle.runtime.TruffleInlining;
import org.graalvm.compiler.truffle.runtime.debug.CompilerDebugAccessor;
import org.graalvm.compiler.truffle.runtime.serviceprovider.TruffleRuntimeServices;
import org.graalvm.nativeimage.ImageInfo;

public final class JFRListener
extends AbstractGraalTruffleRuntimeListener {
    private static final EventFactory factory;
    private final ThreadLocal<CompilationData> currentCompilation = new ThreadLocal();
    private final Statistics statistics = new Statistics();

    private JFRListener(GraalTruffleRuntime runtime) {
        super(runtime);
        factory.addPeriodicEvent(CompilationStatisticsEvent.class, this.statistics);
    }

    public static void install(GraalTruffleRuntime runtime) {
        if (factory != null) {
            runtime.addListener(new JFRListener(runtime));
        }
    }

    @Override
    public void onCompilationStarted(OptimizedCallTarget target) {
        CompilationEvent event = null;
        if (factory != null) {
            event = factory.createCompilationEvent();
            if (event.isEnabled()) {
                event.setRootFunction(target);
                event.compilationStarted();
            } else {
                event = null;
            }
        }
        this.currentCompilation.set(new CompilationData(event));
    }

    @Override
    public void onCompilationDeoptimized(OptimizedCallTarget target, Frame frame) {
        DeoptimizationEvent event;
        if (factory != null && (event = factory.createDeoptimizationEvent()).isEnabled()) {
            event.setRootFunction(target);
            event.publish();
        }
    }

    @Override
    public void onCompilationTruffleTierFinished(OptimizedCallTarget target, TruffleInlining inliningDecision, TruffleCompilerListener.GraphInfo graph) {
        CompilationData data = this.getCurrentData();
        if (data.event != null) {
            data.partialEvalNodeCount = graph.getNodeCount();
        }
    }

    @Override
    public void onCompilationFailed(OptimizedCallTarget target, String reason, boolean bailout, boolean permanentBailout) {
        CompilationData data = this.getCurrentData();
        this.statistics.finishCompilation(data.finish(), bailout, 0);
        if (data.event != null) {
            data.event.failed(JFRListener.isPermanentFailure(bailout, permanentBailout), reason);
            data.event.publish();
        }
        this.currentCompilation.remove();
    }

    @Override
    public void onCompilationSuccess(OptimizedCallTarget target, TruffleInlining inliningDecision, TruffleCompilerListener.GraphInfo graph, TruffleCompilerListener.CompilationResultInfo result) {
        CompilationData data = this.getCurrentData();
        int compiledCodeSize = result.getTargetCodeSize();
        this.statistics.finishCompilation(data.finish(), false, compiledCodeSize);
        if (data.event != null) {
            int inlinedCalls;
            CompilationEvent event = data.event;
            event.succeeded();
            event.setCompiledCodeSize(compiledCodeSize);
            if (target.getCodeAddress() != 0L) {
                event.setCompiledCodeAddress(target.getCodeAddress());
            }
            int calls = 0;
            if (inliningDecision == null) {
                for (Node node : target.nodeIterable(null)) {
                    if (!(node instanceof OptimizedDirectCallNode)) continue;
                    ++calls;
                }
                inlinedCalls = 0;
            } else {
                calls = inliningDecision.countCalls();
                inlinedCalls = inliningDecision.countInlinedCalls();
            }
            int dispatchedCalls = calls - inlinedCalls;
            event.setInlinedCalls(inlinedCalls);
            event.setDispatchedCalls(dispatchedCalls);
            event.setGraalNodeCount(graph.getNodeCount());
            event.setPartialEvaluationNodeCount(data.partialEvalNodeCount);
            event.publish();
            this.currentCompilation.remove();
        }
    }

    @Override
    public void onCompilationInvalidated(OptimizedCallTarget target, Object source, CharSequence reason) {
        InvalidationEvent event;
        this.statistics.invalidations.incrementAndGet();
        if (factory != null && (event = factory.createInvalidationEvent()).isEnabled()) {
            event.setRootFunction(target);
            event.setReason(reason);
            event.publish();
        }
    }

    private CompilationData getCurrentData() {
        return this.currentCompilation.get();
    }

    private static boolean isPermanentFailure(boolean bailout, boolean permanentBailout) {
        return !bailout || permanentBailout;
    }

    static {
        if (ImageInfo.inImageCode()) {
            factory = null;
        } else {
            EventFactory.Provider provider;
            Iterator<EventFactory.Provider> it = TruffleRuntimeServices.load(EventFactory.Provider.class).iterator();
            EventFactory.Provider provider2 = provider = it.hasNext() ? it.next() : null;
            if (provider == null) {
                factory = null;
            } else {
                CompilerDebugAccessor.jdkServicesAccessor().exportTo(provider.getClass());
                factory = provider == null ? null : provider.getEventFactory();
            }
        }
    }

    private static final class Statistics
    implements Runnable {
        private long compiledMethods;
        private long bailouts;
        private long compiledCodeSize;
        private long totalTime;
        private int peakTime;
        final AtomicLong invalidations = new AtomicLong();

        Statistics() {
        }

        synchronized void finishCompilation(int time, boolean bailout, int codeSize) {
            ++this.compiledMethods;
            if (bailout) {
                ++this.bailouts;
            }
            this.compiledCodeSize += (long)codeSize;
            this.totalTime += (long)time;
            this.peakTime = Math.max(this.peakTime, time);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            CompilationStatisticsEvent event = factory.createCompilationStatisticsEvent();
            if (event.isEnabled()) {
                Statistics statistics = this;
                synchronized (statistics) {
                    event.setCompiledMethods(this.compiledMethods);
                    event.setBailouts(this.bailouts);
                    event.setInvalidations(this.invalidations.get());
                    event.setCompiledCodeSize(this.compiledCodeSize);
                    event.setTotalTime(this.totalTime);
                    event.setPeakTime(this.peakTime);
                    event.publish();
                }
            }
        }
    }

    private static final class CompilationData {
        final CompilationEvent event;
        final long startTime;
        int partialEvalNodeCount;

        CompilationData(CompilationEvent event) {
            this.event = event;
            this.startTime = System.nanoTime();
        }

        int finish() {
            return (int)(System.nanoTime() - this.startTime) / 1000000;
        }
    }
}

