/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.compiler.truffle.runtime;

import java.util.EnumSet;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import jdk.vm.ci.common.NativeImageReinitialize;
import org.graalvm.collections.EconomicMap;
import org.graalvm.collections.Equivalence;
import org.graalvm.collections.Pair;
import org.graalvm.collections.UnmodifiableEconomicMap;
import org.graalvm.compiler.truffle.common.SharedTruffleOptions;
import org.graalvm.compiler.truffle.common.TruffleCompilerRuntime;
import org.graalvm.compiler.truffle.options.OptionValuesImpl;
import org.graalvm.compiler.truffle.options.PolyglotCompilerOptions;
import org.graalvm.compiler.truffle.runtime.GraalRuntimeAccessor;
import org.graalvm.compiler.truffle.runtime.OptimizedCallTarget;
import org.graalvm.compiler.truffle.runtime.SharedTruffleRuntimeOptions;
import org.graalvm.compiler.truffle.runtime.SharedTruffleRuntimeOptionsOptionDescriptors;
import org.graalvm.options.OptionDescriptor;
import org.graalvm.options.OptionKey;
import org.graalvm.options.OptionValues;

@SharedTruffleOptions(name="SharedTruffleRuntimeOptions", runtime=true)
public final class TruffleRuntimeOptions {
    @NativeImageReinitialize
    private static volatile OptionValuesImpl optionValues;
    private static final EconomicMap<OptionKey<?>, Pair<? extends OptionKey<?>, Function<Object, ?>>> POLYGLOT_TO_RUNTIME;

    private TruffleRuntimeOptions() {
        throw new IllegalStateException("No instance allowed.");
    }

    private static OptionValues getOptions() {
        OptionValuesImpl result = optionValues;
        if (result == null) {
            EconomicMap valuesMap = EconomicMap.create();
            SharedTruffleRuntimeOptionsOptionDescriptors descriptors = new SharedTruffleRuntimeOptionsOptionDescriptors();
            for (Map.Entry<String, Object> e : TruffleCompilerRuntime.getRuntime().getOptions().entrySet()) {
                OptionDescriptor descriptor = descriptors.get(e.getKey());
                OptionKey k = descriptor != null ? descriptor.getKey() : null;
                if (k == null) continue;
                valuesMap.put((Object)k, e.getValue());
            }
            optionValues = result = new OptionValuesImpl(descriptors, (UnmodifiableEconomicMap<OptionKey<?>, Object>)valuesMap);
        }
        return result;
    }

    public static Map<String, Object> getOptionsForCompiler(OptimizedCallTarget callTarget) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        OptionValues values = callTarget == null ? null : callTarget.getOptionValues();
        for (OptionDescriptor desc : PolyglotCompilerOptions.getDescriptors()) {
            OptionKey key = desc.getKey();
            if (!TruffleRuntimeOptions.hasBeenSet(values, key)) continue;
            Object value = TruffleRuntimeOptions.getPolyglotOptionValue(values, key);
            if (!TruffleRuntimeOptions.isPrimitiveType(value)) {
                value = GraalRuntimeAccessor.ENGINE.getUnparsedOptionValue(values, key);
            }
            if (value == null) continue;
            map.put(desc.getName(), value);
        }
        return map;
    }

    public static <T> T getPolyglotOptionValue(OptionValues options, OptionKey<T> optionKey) {
        if (options != null && options.hasBeenSet(optionKey)) {
            return (T)options.get(optionKey);
        }
        Pair runtimeOptionKeyPair = (Pair)POLYGLOT_TO_RUNTIME.get(optionKey);
        if (runtimeOptionKeyPair != null) {
            return (T)((Function)runtimeOptionKeyPair.getRight()).apply(((OptionKey)runtimeOptionKeyPair.getLeft()).getValue(TruffleRuntimeOptions.getOptions()));
        }
        return (T)optionKey.getDefaultValue();
    }

    private static boolean hasBeenSet(OptionValues options, OptionKey<?> optionKey) {
        if (options != null && options.hasBeenSet(optionKey)) {
            return true;
        }
        Pair runtimeOptionKeyPair = (Pair)POLYGLOT_TO_RUNTIME.get(optionKey);
        return runtimeOptionKeyPair == null ? false : TruffleRuntimeOptions.getOptions().hasBeenSet((OptionKey)runtimeOptionKeyPair.getLeft());
    }

    private static boolean isPrimitiveType(Object value) {
        Class<?> valueClass = value.getClass();
        return valueClass == Boolean.class || valueClass == Byte.class || valueClass == Short.class || valueClass == Character.class || valueClass == Integer.class || valueClass == Long.class || valueClass == Float.class || valueClass == Double.class || valueClass == String.class;
    }

    private static EconomicMap<OptionKey<?>, Pair<? extends OptionKey<?>, Function<Object, ?>>> initializePolyglotToGraalMapping() {
        EconomicMap result = EconomicMap.create((Equivalence)Equivalence.IDENTITY);
        result.put(PolyglotCompilerOptions.Compilation, TruffleRuntimeOptions.identity(SharedTruffleRuntimeOptions.TruffleCompilation));
        result.put(PolyglotCompilerOptions.CompileOnly, TruffleRuntimeOptions.identity(SharedTruffleRuntimeOptions.TruffleCompileOnly));
        result.put(PolyglotCompilerOptions.CompileImmediately, TruffleRuntimeOptions.identity(SharedTruffleRuntimeOptions.TruffleCompileImmediately));
        result.put(PolyglotCompilerOptions.BackgroundCompilation, TruffleRuntimeOptions.identity(SharedTruffleRuntimeOptions.TruffleBackgroundCompilation));
        result.put(PolyglotCompilerOptions.CompilerThreads, TruffleRuntimeOptions.identity(SharedTruffleRuntimeOptions.TruffleCompilerThreads));
        result.put(PolyglotCompilerOptions.CompilationThreshold, TruffleRuntimeOptions.identity(SharedTruffleRuntimeOptions.TruffleCompilationThreshold));
        result.put(PolyglotCompilerOptions.MinInvokeThreshold, TruffleRuntimeOptions.identity(SharedTruffleRuntimeOptions.TruffleMinInvokeThreshold));
        result.put(PolyglotCompilerOptions.InvalidationReprofileCount, TruffleRuntimeOptions.identity(SharedTruffleRuntimeOptions.TruffleInvalidationReprofileCount));
        result.put(PolyglotCompilerOptions.ReplaceReprofileCount, TruffleRuntimeOptions.identity(SharedTruffleRuntimeOptions.TruffleReplaceReprofileCount));
        result.put(PolyglotCompilerOptions.ArgumentTypeSpeculation, TruffleRuntimeOptions.identity(SharedTruffleRuntimeOptions.TruffleArgumentTypeSpeculation));
        result.put(PolyglotCompilerOptions.ReturnTypeSpeculation, TruffleRuntimeOptions.identity(SharedTruffleRuntimeOptions.TruffleReturnTypeSpeculation));
        result.put(PolyglotCompilerOptions.Profiling, TruffleRuntimeOptions.identity(SharedTruffleRuntimeOptions.TruffleProfilingEnabled));
        result.put(PolyglotCompilerOptions.MultiTier, TruffleRuntimeOptions.identity(SharedTruffleRuntimeOptions.TruffleMultiTier));
        result.put(PolyglotCompilerOptions.FirstTierCompilationThreshold, TruffleRuntimeOptions.identity(SharedTruffleRuntimeOptions.TruffleFirstTierCompilationThreshold));
        result.put(PolyglotCompilerOptions.FirstTierMinInvokeThreshold, TruffleRuntimeOptions.identity(SharedTruffleRuntimeOptions.TruffleFirstTierMinInvokeThreshold));
        result.put(PolyglotCompilerOptions.CompilationExceptionsArePrinted, TruffleRuntimeOptions.identity(SharedTruffleRuntimeOptions.TruffleCompilationExceptionsArePrinted));
        result.put(PolyglotCompilerOptions.CompilationExceptionsAreThrown, TruffleRuntimeOptions.identity(SharedTruffleRuntimeOptions.TruffleCompilationExceptionsAreThrown));
        result.put(PolyglotCompilerOptions.CompilationExceptionsAreFatal, TruffleRuntimeOptions.identity(SharedTruffleRuntimeOptions.TruffleCompilationExceptionsAreFatal));
        result.put(PolyglotCompilerOptions.PerformanceWarningsAreFatal, TruffleRuntimeOptions.booleanToPerformanceWarningKind(SharedTruffleRuntimeOptions.TrufflePerformanceWarningsAreFatal));
        result.put(PolyglotCompilerOptions.TraceCompilation, TruffleRuntimeOptions.identity(SharedTruffleRuntimeOptions.TraceTruffleCompilation));
        result.put(PolyglotCompilerOptions.TraceCompilationDetails, TruffleRuntimeOptions.identity(SharedTruffleRuntimeOptions.TraceTruffleCompilationDetails));
        result.put(PolyglotCompilerOptions.TraceCompilationPolymorphism, TruffleRuntimeOptions.identity(SharedTruffleRuntimeOptions.TraceTruffleCompilationPolymorphism));
        result.put(PolyglotCompilerOptions.TraceCompilationAST, TruffleRuntimeOptions.identity(SharedTruffleRuntimeOptions.TraceTruffleCompilationAST));
        result.put(PolyglotCompilerOptions.TraceCompilationCallTree, TruffleRuntimeOptions.identity(SharedTruffleRuntimeOptions.TraceTruffleCompilationCallTree));
        result.put(PolyglotCompilerOptions.TraceAssumptions, TruffleRuntimeOptions.identity(SharedTruffleRuntimeOptions.TraceTruffleAssumptions));
        result.put(PolyglotCompilerOptions.TraceStackTraceLimit, TruffleRuntimeOptions.identity(SharedTruffleRuntimeOptions.TraceTruffleStackTraceLimit));
        result.put(PolyglotCompilerOptions.CompilationStatistics, TruffleRuntimeOptions.identity(SharedTruffleRuntimeOptions.TruffleCompilationStatistics));
        result.put(PolyglotCompilerOptions.CompilationStatisticDetails, TruffleRuntimeOptions.identity(SharedTruffleRuntimeOptions.TruffleCompilationStatisticDetails));
        result.put(PolyglotCompilerOptions.TraceTransferToInterpreter, TruffleRuntimeOptions.identity(SharedTruffleRuntimeOptions.TraceTruffleTransferToInterpreter));
        result.put(PolyglotCompilerOptions.TraceInlining, TruffleRuntimeOptions.identity(SharedTruffleRuntimeOptions.TraceTruffleInlining));
        result.put(PolyglotCompilerOptions.TraceSplitting, TruffleRuntimeOptions.identity(SharedTruffleRuntimeOptions.TraceTruffleSplitting));
        result.put(PolyglotCompilerOptions.Inlining, TruffleRuntimeOptions.identity(SharedTruffleRuntimeOptions.TruffleFunctionInlining));
        result.put(PolyglotCompilerOptions.InliningNodeBudget, TruffleRuntimeOptions.identity(SharedTruffleRuntimeOptions.TruffleInliningMaxCallerSize));
        result.put(PolyglotCompilerOptions.InliningRecursionDepth, TruffleRuntimeOptions.identity(SharedTruffleRuntimeOptions.TruffleMaximumRecursiveInlining));
        result.put(PolyglotCompilerOptions.LanguageAgnosticInlining, TruffleRuntimeOptions.identity(SharedTruffleRuntimeOptions.TruffleLanguageAgnosticInlining));
        result.put(PolyglotCompilerOptions.Splitting, TruffleRuntimeOptions.identity(SharedTruffleRuntimeOptions.TruffleSplitting));
        result.put(PolyglotCompilerOptions.SplittingMaxCalleeSize, TruffleRuntimeOptions.identity(SharedTruffleRuntimeOptions.TruffleSplittingMaxCalleeSize));
        result.put(PolyglotCompilerOptions.SplittingGrowthLimit, TruffleRuntimeOptions.identity(SharedTruffleRuntimeOptions.TruffleSplittingGrowthLimit));
        result.put(PolyglotCompilerOptions.SplittingMaxNumberOfSplitNodes, TruffleRuntimeOptions.identity(SharedTruffleRuntimeOptions.TruffleSplittingMaxNumberOfSplitNodes));
        result.put(PolyglotCompilerOptions.SplittingMaxPropagationDepth, TruffleRuntimeOptions.identity(SharedTruffleRuntimeOptions.TruffleSplittingMaxPropagationDepth));
        result.put(PolyglotCompilerOptions.TraceSplittingSummary, TruffleRuntimeOptions.identity(SharedTruffleRuntimeOptions.TruffleTraceSplittingSummary));
        result.put(PolyglotCompilerOptions.SplittingTraceEvents, TruffleRuntimeOptions.identity(SharedTruffleRuntimeOptions.TruffleSplittingTraceEvents));
        result.put(PolyglotCompilerOptions.SplittingDumpDecisions, TruffleRuntimeOptions.identity(SharedTruffleRuntimeOptions.TruffleSplittingDumpDecisions));
        result.put(PolyglotCompilerOptions.SplittingAllowForcedSplits, TruffleRuntimeOptions.identity(SharedTruffleRuntimeOptions.TruffleSplittingAllowForcedSplits));
        result.put(PolyglotCompilerOptions.OSR, TruffleRuntimeOptions.identity(SharedTruffleRuntimeOptions.TruffleOSR));
        result.put(PolyglotCompilerOptions.OSRCompilationThreshold, TruffleRuntimeOptions.identity(SharedTruffleRuntimeOptions.TruffleOSRCompilationThreshold));
        return result;
    }

    private static Pair<OptionKey<?>, Function<Object, ?>> identity(OptionKey<?> key) {
        return Pair.create(key, Function.identity());
    }

    private static Pair<OptionKey<Boolean>, Function<Object, ?>> booleanToPerformanceWarningKind(OptionKey<Boolean> key) {
        return Pair.create(key, (Object)new Function<Object, Set<PolyglotCompilerOptions.PerformanceWarningKind>>(){

            @Override
            public Set<PolyglotCompilerOptions.PerformanceWarningKind> apply(Object t) {
                return (Boolean)t != false ? EnumSet.allOf(PolyglotCompilerOptions.PerformanceWarningKind.class) : EnumSet.noneOf(PolyglotCompilerOptions.PerformanceWarningKind.class);
            }
        });
    }

    static {
        POLYGLOT_TO_RUNTIME = TruffleRuntimeOptions.initializePolyglotToGraalMapping();
    }
}

