/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.compiler.truffle.runtime;

import com.oracle.truffle.api.dsl.GeneratedBy;
import java.util.Arrays;
import java.util.Iterator;
import org.graalvm.compiler.truffle.runtime.SharedTruffleRuntimeOptions;
import org.graalvm.options.OptionCategory;
import org.graalvm.options.OptionDescriptor;
import org.graalvm.options.OptionDescriptors;
import org.graalvm.options.OptionStability;

@GeneratedBy(value=SharedTruffleRuntimeOptions.class)
final class SharedTruffleRuntimeOptionsOptionDescriptors
implements OptionDescriptors {
    SharedTruffleRuntimeOptionsOptionDescriptors() {
    }

    public OptionDescriptor get(String optionName) {
        switch (optionName) {
            case "PrintTruffleTrees": {
                return OptionDescriptor.newBuilder(SharedTruffleRuntimeOptions.PrintTruffleTrees, (String)"PrintTruffleTrees").deprecated(false).help("Enable dumping Truffle ASTs to the IdealGraphVisualizer.").category(OptionCategory.INTERNAL).stability(OptionStability.EXPERIMENTAL).build();
            }
            case "TraceTruffleAssumptions": {
                return OptionDescriptor.newBuilder(SharedTruffleRuntimeOptions.TraceTruffleAssumptions, (String)"TraceTruffleAssumptions").deprecated(false).help("Print stack trace on assumption invalidation").category(OptionCategory.INTERNAL).stability(OptionStability.EXPERIMENTAL).build();
            }
            case "TraceTruffleCompilation": {
                return OptionDescriptor.newBuilder(SharedTruffleRuntimeOptions.TraceTruffleCompilation, (String)"TraceTruffleCompilation").deprecated(false).help("Print information for compilation results").category(OptionCategory.INTERNAL).stability(OptionStability.EXPERIMENTAL).build();
            }
            case "TraceTruffleCompilationAST": {
                return OptionDescriptor.newBuilder(SharedTruffleRuntimeOptions.TraceTruffleCompilationAST, (String)"TraceTruffleCompilationAST").deprecated(false).help("Print the entire AST after each compilation").category(OptionCategory.INTERNAL).stability(OptionStability.EXPERIMENTAL).build();
            }
            case "TraceTruffleCompilationCallTree": {
                return OptionDescriptor.newBuilder(SharedTruffleRuntimeOptions.TraceTruffleCompilationCallTree, (String)"TraceTruffleCompilationCallTree").deprecated(false).help("Print the inlined call tree for each compiled method").category(OptionCategory.INTERNAL).stability(OptionStability.EXPERIMENTAL).build();
            }
            case "TraceTruffleCompilationDetails": {
                return OptionDescriptor.newBuilder(SharedTruffleRuntimeOptions.TraceTruffleCompilationDetails, (String)"TraceTruffleCompilationDetails").deprecated(false).help("Print information for compilation queuing").category(OptionCategory.INTERNAL).stability(OptionStability.EXPERIMENTAL).build();
            }
            case "TraceTruffleCompilationPolymorphism": {
                return OptionDescriptor.newBuilder(SharedTruffleRuntimeOptions.TraceTruffleCompilationPolymorphism, (String)"TraceTruffleCompilationPolymorphism").deprecated(false).help("Print all polymorphic and generic nodes after each compilation").category(OptionCategory.INTERNAL).stability(OptionStability.EXPERIMENTAL).build();
            }
            case "TraceTruffleInlining": {
                return OptionDescriptor.newBuilder(SharedTruffleRuntimeOptions.TraceTruffleInlining, (String)"TraceTruffleInlining").deprecated(false).help("Print information for inlining for each compilation.").category(OptionCategory.INTERNAL).stability(OptionStability.EXPERIMENTAL).build();
            }
            case "TraceTruffleSplitting": {
                return OptionDescriptor.newBuilder(SharedTruffleRuntimeOptions.TraceTruffleSplitting, (String)"TraceTruffleSplitting").deprecated(false).help("Print information for each splitted call site.").category(OptionCategory.INTERNAL).stability(OptionStability.EXPERIMENTAL).build();
            }
            case "TraceTruffleStackTraceLimit": {
                return OptionDescriptor.newBuilder(SharedTruffleRuntimeOptions.TraceTruffleStackTraceLimit, (String)"TraceTruffleStackTraceLimit").deprecated(false).help("Number of stack trace elements printed by TraceTruffleTransferToInterpreter and TraceTruffleAssumptions").category(OptionCategory.INTERNAL).stability(OptionStability.EXPERIMENTAL).build();
            }
            case "TraceTruffleTransferToInterpreter": {
                return OptionDescriptor.newBuilder(SharedTruffleRuntimeOptions.TraceTruffleTransferToInterpreter, (String)"TraceTruffleTransferToInterpreter").deprecated(false).help("Print stack trace on transfer to interpreter.").category(OptionCategory.INTERNAL).stability(OptionStability.EXPERIMENTAL).build();
            }
            case "TruffleArgumentTypeSpeculation": {
                return OptionDescriptor.newBuilder(SharedTruffleRuntimeOptions.TruffleArgumentTypeSpeculation, (String)"TruffleArgumentTypeSpeculation").deprecated(false).help("").category(OptionCategory.INTERNAL).stability(OptionStability.EXPERIMENTAL).build();
            }
            case "TruffleBackgroundCompilation": {
                return OptionDescriptor.newBuilder(SharedTruffleRuntimeOptions.TruffleBackgroundCompilation, (String)"TruffleBackgroundCompilation").deprecated(false).help("Enable asynchronous truffle compilation in background thread").category(OptionCategory.EXPERT).stability(OptionStability.EXPERIMENTAL).build();
            }
            case "TruffleCompilation": {
                return OptionDescriptor.newBuilder(SharedTruffleRuntimeOptions.TruffleCompilation, (String)"TruffleCompilation").deprecated(false).help("Enable or disable truffle compilation.").category(OptionCategory.INTERNAL).stability(OptionStability.EXPERIMENTAL).build();
            }
            case "TruffleCompilationExceptionsAreFatal": {
                return OptionDescriptor.newBuilder(SharedTruffleRuntimeOptions.TruffleCompilationExceptionsAreFatal, (String)"TruffleCompilationExceptionsAreFatal").deprecated(false).help("Treat compilation exceptions as fatal exceptions that will exit the application").category(OptionCategory.INTERNAL).stability(OptionStability.EXPERIMENTAL).build();
            }
            case "TruffleCompilationExceptionsArePrinted": {
                return OptionDescriptor.newBuilder(SharedTruffleRuntimeOptions.TruffleCompilationExceptionsArePrinted, (String)"TruffleCompilationExceptionsArePrinted").deprecated(false).help("Prints the exception stack trace for compilation exceptions").category(OptionCategory.INTERNAL).stability(OptionStability.EXPERIMENTAL).build();
            }
            case "TruffleCompilationExceptionsAreThrown": {
                return OptionDescriptor.newBuilder(SharedTruffleRuntimeOptions.TruffleCompilationExceptionsAreThrown, (String)"TruffleCompilationExceptionsAreThrown").deprecated(false).help("Treat compilation exceptions as thrown runtime exceptions").category(OptionCategory.INTERNAL).stability(OptionStability.EXPERIMENTAL).build();
            }
            case "TruffleCompilationStatisticDetails": {
                return OptionDescriptor.newBuilder(SharedTruffleRuntimeOptions.TruffleCompilationStatisticDetails, (String)"TruffleCompilationStatisticDetails").deprecated(false).help("Print additional more verbose Truffle compilation statistics at the end of a run.").category(OptionCategory.INTERNAL).stability(OptionStability.EXPERIMENTAL).build();
            }
            case "TruffleCompilationStatistics": {
                return OptionDescriptor.newBuilder(SharedTruffleRuntimeOptions.TruffleCompilationStatistics, (String)"TruffleCompilationStatistics").deprecated(false).help("Print Truffle compilation statistics at the end of a run.").category(OptionCategory.INTERNAL).stability(OptionStability.EXPERIMENTAL).build();
            }
            case "TruffleCompilationThreshold": {
                return OptionDescriptor.newBuilder(SharedTruffleRuntimeOptions.TruffleCompilationThreshold, (String)"TruffleCompilationThreshold").deprecated(false).help("Compile call target when call count exceeds this threshold.").category(OptionCategory.USER).stability(OptionStability.EXPERIMENTAL).build();
            }
            case "TruffleCompileImmediately": {
                return OptionDescriptor.newBuilder(SharedTruffleRuntimeOptions.TruffleCompileImmediately, (String)"TruffleCompileImmediately").deprecated(false).help("Compile immediately to test truffle compiler").category(OptionCategory.INTERNAL).stability(OptionStability.EXPERIMENTAL).build();
            }
            case "TruffleCompileOnly": {
                return OptionDescriptor.newBuilder(SharedTruffleRuntimeOptions.TruffleCompileOnly, (String)"TruffleCompileOnly").deprecated(false).help("Restrict compilation to comma-separated list of includes (or excludes prefixed with tilde).%n%nEBNF format of argument value:  CompileOnly = Element, { ',', Element } ;").category(OptionCategory.INTERNAL).stability(OptionStability.EXPERIMENTAL).build();
            }
            case "TruffleCompilerThreads": {
                return OptionDescriptor.newBuilder(SharedTruffleRuntimeOptions.TruffleCompilerThreads, (String)"TruffleCompilerThreads").deprecated(false).help("Manually set the number of compiler threads").category(OptionCategory.EXPERT).stability(OptionStability.EXPERIMENTAL).build();
            }
            case "TruffleFirstTierCompilationThreshold": {
                return OptionDescriptor.newBuilder(SharedTruffleRuntimeOptions.TruffleFirstTierCompilationThreshold, (String)"TruffleFirstTierCompilationThreshold").deprecated(false).help("Compile call target in the first tier when call count exceeds this threshold.").category(OptionCategory.EXPERT).stability(OptionStability.EXPERIMENTAL).build();
            }
            case "TruffleFirstTierMinInvokeThreshold": {
                return OptionDescriptor.newBuilder(SharedTruffleRuntimeOptions.TruffleFirstTierMinInvokeThreshold, (String)"TruffleFirstTierMinInvokeThreshold").deprecated(false).help("Minimum number of calls before a call target is compiled in the first tier.").category(OptionCategory.EXPERT).stability(OptionStability.EXPERIMENTAL).build();
            }
            case "TruffleFunctionInlining": {
                return OptionDescriptor.newBuilder(SharedTruffleRuntimeOptions.TruffleFunctionInlining, (String)"TruffleFunctionInlining").deprecated(false).help("Enable automatic inlining of call targets").category(OptionCategory.INTERNAL).stability(OptionStability.EXPERIMENTAL).build();
            }
            case "TruffleInliningMaxCallerSize": {
                return OptionDescriptor.newBuilder(SharedTruffleRuntimeOptions.TruffleInliningMaxCallerSize, (String)"TruffleInliningMaxCallerSize").deprecated(false).help("Stop inlining if caller's cumulative tree size would exceed this limit").category(OptionCategory.EXPERT).stability(OptionStability.EXPERIMENTAL).build();
            }
            case "TruffleInvalidationReprofileCount": {
                return OptionDescriptor.newBuilder(SharedTruffleRuntimeOptions.TruffleInvalidationReprofileCount, (String)"TruffleInvalidationReprofileCount").deprecated(false).help("Delay compilation after an invalidation to allow for reprofiling").category(OptionCategory.EXPERT).stability(OptionStability.EXPERIMENTAL).build();
            }
            case "TruffleLanguageAgnosticInlining": {
                return OptionDescriptor.newBuilder(SharedTruffleRuntimeOptions.TruffleLanguageAgnosticInlining, (String)"TruffleLanguageAgnosticInlining").deprecated(false).help("Use language-agnostic inlining (overrides the TruffleFunctionInlining setting, option is experimental).").category(OptionCategory.EXPERT).stability(OptionStability.EXPERIMENTAL).build();
            }
            case "TruffleMaximumRecursiveInlining": {
                return OptionDescriptor.newBuilder(SharedTruffleRuntimeOptions.TruffleMaximumRecursiveInlining, (String)"TruffleMaximumRecursiveInlining").deprecated(false).help("Maximum level of recursive inlining").category(OptionCategory.EXPERT).stability(OptionStability.EXPERIMENTAL).build();
            }
            case "TruffleMinInvokeThreshold": {
                return OptionDescriptor.newBuilder(SharedTruffleRuntimeOptions.TruffleMinInvokeThreshold, (String)"TruffleMinInvokeThreshold").deprecated(false).help("Minimum number of calls before a call target is compiled").category(OptionCategory.EXPERT).stability(OptionStability.EXPERIMENTAL).build();
            }
            case "TruffleMultiTier": {
                return OptionDescriptor.newBuilder(SharedTruffleRuntimeOptions.TruffleMultiTier, (String)"TruffleMultiTier").deprecated(false).help("Whether to use multiple Truffle compilation tiers by default.").category(OptionCategory.EXPERT).stability(OptionStability.EXPERIMENTAL).build();
            }
            case "TruffleOSR": {
                return OptionDescriptor.newBuilder(SharedTruffleRuntimeOptions.TruffleOSR, (String)"TruffleOSR").deprecated(false).help("Enable on stack replacement for Truffle loops.").category(OptionCategory.INTERNAL).stability(OptionStability.EXPERIMENTAL).build();
            }
            case "TruffleOSRCompilationThreshold": {
                return OptionDescriptor.newBuilder(SharedTruffleRuntimeOptions.TruffleOSRCompilationThreshold, (String)"TruffleOSRCompilationThreshold").deprecated(false).help("Number of loop iterations until on-stack-replacement compilation is triggered.").category(OptionCategory.INTERNAL).stability(OptionStability.EXPERIMENTAL).build();
            }
            case "TrufflePerformanceWarningsAreFatal": {
                return OptionDescriptor.newBuilder(SharedTruffleRuntimeOptions.TrufflePerformanceWarningsAreFatal, (String)"TrufflePerformanceWarningsAreFatal").deprecated(false).help("Treat performance warnings as fatal occurrences that will exit the applications").category(OptionCategory.INTERNAL).stability(OptionStability.EXPERIMENTAL).build();
            }
            case "TruffleProfilingEnabled": {
                return OptionDescriptor.newBuilder(SharedTruffleRuntimeOptions.TruffleProfilingEnabled, (String)"TruffleProfilingEnabled").deprecated(false).help("Enable/disable builtin profiles in com.oracle.truffle.api.profiles.").category(OptionCategory.INTERNAL).stability(OptionStability.EXPERIMENTAL).build();
            }
            case "TruffleReplaceReprofileCount": {
                return OptionDescriptor.newBuilder(SharedTruffleRuntimeOptions.TruffleReplaceReprofileCount, (String)"TruffleReplaceReprofileCount").deprecated(false).help("Delay compilation after a node replacement").category(OptionCategory.EXPERT).stability(OptionStability.EXPERIMENTAL).build();
            }
            case "TruffleReturnTypeSpeculation": {
                return OptionDescriptor.newBuilder(SharedTruffleRuntimeOptions.TruffleReturnTypeSpeculation, (String)"TruffleReturnTypeSpeculation").deprecated(false).help("").category(OptionCategory.INTERNAL).stability(OptionStability.EXPERIMENTAL).build();
            }
            case "TruffleSplitting": {
                return OptionDescriptor.newBuilder(SharedTruffleRuntimeOptions.TruffleSplitting, (String)"TruffleSplitting").deprecated(false).help("Enable call target splitting").category(OptionCategory.EXPERT).stability(OptionStability.EXPERIMENTAL).build();
            }
            case "TruffleSplittingAllowForcedSplits": {
                return OptionDescriptor.newBuilder(SharedTruffleRuntimeOptions.TruffleSplittingAllowForcedSplits, (String)"TruffleSplittingAllowForcedSplits").deprecated(false).help("Should forced splits be allowed.").category(OptionCategory.EXPERT).stability(OptionStability.EXPERIMENTAL).build();
            }
            case "TruffleSplittingDumpDecisions": {
                return OptionDescriptor.newBuilder(SharedTruffleRuntimeOptions.TruffleSplittingDumpDecisions, (String)"TruffleSplittingDumpDecisions").deprecated(false).help("Dumps to IGV information on polymorphic events").category(OptionCategory.EXPERT).stability(OptionStability.EXPERIMENTAL).build();
            }
            case "TruffleSplittingGrowthLimit": {
                return OptionDescriptor.newBuilder(SharedTruffleRuntimeOptions.TruffleSplittingGrowthLimit, (String)"TruffleSplittingGrowthLimit").deprecated(false).help("Disable call target splitting if the number of nodes created by splitting exceeds this factor times node count").category(OptionCategory.INTERNAL).stability(OptionStability.EXPERIMENTAL).build();
            }
            case "TruffleSplittingMaxCalleeSize": {
                return OptionDescriptor.newBuilder(SharedTruffleRuntimeOptions.TruffleSplittingMaxCalleeSize, (String)"TruffleSplittingMaxCalleeSize").deprecated(false).help("Disable call target splitting if tree size exceeds this limit").category(OptionCategory.INTERNAL).stability(OptionStability.EXPERIMENTAL).build();
            }
            case "TruffleSplittingMaxNumberOfSplitNodes": {
                return OptionDescriptor.newBuilder(SharedTruffleRuntimeOptions.TruffleSplittingMaxNumberOfSplitNodes, (String)"TruffleSplittingMaxNumberOfSplitNodes").deprecated(false).help("Disable call target splitting if number of nodes created by splitting exceeds this limit").category(OptionCategory.INTERNAL).stability(OptionStability.EXPERIMENTAL).build();
            }
            case "TruffleSplittingMaxPropagationDepth": {
                return OptionDescriptor.newBuilder(SharedTruffleRuntimeOptions.TruffleSplittingMaxPropagationDepth, (String)"TruffleSplittingMaxPropagationDepth").deprecated(false).help("Propagate info about a polymorphic specialize through maximum this many call targets").category(OptionCategory.INTERNAL).stability(OptionStability.EXPERIMENTAL).build();
            }
            case "TruffleSplittingTraceEvents": {
                return OptionDescriptor.newBuilder(SharedTruffleRuntimeOptions.TruffleSplittingTraceEvents, (String)"TruffleSplittingTraceEvents").deprecated(false).help("Trace details of splitting events and decisions.").category(OptionCategory.EXPERT).stability(OptionStability.EXPERIMENTAL).build();
            }
            case "TruffleTraceSplittingSummary": {
                return OptionDescriptor.newBuilder(SharedTruffleRuntimeOptions.TruffleTraceSplittingSummary, (String)"TruffleTraceSplittingSummary").deprecated(false).help("Used for debugging the splitting implementation. Prints splitting summary directly to stdout on shutdown").category(OptionCategory.EXPERT).stability(OptionStability.EXPERIMENTAL).build();
            }
        }
        return null;
    }

    public Iterator<OptionDescriptor> iterator() {
        return Arrays.asList(OptionDescriptor.newBuilder(SharedTruffleRuntimeOptions.PrintTruffleTrees, (String)"PrintTruffleTrees").deprecated(false).help("Enable dumping Truffle ASTs to the IdealGraphVisualizer.").category(OptionCategory.INTERNAL).stability(OptionStability.EXPERIMENTAL).build(), OptionDescriptor.newBuilder(SharedTruffleRuntimeOptions.TraceTruffleAssumptions, (String)"TraceTruffleAssumptions").deprecated(false).help("Print stack trace on assumption invalidation").category(OptionCategory.INTERNAL).stability(OptionStability.EXPERIMENTAL).build(), OptionDescriptor.newBuilder(SharedTruffleRuntimeOptions.TraceTruffleCompilation, (String)"TraceTruffleCompilation").deprecated(false).help("Print information for compilation results").category(OptionCategory.INTERNAL).stability(OptionStability.EXPERIMENTAL).build(), OptionDescriptor.newBuilder(SharedTruffleRuntimeOptions.TraceTruffleCompilationAST, (String)"TraceTruffleCompilationAST").deprecated(false).help("Print the entire AST after each compilation").category(OptionCategory.INTERNAL).stability(OptionStability.EXPERIMENTAL).build(), OptionDescriptor.newBuilder(SharedTruffleRuntimeOptions.TraceTruffleCompilationCallTree, (String)"TraceTruffleCompilationCallTree").deprecated(false).help("Print the inlined call tree for each compiled method").category(OptionCategory.INTERNAL).stability(OptionStability.EXPERIMENTAL).build(), OptionDescriptor.newBuilder(SharedTruffleRuntimeOptions.TraceTruffleCompilationDetails, (String)"TraceTruffleCompilationDetails").deprecated(false).help("Print information for compilation queuing").category(OptionCategory.INTERNAL).stability(OptionStability.EXPERIMENTAL).build(), OptionDescriptor.newBuilder(SharedTruffleRuntimeOptions.TraceTruffleCompilationPolymorphism, (String)"TraceTruffleCompilationPolymorphism").deprecated(false).help("Print all polymorphic and generic nodes after each compilation").category(OptionCategory.INTERNAL).stability(OptionStability.EXPERIMENTAL).build(), OptionDescriptor.newBuilder(SharedTruffleRuntimeOptions.TraceTruffleInlining, (String)"TraceTruffleInlining").deprecated(false).help("Print information for inlining for each compilation.").category(OptionCategory.INTERNAL).stability(OptionStability.EXPERIMENTAL).build(), OptionDescriptor.newBuilder(SharedTruffleRuntimeOptions.TraceTruffleSplitting, (String)"TraceTruffleSplitting").deprecated(false).help("Print information for each splitted call site.").category(OptionCategory.INTERNAL).stability(OptionStability.EXPERIMENTAL).build(), OptionDescriptor.newBuilder(SharedTruffleRuntimeOptions.TraceTruffleStackTraceLimit, (String)"TraceTruffleStackTraceLimit").deprecated(false).help("Number of stack trace elements printed by TraceTruffleTransferToInterpreter and TraceTruffleAssumptions").category(OptionCategory.INTERNAL).stability(OptionStability.EXPERIMENTAL).build(), OptionDescriptor.newBuilder(SharedTruffleRuntimeOptions.TraceTruffleTransferToInterpreter, (String)"TraceTruffleTransferToInterpreter").deprecated(false).help("Print stack trace on transfer to interpreter.").category(OptionCategory.INTERNAL).stability(OptionStability.EXPERIMENTAL).build(), OptionDescriptor.newBuilder(SharedTruffleRuntimeOptions.TruffleArgumentTypeSpeculation, (String)"TruffleArgumentTypeSpeculation").deprecated(false).help("").category(OptionCategory.INTERNAL).stability(OptionStability.EXPERIMENTAL).build(), OptionDescriptor.newBuilder(SharedTruffleRuntimeOptions.TruffleBackgroundCompilation, (String)"TruffleBackgroundCompilation").deprecated(false).help("Enable asynchronous truffle compilation in background thread").category(OptionCategory.EXPERT).stability(OptionStability.EXPERIMENTAL).build(), OptionDescriptor.newBuilder(SharedTruffleRuntimeOptions.TruffleCompilation, (String)"TruffleCompilation").deprecated(false).help("Enable or disable truffle compilation.").category(OptionCategory.INTERNAL).stability(OptionStability.EXPERIMENTAL).build(), OptionDescriptor.newBuilder(SharedTruffleRuntimeOptions.TruffleCompilationExceptionsAreFatal, (String)"TruffleCompilationExceptionsAreFatal").deprecated(false).help("Treat compilation exceptions as fatal exceptions that will exit the application").category(OptionCategory.INTERNAL).stability(OptionStability.EXPERIMENTAL).build(), OptionDescriptor.newBuilder(SharedTruffleRuntimeOptions.TruffleCompilationExceptionsArePrinted, (String)"TruffleCompilationExceptionsArePrinted").deprecated(false).help("Prints the exception stack trace for compilation exceptions").category(OptionCategory.INTERNAL).stability(OptionStability.EXPERIMENTAL).build(), OptionDescriptor.newBuilder(SharedTruffleRuntimeOptions.TruffleCompilationExceptionsAreThrown, (String)"TruffleCompilationExceptionsAreThrown").deprecated(false).help("Treat compilation exceptions as thrown runtime exceptions").category(OptionCategory.INTERNAL).stability(OptionStability.EXPERIMENTAL).build(), OptionDescriptor.newBuilder(SharedTruffleRuntimeOptions.TruffleCompilationStatisticDetails, (String)"TruffleCompilationStatisticDetails").deprecated(false).help("Print additional more verbose Truffle compilation statistics at the end of a run.").category(OptionCategory.INTERNAL).stability(OptionStability.EXPERIMENTAL).build(), OptionDescriptor.newBuilder(SharedTruffleRuntimeOptions.TruffleCompilationStatistics, (String)"TruffleCompilationStatistics").deprecated(false).help("Print Truffle compilation statistics at the end of a run.").category(OptionCategory.INTERNAL).stability(OptionStability.EXPERIMENTAL).build(), OptionDescriptor.newBuilder(SharedTruffleRuntimeOptions.TruffleCompilationThreshold, (String)"TruffleCompilationThreshold").deprecated(false).help("Compile call target when call count exceeds this threshold.").category(OptionCategory.USER).stability(OptionStability.EXPERIMENTAL).build(), OptionDescriptor.newBuilder(SharedTruffleRuntimeOptions.TruffleCompileImmediately, (String)"TruffleCompileImmediately").deprecated(false).help("Compile immediately to test truffle compiler").category(OptionCategory.INTERNAL).stability(OptionStability.EXPERIMENTAL).build(), OptionDescriptor.newBuilder(SharedTruffleRuntimeOptions.TruffleCompileOnly, (String)"TruffleCompileOnly").deprecated(false).help("Restrict compilation to comma-separated list of includes (or excludes prefixed with tilde).%n%nEBNF format of argument value:  CompileOnly = Element, { ',', Element } ;").category(OptionCategory.INTERNAL).stability(OptionStability.EXPERIMENTAL).build(), OptionDescriptor.newBuilder(SharedTruffleRuntimeOptions.TruffleCompilerThreads, (String)"TruffleCompilerThreads").deprecated(false).help("Manually set the number of compiler threads").category(OptionCategory.EXPERT).stability(OptionStability.EXPERIMENTAL).build(), OptionDescriptor.newBuilder(SharedTruffleRuntimeOptions.TruffleFirstTierCompilationThreshold, (String)"TruffleFirstTierCompilationThreshold").deprecated(false).help("Compile call target in the first tier when call count exceeds this threshold.").category(OptionCategory.EXPERT).stability(OptionStability.EXPERIMENTAL).build(), OptionDescriptor.newBuilder(SharedTruffleRuntimeOptions.TruffleFirstTierMinInvokeThreshold, (String)"TruffleFirstTierMinInvokeThreshold").deprecated(false).help("Minimum number of calls before a call target is compiled in the first tier.").category(OptionCategory.EXPERT).stability(OptionStability.EXPERIMENTAL).build(), OptionDescriptor.newBuilder(SharedTruffleRuntimeOptions.TruffleFunctionInlining, (String)"TruffleFunctionInlining").deprecated(false).help("Enable automatic inlining of call targets").category(OptionCategory.INTERNAL).stability(OptionStability.EXPERIMENTAL).build(), OptionDescriptor.newBuilder(SharedTruffleRuntimeOptions.TruffleInliningMaxCallerSize, (String)"TruffleInliningMaxCallerSize").deprecated(false).help("Stop inlining if caller's cumulative tree size would exceed this limit").category(OptionCategory.EXPERT).stability(OptionStability.EXPERIMENTAL).build(), OptionDescriptor.newBuilder(SharedTruffleRuntimeOptions.TruffleInvalidationReprofileCount, (String)"TruffleInvalidationReprofileCount").deprecated(false).help("Delay compilation after an invalidation to allow for reprofiling").category(OptionCategory.EXPERT).stability(OptionStability.EXPERIMENTAL).build(), OptionDescriptor.newBuilder(SharedTruffleRuntimeOptions.TruffleLanguageAgnosticInlining, (String)"TruffleLanguageAgnosticInlining").deprecated(false).help("Use language-agnostic inlining (overrides the TruffleFunctionInlining setting, option is experimental).").category(OptionCategory.EXPERT).stability(OptionStability.EXPERIMENTAL).build(), OptionDescriptor.newBuilder(SharedTruffleRuntimeOptions.TruffleMaximumRecursiveInlining, (String)"TruffleMaximumRecursiveInlining").deprecated(false).help("Maximum level of recursive inlining").category(OptionCategory.EXPERT).stability(OptionStability.EXPERIMENTAL).build(), OptionDescriptor.newBuilder(SharedTruffleRuntimeOptions.TruffleMinInvokeThreshold, (String)"TruffleMinInvokeThreshold").deprecated(false).help("Minimum number of calls before a call target is compiled").category(OptionCategory.EXPERT).stability(OptionStability.EXPERIMENTAL).build(), OptionDescriptor.newBuilder(SharedTruffleRuntimeOptions.TruffleMultiTier, (String)"TruffleMultiTier").deprecated(false).help("Whether to use multiple Truffle compilation tiers by default.").category(OptionCategory.EXPERT).stability(OptionStability.EXPERIMENTAL).build(), OptionDescriptor.newBuilder(SharedTruffleRuntimeOptions.TruffleOSR, (String)"TruffleOSR").deprecated(false).help("Enable on stack replacement for Truffle loops.").category(OptionCategory.INTERNAL).stability(OptionStability.EXPERIMENTAL).build(), OptionDescriptor.newBuilder(SharedTruffleRuntimeOptions.TruffleOSRCompilationThreshold, (String)"TruffleOSRCompilationThreshold").deprecated(false).help("Number of loop iterations until on-stack-replacement compilation is triggered.").category(OptionCategory.INTERNAL).stability(OptionStability.EXPERIMENTAL).build(), OptionDescriptor.newBuilder(SharedTruffleRuntimeOptions.TrufflePerformanceWarningsAreFatal, (String)"TrufflePerformanceWarningsAreFatal").deprecated(false).help("Treat performance warnings as fatal occurrences that will exit the applications").category(OptionCategory.INTERNAL).stability(OptionStability.EXPERIMENTAL).build(), OptionDescriptor.newBuilder(SharedTruffleRuntimeOptions.TruffleProfilingEnabled, (String)"TruffleProfilingEnabled").deprecated(false).help("Enable/disable builtin profiles in com.oracle.truffle.api.profiles.").category(OptionCategory.INTERNAL).stability(OptionStability.EXPERIMENTAL).build(), OptionDescriptor.newBuilder(SharedTruffleRuntimeOptions.TruffleReplaceReprofileCount, (String)"TruffleReplaceReprofileCount").deprecated(false).help("Delay compilation after a node replacement").category(OptionCategory.EXPERT).stability(OptionStability.EXPERIMENTAL).build(), OptionDescriptor.newBuilder(SharedTruffleRuntimeOptions.TruffleReturnTypeSpeculation, (String)"TruffleReturnTypeSpeculation").deprecated(false).help("").category(OptionCategory.INTERNAL).stability(OptionStability.EXPERIMENTAL).build(), OptionDescriptor.newBuilder(SharedTruffleRuntimeOptions.TruffleSplitting, (String)"TruffleSplitting").deprecated(false).help("Enable call target splitting").category(OptionCategory.EXPERT).stability(OptionStability.EXPERIMENTAL).build(), OptionDescriptor.newBuilder(SharedTruffleRuntimeOptions.TruffleSplittingAllowForcedSplits, (String)"TruffleSplittingAllowForcedSplits").deprecated(false).help("Should forced splits be allowed.").category(OptionCategory.EXPERT).stability(OptionStability.EXPERIMENTAL).build(), OptionDescriptor.newBuilder(SharedTruffleRuntimeOptions.TruffleSplittingDumpDecisions, (String)"TruffleSplittingDumpDecisions").deprecated(false).help("Dumps to IGV information on polymorphic events").category(OptionCategory.EXPERT).stability(OptionStability.EXPERIMENTAL).build(), OptionDescriptor.newBuilder(SharedTruffleRuntimeOptions.TruffleSplittingGrowthLimit, (String)"TruffleSplittingGrowthLimit").deprecated(false).help("Disable call target splitting if the number of nodes created by splitting exceeds this factor times node count").category(OptionCategory.INTERNAL).stability(OptionStability.EXPERIMENTAL).build(), OptionDescriptor.newBuilder(SharedTruffleRuntimeOptions.TruffleSplittingMaxCalleeSize, (String)"TruffleSplittingMaxCalleeSize").deprecated(false).help("Disable call target splitting if tree size exceeds this limit").category(OptionCategory.INTERNAL).stability(OptionStability.EXPERIMENTAL).build(), OptionDescriptor.newBuilder(SharedTruffleRuntimeOptions.TruffleSplittingMaxNumberOfSplitNodes, (String)"TruffleSplittingMaxNumberOfSplitNodes").deprecated(false).help("Disable call target splitting if number of nodes created by splitting exceeds this limit").category(OptionCategory.INTERNAL).stability(OptionStability.EXPERIMENTAL).build(), OptionDescriptor.newBuilder(SharedTruffleRuntimeOptions.TruffleSplittingMaxPropagationDepth, (String)"TruffleSplittingMaxPropagationDepth").deprecated(false).help("Propagate info about a polymorphic specialize through maximum this many call targets").category(OptionCategory.INTERNAL).stability(OptionStability.EXPERIMENTAL).build(), OptionDescriptor.newBuilder(SharedTruffleRuntimeOptions.TruffleSplittingTraceEvents, (String)"TruffleSplittingTraceEvents").deprecated(false).help("Trace details of splitting events and decisions.").category(OptionCategory.EXPERT).stability(OptionStability.EXPERIMENTAL).build(), OptionDescriptor.newBuilder(SharedTruffleRuntimeOptions.TruffleTraceSplittingSummary, (String)"TruffleTraceSplittingSummary").deprecated(false).help("Used for debugging the splitting implementation. Prints splitting summary directly to stdout on shutdown").category(OptionCategory.EXPERT).stability(OptionStability.EXPERIMENTAL).build()).iterator();
    }
}

