/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.compiler.truffle.runtime;

import com.oracle.truffle.api.Option;
import org.graalvm.compiler.truffle.options.PolyglotCompilerOptions;
import org.graalvm.options.OptionCategory;
import org.graalvm.options.OptionKey;
import org.graalvm.options.OptionType;

public abstract class SharedTruffleRuntimeOptions {
    @Option(help="Restrict compilation to comma-separated list of includes (or excludes prefixed with tilde).%n%nEBNF format of argument value:  CompileOnly = Element, { ',', Element } ;", category=OptionCategory.INTERNAL)
    static final OptionKey<String> TruffleCompileOnly = new OptionKey(PolyglotCompilerOptions.CompileOnly.getDefaultValue(), OptionType.defaultType(String.class));
    @Option(help="Enable or disable truffle compilation.", category=OptionCategory.INTERNAL)
    static final OptionKey<Boolean> TruffleCompilation = new OptionKey(PolyglotCompilerOptions.Compilation.getDefaultValue(), OptionType.defaultType(Boolean.class));
    @Option(help="Compile immediately to test truffle compiler", category=OptionCategory.INTERNAL)
    static final OptionKey<Boolean> TruffleCompileImmediately = new OptionKey(PolyglotCompilerOptions.CompileImmediately.getDefaultValue(), OptionType.defaultType(Boolean.class));
    @Option(help="Compile call target when call count exceeds this threshold.", category=OptionCategory.USER)
    static final OptionKey<Integer> TruffleCompilationThreshold = new OptionKey(PolyglotCompilerOptions.CompilationThreshold.getDefaultValue(), OptionType.defaultType(Integer.class));
    @Option(help="Compile call target in the first tier when call count exceeds this threshold.", category=OptionCategory.EXPERT)
    static final OptionKey<Integer> TruffleFirstTierCompilationThreshold = new OptionKey(PolyglotCompilerOptions.FirstTierCompilationThreshold.getDefaultValue(), OptionType.defaultType(Integer.class));
    @Option(help="Minimum number of calls before a call target is compiled in the first tier.", category=OptionCategory.EXPERT)
    static final OptionKey<Integer> TruffleFirstTierMinInvokeThreshold = new OptionKey(PolyglotCompilerOptions.FirstTierMinInvokeThreshold.getDefaultValue(), OptionType.defaultType(Integer.class));
    @Option(help="Minimum number of calls before a call target is compiled", category=OptionCategory.EXPERT)
    static final OptionKey<Integer> TruffleMinInvokeThreshold = new OptionKey(PolyglotCompilerOptions.MinInvokeThreshold.getDefaultValue(), OptionType.defaultType(Integer.class));
    @Option(help="Delay compilation after an invalidation to allow for reprofiling", category=OptionCategory.EXPERT)
    static final OptionKey<Integer> TruffleInvalidationReprofileCount = new OptionKey(PolyglotCompilerOptions.InvalidationReprofileCount.getDefaultValue(), OptionType.defaultType(Integer.class));
    @Option(help="Delay compilation after a node replacement", category=OptionCategory.EXPERT)
    static final OptionKey<Integer> TruffleReplaceReprofileCount = new OptionKey(PolyglotCompilerOptions.ReplaceReprofileCount.getDefaultValue(), OptionType.defaultType(Integer.class));
    @Option(help="Enable automatic inlining of call targets", category=OptionCategory.INTERNAL)
    static final OptionKey<Boolean> TruffleFunctionInlining = new OptionKey(PolyglotCompilerOptions.Inlining.getDefaultValue(), OptionType.defaultType(Boolean.class));
    @Option(help="Use language-agnostic inlining (overrides the TruffleFunctionInlining setting, option is experimental).", category=OptionCategory.EXPERT)
    static final OptionKey<Boolean> TruffleLanguageAgnosticInlining = new OptionKey(PolyglotCompilerOptions.LanguageAgnosticInlining.getDefaultValue(), OptionType.defaultType(Boolean.class));
    @Option(help="Stop inlining if caller's cumulative tree size would exceed this limit", category=OptionCategory.EXPERT)
    static final OptionKey<Integer> TruffleInliningMaxCallerSize = new OptionKey(PolyglotCompilerOptions.InliningNodeBudget.getDefaultValue(), OptionType.defaultType(Integer.class));
    @Option(help="Maximum level of recursive inlining", category=OptionCategory.EXPERT)
    static final OptionKey<Integer> TruffleMaximumRecursiveInlining = new OptionKey(PolyglotCompilerOptions.InliningRecursionDepth.getDefaultValue(), OptionType.defaultType(Integer.class));
    @Option(help="Enable call target splitting", category=OptionCategory.EXPERT)
    static final OptionKey<Boolean> TruffleSplitting = new OptionKey(PolyglotCompilerOptions.Splitting.getDefaultValue(), OptionType.defaultType(Boolean.class));
    @Option(help="Enable on stack replacement for Truffle loops.", category=OptionCategory.INTERNAL)
    static final OptionKey<Boolean> TruffleOSR = new OptionKey(PolyglotCompilerOptions.OSR.getDefaultValue(), OptionType.defaultType(Boolean.class));
    @Option(help="Number of loop iterations until on-stack-replacement compilation is triggered.", category=OptionCategory.INTERNAL)
    static final OptionKey<Integer> TruffleOSRCompilationThreshold = new OptionKey(PolyglotCompilerOptions.OSRCompilationThreshold.getDefaultValue(), OptionType.defaultType(Integer.class));
    @Option(help="Disable call target splitting if tree size exceeds this limit", category=OptionCategory.INTERNAL)
    static final OptionKey<Integer> TruffleSplittingMaxCalleeSize = new OptionKey(PolyglotCompilerOptions.SplittingMaxCalleeSize.getDefaultValue(), OptionType.defaultType(Integer.class));
    @Option(help="Disable call target splitting if the number of nodes created by splitting exceeds this factor times node count", category=OptionCategory.INTERNAL)
    static final OptionKey<Double> TruffleSplittingGrowthLimit = new OptionKey(PolyglotCompilerOptions.SplittingGrowthLimit.getDefaultValue(), OptionType.defaultType(Double.class));
    @Option(help="Disable call target splitting if number of nodes created by splitting exceeds this limit", category=OptionCategory.INTERNAL)
    static final OptionKey<Integer> TruffleSplittingMaxNumberOfSplitNodes = new OptionKey(PolyglotCompilerOptions.SplittingMaxNumberOfSplitNodes.getDefaultValue(), OptionType.defaultType(Integer.class));
    @Option(help="Propagate info about a polymorphic specialize through maximum this many call targets", category=OptionCategory.INTERNAL)
    static final OptionKey<Integer> TruffleSplittingMaxPropagationDepth = new OptionKey(PolyglotCompilerOptions.SplittingMaxPropagationDepth.getDefaultValue(), OptionType.defaultType(Integer.class));
    @Option(help="Used for debugging the splitting implementation. Prints splitting summary directly to stdout on shutdown", category=OptionCategory.EXPERT)
    static final OptionKey<Boolean> TruffleTraceSplittingSummary = new OptionKey(PolyglotCompilerOptions.TraceSplittingSummary.getDefaultValue(), OptionType.defaultType(Boolean.class));
    @Option(help="Trace details of splitting events and decisions.", category=OptionCategory.EXPERT)
    static final OptionKey<Boolean> TruffleSplittingTraceEvents = new OptionKey(PolyglotCompilerOptions.SplittingTraceEvents.getDefaultValue(), OptionType.defaultType(Boolean.class));
    @Option(help="Dumps to IGV information on polymorphic events", category=OptionCategory.EXPERT)
    static final OptionKey<Boolean> TruffleSplittingDumpDecisions = new OptionKey(PolyglotCompilerOptions.SplittingDumpDecisions.getDefaultValue(), OptionType.defaultType(Boolean.class));
    @Option(help="Should forced splits be allowed.", category=OptionCategory.EXPERT)
    static final OptionKey<Boolean> TruffleSplittingAllowForcedSplits = new OptionKey(PolyglotCompilerOptions.SplittingAllowForcedSplits.getDefaultValue(), OptionType.defaultType(Boolean.class));
    @Option(help="Enable asynchronous truffle compilation in background thread", category=OptionCategory.EXPERT)
    static final OptionKey<Boolean> TruffleBackgroundCompilation = new OptionKey(PolyglotCompilerOptions.BackgroundCompilation.getDefaultValue(), OptionType.defaultType(Boolean.class));
    @Option(help="Manually set the number of compiler threads", category=OptionCategory.EXPERT)
    static final OptionKey<Integer> TruffleCompilerThreads = new OptionKey(PolyglotCompilerOptions.CompilerThreads.getDefaultValue(), OptionType.defaultType(Integer.class));
    @Option(help="", category=OptionCategory.INTERNAL)
    static final OptionKey<Boolean> TruffleReturnTypeSpeculation = new OptionKey(PolyglotCompilerOptions.ReturnTypeSpeculation.getDefaultValue(), OptionType.defaultType(Boolean.class));
    @Option(help="", category=OptionCategory.INTERNAL)
    static final OptionKey<Boolean> TruffleArgumentTypeSpeculation = new OptionKey(PolyglotCompilerOptions.ArgumentTypeSpeculation.getDefaultValue(), OptionType.defaultType(Boolean.class));
    @Option(help="Print information for compilation results", category=OptionCategory.INTERNAL)
    static final OptionKey<Boolean> TraceTruffleCompilation = new OptionKey(PolyglotCompilerOptions.TraceCompilation.getDefaultValue(), OptionType.defaultType(Boolean.class));
    @Option(help="Print information for compilation queuing", category=OptionCategory.INTERNAL)
    static final OptionKey<Boolean> TraceTruffleCompilationDetails = new OptionKey(PolyglotCompilerOptions.TraceCompilationDetails.getDefaultValue(), OptionType.defaultType(Boolean.class));
    @Option(help="Print all polymorphic and generic nodes after each compilation", category=OptionCategory.INTERNAL)
    static final OptionKey<Boolean> TraceTruffleCompilationPolymorphism = new OptionKey(PolyglotCompilerOptions.TraceCompilationPolymorphism.getDefaultValue(), OptionType.defaultType(Boolean.class));
    @Option(help="Print the entire AST after each compilation", category=OptionCategory.INTERNAL)
    static final OptionKey<Boolean> TraceTruffleCompilationAST = new OptionKey(PolyglotCompilerOptions.TraceCompilationAST.getDefaultValue(), OptionType.defaultType(Boolean.class));
    @Option(help="Print the inlined call tree for each compiled method", category=OptionCategory.INTERNAL)
    static final OptionKey<Boolean> TraceTruffleCompilationCallTree = new OptionKey(PolyglotCompilerOptions.TraceCompilationCallTree.getDefaultValue(), OptionType.defaultType(Boolean.class));
    @Option(help="Treat compilation exceptions as fatal exceptions that will exit the application", category=OptionCategory.INTERNAL)
    static final OptionKey<Boolean> TruffleCompilationExceptionsAreFatal = new OptionKey(PolyglotCompilerOptions.CompilationExceptionsAreFatal.getDefaultValue(), OptionType.defaultType(Boolean.class));
    @Option(help="Treat performance warnings as fatal occurrences that will exit the applications", category=OptionCategory.INTERNAL)
    static final OptionKey<Boolean> TrufflePerformanceWarningsAreFatal = new OptionKey((Object)false, OptionType.defaultType(Boolean.class));
    @Option(help="Prints the exception stack trace for compilation exceptions", category=OptionCategory.INTERNAL)
    static final OptionKey<Boolean> TruffleCompilationExceptionsArePrinted = new OptionKey(PolyglotCompilerOptions.CompilationExceptionsArePrinted.getDefaultValue(), OptionType.defaultType(Boolean.class));
    @Option(help="Treat compilation exceptions as thrown runtime exceptions", category=OptionCategory.INTERNAL)
    static final OptionKey<Boolean> TruffleCompilationExceptionsAreThrown = new OptionKey(PolyglotCompilerOptions.CompilationExceptionsAreThrown.getDefaultValue(), OptionType.defaultType(Boolean.class));
    @Option(help="Print information for inlining for each compilation.", category=OptionCategory.INTERNAL)
    static final OptionKey<Boolean> TraceTruffleInlining = new OptionKey(PolyglotCompilerOptions.TraceInlining.getDefaultValue(), OptionType.defaultType(Boolean.class));
    @Option(help="Print information for each splitted call site.", category=OptionCategory.INTERNAL)
    static final OptionKey<Boolean> TraceTruffleSplitting = new OptionKey(PolyglotCompilerOptions.TraceSplitting.getDefaultValue(), OptionType.defaultType(Boolean.class));
    @Option(help="Print stack trace on assumption invalidation", category=OptionCategory.INTERNAL)
    static final OptionKey<Boolean> TraceTruffleAssumptions = new OptionKey(PolyglotCompilerOptions.TraceAssumptions.getDefaultValue(), OptionType.defaultType(Boolean.class));
    @Option(help="Number of stack trace elements printed by TraceTruffleTransferToInterpreter and TraceTruffleAssumptions", category=OptionCategory.INTERNAL)
    static final OptionKey<Integer> TraceTruffleStackTraceLimit = new OptionKey(PolyglotCompilerOptions.TraceStackTraceLimit.getDefaultValue(), OptionType.defaultType(Integer.class));
    @Option(help="Print Truffle compilation statistics at the end of a run.", category=OptionCategory.INTERNAL)
    static final OptionKey<Boolean> TruffleCompilationStatistics = new OptionKey(PolyglotCompilerOptions.CompilationStatistics.getDefaultValue(), OptionType.defaultType(Boolean.class));
    @Option(help="Print additional more verbose Truffle compilation statistics at the end of a run.", category=OptionCategory.INTERNAL)
    static final OptionKey<Boolean> TruffleCompilationStatisticDetails = new OptionKey(PolyglotCompilerOptions.CompilationStatisticDetails.getDefaultValue(), OptionType.defaultType(Boolean.class));
    @Option(help="Enable/disable builtin profiles in com.oracle.truffle.api.profiles.", category=OptionCategory.INTERNAL)
    static final OptionKey<Boolean> TruffleProfilingEnabled = new OptionKey(PolyglotCompilerOptions.Profiling.getDefaultValue(), OptionType.defaultType(Boolean.class));
    @Option(help="Print stack trace on transfer to interpreter.", category=OptionCategory.INTERNAL)
    static final OptionKey<Boolean> TraceTruffleTransferToInterpreter = new OptionKey(PolyglotCompilerOptions.TraceTransferToInterpreter.getDefaultValue(), OptionType.defaultType(Boolean.class));
    @Option(help="Whether to use multiple Truffle compilation tiers by default.", category=OptionCategory.EXPERT)
    static final OptionKey<Boolean> TruffleMultiTier = new OptionKey(PolyglotCompilerOptions.MultiTier.getDefaultValue(), OptionType.defaultType(Boolean.class));
    @Option(help="Enable dumping Truffle ASTs to the IdealGraphVisualizer.", category=OptionCategory.INTERNAL)
    static final OptionKey<Boolean> PrintTruffleTrees = new OptionKey((Object)true, OptionType.defaultType(Boolean.class));
}

