/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.compiler.truffle.runtime;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.ReplaceObserver;
import com.oracle.truffle.api.Truffle;
import com.oracle.truffle.api.frame.FrameDescriptor;
import com.oracle.truffle.api.frame.FrameSlot;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.ExplodeLoop;
import com.oracle.truffle.api.nodes.LoopNode;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.RepeatingNode;
import com.oracle.truffle.api.nodes.RootNode;
import com.oracle.truffle.api.source.SourceSection;
import java.util.Objects;
import jdk.vm.ci.meta.SpeculationLog;
import org.graalvm.compiler.truffle.options.PolyglotCompilerOptions;
import org.graalvm.compiler.truffle.runtime.FrameWithoutBoxing;
import org.graalvm.compiler.truffle.runtime.GraalTVMCI;
import org.graalvm.compiler.truffle.runtime.GraalTruffleRuntime;
import org.graalvm.compiler.truffle.runtime.OptimizedCallTarget;
import org.graalvm.compiler.truffle.runtime.OptimizedLoopNode;
import org.graalvm.compiler.truffle.runtime.TruffleRuntimeOptions;
import org.graalvm.options.OptionValues;

public abstract class OptimizedOSRLoopNode
extends LoopNode
implements ReplaceObserver {
    @Node.Child
    private RepeatingNode repeatableNode;
    private volatile OptimizedCallTarget compiledOSRLoop;
    private volatile SpeculationLog speculationLog;
    private int baseLoopCount;
    private final int osrThreshold;

    private OptimizedOSRLoopNode(RepeatingNode repeatableNode, int osrThreshold) {
        Objects.requireNonNull(repeatableNode);
        this.repeatableNode = repeatableNode;
        this.osrThreshold = osrThreshold;
    }

    protected OSRRootNode createRootNode(FrameDescriptor rootFrameDescriptor, Class<? extends VirtualFrame> clazz) {
        return new OSRRootNode(this, new FrameDescriptor(), clazz);
    }

    public final Node copy() {
        OptimizedOSRLoopNode copy = (OptimizedOSRLoopNode)super.copy();
        copy.compiledOSRLoop = null;
        return copy;
    }

    public final RepeatingNode getRepeatingNode() {
        return this.repeatableNode;
    }

    public void executeLoop(VirtualFrame frame) {
        this.execute(frame);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object execute(VirtualFrame frame) {
        Object status;
        if (CompilerDirectives.inInterpreter()) {
            try {
                Object status2 = RepeatingNode.CONTINUE_LOOP_STATUS;
                while (status2 == RepeatingNode.CONTINUE_LOOP_STATUS) {
                    if (this.compiledOSRLoop == null) {
                        status2 = this.profilingLoop(frame);
                        continue;
                    }
                    status2 = this.compilingLoop(frame);
                }
                Object object = status2;
                return object;
            }
            finally {
                this.baseLoopCount = 0;
            }
        }
        while ((status = this.repeatableNode.executeRepeatingWithValue(frame)) == RepeatingNode.CONTINUE_LOOP_STATUS) {
            if (!CompilerDirectives.inInterpreter()) continue;
            return this.execute(frame);
        }
        return status;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Object profilingLoop(VirtualFrame frame) {
        int iterations = 0;
        try {
            Object status;
            while ((status = this.repeatableNode.executeRepeatingWithValue(frame)) == RepeatingNode.CONTINUE_LOOP_STATUS) {
                if (++iterations + this.baseLoopCount <= this.osrThreshold) continue;
                this.compileLoop(frame);
                Object object = status;
                return object;
            }
            Object object = status;
            return object;
        }
        finally {
            this.baseLoopCount += iterations;
            this.reportParentLoopCount(iterations);
        }
    }

    private void reportParentLoopCount(int iterations) {
        Node parent = this.getParent();
        if (parent != null) {
            LoopNode.reportLoopCount((Node)parent, (int)iterations);
        }
    }

    final void reportChildLoopCount(int iterations) {
        this.baseLoopCount += iterations;
    }

    public final void forceOSR() {
        this.baseLoopCount = this.osrThreshold;
        RootNode rootNode = this.getRootNode();
        VirtualFrame dummyFrame = Truffle.getRuntime().createVirtualFrame(new Object[]{}, rootNode != null ? rootNode.getFrameDescriptor() : new FrameDescriptor());
        this.compileLoop(dummyFrame);
    }

    public final OptimizedCallTarget getCompiledOSRLoop() {
        return this.compiledOSRLoop;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Object compilingLoop(VirtualFrame frame) {
        int iterations = 0;
        try {
            Object status;
            do {
                OptimizedCallTarget target;
                if ((target = this.compiledOSRLoop) == null) {
                    Object object = RepeatingNode.CONTINUE_LOOP_STATUS;
                    return object;
                }
                if (!target.isSubmittedForCompilation()) {
                    if (target.isValid()) {
                        Object object = this.callOSR(target, frame);
                        return object;
                    }
                    this.invalidateOSRTarget((Object)this, "OSR compilation failed or cancelled");
                    Object object = RepeatingNode.CONTINUE_LOOP_STATUS;
                    return object;
                }
                ++iterations;
            } while ((status = this.repeatableNode.executeRepeatingWithValue(frame)) == RepeatingNode.CONTINUE_LOOP_STATUS);
            Object object = status;
            return object;
        }
        finally {
            this.baseLoopCount += iterations;
            this.reportParentLoopCount(iterations);
        }
    }

    private Object callOSR(OptimizedCallTarget target, VirtualFrame frame) {
        Object status = target.callOSR(frame);
        if (!RepeatingNode.CONTINUE_LOOP_STATUS.equals(status)) {
            return status;
        }
        if (!target.isValid()) {
            this.invalidateOSRTarget((Object)this, "OSR compilation got invalidated");
        }
        return status;
    }

    private void compileLoop(final VirtualFrame frame) {
        this.atomic(new Runnable(){

            @Override
            public void run() {
                if (OptimizedOSRLoopNode.this.compiledOSRLoop == null) {
                    OptimizedOSRLoopNode.this.compiledOSRLoop = OptimizedOSRLoopNode.this.compileImpl(frame);
                }
            }
        });
    }

    private OSRRootNode createRootNodeImpl(RootNode root, Class<? extends VirtualFrame> frameClass) {
        return this.createRootNode(root == null ? null : root.getFrameDescriptor(), frameClass);
    }

    private OptimizedCallTarget compileImpl(VirtualFrame frame) {
        RootNode root = this.getRootNode();
        if (this.speculationLog == null) {
            this.speculationLog = GraalTruffleRuntime.getRuntime().createSpeculationLog();
        }
        OptimizedCallTarget osrTarget = GraalTruffleRuntime.getRuntime().createOSRCallTarget(this.createRootNodeImpl(root, frame.getClass()));
        osrTarget.setSpeculationLog(this.speculationLog);
        osrTarget.compile(true);
        return osrTarget;
    }

    public final boolean nodeReplaced(Node oldNode, Node newNode, CharSequence reason) {
        this.callNodeReplacedOnOSRTarget(oldNode, newNode, reason);
        return false;
    }

    private void callNodeReplacedOnOSRTarget(final Node oldNode, final Node newNode, final CharSequence reason) {
        this.atomic(new Runnable(){

            @Override
            public void run() {
                OptimizedCallTarget target = OptimizedOSRLoopNode.this.compiledOSRLoop;
                if (target != null) {
                    OptimizedOSRLoopNode.this.compiledOSRLoop = null;
                    target.nodeReplaced(oldNode, newNode, reason);
                }
            }
        });
    }

    private void invalidateOSRTarget(final Object source, final CharSequence reason) {
        this.atomic(new Runnable(){

            @Override
            public void run() {
                OptimizedCallTarget target = OptimizedOSRLoopNode.this.compiledOSRLoop;
                if (target != null) {
                    OptimizedOSRLoopNode.this.compiledOSRLoop = null;
                    target.invalidate(source, reason);
                }
            }
        });
    }

    public static LoopNode create(RepeatingNode repeat) {
        OptionValues engineOptions = GraalTVMCI.getEngineData(null).engineOptions;
        if (TruffleRuntimeOptions.getPolyglotOptionValue(engineOptions, PolyglotCompilerOptions.OSR).booleanValue()) {
            return OptimizedOSRLoopNode.createDefault(repeat, engineOptions);
        }
        return OptimizedLoopNode.create(repeat);
    }

    private static LoopNode createDefault(RepeatingNode repeatableNode, OptionValues options) {
        return new OptimizedDefaultOSRLoopNode(repeatableNode, TruffleRuntimeOptions.getPolyglotOptionValue(options, PolyglotCompilerOptions.OSRCompilationThreshold));
    }

    public static OptimizedOSRLoopNode createOSRLoop(RepeatingNode repeating, int osrThreshold, FrameSlot[] readFrameSlots, FrameSlot[] writtenFrameSlots) {
        if (readFrameSlots == null != (writtenFrameSlots == null)) {
            throw new IllegalArgumentException("If either readFrameSlots or writtenFrameSlots is set both must be provided.");
        }
        return new OptimizedVirtualizingOSRLoopNode(repeating, osrThreshold, readFrameSlots, writtenFrameSlots);
    }

    @Deprecated
    public static OptimizedOSRLoopNode createOSRLoop(RepeatingNode repeating, int osrThreshold, int invalidationBackoff, FrameSlot[] readFrameSlots, FrameSlot[] writtenFrameSlots) {
        return OptimizedOSRLoopNode.createOSRLoop(repeating, osrThreshold, readFrameSlots, writtenFrameSlots);
    }

    private static final class VirtualizingOSRRootNode
    extends OSRRootNode {
        @CompilerDirectives.CompilationFinal(dimensions=1)
        private final FrameSlot[] readFrameSlots;
        @CompilerDirectives.CompilationFinal(dimensions=1)
        private final FrameSlot[] writtenFrameSlots;
        @CompilerDirectives.CompilationFinal(dimensions=1)
        private final byte[] readFrameSlotsTags;
        @CompilerDirectives.CompilationFinal(dimensions=1)
        private final byte[] writtenFrameSlotsTags;
        private final int maxTagsLength;

        VirtualizingOSRRootNode(VirtualizingOSRRootNode previousRoot, OptimizedOSRLoopNode loop, FrameDescriptor frameDescriptor, Class<? extends VirtualFrame> clazz) {
            super(loop, frameDescriptor, clazz);
            this.readFrameSlots = previousRoot.readFrameSlots;
            this.writtenFrameSlots = previousRoot.writtenFrameSlots;
            this.readFrameSlotsTags = previousRoot.readFrameSlotsTags;
            this.writtenFrameSlotsTags = previousRoot.writtenFrameSlotsTags;
            this.maxTagsLength = previousRoot.maxTagsLength;
        }

        VirtualizingOSRRootNode(OptimizedOSRLoopNode loop, FrameDescriptor frameDescriptor, Class<? extends VirtualFrame> clazz, FrameSlot[] readFrameSlots, FrameSlot[] writtenFrameSlots) {
            super(loop, frameDescriptor, clazz);
            this.readFrameSlots = readFrameSlots;
            this.writtenFrameSlots = writtenFrameSlots;
            this.readFrameSlotsTags = new byte[readFrameSlots.length];
            this.writtenFrameSlotsTags = new byte[writtenFrameSlots.length];
            int maxIndex = -1;
            maxIndex = VirtualizingOSRRootNode.initializeFrameSlots(frameDescriptor, readFrameSlots, this.readFrameSlotsTags, maxIndex);
            maxIndex = VirtualizingOSRRootNode.initializeFrameSlots(frameDescriptor, writtenFrameSlots, this.writtenFrameSlotsTags, maxIndex);
            this.maxTagsLength = maxIndex + 1;
        }

        private static int initializeFrameSlots(FrameDescriptor frameDescriptor, FrameSlot[] frameSlots, byte[] tags, int maxIndex) {
            int currentMaxIndex = maxIndex;
            for (int i = 0; i < frameSlots.length; ++i) {
                FrameSlot frameSlot = frameSlots[i];
                if (VirtualizingOSRRootNode.getFrameSlotIndex(frameSlot) > currentMaxIndex) {
                    currentMaxIndex = VirtualizingOSRRootNode.getFrameSlotIndex(frameSlot);
                }
                tags[i] = frameDescriptor.getFrameSlotKind((FrameSlot)frameSlot).tag;
            }
            return currentMaxIndex;
        }

        private static int getFrameSlotIndex(FrameSlot slot) {
            return slot.getIndex();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        protected Object executeImpl(VirtualFrame originalFrame) {
            FrameWithoutBoxing loopFrame = (FrameWithoutBoxing)originalFrame;
            FrameWithoutBoxing parentFrame = (FrameWithoutBoxing)loopFrame.getArguments()[0];
            this.executeTransfer(parentFrame, loopFrame, this.readFrameSlots, this.readFrameSlotsTags);
            try {
                Object status;
                while ((status = this.loopNode.getRepeatingNode().executeRepeatingWithValue((VirtualFrame)loopFrame)) == RepeatingNode.CONTINUE_LOOP_STATUS) {
                    if (!CompilerDirectives.inInterpreter()) continue;
                    Object object = RepeatingNode.CONTINUE_LOOP_STATUS;
                    return object;
                }
                Object object = status;
                return object;
            }
            finally {
                this.executeTransfer(loopFrame, parentFrame, this.writtenFrameSlots, this.writtenFrameSlotsTags);
            }
        }

        @ExplodeLoop
        private void executeTransfer(FrameWithoutBoxing source, FrameWithoutBoxing target, FrameSlot[] frameSlots, byte[] speculatedTags) {
            if (frameSlots == null) {
                return;
            }
            byte[] currentSourceTags = source.getTags();
            byte[] currentTargetTags = target.getTags();
            if (currentSourceTags.length < this.maxTagsLength || currentTargetTags.length < this.maxTagsLength) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                throw new AssertionError((Object)"Frames should never shrink.");
            }
            block9: for (int i = 0; i < frameSlots.length; ++i) {
                boolean tagsCondition;
                FrameSlot slot = frameSlots[i];
                int index = VirtualizingOSRRootNode.getFrameSlotIndex(slot);
                byte speculatedTag = speculatedTags[i];
                byte currentSourceTag = currentSourceTags[index];
                if (CompilerDirectives.inInterpreter() && currentSourceTag == 0 && speculatedTag != 0) {
                    if (frameSlots == this.readFrameSlots) {
                        throw new AssertionError((Object)("Frame slot " + slot + " was never written outside the loop but virtualized as read frame slot."));
                    }
                    throw new AssertionError((Object)("Frame slot " + slot + " was never written in the loop but virtualized as written frame slot."));
                }
                boolean bl = tagsCondition = speculatedTag == currentSourceTag;
                if (!tagsCondition) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                    speculatedTags[i] = currentSourceTag;
                    speculatedTag = currentSourceTag;
                }
                switch (speculatedTag) {
                    case 6: {
                        target.setBoolean(slot, source.getBooleanUnsafe(index, slot, tagsCondition));
                        continue block9;
                    }
                    case 7: {
                        target.setByte(slot, source.getByteUnsafe(index, slot, tagsCondition));
                        continue block9;
                    }
                    case 4: {
                        target.setDouble(slot, source.getDoubleUnsafe(index, slot, tagsCondition));
                        continue block9;
                    }
                    case 5: {
                        target.setFloat(slot, source.getFloatUnsafe(index, slot, tagsCondition));
                        continue block9;
                    }
                    case 3: {
                        target.setInt(slot, source.getIntUnsafe(index, slot, tagsCondition));
                        continue block9;
                    }
                    case 2: {
                        target.setLong(slot, source.getLongUnsafe(index, slot, tagsCondition));
                        continue block9;
                    }
                    case 0: {
                        target.setObject(slot, source.getObjectUnsafe(index, slot, tagsCondition));
                        continue block9;
                    }
                    default: {
                        CompilerDirectives.transferToInterpreterAndInvalidate();
                        throw new AssertionError((Object)("Defined frame slot " + slot + " is illegal. Revirtualization failed. Please initialize frame slot with a FrameSlotKind."));
                    }
                }
            }
        }
    }

    public static class OSRRootNode
    extends RootNode {
        protected final Class<? extends VirtualFrame> clazz;
        @Node.Child
        protected OptimizedOSRLoopNode loopNode;

        OSRRootNode(OptimizedOSRLoopNode loop, FrameDescriptor frameDescriptor, Class<? extends VirtualFrame> clazz) {
            super(null, frameDescriptor);
            this.loopNode = loop;
            this.clazz = clazz;
        }

        public SourceSection getSourceSection() {
            return this.loopNode.getSourceSection();
        }

        public static Object callProxy(OSRRootNode target, VirtualFrame frame) {
            return target.executeImpl(frame);
        }

        protected Object executeImpl(VirtualFrame frame) {
            Object status;
            VirtualFrame parentFrame = this.clazz.cast(frame.getArguments()[0]);
            while ((status = this.loopNode.getRepeatingNode().executeRepeatingWithValue(parentFrame)) == RepeatingNode.CONTINUE_LOOP_STATUS) {
                if (!CompilerDirectives.inInterpreter()) continue;
                return RepeatingNode.CONTINUE_LOOP_STATUS;
            }
            return status;
        }

        public final Object execute(VirtualFrame frame) {
            return OSRRootNode.callProxy(this, frame);
        }

        public final boolean isCloningAllowed() {
            return false;
        }

        public final String toString() {
            return this.loopNode.getRepeatingNode().toString() + "<OSR>";
        }
    }

    private static final class OptimizedVirtualizingOSRLoopNode
    extends OptimizedOSRLoopNode {
        @CompilerDirectives.CompilationFinal(dimensions=1)
        private final FrameSlot[] readFrameSlots;
        @CompilerDirectives.CompilationFinal(dimensions=1)
        private final FrameSlot[] writtenFrameSlots;
        private VirtualizingOSRRootNode previousRoot;

        private OptimizedVirtualizingOSRLoopNode(RepeatingNode repeatableNode, int osrThreshold, FrameSlot[] readFrameSlots, FrameSlot[] writtenFrameSlots) {
            super(repeatableNode, osrThreshold);
            this.readFrameSlots = readFrameSlots;
            this.writtenFrameSlots = writtenFrameSlots;
        }

        @Override
        protected OSRRootNode createRootNode(FrameDescriptor rootFrameDescriptor, Class<? extends VirtualFrame> clazz) {
            if (this.readFrameSlots == null || this.writtenFrameSlots == null) {
                return super.createRootNode(rootFrameDescriptor, clazz);
            }
            FrameDescriptor frameDescriptor = rootFrameDescriptor == null ? new FrameDescriptor() : rootFrameDescriptor;
            this.previousRoot = this.previousRoot == null ? new VirtualizingOSRRootNode(this, frameDescriptor, clazz, this.readFrameSlots, this.writtenFrameSlots) : new VirtualizingOSRRootNode(this.previousRoot, this, frameDescriptor, clazz);
            return this.previousRoot;
        }
    }

    private static final class OptimizedDefaultOSRLoopNode
    extends OptimizedOSRLoopNode {
        OptimizedDefaultOSRLoopNode(RepeatingNode repeatableNode, int osrThreshold) {
            super(repeatableNode, osrThreshold);
        }
    }
}

