/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.compiler.truffle.runtime;

import com.oracle.truffle.api.CallTarget;
import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.nodes.EncapsulatingNodeReference;
import com.oracle.truffle.api.nodes.IndirectCallNode;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.NodeInfo;
import com.oracle.truffle.api.profiles.ValueProfile;
import org.graalvm.compiler.truffle.runtime.GraalRuntimeAccessor;
import org.graalvm.compiler.truffle.runtime.OptimizedCallTarget;

@NodeInfo
public final class OptimizedIndirectCallNode
extends IndirectCallNode {
    @CompilerDirectives.CompilationFinal
    private ValueProfile exceptionProfile;

    OptimizedIndirectCallNode() {
    }

    public Object call(CallTarget target, Object ... arguments) {
        try {
            return ((OptimizedCallTarget)target).callIndirect((Node)this, arguments);
        }
        catch (Throwable t) {
            if (this.exceptionProfile == null) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.exceptionProfile = ValueProfile.createClassProfile();
            }
            Throwable profiledT = (Throwable)this.exceptionProfile.profile((Object)t);
            GraalRuntimeAccessor.LANGUAGE.onThrowable((Node)this, null, profiledT, null);
            throw OptimizedCallTarget.rethrow(profiledT);
        }
    }

    static IndirectCallNode createUncached() {
        return new IndirectCallNode(){

            public boolean isAdoptable() {
                return false;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @CompilerDirectives.TruffleBoundary
            public Object call(CallTarget target, Object ... arguments) {
                EncapsulatingNodeReference encapsulating = EncapsulatingNodeReference.getCurrent();
                Node prev = encapsulating.set(null);
                try {
                    Object object = ((OptimizedCallTarget)target).callIndirect(prev, arguments);
                    return object;
                }
                finally {
                    encapsulating.set(prev);
                }
            }
        };
    }
}

