/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.compiler.truffle.runtime;

import com.oracle.truffle.api.CallTarget;
import com.oracle.truffle.api.CompilerAsserts;
import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.CompilerOptions;
import com.oracle.truffle.api.impl.DefaultCompilerOptions;
import com.oracle.truffle.api.nodes.DirectCallNode;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.NodeInfo;
import com.oracle.truffle.api.nodes.RootNode;
import org.graalvm.compiler.truffle.common.TruffleCallNode;
import org.graalvm.compiler.truffle.runtime.GraalRuntimeAccessor;
import org.graalvm.compiler.truffle.runtime.OptimizedCallTarget;
import org.graalvm.compiler.truffle.runtime.TruffleSplittingStrategy;

@NodeInfo
public final class OptimizedDirectCallNode
extends DirectCallNode
implements TruffleCallNode {
    private int callCount;
    private boolean inliningForced;
    @CompilerDirectives.CompilationFinal
    private Class<? extends Throwable> exceptionProfile;
    @CompilerDirectives.CompilationFinal
    private OptimizedCallTarget splitCallTarget;
    private volatile boolean splitDecided;

    OptimizedDirectCallNode(OptimizedCallTarget target) {
        super((CallTarget)target);
        assert (target.getSourceCallTarget() == null);
    }

    public Object call(Object ... arguments) {
        OptimizedCallTarget target = this.getCurrentCallTarget();
        if (CompilerDirectives.inInterpreter()) {
            target = this.onInterpreterCall(target);
        }
        try {
            return target.callDirect((Node)this, arguments);
        }
        catch (Throwable t) {
            Throwable profiledT = this.profileExceptionType(t);
            GraalRuntimeAccessor.LANGUAGE.onThrowable((Node)this, null, profiledT, null);
            throw OptimizedCallTarget.rethrow(profiledT);
        }
    }

    private <T extends Throwable> T profileExceptionType(T value) {
        Class<? extends Throwable> clazz = this.exceptionProfile;
        if (clazz != Throwable.class) {
            if (clazz != null && value.getClass() == clazz) {
                if (CompilerDirectives.inInterpreter()) {
                    return value;
                }
                return (T)((Throwable)CompilerDirectives.castExact(value, clazz));
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            this.exceptionProfile = clazz == null ? value.getClass() : Throwable.class;
        }
        return value;
    }

    public boolean isInlinable() {
        CompilerAsserts.neverPartOfCompilation();
        return true;
    }

    public void forceInlining() {
        CompilerAsserts.neverPartOfCompilation();
        this.inliningForced = true;
    }

    @Override
    public boolean isInliningForced() {
        CompilerAsserts.neverPartOfCompilation();
        return this.inliningForced;
    }

    public boolean isCallTargetCloningAllowed() {
        return this.getCallTarget().getRootNode().isCloningAllowed();
    }

    public OptimizedCallTarget getCallTarget() {
        return (OptimizedCallTarget)super.getCallTarget();
    }

    @Override
    public int getCallCount() {
        return this.callCount;
    }

    public CompilerOptions getCompilerOptions() {
        RootNode rootNode = this.getRootNode();
        return rootNode != null ? rootNode.getCompilerOptions() : DefaultCompilerOptions.INSTANCE;
    }

    @Override
    public OptimizedCallTarget getCurrentCallTarget() {
        return (OptimizedCallTarget)super.getCurrentCallTarget();
    }

    public int getKnownCallSiteCount() {
        return this.getCurrentCallTarget().getKnownCallSiteCount();
    }

    public OptimizedCallTarget getClonedCallTarget() {
        return this.splitCallTarget;
    }

    private OptimizedCallTarget onInterpreterCall(OptimizedCallTarget target) {
        ++this.callCount;
        if (target.isNeedsSplit() && !this.splitDecided) {
            this.splitDecided = true;
            TruffleSplittingStrategy.beforeCall(this, target);
            return this.getCurrentCallTarget();
        }
        return target;
    }

    void split() {
        CompilerAsserts.neverPartOfCompilation();
        this.atomic(() -> {
            if (this.splitCallTarget != null) {
                return;
            }
            assert (this.isCallTargetCloningAllowed());
            OptimizedCallTarget currentTarget = this.getCallTarget();
            OptimizedCallTarget splitTarget = this.getCallTarget().cloneUninitialized();
            currentTarget.removeDirectCallNode(this);
            splitTarget.addDirectCallNode(this);
            assert (splitTarget.getCallSiteForSplit() == this);
            if (this.getParent() != null) {
                this.replace((Node)this, "Split call node");
            }
            this.splitCallTarget = splitTarget;
            OptimizedCallTarget.runtime().getListener().onCompilationSplit(this);
        });
    }

    public boolean cloneCallTarget() {
        TruffleSplittingStrategy.forceSplitting(this);
        return true;
    }
}

