/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.compiler.truffle.runtime;

import com.oracle.truffle.api.Assumption;
import com.oracle.truffle.api.CompilerAsserts;
import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.CompilerOptions;
import com.oracle.truffle.api.OptimizationFailedException;
import com.oracle.truffle.api.ReplaceObserver;
import com.oracle.truffle.api.RootCallTarget;
import com.oracle.truffle.api.Truffle;
import com.oracle.truffle.api.frame.Frame;
import com.oracle.truffle.api.frame.FrameDescriptor;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.impl.DefaultCompilerOptions;
import com.oracle.truffle.api.nodes.ControlFlowException;
import com.oracle.truffle.api.nodes.EncapsulatingNodeReference;
import com.oracle.truffle.api.nodes.ExplodeLoop;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.NodeUtil;
import com.oracle.truffle.api.nodes.NodeVisitor;
import com.oracle.truffle.api.nodes.RootNode;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.atomic.AtomicReferenceFieldUpdater;
import java.util.function.Supplier;
import java.util.function.UnaryOperator;
import jdk.vm.ci.meta.JavaConstant;
import jdk.vm.ci.meta.SpeculationLog;
import org.graalvm.compiler.truffle.common.CompilableTruffleAST;
import org.graalvm.compiler.truffle.common.TruffleCallNode;
import org.graalvm.compiler.truffle.options.PolyglotCompilerOptions;
import org.graalvm.compiler.truffle.runtime.CancellableCompileTask;
import org.graalvm.compiler.truffle.runtime.EngineData;
import org.graalvm.compiler.truffle.runtime.FrameWithoutBoxing;
import org.graalvm.compiler.truffle.runtime.GraalCompilerDirectives;
import org.graalvm.compiler.truffle.runtime.GraalRuntimeAccessor;
import org.graalvm.compiler.truffle.runtime.GraalTVMCI;
import org.graalvm.compiler.truffle.runtime.GraalTruffleRuntime;
import org.graalvm.compiler.truffle.runtime.GraalTruffleRuntimeListener;
import org.graalvm.compiler.truffle.runtime.OptimizedAssumption;
import org.graalvm.compiler.truffle.runtime.OptimizedDirectCallNode;
import org.graalvm.compiler.truffle.runtime.OptimizedOSRLoopNode;
import org.graalvm.compiler.truffle.runtime.PolymorphicSpecializeDump;
import org.graalvm.compiler.truffle.runtime.SuppressFBWarnings;
import org.graalvm.compiler.truffle.runtime.TruffleCallBoundary;
import org.graalvm.compiler.truffle.runtime.TruffleInlining;
import org.graalvm.compiler.truffle.runtime.TruffleRuntimeOptions;
import org.graalvm.options.OptionKey;
import org.graalvm.options.OptionValues;

public abstract class OptimizedCallTarget
implements CompilableTruffleAST,
RootCallTarget,
ReplaceObserver {
    private static final String NODE_REWRITING_ASSUMPTION_NAME = "nodeRewritingAssumption";
    static final String EXECUTE_ROOT_NODE_METHOD_NAME = "executeRootNode";
    private static final AtomicReferenceFieldUpdater<OptimizedCallTarget, SpeculationLog> SPECULATION_LOG_UPDATER = AtomicReferenceFieldUpdater.newUpdater(OptimizedCallTarget.class, SpeculationLog.class, "speculationLog");
    private static final AtomicReferenceFieldUpdater<OptimizedCallTarget, Assumption> NODE_REWRITING_ASSUMPTION_UPDATER = AtomicReferenceFieldUpdater.newUpdater(OptimizedCallTarget.class, Assumption.class, "nodeRewritingAssumption");
    private static final AtomicReferenceFieldUpdater<OptimizedCallTarget, ArgumentsProfile> ARGUMENTS_PROFILE_UPDATER = AtomicReferenceFieldUpdater.newUpdater(OptimizedCallTarget.class, ArgumentsProfile.class, "argumentsProfile");
    private static final AtomicReferenceFieldUpdater<OptimizedCallTarget, ReturnProfile> RETURN_PROFILE_UPDATER = AtomicReferenceFieldUpdater.newUpdater(OptimizedCallTarget.class, ReturnProfile.class, "returnProfile");
    private static final WeakReference<OptimizedDirectCallNode> NO_CALL = new WeakReference<Object>(null);
    private static final WeakReference<OptimizedDirectCallNode> MULTIPLE_CALLS = null;
    private static final String SPLIT_LOG_FORMAT = "[poly-event] %-70s %s";
    private static final int MAX_PROFILED_ARGUMENTS = 256;
    private final RootNode rootNode;
    @CompilerDirectives.CompilationFinal
    protected volatile boolean initialized;
    private int callCount;
    private int callAndLoopCount;
    @CompilerDirectives.CompilationFinal
    private volatile ArgumentsProfile argumentsProfile;
    @CompilerDirectives.CompilationFinal
    private volatile ReturnProfile returnProfile;
    @CompilerDirectives.CompilationFinal
    private Class<? extends Throwable> profiledExceptionType;
    private volatile boolean compilationFailed;
    @CompilerDirectives.CompilationFinal
    private boolean callProfiled;
    private volatile long initializedTimestamp;
    private volatile CancellableCompileTask compilationTask;
    private volatile boolean needsSplit;
    public final EngineData engine;
    private volatile RootNode uninitializedRootNode;
    private volatile SpeculationLog speculationLog;
    private final OptimizedCallTarget sourceCallTarget;
    private volatile Assumption nodeRewritingAssumption;
    private volatile int cachedNonTrivialNodeCount = -1;
    private volatile int callSitesKnown;
    private volatile String nameCache;
    private final int uninitializedNodeCount;
    private volatile WeakReference<OptimizedDirectCallNode> singleCallNode = NO_CALL;

    protected OptimizedCallTarget(OptimizedCallTarget sourceCallTarget, RootNode rootNode) {
        assert (sourceCallTarget == null || sourceCallTarget.sourceCallTarget == null) : "Cannot create a clone of a cloned CallTarget";
        this.sourceCallTarget = sourceCallTarget;
        this.speculationLog = sourceCallTarget != null ? sourceCallTarget.getSpeculationLog() : null;
        this.rootNode = rootNode;
        this.engine = GraalTVMCI.getEngineData(rootNode);
        this.resetCompilationProfile();
        this.uninitializedNodeCount = !(rootNode instanceof OptimizedOSRLoopNode.OSRRootNode) ? GraalRuntimeAccessor.NODES.adoptChildrenAndCount(rootNode) : -1;
        GraalRuntimeAccessor.NODES.setCallTarget(rootNode, (RootCallTarget)this);
    }

    final Assumption getNodeRewritingAssumption() {
        Assumption assumption = this.nodeRewritingAssumption;
        if (assumption == null) {
            assumption = this.initializeNodeRewritingAssumption();
        }
        return assumption;
    }

    @Override
    public JavaConstant getNodeRewritingAssumptionConstant() {
        return OptimizedCallTarget.runtime().forObject(this.getNodeRewritingAssumption());
    }

    private Assumption initializeNodeRewritingAssumption() {
        Assumption newAssumption = OptimizedCallTarget.runtime().createAssumption(this.getOptionValue(PolyglotCompilerOptions.TraceAssumptions) == false ? NODE_REWRITING_ASSUMPTION_NAME : "nodeRewritingAssumption of " + this.rootNode);
        if (NODE_REWRITING_ASSUMPTION_UPDATER.compareAndSet(this, null, newAssumption)) {
            return newAssumption;
        }
        return Objects.requireNonNull(this.nodeRewritingAssumption);
    }

    private void invalidateNodeRewritingAssumption() {
        Assumption oldAssumption = NODE_REWRITING_ASSUMPTION_UPDATER.getAndUpdate(this, new UnaryOperator<Assumption>(){

            @Override
            public Assumption apply(Assumption prev) {
                return prev == null ? null : OptimizedCallTarget.runtime().createAssumption(prev.getName());
            }
        });
        if (oldAssumption != null) {
            oldAssumption.invalidate();
        }
    }

    public final RootNode getRootNode() {
        return this.rootNode;
    }

    public final void resetCompilationProfile() {
        this.callCount = 0;
        this.callAndLoopCount = 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final Object call(Object ... args) {
        EncapsulatingNodeReference encapsulating = EncapsulatingNodeReference.getCurrent();
        Node encapsulatingNode = encapsulating.set(null);
        try {
            Object object = this.callIndirect(encapsulatingNode, args);
            return object;
        }
        finally {
            encapsulating.set(encapsulatingNode);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final Object callIndirect(Node location, Object ... args) {
        try {
            this.stopProfilingArguments();
            Object object = this.doInvoke(args);
            return object;
        }
        finally {
            assert (OptimizedCallTarget.keepAlive(location));
        }
    }

    public final Object callDirect(Node location, Object ... args) {
        try {
            this.profileArguments(args);
            Object result = this.doInvoke(args);
            if (CompilerDirectives.inCompiledCode()) {
                result = this.injectReturnValueProfile(result);
            }
            Object object = result;
            return object;
        }
        catch (Throwable t) {
            throw OptimizedCallTarget.rethrow(this.profileExceptionType(t));
        }
        finally {
            assert (OptimizedCallTarget.keepAlive(location));
        }
    }

    private static boolean keepAlive(Object o) {
        return true;
    }

    public final Object callOSR(Object ... args) {
        return this.doInvoke(args);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final Object callInlined(Node location, Object ... arguments) {
        try {
            this.ensureInitialized();
            Object object = this.executeRootNode(OptimizedCallTarget.createFrame(this.getRootNode().getFrameDescriptor(), arguments));
            return object;
        }
        finally {
            assert (OptimizedCallTarget.keepAlive(location));
        }
    }

    protected Object doInvoke(Object[] args) {
        return this.callBoundary(args);
    }

    @TruffleCallBoundary
    protected final Object callBoundary(Object[] args) {
        if (this.interpreterCall()) {
            return this.doInvoke(args);
        }
        return this.profiledPERoot(args);
    }

    private boolean interpreterCall() {
        if (this.isValid()) {
            OptimizedCallTarget.runtime().bypassedInstalledCode(this);
        }
        this.ensureInitialized();
        int intCallCount = this.callCount;
        this.callCount = intCallCount == Integer.MAX_VALUE ? intCallCount : ++intCallCount;
        int intAndLoopCallCount = this.callAndLoopCount;
        int n = this.callAndLoopCount = intAndLoopCallCount == Integer.MAX_VALUE ? intAndLoopCallCount : ++intAndLoopCallCount;
        if (intCallCount >= this.engine.firstTierCallThreshold && intAndLoopCallCount >= this.engine.firstTierCallAndLoopThreshold && !this.compilationFailed && !this.isSubmittedForCompilation()) {
            return this.compile(!this.engine.multiTier);
        }
        return false;
    }

    protected final Object profiledPERoot(Object[] originalArguments) {
        Object[] args = originalArguments;
        if (GraalCompilerDirectives.inFirstTier()) {
            this.firstTierCall();
        }
        if (CompilerDirectives.inCompiledCode()) {
            args = this.injectArgumentsProfile(originalArguments);
        }
        Object result = this.executeRootNode(OptimizedCallTarget.createFrame(this.getRootNode().getFrameDescriptor(), args));
        this.profileReturnValue(result);
        return result;
    }

    public final boolean firstTierCall() {
        int firstTierCallThreshold;
        if ((firstTierCallThreshold = ++this.callCount) >= this.engine.lastTierCallThreshold && !this.isSubmittedForCompilation() && !this.compilationFailed) {
            return OptimizedCallTarget.lastTierCompile(this);
        }
        return false;
    }

    @CompilerDirectives.TruffleBoundary
    private static boolean lastTierCompile(OptimizedCallTarget callTarget) {
        return callTarget.compile(true);
    }

    private Object executeRootNode(VirtualFrame frame) {
        boolean inCompiled = CompilerDirectives.inCompilationRoot();
        try {
            Object object = this.rootNode.execute(frame);
            return object;
        }
        catch (ControlFlowException t) {
            throw OptimizedCallTarget.rethrow(this.profileExceptionType(t));
        }
        catch (Throwable t) {
            Throwable profiledT = this.profileExceptionType(t);
            GraalRuntimeAccessor.LANGUAGE.onThrowable(null, (RootCallTarget)this, profiledT, (Frame)frame);
            throw OptimizedCallTarget.rethrow(profiledT);
        }
        finally {
            assert (frame != null && this != null);
            if (CompilerDirectives.inInterpreter() && inCompiled) {
                this.notifyDeoptimized(frame);
            }
        }
    }

    private void notifyDeoptimized(VirtualFrame frame) {
        OptimizedCallTarget.runtime().getListener().onCompilationDeoptimized(this, (Frame)frame);
    }

    static GraalTruffleRuntime runtime() {
        return (GraalTruffleRuntime)Truffle.getRuntime();
    }

    public final void ensureInitialized() {
        if (!this.initialized) {
            CompilerDirectives.transferToInterpreterAndInvalidate();
            this.initialize();
        }
    }

    private synchronized void initialize() {
        if (!this.initialized) {
            if (this.sourceCallTarget == null && this.rootNode.isCloningAllowed() && !GraalRuntimeAccessor.NODES.isCloneUninitializedSupported(this.rootNode)) {
                this.uninitializedRootNode = (RootNode)NodeUtil.cloneNode((Node)this.rootNode);
            }
            GraalRuntimeAccessor.INSTRUMENT.onFirstExecution(this.getRootNode());
            this.initializedTimestamp = this.engine.callTargetStatistics ? System.nanoTime() : 0L;
            this.initialized = true;
        }
    }

    public final OptionValues getOptionValues() {
        return this.engine.engineOptions;
    }

    public final <T> T getOptionValue(OptionKey<T> key) {
        return TruffleRuntimeOptions.getPolyglotOptionValue(this.getOptionValues(), key);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final boolean compile(boolean lastTierCompilation) {
        if (!this.needsCompile(lastTierCompilation)) {
            return true;
        }
        if (!this.isSubmittedForCompilation()) {
            if (!this.engine.acceptForCompilation(this.getRootNode())) {
                this.compilationFailed = true;
                return false;
            }
            CancellableCompileTask task = null;
            OptimizedCallTarget optimizedCallTarget = this;
            synchronized (optimizedCallTarget) {
                if (!this.needsCompile(lastTierCompilation)) {
                    return true;
                }
                this.ensureInitialized();
                if (!this.isSubmittedForCompilation()) {
                    try {
                        assert (this.compilationTask == null);
                        this.compilationTask = task = OptimizedCallTarget.runtime().submitForCompilation(this, lastTierCompilation);
                    }
                    catch (RejectedExecutionException e) {
                        return false;
                    }
                }
            }
            if (task != null) {
                OptimizedCallTarget.runtime().getListener().onCompilationQueued(this);
                return this.maybeWaitForTask(task);
            }
        }
        return false;
    }

    public final boolean maybeWaitForTask(CancellableCompileTask task) {
        boolean mayBeAsynchronous = this.engine.backgroundCompilation;
        OptimizedCallTarget.runtime().finishCompilation(this, task, mayBeAsynchronous);
        return !mayBeAsynchronous && this.isValid();
    }

    private boolean needsCompile(boolean isLastTierCompilation) {
        return !this.isValid() || this.engine.multiTier && isLastTierCompilation && !this.isValidLastTier();
    }

    public final boolean isSubmittedForCompilation() {
        return this.compilationTask != null;
    }

    public abstract long getCodeAddress();

    public abstract boolean isValid();

    public abstract boolean isValidLastTier();

    public final void invalidate(Object source, CharSequence reason) {
        this.cachedNonTrivialNodeCount = -1;
        if (this.isValid()) {
            this.invalidateCode();
            OptimizedCallTarget.runtime().getListener().onCompilationInvalidated(this, source, reason);
        }
        this.cancelCompilation(reason);
    }

    final OptimizedCallTarget cloneUninitialized() {
        RootNode clonedRoot;
        assert (this.sourceCallTarget == null);
        this.ensureInitialized();
        if (GraalRuntimeAccessor.NODES.isCloneUninitializedSupported(this.rootNode)) {
            assert (this.uninitializedRootNode == null);
            clonedRoot = GraalRuntimeAccessor.NODES.cloneUninitialized(this.rootNode);
        } else {
            clonedRoot = (RootNode)NodeUtil.cloneNode((Node)this.uninitializedRootNode);
        }
        return OptimizedCallTarget.runtime().createClonedCallTarget(clonedRoot, this);
    }

    public SpeculationLog getSpeculationLog() {
        if (this.speculationLog == null) {
            SPECULATION_LOG_UPDATER.compareAndSet(this, null, ((GraalTruffleRuntime)Truffle.getRuntime()).createSpeculationLog());
        }
        return this.speculationLog;
    }

    final void setSpeculationLog(SpeculationLog speculationLog) {
        this.speculationLog = speculationLog;
    }

    @Override
    public final JavaConstant asJavaConstant() {
        return GraalTruffleRuntime.getRuntime().forObject(this);
    }

    static <E extends Throwable> RuntimeException rethrow(Throwable ex) throws E {
        throw ex;
    }

    @Override
    public final boolean isSameOrSplit(CompilableTruffleAST ast) {
        if (!(ast instanceof OptimizedCallTarget)) {
            return false;
        }
        OptimizedCallTarget other = (OptimizedCallTarget)ast;
        return this == other || this == other.sourceCallTarget || other == this.sourceCallTarget || this.sourceCallTarget != null && other.sourceCallTarget != null && this.sourceCallTarget == other.sourceCallTarget;
    }

    @Override
    public boolean cancelCompilation(CharSequence reason) {
        if (!this.initialized) {
            return false;
        }
        if (this.cancelAndResetCompilationTask()) {
            OptimizedCallTarget.runtime().getListener().onCompilationDequeued(this, null, reason);
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean cancelAndResetCompilationTask() {
        CancellableCompileTask task = this.compilationTask;
        if (task != null) {
            OptimizedCallTarget optimizedCallTarget = this;
            synchronized (optimizedCallTarget) {
                task = this.compilationTask;
                if (task != null) {
                    return task.cancel();
                }
            }
        }
        return false;
    }

    @Override
    public final void onCompilationFailed(Supplier<String> serializedException, boolean bailout, boolean permanentBailout) {
        PolyglotCompilerOptions.ExceptionAction action;
        if (bailout && !permanentBailout) {
            action = PolyglotCompilerOptions.ExceptionAction.Silent;
        } else {
            this.compilationFailed = true;
            action = this.engine.compilationFailureAction;
        }
        if (action == PolyglotCompilerOptions.ExceptionAction.Throw) {
            InternalError error = new InternalError(serializedException.get());
            throw new OptimizationFailedException((Throwable)error, (RootCallTarget)this);
        }
        if (action.ordinal() >= PolyglotCompilerOptions.ExceptionAction.Print.ordinal()) {
            GraalTruffleRuntime rt = OptimizedCallTarget.runtime();
            LinkedHashMap<String, Integer> properties = new LinkedHashMap<String, Integer>();
            properties.put("ASTSize", this.getNonTrivialNodeCount());
            rt.logEvent(this, 0, "opt fail", this.toString(), properties, serializedException.get());
            if (action == PolyglotCompilerOptions.ExceptionAction.ExitVM) {
                String reason = this.getOptionValue(PolyglotCompilerOptions.CompilationFailureAction) == PolyglotCompilerOptions.ExceptionAction.ExitVM ? "engine.CompilationFailureAction=ExitVM" : (this.getOptionValue(PolyglotCompilerOptions.CompilationExceptionsAreFatal) != false ? "engine.CompilationExceptionsAreFatal=true" : "engine.PerformanceWarningsAreFatal=true");
                this.log(String.format("Exiting VM due to %s", reason));
                System.exit(-1);
            }
        }
    }

    public final void log(String message) {
        OptimizedCallTarget.runtime().log(this, message);
    }

    @Override
    public final int getKnownCallSiteCount() {
        return this.callSitesKnown;
    }

    public final OptimizedCallTarget getSourceCallTarget() {
        return this.sourceCallTarget;
    }

    @Override
    public final String getName() {
        CompilerAsserts.neverPartOfCompilation();
        String result = this.nameCache;
        if (result == null) {
            this.nameCache = result = this.rootNode.toString();
        }
        return result;
    }

    public final String toString() {
        CompilerAsserts.neverPartOfCompilation();
        String superString = this.rootNode.toString();
        if (this.sourceCallTarget != null) {
            superString = superString + " <split-" + Integer.toHexString(this.hashCode()) + ">";
        }
        return superString;
    }

    static final Object[] castArrayFixedLength(Object[] args, int length) {
        return args;
    }

    static <T> T unsafeCast(Object value, Class<T> type, boolean condition, boolean nonNull, boolean exact) {
        return (T)value;
    }

    public static VirtualFrame createFrame(FrameDescriptor descriptor, Object[] args) {
        return new FrameWithoutBoxing(descriptor, args);
    }

    final void onLoopCount(int count) {
        this.callAndLoopCount += count;
    }

    public final boolean nodeReplaced(Node oldNode, Node newNode, CharSequence reason) {
        CompilerAsserts.neverPartOfCompilation();
        this.invalidate(newNode, reason);
        this.invalidateNodeRewritingAssumption();
        return false;
    }

    public final void accept(NodeVisitor visitor, TruffleInlining inlingDecision) {
        if (inlingDecision != null) {
            inlingDecision.accept(this, visitor);
        } else {
            this.getRootNode().accept(visitor);
        }
    }

    public final Iterable<Node> nodeIterable(TruffleInlining inliningDecision) {
        Iterator<Node> iterator = this.nodeIterator(inliningDecision);
        return () -> iterator;
    }

    public final Iterator<Node> nodeIterator(TruffleInlining inliningDecision) {
        Iterator iterator = inliningDecision != null ? inliningDecision.makeNodeIterator(this) : NodeUtil.makeRecursiveIterator((Node)this.getRootNode());
        return iterator;
    }

    @Override
    public final int getNonTrivialNodeCount() {
        if (this.cachedNonTrivialNodeCount == -1) {
            this.cachedNonTrivialNodeCount = OptimizedCallTarget.calculateNonTrivialNodes((Node)this.getRootNode());
        }
        return this.cachedNonTrivialNodeCount;
    }

    @Override
    public final int getCallCount() {
        return this.callCount;
    }

    public final int getCallAndLoopCount() {
        return this.callAndLoopCount;
    }

    public final long getInitializedTimestamp() {
        return this.initializedTimestamp;
    }

    public static int calculateNonTrivialNodes(Node node) {
        NonTrivialNodeCountVisitor visitor = new NonTrivialNodeCountVisitor();
        node.accept((NodeVisitor)visitor);
        return visitor.nodeCount;
    }

    public final Map<String, Object> getDebugProperties(TruffleInlining inlining) {
        LinkedHashMap<String, Object> properties = new LinkedHashMap<String, Object>();
        GraalTruffleRuntimeListener.addASTSizeProperty(this, inlining, properties);
        String callsThreshold = String.format("%7d/%5d", this.getCallCount(), this.engine.firstTierCallThreshold);
        String loopsThreshold = String.format("%7d/%5d", this.getCallAndLoopCount(), this.engine.firstTierCallAndLoopThreshold);
        properties.put("Calls/Thres", callsThreshold);
        properties.put("CallsAndLoop/Thres", loopsThreshold);
        return properties;
    }

    @Override
    public final TruffleCallNode[] getCallNodes() {
        final ArrayList callNodes = new ArrayList();
        this.getRootNode().accept(new NodeVisitor(){

            public boolean visit(Node node) {
                if (node instanceof OptimizedDirectCallNode) {
                    callNodes.add((OptimizedDirectCallNode)node);
                }
                return true;
            }
        });
        return callNodes.toArray(new TruffleCallNode[0]);
    }

    public final CompilerOptions getCompilerOptions() {
        CompilerOptions options = this.rootNode.getCompilerOptions();
        if (options != null) {
            return options;
        }
        return DefaultCompilerOptions.INSTANCE;
    }

    final void initializeArgumentTypes(Class<?>[] argumentTypes) {
        CompilerAsserts.neverPartOfCompilation();
        ArgumentsProfile newProfile = new ArgumentsProfile(argumentTypes, "Custom profiled argument types");
        if (!ARGUMENTS_PROFILE_UPDATER.compareAndSet(this, null, newProfile)) {
            this.argumentsProfile.assumption.invalidate();
            throw new AssertionError((Object)"Argument types already initialized. initializeArgumentTypes() must be called before any profile is initialized.");
        }
        this.callProfiled = true;
    }

    final boolean isValidArgumentProfile(Object[] args) {
        assert (this.callProfiled);
        ArgumentsProfile argumentsProfile = this.argumentsProfile;
        return argumentsProfile.assumption.isValid() && OptimizedCallTarget.checkProfiledArgumentTypes(args, argumentsProfile.types);
    }

    private static boolean checkProfiledArgumentTypes(Object[] args, Class<?>[] types) {
        assert (types != null);
        if (args.length != types.length) {
            throw new ArrayIndexOutOfBoundsException();
        }
        if (types[0] != args[0].getClass()) {
            throw new ClassCastException();
        }
        for (int j = 1; j < types.length; ++j) {
            if (types[j] == null) continue;
            types[j].cast(args[j]);
            Objects.requireNonNull(args[j]);
        }
        return true;
    }

    public final void stopProfilingArguments() {
        assert (!this.callProfiled);
        ArgumentsProfile argumentsProfile = this.argumentsProfile;
        if (argumentsProfile != null && argumentsProfile.assumption.isValid()) {
            CompilerDirectives.transferToInterpreter();
            ArgumentsProfile previous = ARGUMENTS_PROFILE_UPDATER.getAndSet(this, ArgumentsProfile.INVALID);
            previous.assumption.invalidate();
        }
    }

    @ExplodeLoop
    public final void profileArguments(Object[] args) {
        block7: {
            ArgumentsProfile argumentsProfile;
            block6: {
                assert (!this.callProfiled);
                argumentsProfile = this.argumentsProfile;
                if (argumentsProfile != null) break block6;
                if (!CompilerDirectives.inInterpreter()) break block7;
                this.initializeProfiledArgumentTypes(args);
                break block7;
            }
            Class<?>[] types = argumentsProfile.types;
            if (types != null) {
                if (types.length != args.length) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                    ArgumentsProfile previous = ARGUMENTS_PROFILE_UPDATER.getAndSet(this, ArgumentsProfile.INVALID);
                    previous.assumption.invalidate();
                } else if (argumentsProfile.assumption.isValid()) {
                    for (int i = 0; i < types.length; ++i) {
                        Class<?> type = types[i];
                        Object value = args[i];
                        if (type == null || value != null && value.getClass() == type) continue;
                        CompilerDirectives.transferToInterpreterAndInvalidate();
                        this.updateProfiledArgumentTypes(args, argumentsProfile);
                        break;
                    }
                }
            }
        }
    }

    private void initializeProfiledArgumentTypes(Object[] args) {
        ArgumentsProfile newProfile;
        CompilerAsserts.neverPartOfCompilation();
        assert (!this.callProfiled);
        if (args.length <= 256 && this.engine.argumentTypeSpeculation) {
            Class[] types = args.length == 0 ? ArgumentsProfile.EMPTY_ARGUMENT_TYPES : new Class[args.length];
            for (int i = 0; i < args.length; ++i) {
                types[i] = OptimizedCallTarget.classOf(args[i]);
            }
            newProfile = new ArgumentsProfile(types, "Profiled Argument Types");
        } else {
            newProfile = ArgumentsProfile.INVALID;
        }
        if (!ARGUMENTS_PROFILE_UPDATER.compareAndSet(this, null, newProfile)) {
            this.profileArguments(args);
        }
    }

    private void updateProfiledArgumentTypes(Object[] args, ArgumentsProfile oldProfile) {
        CompilerAsserts.neverPartOfCompilation();
        assert (!this.callProfiled);
        Class<?>[] oldTypes = oldProfile.types;
        Class[] newTypes = new Class[oldProfile.types.length];
        for (int j = 0; j < oldTypes.length; ++j) {
            newTypes[j] = OptimizedCallTarget.joinTypes(oldTypes[j], OptimizedCallTarget.classOf(args[j]));
        }
        ArgumentsProfile newProfile = new ArgumentsProfile(newTypes, "Profiled Argument Types");
        if (ARGUMENTS_PROFILE_UPDATER.compareAndSet(this, oldProfile, newProfile)) {
            oldProfile.assumption.invalidate();
        } else {
            this.profileArguments(args);
        }
    }

    public final Object[] injectArgumentsProfile(Object[] originalArguments) {
        assert (CompilerDirectives.inCompiledCode());
        ArgumentsProfile argumentsProfile = this.argumentsProfile;
        Object[] args = originalArguments;
        if (argumentsProfile != null && argumentsProfile.assumption.isValid()) {
            Class<?>[] types = argumentsProfile.types;
            args = OptimizedCallTarget.unsafeCast(OptimizedCallTarget.castArrayFixedLength(args, types.length), Object[].class, true, true, true);
            args = this.castArgumentsImpl(args, types);
        }
        return args;
    }

    @ExplodeLoop
    private Object[] castArgumentsImpl(Object[] originalArguments, Class<?>[] types) {
        Object[] castArguments = new Object[types.length];
        boolean isCallProfiled = this.callProfiled;
        for (int i = 0; i < types.length; ++i) {
            Class<?> targetType = types[i];
            boolean exact = !isCallProfiled || i == 0;
            castArguments[i] = targetType != null ? OptimizedCallTarget.unsafeCast(originalArguments[i], targetType, true, true, exact) : originalArguments[i];
        }
        return castArguments;
    }

    protected final ArgumentsProfile getInitializedArgumentsProfile() {
        if (this.argumentsProfile == null) {
            CompilerDirectives.transferToInterpreterAndInvalidate();
            ARGUMENTS_PROFILE_UPDATER.compareAndSet(this, null, ArgumentsProfile.INVALID);
            assert (this.argumentsProfile != null);
        }
        return this.argumentsProfile;
    }

    private void profileReturnValue(Object result) {
        ReturnProfile returnProfile = this.returnProfile;
        if (returnProfile == null) {
            if (CompilerDirectives.inInterpreter() && this.engine.returnTypeSpeculation) {
                ReturnProfile newProfile;
                Class<?> type = OptimizedCallTarget.classOf(result);
                ReturnProfile returnProfile2 = newProfile = type == null ? ReturnProfile.INVALID : new ReturnProfile(type);
                if (!RETURN_PROFILE_UPDATER.compareAndSet(this, null, newProfile)) {
                    this.profileReturnValue(result);
                }
            }
        } else if (returnProfile.assumption.isValid() && (result == null || returnProfile.type != result.getClass())) {
            CompilerDirectives.transferToInterpreterAndInvalidate();
            ReturnProfile previous = RETURN_PROFILE_UPDATER.getAndSet(this, ReturnProfile.INVALID);
            previous.assumption.invalidate();
        }
    }

    private Object injectReturnValueProfile(Object result) {
        ReturnProfile returnProfile = this.returnProfile;
        if (CompilerDirectives.inCompiledCode() && returnProfile != null && returnProfile.assumption.isValid()) {
            return OptimizedCallTarget.unsafeCast(result, returnProfile.type, true, true, true);
        }
        return result;
    }

    protected final ReturnProfile getInitializedReturnProfile() {
        if (this.returnProfile == null) {
            CompilerDirectives.transferToInterpreterAndInvalidate();
            RETURN_PROFILE_UPDATER.compareAndSet(this, null, ReturnProfile.INVALID);
            assert (this.returnProfile != null);
        }
        return this.returnProfile;
    }

    private <T extends Throwable> T profileExceptionType(T value) {
        Class<? extends Throwable> clazz = this.profiledExceptionType;
        if (clazz != Throwable.class) {
            if (clazz != null && value.getClass() == clazz) {
                if (CompilerDirectives.inInterpreter()) {
                    return value;
                }
                return (T)((Throwable)CompilerDirectives.castExact(value, clazz));
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            this.profiledExceptionType = clazz == null ? value.getClass() : Throwable.class;
        }
        return value;
    }

    private static Class<?> classOf(Object arg) {
        return arg != null ? arg.getClass() : null;
    }

    private static Class<?> joinTypes(Class<?> class1, Class<?> class2) {
        if (class1 == class2) {
            return class1;
        }
        return null;
    }

    private static OptimizedAssumption createInvalidAssumption(String name) {
        OptimizedAssumption result = OptimizedCallTarget.createValidAssumption(name);
        result.invalidate();
        return result;
    }

    private static OptimizedAssumption createValidAssumption(String name) {
        return (OptimizedAssumption)Truffle.getRuntime().createAssumption(name);
    }

    public final boolean isSplit() {
        return this.sourceCallTarget != null;
    }

    public final OptimizedDirectCallNode getCallSiteForSplit() {
        if (this.isSplit()) {
            OptimizedDirectCallNode callNode = this.getSingleCallNode();
            assert (callNode != null);
            return callNode;
        }
        return null;
    }

    final int getUninitializedNodeCount() {
        assert (this.uninitializedNodeCount >= 0);
        return this.uninitializedNodeCount;
    }

    public final boolean equals(Object obj) {
        return obj == this;
    }

    public final int hashCode() {
        return System.identityHashCode(this);
    }

    final CancellableCompileTask getCompilationTask() {
        return this.compilationTask;
    }

    final synchronized void resetCompilationTask() {
        assert (this.compilationTask != null);
        this.compilationTask = null;
    }

    @SuppressFBWarnings(value={"VO_VOLATILE_INCREMENT"}, justification="All increments and decrements are synchronized.")
    final synchronized void addDirectCallNode(OptimizedDirectCallNode directCallNode) {
        Objects.requireNonNull(directCallNode);
        WeakReference<OptimizedDirectCallNode> nodeRef = this.singleCallNode;
        if (nodeRef != MULTIPLE_CALLS) {
            if (nodeRef == NO_CALL) {
                this.singleCallNode = new WeakReference<OptimizedDirectCallNode>(directCallNode);
            } else {
                if (nodeRef.get() == directCallNode) {
                    return;
                }
                this.singleCallNode = MULTIPLE_CALLS;
            }
        }
        ++this.callSitesKnown;
    }

    @SuppressFBWarnings(value={"VO_VOLATILE_INCREMENT"}, justification="All increments and decrements are synchronized.")
    final synchronized void removeDirectCallNode(OptimizedDirectCallNode directCallNode) {
        Objects.requireNonNull(directCallNode);
        WeakReference<OptimizedDirectCallNode> nodeRef = this.singleCallNode;
        if (nodeRef != MULTIPLE_CALLS) {
            if (nodeRef == NO_CALL) {
                return;
            }
            this.singleCallNode = nodeRef.get() == directCallNode ? NO_CALL : MULTIPLE_CALLS;
        }
        --this.callSitesKnown;
    }

    public final boolean isSingleCaller() {
        WeakReference<OptimizedDirectCallNode> nodeRef = this.singleCallNode;
        if (nodeRef != null) {
            return nodeRef.get() != null;
        }
        return false;
    }

    public final OptimizedDirectCallNode getSingleCallNode() {
        WeakReference<OptimizedDirectCallNode> nodeRef = this.singleCallNode;
        if (nodeRef != null) {
            return (OptimizedDirectCallNode)nodeRef.get();
        }
        return null;
    }

    final boolean isNeedsSplit() {
        return this.needsSplit;
    }

    final void polymorphicSpecialize(Node source) {
        ArrayList<Node> toDump = null;
        if (this.engine.splittingDumpDecisions) {
            toDump = new ArrayList<Node>();
            OptimizedCallTarget.pullOutParentChain(source, toDump);
        }
        this.logPolymorphicEvent(0, "Polymorphic event! Source:", source);
        this.maybeSetNeedsSplit(0, toDump);
    }

    private boolean maybeSetNeedsSplit(int depth, List<Node> toDump) {
        OptimizedDirectCallNode onlyCaller = this.getSingleCallNode();
        if (depth > this.engine.splittingMaxPropagationDepth || this.needsSplit || this.callSitesKnown == 0 || this.getCallCount() == 1) {
            this.logEarlyReturn(depth, this.callSitesKnown);
            return this.needsSplit;
        }
        if (onlyCaller != null) {
            RootNode callerRootNode = onlyCaller.getRootNode();
            if (callerRootNode != null && callerRootNode.getCallTarget() != null) {
                OptimizedCallTarget callerTarget = (OptimizedCallTarget)callerRootNode.getCallTarget();
                if (this.engine.splittingDumpDecisions) {
                    OptimizedCallTarget.pullOutParentChain((Node)onlyCaller, toDump);
                }
                this.logPolymorphicEvent(depth, "One caller! Analysing parent.");
                if (callerTarget.maybeSetNeedsSplit(depth + 1, toDump)) {
                    this.logPolymorphicEvent(depth, "Set needs split to true via parent");
                    this.needsSplit = true;
                }
            }
        } else {
            this.logPolymorphicEvent(depth, "Set needs split to true");
            this.needsSplit = true;
            this.maybeDump(toDump);
        }
        this.logPolymorphicEvent(depth, "Return:", this.needsSplit);
        return this.needsSplit;
    }

    private void logEarlyReturn(int depth, int numberOfKnownCallNodes) {
        if (this.engine.splittingTraceEvents) {
            this.logPolymorphicEvent(depth, "Early return: " + this.needsSplit + " callCount: " + this.getCallCount() + ", numberOfKnownCallNodes: " + numberOfKnownCallNodes);
        }
    }

    private void logPolymorphicEvent(int depth, String message) {
        this.logPolymorphicEvent(depth, message, null);
    }

    private void logPolymorphicEvent(int depth, String message, Object arg) {
        if (this.engine.splittingTraceEvents) {
            String indent = new String(new char[depth]).replace("\u0000", "  ");
            String argString = arg == null ? "" : " " + arg;
            this.log(String.format(SPLIT_LOG_FORMAT, indent + message + argString, this.toString()));
        }
    }

    private void maybeDump(List<Node> toDump) {
        if (this.engine.splittingDumpDecisions) {
            ArrayList<OptimizedDirectCallNode> callers = new ArrayList<OptimizedDirectCallNode>();
            OptimizedDirectCallNode callNode = this.getSingleCallNode();
            if (callNode != null) {
                callers.add(callNode);
            }
            PolymorphicSpecializeDump.dumpPolymorphicSpecialize(this, toDump);
        }
    }

    private static void pullOutParentChain(Node node, List<Node> toDump) {
        Node rootNode = node;
        while (rootNode.getParent() != null) {
            toDump.add(rootNode);
            rootNode = rootNode.getParent();
        }
        toDump.add(rootNode);
    }

    final void setNonTrivialNodeCount(int nonTrivialNodeCount) {
        this.cachedNonTrivialNodeCount = nonTrivialNodeCount;
    }

    private static final class NonTrivialNodeCountVisitor
    implements NodeVisitor {
        public int nodeCount;

        private NonTrivialNodeCountVisitor() {
        }

        public boolean visit(Node node) {
            if (!node.getCost().isTrivial()) {
                ++this.nodeCount;
            }
            return true;
        }
    }

    public static final class ReturnProfile {
        private static final String RETURN_TYPE_ASSUMPTION_NAME = "Profiled Return Type";
        private static final ReturnProfile INVALID = new ReturnProfile();
        final OptimizedAssumption assumption;
        final Class<?> type;

        private ReturnProfile() {
            this.assumption = OptimizedCallTarget.createInvalidAssumption(RETURN_TYPE_ASSUMPTION_NAME);
            this.type = null;
        }

        private ReturnProfile(Class<?> type) {
            assert (type != null);
            this.assumption = OptimizedCallTarget.createValidAssumption(RETURN_TYPE_ASSUMPTION_NAME);
            this.type = type;
        }

        public OptimizedAssumption getAssumption() {
            return this.assumption;
        }

        public Class<?> getType() {
            return this.type;
        }
    }

    public static final class ArgumentsProfile {
        private static final String ARGUMENT_TYPES_ASSUMPTION_NAME = "Profiled Argument Types";
        private static final Class<?>[] EMPTY_ARGUMENT_TYPES = new Class[0];
        private static final ArgumentsProfile INVALID = new ArgumentsProfile();
        final OptimizedAssumption assumption;
        @CompilerDirectives.CompilationFinal(dimensions=1)
        final Class<?>[] types;

        private ArgumentsProfile() {
            this.assumption = OptimizedCallTarget.createInvalidAssumption(ARGUMENT_TYPES_ASSUMPTION_NAME);
            this.types = null;
        }

        private ArgumentsProfile(Class<?>[] types, String assumptionName) {
            assert (types != null);
            this.assumption = OptimizedCallTarget.createValidAssumption(assumptionName);
            this.types = types;
        }

        public OptimizedAssumption getAssumption() {
            return this.assumption;
        }

        public Class<?>[] getTypes() {
            return this.types;
        }
    }
}

