/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.compiler.truffle.runtime;

import com.oracle.truffle.api.impl.TVMCI;
import com.oracle.truffle.api.nodes.RootNode;
import java.io.Closeable;
import java.io.IOException;
import java.lang.ref.WeakReference;
import java.util.Map;
import org.graalvm.compiler.truffle.common.TruffleDebugContext;
import org.graalvm.compiler.truffle.common.VoidGraphStructure;
import org.graalvm.compiler.truffle.runtime.CancellableCompileTask;
import org.graalvm.compiler.truffle.runtime.GraalTruffleRuntime;
import org.graalvm.compiler.truffle.runtime.OptimizedCallTarget;
import org.graalvm.compiler.truffle.runtime.TruffleRuntimeOptions;
import org.graalvm.graphio.GraphOutput;

final class GraalTestTVMCI
extends TVMCI.Test<GraalTestContext, OptimizedCallTarget> {
    private final GraalTruffleRuntime truffleRuntime;

    GraalTestTVMCI(GraalTruffleRuntime truffleRuntime) {
        this.truffleRuntime = truffleRuntime;
    }

    protected GraalTestContext createTestContext(String testName) {
        return new GraalTestContext(testName, this.truffleRuntime);
    }

    public OptimizedCallTarget createTestCallTarget(GraalTestContext testContext, RootNode testNode) {
        OptimizedCallTarget target = (OptimizedCallTarget)this.truffleRuntime.createCallTarget(testNode);
        testContext.init(target);
        return target;
    }

    public void finishWarmup(GraalTestContext testContext, OptimizedCallTarget callTarget) {
        this.truffleRuntime.doCompile(callTarget, new CancellableCompileTask(new WeakReference<OptimizedCallTarget>(callTarget), true));
    }

    static final class GraalTestContext
    implements Closeable {
        private final String testName;
        private final GraalTruffleRuntime runtime;
        private TruffleDebugContext debug;
        private GraphOutput<Void, ?> output;

        private static GraphOutput<Void, ?> beginGroup(TruffleDebugContext debug, String testName) {
            block3: {
                GraphOutput<Void, ?> output = null;
                try {
                    if (debug.isDumpEnabled()) {
                        output = debug.buildOutput(GraphOutput.newBuilder(VoidGraphStructure.INSTANCE));
                        output.beginGroup(null, testName, testName, null, 0, debug.getVersionProperties());
                        return output;
                    }
                }
                catch (IOException e) {
                    if (output == null) break block3;
                    output.close();
                }
            }
            return null;
        }

        private GraalTestContext(String testName, GraalTruffleRuntime runtime) {
            this.testName = testName;
            this.runtime = runtime;
        }

        private synchronized void init(OptimizedCallTarget target) {
            if (this.debug == null) {
                Map<String, Object> optionsMap = TruffleRuntimeOptions.getOptionsForCompiler(target);
                this.debug = this.runtime.getTruffleCompiler(target).openDebugContext(optionsMap, null);
                this.output = GraalTestContext.beginGroup(this.debug, this.testName);
            }
        }

        @Override
        public synchronized void close() throws IOException {
            block6: {
                try {
                    if (this.output == null) break block6;
                    try {
                        this.output.endGroup();
                    }
                    finally {
                        this.output.close();
                    }
                }
                finally {
                    this.debug.close();
                }
            }
        }
    }
}

