/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.compiler.truffle.runtime;

import com.oracle.truffle.api.CallTarget;
import com.oracle.truffle.api.RootCallTarget;
import com.oracle.truffle.api.impl.Accessor;
import com.oracle.truffle.api.nodes.BlockNode;
import com.oracle.truffle.api.nodes.IndirectCallNode;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.RootNode;
import java.io.OutputStream;
import jdk.vm.ci.services.Services;
import org.graalvm.compiler.truffle.options.PolyglotCompilerOptions;
import org.graalvm.compiler.truffle.runtime.EngineData;
import org.graalvm.compiler.truffle.runtime.GraalRuntimeAccessor;
import org.graalvm.compiler.truffle.runtime.GraalTruffleRuntime;
import org.graalvm.compiler.truffle.runtime.OptimizedBlockNode;
import org.graalvm.compiler.truffle.runtime.OptimizedCallTarget;
import org.graalvm.compiler.truffle.runtime.OptimizedIndirectCallNode;
import org.graalvm.compiler.truffle.runtime.OptimizedOSRLoopNode;
import org.graalvm.compiler.truffle.runtime.TruffleDebugOptions;
import org.graalvm.compiler.truffle.runtime.TruffleSplittingStrategy;
import org.graalvm.options.OptionDescriptors;
import org.graalvm.options.OptionValues;

final class GraalRuntimeSupport
extends Accessor.RuntimeSupport {
    static final String CALL_INLINED_METHOD_NAME = "callInlined";

    GraalRuntimeSupport(Object permission) {
        super(permission);
    }

    public IndirectCallNode createUncachedIndirectCall() {
        return OptimizedIndirectCallNode.createUncached();
    }

    public void onLoopCount(Node source, int count) {
        RootCallTarget target;
        Node parentNode;
        Node node = parentNode = source != null ? source.getParent() : null;
        for (Node node2 = source; node2 != null; node2 = node2.getParent()) {
            if (node2 instanceof OptimizedOSRLoopNode) {
                ((OptimizedOSRLoopNode)node2).reportChildLoopCount(count);
            }
            parentNode = node2;
        }
        if (parentNode != null && parentNode instanceof RootNode && (target = ((RootNode)parentNode).getCallTarget()) instanceof OptimizedCallTarget) {
            ((OptimizedCallTarget)target).onLoopCount(count);
        }
    }

    public OptionDescriptors getCompilerOptionDescriptors() {
        return PolyglotCompilerOptions.getDescriptors();
    }

    public boolean isGuestCallStackFrame(StackTraceElement e) {
        return e.getMethodName().equals("executeRootNode") && e.getClassName().equals(OptimizedCallTarget.class.getName()) || e.getMethodName().equals(CALL_INLINED_METHOD_NAME) && e.getClassName().equals(GraalRuntimeSupport.class.getName());
    }

    public void initializeProfile(CallTarget target, Class<?>[] argumentTypes) {
        ((OptimizedCallTarget)target).initializeArgumentTypes(argumentTypes);
    }

    public <T extends Node> BlockNode<T> createBlockNode(T[] elements, BlockNode.ElementExecutor<T> executor) {
        return new OptimizedBlockNode(elements, executor);
    }

    public void reloadEngineOptions(Object runtimeData, OptionValues optionValues) {
        ((EngineData)runtimeData).loadOptions(optionValues);
    }

    public void onEngineClosed(Object runtimeData) {
        GraalTruffleRuntime.getRuntime().onEngineClosed((EngineData)runtimeData);
    }

    public OutputStream getConfiguredLogStream() {
        return TruffleDebugOptions.getConfiguredLogStream();
    }

    public String getSavedProperty(String key) {
        return (String)Services.getSavedProperties().get(key);
    }

    public void reportPolymorphicSpecialize(Node source) {
        OptimizedCallTarget callTarget;
        RootNode rootNode = source.getRootNode();
        OptimizedCallTarget optimizedCallTarget = callTarget = rootNode == null ? null : (OptimizedCallTarget)rootNode.getCallTarget();
        if (callTarget == null) {
            return;
        }
        TruffleSplittingStrategy.newPolymorphicSpecialize(source, callTarget.engine);
        callTarget.polymorphicSpecialize(source);
    }

    public Object callInlined(Node callNode, CallTarget target, Object ... arguments) {
        OptimizedCallTarget optimizedCallTarget = (OptimizedCallTarget)target;
        try {
            return optimizedCallTarget.callInlined(callNode, arguments);
        }
        catch (Throwable t) {
            GraalRuntimeAccessor.LANGUAGE.onThrowable(callNode, (RootCallTarget)optimizedCallTarget, t, null);
            throw OptimizedCallTarget.rethrow(t);
        }
    }

    public Object callProfiled(CallTarget target, Object ... arguments) {
        OptimizedCallTarget castTarget = (OptimizedCallTarget)target;
        assert (castTarget.isValidArgumentProfile(arguments)) : "Invalid argument profile. callProfiled requires to explicity initialize the profile.";
        return castTarget.doInvoke(arguments);
    }

    public Object[] castArrayFixedLength(Object[] args, int length) {
        return OptimizedCallTarget.castArrayFixedLength(args, length);
    }

    public <T> T unsafeCast(Object value, Class<T> type, boolean condition, boolean nonNull, boolean exact) {
        return OptimizedCallTarget.unsafeCast(value, type, condition, nonNull, exact);
    }
}

