/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.compiler.truffle.runtime;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.TruffleLogger;
import com.oracle.truffle.api.nodes.RootNode;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.BiFunction;
import java.util.function.Supplier;
import java.util.logging.Level;
import org.graalvm.collections.Pair;
import org.graalvm.compiler.truffle.options.PolyglotCompilerOptions;
import org.graalvm.compiler.truffle.runtime.GraalTruffleRuntime;
import org.graalvm.compiler.truffle.runtime.TruffleRuntimeOptions;
import org.graalvm.compiler.truffle.runtime.TruffleSplittingStrategy;
import org.graalvm.compiler.truffle.runtime.debug.StatisticsListener;
import org.graalvm.options.OptionDescriptor;
import org.graalvm.options.OptionValues;

public final class EngineData {
    static final BiFunction<OptionValues, Supplier<TruffleLogger>, EngineData> ENGINE_DATA_SUPPLIER = new BiFunction<OptionValues, Supplier<TruffleLogger>, EngineData>(){

        @Override
        public EngineData apply(OptionValues engineOptions, Supplier<TruffleLogger> loggerFactory) {
            return new EngineData(engineOptions, loggerFactory);
        }
    };
    private static final AtomicLong engineCounter = new AtomicLong();
    int splitLimit;
    int splitCount;
    public final long id = engineCounter.incrementAndGet();
    private final Supplier<TruffleLogger> loggerFactory;
    @CompilerDirectives.CompilationFinal
    OptionValues engineOptions;
    final TruffleSplittingStrategy.SplitStatisticsData splittingStatistics;
    @CompilerDirectives.CompilationFinal
    public StatisticsListener statisticsListener;
    @CompilerDirectives.CompilationFinal
    public boolean splitting;
    @CompilerDirectives.CompilationFinal
    public boolean splittingAllowForcedSplits;
    @CompilerDirectives.CompilationFinal
    public boolean splittingDumpDecisions;
    @CompilerDirectives.CompilationFinal
    public boolean splittingTraceEvents;
    @CompilerDirectives.CompilationFinal
    public boolean traceSplittingSummary;
    @CompilerDirectives.CompilationFinal
    public boolean traceSplits;
    @CompilerDirectives.CompilationFinal
    public int splittingMaxCalleeSize;
    @CompilerDirectives.CompilationFinal
    public int splittingMaxPropagationDepth;
    @CompilerDirectives.CompilationFinal
    public double splittingGrowthLimit;
    @CompilerDirectives.CompilationFinal
    public int splittingMaxNumberOfSplitNodes;
    @CompilerDirectives.CompilationFinal
    public boolean inlining;
    @CompilerDirectives.CompilationFinal
    public boolean compilation;
    @CompilerDirectives.CompilationFinal
    public boolean compileImmediately;
    @CompilerDirectives.CompilationFinal
    public boolean multiTier;
    @CompilerDirectives.CompilationFinal
    public boolean returnTypeSpeculation;
    @CompilerDirectives.CompilationFinal
    public boolean argumentTypeSpeculation;
    @CompilerDirectives.CompilationFinal
    public boolean traceCompilation;
    @CompilerDirectives.CompilationFinal
    public boolean traceCompilationDetails;
    @CompilerDirectives.CompilationFinal
    public boolean backgroundCompilation;
    @CompilerDirectives.CompilationFinal
    public PolyglotCompilerOptions.ExceptionAction compilationFailureAction;
    @CompilerDirectives.CompilationFinal
    public String compileOnly;
    @CompilerDirectives.CompilationFinal
    public boolean callTargetStatistics;
    @CompilerDirectives.CompilationFinal
    public boolean callTargetStatisticDetails;
    @CompilerDirectives.CompilationFinal
    public boolean profilingEnabled;
    @CompilerDirectives.CompilationFinal
    public boolean traceTransferToInterpreter;
    @CompilerDirectives.CompilationFinal
    public int firstTierCallThreshold;
    @CompilerDirectives.CompilationFinal
    public int firstTierCallAndLoopThreshold;
    @CompilerDirectives.CompilationFinal
    public int lastTierCallThreshold;
    private volatile TruffleLogger logger;
    private volatile Pair<List<String>, List<String>> parsedCompileOnly;

    EngineData(OptionValues options, Supplier<TruffleLogger> loggerFactory) {
        this.loggerFactory = loggerFactory;
        this.loadOptions(options);
        this.splittingStatistics = new TruffleSplittingStrategy.SplitStatisticsData();
    }

    void loadOptions(OptionValues options) {
        this.engineOptions = options;
        this.splitting = TruffleRuntimeOptions.getPolyglotOptionValue(options, PolyglotCompilerOptions.Splitting) != false && TruffleRuntimeOptions.getPolyglotOptionValue(options, PolyglotCompilerOptions.Mode) != PolyglotCompilerOptions.EngineModeEnum.LATENCY;
        this.splittingAllowForcedSplits = TruffleRuntimeOptions.getPolyglotOptionValue(options, PolyglotCompilerOptions.SplittingAllowForcedSplits);
        this.splittingDumpDecisions = TruffleRuntimeOptions.getPolyglotOptionValue(options, PolyglotCompilerOptions.SplittingDumpDecisions);
        this.splittingMaxCalleeSize = TruffleRuntimeOptions.getPolyglotOptionValue(options, PolyglotCompilerOptions.SplittingMaxCalleeSize);
        this.splittingMaxPropagationDepth = TruffleRuntimeOptions.getPolyglotOptionValue(options, PolyglotCompilerOptions.SplittingMaxPropagationDepth);
        this.splittingTraceEvents = TruffleRuntimeOptions.getPolyglotOptionValue(options, PolyglotCompilerOptions.SplittingTraceEvents);
        this.traceSplittingSummary = TruffleRuntimeOptions.getPolyglotOptionValue(options, PolyglotCompilerOptions.TraceSplittingSummary);
        this.traceSplits = TruffleRuntimeOptions.getPolyglotOptionValue(options, PolyglotCompilerOptions.TraceSplitting);
        this.splittingGrowthLimit = TruffleRuntimeOptions.getPolyglotOptionValue(options, PolyglotCompilerOptions.SplittingGrowthLimit);
        this.splittingMaxNumberOfSplitNodes = TruffleRuntimeOptions.getPolyglotOptionValue(options, PolyglotCompilerOptions.SplittingMaxNumberOfSplitNodes);
        this.inlining = TruffleRuntimeOptions.getPolyglotOptionValue(options, PolyglotCompilerOptions.Inlining) != false && TruffleRuntimeOptions.getPolyglotOptionValue(options, PolyglotCompilerOptions.Mode) != PolyglotCompilerOptions.EngineModeEnum.LATENCY;
        this.compilation = TruffleRuntimeOptions.getPolyglotOptionValue(options, PolyglotCompilerOptions.Compilation);
        this.compileOnly = TruffleRuntimeOptions.getPolyglotOptionValue(options, PolyglotCompilerOptions.CompileOnly);
        this.compileImmediately = TruffleRuntimeOptions.getPolyglotOptionValue(options, PolyglotCompilerOptions.CompileImmediately);
        this.multiTier = TruffleRuntimeOptions.getPolyglotOptionValue(options, PolyglotCompilerOptions.MultiTier);
        this.returnTypeSpeculation = TruffleRuntimeOptions.getPolyglotOptionValue(options, PolyglotCompilerOptions.ReturnTypeSpeculation);
        this.argumentTypeSpeculation = TruffleRuntimeOptions.getPolyglotOptionValue(options, PolyglotCompilerOptions.ArgumentTypeSpeculation);
        this.traceCompilation = TruffleRuntimeOptions.getPolyglotOptionValue(options, PolyglotCompilerOptions.TraceCompilation);
        this.traceCompilationDetails = TruffleRuntimeOptions.getPolyglotOptionValue(options, PolyglotCompilerOptions.TraceCompilationDetails);
        this.backgroundCompilation = TruffleRuntimeOptions.getPolyglotOptionValue(options, PolyglotCompilerOptions.BackgroundCompilation);
        this.firstTierCallThreshold = this.computeFirstTierCallThreshold(options);
        this.lastTierCallThreshold = this.firstTierCallAndLoopThreshold = this.computeFirstTierCallAndLoopThreshold(options);
        this.callTargetStatisticDetails = TruffleRuntimeOptions.getPolyglotOptionValue(options, PolyglotCompilerOptions.CompilationStatisticDetails);
        this.callTargetStatistics = TruffleRuntimeOptions.getPolyglotOptionValue(options, PolyglotCompilerOptions.CompilationStatistics) != false || this.callTargetStatisticDetails;
        this.statisticsListener = this.callTargetStatistics ? StatisticsListener.createEngineListener(GraalTruffleRuntime.getRuntime()) : null;
        this.profilingEnabled = TruffleRuntimeOptions.getPolyglotOptionValue(options, PolyglotCompilerOptions.Profiling);
        this.traceTransferToInterpreter = TruffleRuntimeOptions.getPolyglotOptionValue(options, PolyglotCompilerOptions.TraceTransferToInterpreter);
        this.compilationFailureAction = EngineData.computeCompilationFailureAction(options);
        this.validateOptions();
        this.parsedCompileOnly = null;
    }

    boolean acceptForCompilation(RootNode rootNode) {
        if (!this.compilation) {
            return false;
        }
        Pair<List<String>, List<String>> value = this.getCompileOnly();
        if (value != null) {
            String name = rootNode.getName();
            List includes = (List)value.getLeft();
            boolean included = includes.isEmpty();
            if (name != null) {
                for (int i = 0; !included && i < includes.size(); ++i) {
                    if (!name.contains((CharSequence)includes.get(i))) continue;
                    included = true;
                }
            }
            if (!included) {
                return false;
            }
            if (name != null) {
                for (String exclude : (List)value.getRight()) {
                    if (!name.contains(exclude)) continue;
                    return false;
                }
            }
        }
        return true;
    }

    private Pair<List<String>, List<String>> getCompileOnly() {
        if (this.compileOnly == null) {
            return null;
        }
        Pair result = this.parsedCompileOnly;
        if (result == null) {
            String[] items;
            ArrayList<String> includesList = new ArrayList<String>();
            ArrayList<String> excludesList = new ArrayList<String>();
            for (String item : items = this.compileOnly.split(",")) {
                if (item.startsWith("~")) {
                    excludesList.add(item.substring(1));
                    continue;
                }
                includesList.add(item);
            }
            this.parsedCompileOnly = result = Pair.create(includesList, excludesList);
        }
        return result;
    }

    private static PolyglotCompilerOptions.ExceptionAction computeCompilationFailureAction(OptionValues options) {
        PolyglotCompilerOptions.ExceptionAction action = TruffleRuntimeOptions.getPolyglotOptionValue(options, PolyglotCompilerOptions.CompilationFailureAction);
        if (action.ordinal() < PolyglotCompilerOptions.ExceptionAction.Print.ordinal() && TruffleRuntimeOptions.getPolyglotOptionValue(options, PolyglotCompilerOptions.CompilationExceptionsArePrinted).booleanValue()) {
            action = PolyglotCompilerOptions.ExceptionAction.Print;
        }
        if (action.ordinal() < PolyglotCompilerOptions.ExceptionAction.Throw.ordinal() && TruffleRuntimeOptions.getPolyglotOptionValue(options, PolyglotCompilerOptions.CompilationExceptionsAreThrown).booleanValue()) {
            action = PolyglotCompilerOptions.ExceptionAction.Throw;
        }
        if (action.ordinal() < PolyglotCompilerOptions.ExceptionAction.ExitVM.ordinal() && TruffleRuntimeOptions.getPolyglotOptionValue(options, PolyglotCompilerOptions.CompilationExceptionsAreFatal).booleanValue()) {
            action = PolyglotCompilerOptions.ExceptionAction.ExitVM;
        }
        if (action.ordinal() < PolyglotCompilerOptions.ExceptionAction.ExitVM.ordinal() && !TruffleRuntimeOptions.getPolyglotOptionValue(options, PolyglotCompilerOptions.PerformanceWarningsAreFatal).isEmpty()) {
            action = PolyglotCompilerOptions.ExceptionAction.ExitVM;
        }
        return action;
    }

    private void validateOptions() {
        if (this.compilationFailureAction == PolyglotCompilerOptions.ExceptionAction.Throw && this.backgroundCompilation) {
            this.getLogger().log(Level.WARNING, "The 'Throw' value of the 'engine.CompilationFailureAction' option requires the 'engine.BackgroundCompilation' option to be set to 'false'.");
        }
        for (OptionDescriptor descriptor : PolyglotCompilerOptions.getDescriptors()) {
            if (!descriptor.isDeprecated() || !this.engineOptions.hasBeenSet(descriptor.getKey())) continue;
            String optionName = descriptor.getName();
            String deprecationMessage = descriptor.getDeprecationMessage();
            if (deprecationMessage.isEmpty()) {
                deprecationMessage = "Will be removed with no replacement.";
            }
            this.getLogger().log(Level.WARNING, String.format("The option '%s' is deprecated.%n%s", optionName, deprecationMessage));
        }
    }

    private int computeFirstTierCallThreshold(OptionValues options) {
        if (this.compileImmediately) {
            return 0;
        }
        if (this.multiTier) {
            return Math.min(TruffleRuntimeOptions.getPolyglotOptionValue(options, PolyglotCompilerOptions.FirstTierMinInvokeThreshold), TruffleRuntimeOptions.getPolyglotOptionValue(options, PolyglotCompilerOptions.FirstTierCompilationThreshold));
        }
        return Math.min(TruffleRuntimeOptions.getPolyglotOptionValue(options, PolyglotCompilerOptions.MinInvokeThreshold), TruffleRuntimeOptions.getPolyglotOptionValue(options, PolyglotCompilerOptions.CompilationThreshold));
    }

    private int computeFirstTierCallAndLoopThreshold(OptionValues options) {
        if (this.compileImmediately) {
            return 0;
        }
        if (this.multiTier) {
            return TruffleRuntimeOptions.getPolyglotOptionValue(options, PolyglotCompilerOptions.FirstTierCompilationThreshold);
        }
        return TruffleRuntimeOptions.getPolyglotOptionValue(options, PolyglotCompilerOptions.CompilationThreshold);
    }

    public TruffleLogger getLogger() {
        TruffleLogger result = this.logger;
        if (result == null) {
            this.logger = result = this.loggerFactory.get();
        }
        return result;
    }
}

