/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.compiler.truffle.runtime;

import java.lang.ref.WeakReference;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.graalvm.compiler.truffle.common.TruffleCompilationTask;
import org.graalvm.compiler.truffle.runtime.OptimizedCallTarget;

public final class CancellableCompileTask
implements TruffleCompilationTask {
    private final WeakReference<OptimizedCallTarget> targetRef;
    private final boolean lastTierCompilation;
    private volatile Future<?> future;
    private volatile boolean cancelled;
    private volatile boolean started;

    public CancellableCompileTask(WeakReference<OptimizedCallTarget> targetRef, boolean lastTierCompilation) {
        this.targetRef = targetRef;
        this.lastTierCompilation = lastTierCompilation;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setFuture(Future<?> future) {
        CancellableCompileTask cancellableCompileTask = this;
        synchronized (cancellableCompileTask) {
            if (this.future != null) {
                throw new IllegalStateException("The future should not be re-set.");
            }
            this.future = future;
        }
    }

    public void awaitCompletion(long timeout, TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
        this.future.get(timeout, unit);
    }

    public void awaitCompletion() throws ExecutionException, InterruptedException {
        this.future.get();
    }

    public synchronized boolean cancel() {
        if (!this.cancelled) {
            this.cancelled = true;
            if (!this.started) {
                this.finished();
            }
            return true;
        }
        return false;
    }

    public void finished() {
        OptimizedCallTarget target = (OptimizedCallTarget)this.targetRef.get();
        if (target != null) {
            target.resetCompilationTask();
        }
    }

    public synchronized boolean start() {
        assert (!this.started) : "Should not start a stared task";
        if (this.cancelled) {
            return false;
        }
        this.started = true;
        return true;
    }

    @Override
    public boolean isCancelled() {
        return this.cancelled;
    }

    @Override
    public boolean isLastTier() {
        return this.lastTierCompilation;
    }

    public Future<?> getFuture() {
        return this.future;
    }
}

