/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.compiler.truffle.runtime;

import java.lang.ref.WeakReference;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.FutureTask;
import java.util.concurrent.PriorityBlockingQueue;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.RunnableFuture;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import org.graalvm.compiler.truffle.options.PolyglotCompilerOptions;
import org.graalvm.compiler.truffle.runtime.CancellableCompileTask;
import org.graalvm.compiler.truffle.runtime.GraalTruffleRuntime;
import org.graalvm.compiler.truffle.runtime.OptimizedCallTarget;

public class BackgroundCompileQueue {
    private final AtomicLong idCounter;
    private volatile ThreadPoolExecutor compilationExecutorService;
    private boolean shutdown = false;
    protected final GraalTruffleRuntime runtime;
    private long delayMillis;

    public BackgroundCompileQueue(GraalTruffleRuntime runtime) {
        this.runtime = runtime;
        this.idCounter = new AtomicLong();
    }

    private static int log2(int n) {
        assert (n > 0);
        return 31 - Integer.numberOfLeadingZeros(n);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ExecutorService getExecutorService(OptimizedCallTarget callTarget) {
        if (this.compilationExecutorService != null) {
            return this.compilationExecutorService;
        }
        BackgroundCompileQueue backgroundCompileQueue = this;
        synchronized (backgroundCompileQueue) {
            int availableProcessors;
            if (this.compilationExecutorService != null) {
                return this.compilationExecutorService;
            }
            if (this.shutdown) {
                throw new RejectedExecutionException("The BackgroundCompileQueue is shutdown");
            }
            this.delayMillis = callTarget.getOptionValue(PolyglotCompilerOptions.EncodedGraphCachePurgeDelay).intValue();
            int threads = callTarget.getOptionValue(PolyglotCompilerOptions.CompilerThreads);
            if (threads == 0) {
                availableProcessors = Runtime.getRuntime().availableProcessors();
                if (availableProcessors >= 4) {
                    threads = 2;
                }
            } else if (threads < 0) {
                availableProcessors = Runtime.getRuntime().availableProcessors();
                int logCPU = BackgroundCompileQueue.log2(availableProcessors);
                int loglogCPU = BackgroundCompileQueue.log2(Math.max(logCPU, 1));
                threads = Math.min(availableProcessors / 4 + loglogCPU, 16);
            }
            threads = Math.max(1, threads);
            ThreadFactory factory = this.newThreadFactory("TruffleCompilerThread", callTarget);
            long compilerIdleDelay = this.runtime.getCompilerIdleDelay(callTarget);
            long keepAliveTime = compilerIdleDelay >= 0L ? compilerIdleDelay : 0L;
            ThreadPoolExecutor threadPoolExecutor = new ThreadPoolExecutor(threads, threads, keepAliveTime, TimeUnit.MILLISECONDS, new IdlingPriorityBlockingQueue(), factory){

                @Override
                protected <T> RunnableFuture<T> newTaskFor(Callable<T> callable) {
                    return new RequestFutureTask((RequestImpl)callable);
                }
            };
            if (compilerIdleDelay > 0L) {
                threadPoolExecutor.allowCoreThreadTimeOut(true);
            }
            this.compilationExecutorService = threadPoolExecutor;
            return this.compilationExecutorService;
        }
    }

    protected ThreadFactory newThreadFactory(String threadNamePrefix, OptimizedCallTarget callTarget) {
        return new TruffleCompilerThreadFactory(threadNamePrefix, this.runtime);
    }

    public CancellableCompileTask submitTask(Priority priority, OptimizedCallTarget target, Request request) {
        WeakReference<OptimizedCallTarget> targetReference = new WeakReference<OptimizedCallTarget>(target);
        CancellableCompileTask cancellable = new CancellableCompileTask(targetReference, priority == Priority.LAST_TIER);
        RequestImpl requestImpl = new RequestImpl(this.nextId(), priority, targetReference, cancellable, request);
        cancellable.setFuture(this.getExecutorService(target).submit(requestImpl));
        return cancellable;
    }

    private long nextId() {
        return this.idCounter.getAndIncrement();
    }

    public int getQueueSize() {
        ThreadPoolExecutor threadPool = this.compilationExecutorService;
        if (threadPool instanceof ThreadPoolExecutor) {
            return threadPool.getQueue().size();
        }
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void shutdownAndAwaitTermination(long timeout) {
        ThreadPoolExecutor threadPool;
        BackgroundCompileQueue backgroundCompileQueue = this;
        synchronized (backgroundCompileQueue) {
            threadPool = this.compilationExecutorService;
            if (threadPool == null) {
                this.shutdown = true;
                return;
            }
        }
        threadPool.shutdownNow();
        try {
            threadPool.awaitTermination(timeout, TimeUnit.MILLISECONDS);
        }
        catch (InterruptedException e) {
            throw new RuntimeException("Could not terminate compiler threads. Check if there are runaway compilations that don't handle Thread#interrupt.", e);
        }
    }

    protected void compilerThreadIdled() {
    }

    private final class IdlingPriorityBlockingQueue<E>
    extends PriorityBlockingQueue<E> {
        private IdlingPriorityBlockingQueue() {
        }

        @Override
        public E take() throws InterruptedException {
            while (!BackgroundCompileQueue.this.compilationExecutorService.allowsCoreThreadTimeOut()) {
                Object elem = this.poll(BackgroundCompileQueue.this.delayMillis, TimeUnit.MILLISECONDS);
                if (elem == null) {
                    BackgroundCompileQueue.this.compilerThreadIdled();
                    continue;
                }
                return elem;
            }
            return super.take();
        }
    }

    private final class TruffleCompilerThreadFactory
    implements ThreadFactory {
        private final String namePrefix;
        private final GraalTruffleRuntime runtime;

        TruffleCompilerThreadFactory(String namePrefix, GraalTruffleRuntime runtime) {
            this.namePrefix = namePrefix;
            this.runtime = runtime;
        }

        @Override
        public Thread newThread(Runnable r) {
            Thread t = new Thread(r){

                @Override
                public void run() {
                    this.setContextClassLoader(this.getClass().getClassLoader());
                    try (AutoCloseable scope = TruffleCompilerThreadFactory.this.runtime.openCompilerThreadScope();){
                        super.run();
                        if (BackgroundCompileQueue.this.compilationExecutorService.allowsCoreThreadTimeOut()) {
                            BackgroundCompileQueue.this.compilerThreadIdled();
                        }
                    }
                    catch (Exception e) {
                        throw new InternalError(e);
                    }
                }
            };
            t.setName(this.namePrefix + "-" + t.getId());
            t.setPriority(10);
            t.setDaemon(true);
            return t;
        }
    }

    private static class RequestFutureTask<V>
    extends FutureTask<V>
    implements Comparable<RequestFutureTask<?>> {
        private final RequestImpl<V> request;

        RequestFutureTask(RequestImpl<V> callable) {
            super(callable);
            this.request = callable;
        }

        @Override
        public int compareTo(RequestFutureTask<?> that) {
            return this.request.compareTo(that.request);
        }

        @Override
        public String toString() {
            return "Future(" + this.request + ")";
        }
    }

    private static final class RequestImpl<V>
    implements Callable<V>,
    Comparable<RequestImpl<?>> {
        private final long id;
        private final Priority priority;
        private final CancellableCompileTask task;
        private final WeakReference<OptimizedCallTarget> targetRef;
        private final Request request;

        RequestImpl(long id, Priority priority, WeakReference<OptimizedCallTarget> targetRef, CancellableCompileTask task, Request request) {
            this.id = id;
            this.priority = priority;
            this.targetRef = targetRef;
            this.task = task;
            this.request = request;
        }

        @Override
        public int compareTo(RequestImpl<?> that) {
            int diff = this.priority.value - that.priority.value;
            if (diff == 0) {
                diff = Long.compare(this.id, that.id);
            }
            return diff;
        }

        @Override
        public V call() {
            this.request.execute(this.task, this.targetRef);
            return null;
        }

        public String toString() {
            return "Request(id:" + this.id + ", priority:" + (Object)((Object)this.priority) + " target: " + this.targetRef.get() + ")";
        }
    }

    public static abstract class Request {
        protected abstract void execute(CancellableCompileTask var1, WeakReference<OptimizedCallTarget> var2);
    }

    public static enum Priority {
        INITIALIZATION(0),
        FIRST_TIER(1),
        LAST_TIER(2);

        private final int value;

        private Priority(int value) {
            this.value = value;
        }
    }
}

