/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.compiler.truffle.compiler.phases.inlining;

import java.util.Comparator;
import java.util.Map;
import java.util.PriorityQueue;
import org.graalvm.compiler.truffle.compiler.TruffleCompilerOptions;
import org.graalvm.compiler.truffle.compiler.phases.inlining.CallNode;
import org.graalvm.compiler.truffle.compiler.phases.inlining.CallTree;
import org.graalvm.compiler.truffle.compiler.phases.inlining.InliningPolicy;
import org.graalvm.compiler.truffle.options.PolyglotCompilerOptions;
import org.graalvm.options.OptionValues;

final class DefaultInliningPolicy
implements InliningPolicy {
    private static final int MAX_DEPTH = 15;
    private static final Comparator<CallNode> CALL_NODE_COMPARATOR = (o1, o2) -> Double.compare(o2.getRootRelativeFrequency(), o1.getRootRelativeFrequency());
    private final OptionValues options;
    private int expandedCount;

    DefaultInliningPolicy(OptionValues options) {
        this.options = options;
    }

    private static PriorityQueue<CallNode> getQueue(CallTree tree, CallNode.State state) {
        PriorityQueue<CallNode> queue = new PriorityQueue<CallNode>(CALL_NODE_COMPARATOR);
        for (CallNode child : tree.getRoot().getChildren()) {
            if (child.getState() != state) continue;
            queue.add(child);
        }
        return queue;
    }

    private static void updateQueue(CallNode candidate, PriorityQueue<CallNode> inlineQueue, CallNode.State expanded) {
        for (CallNode child : candidate.getChildren()) {
            if (child.getState() != expanded) continue;
            inlineQueue.add(child);
        }
    }

    @Override
    public void run(CallTree tree) {
        this.expand(tree);
        this.analyse(tree.getRoot());
        this.inline(tree);
    }

    private void analyse(CallNode node) {
        for (CallNode child : node.getChildren()) {
            this.analyse(child);
        }
        Data data = DefaultInliningPolicy.data(node);
        if (node.getState() == CallNode.State.Cutoff && node.getRecursionDepth() == 0) {
            data.callDiff = node.getRootRelativeFrequency();
        }
        if (node.getState() == CallNode.State.Expanded) {
            data.callDiff = -1.0 * node.getRootRelativeFrequency();
            for (CallNode child : node.getChildren()) {
                if (child.getState() == CallNode.State.Indirect || child.getState() == CallNode.State.Removed || child.getState() == CallNode.State.BailedOut) continue;
                data.callDiff += DefaultInliningPolicy.data((CallNode)child).callDiff;
            }
            if (data.callDiff > 0.0) {
                data.callDiff = node.getRootRelativeFrequency();
            }
        }
    }

    private static Data data(CallNode node) {
        return (Data)node.getPolicyData();
    }

    @Override
    public Object newCallNodeData(CallNode callNode) {
        return new Data();
    }

    private void inline(CallTree tree) {
        CallNode candidate;
        int inliningBudget = TruffleCompilerOptions.getPolyglotOptionValue(this.options, PolyglotCompilerOptions.InliningInliningBudget);
        PriorityQueue<CallNode> inlineQueue = DefaultInliningPolicy.getQueue(tree, CallNode.State.Expanded);
        while ((candidate = inlineQueue.poll()) != null && tree.getRoot().getIR().getNodeCount() + candidate.getIR().getNodeCount() <= inliningBudget) {
            if (!(DefaultInliningPolicy.data((CallNode)candidate).callDiff <= 0.0)) continue;
            candidate.inline();
            DefaultInliningPolicy.updateQueue(candidate, inlineQueue, CallNode.State.Expanded);
        }
    }

    private void expand(CallTree tree) {
        CallNode candidate;
        int expansionBudget = TruffleCompilerOptions.getPolyglotOptionValue(this.options, PolyglotCompilerOptions.InliningExpansionBudget);
        int maximumRecursiveInliningValue = TruffleCompilerOptions.getPolyglotOptionValue(this.options, PolyglotCompilerOptions.InliningRecursionDepth);
        this.expandedCount = tree.getRoot().getIR().getNodeCount();
        PriorityQueue<CallNode> expandQueue = DefaultInliningPolicy.getQueue(tree, CallNode.State.Cutoff);
        while ((candidate = expandQueue.poll()) != null && this.expandedCount < expansionBudget) {
            if (candidate.getRecursionDepth() > maximumRecursiveInliningValue || candidate.getDepth() > 15) continue;
            this.expand(candidate, expandQueue);
        }
    }

    private void expand(CallNode candidate, PriorityQueue<CallNode> expandQueue) {
        candidate.expand();
        if (candidate.getState() == CallNode.State.Expanded) {
            this.expandedCount += candidate.getIR().getNodeCount();
            DefaultInliningPolicy.updateQueue(candidate, expandQueue, CallNode.State.Cutoff);
        }
    }

    @Override
    public void putProperties(CallNode callNode, Map<Object, Object> properties) {
        properties.put("call diff", DefaultInliningPolicy.data((CallNode)callNode).callDiff);
    }

    private static final class Data {
        double callDiff;

        private Data() {
        }
    }
}

