/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.compiler.truffle.compiler.phases.inlining;

import org.graalvm.compiler.graph.Graph;
import org.graalvm.compiler.truffle.common.TruffleCompilerRuntime;
import org.graalvm.compiler.truffle.common.TruffleMetaAccessProvider;
import org.graalvm.compiler.truffle.compiler.PartialEvaluator;
import org.graalvm.compiler.truffle.compiler.TruffleCompilerOptions;
import org.graalvm.compiler.truffle.compiler.phases.inlining.CallNode;
import org.graalvm.compiler.truffle.compiler.phases.inlining.GraphManager;
import org.graalvm.compiler.truffle.compiler.phases.inlining.InliningPolicy;
import org.graalvm.compiler.truffle.options.PolyglotCompilerOptions;

public final class CallTree
extends Graph {
    private final InliningPolicy policy;
    private final GraphManager graphManager;
    private final CallNode root;
    private final PartialEvaluator.Request request;
    int expanded = 1;
    int inlined = 1;
    private int nextId = 0;

    CallTree(PartialEvaluator partialEvaluator, PartialEvaluator.Request request, InliningPolicy policy) {
        super(request.graph.getOptions(), request.debug);
        this.policy = policy;
        this.request = request;
        this.graphManager = new GraphManager(partialEvaluator, request);
        this.root = CallNode.makeRoot(this, request);
    }

    int nextId() {
        return this.nextId++;
    }

    InliningPolicy getPolicy() {
        return this.policy;
    }

    public CallNode getRoot() {
        return this.root;
    }

    public int getInlinedCount() {
        return this.inlined;
    }

    public int getExpandedCount() {
        return this.expanded;
    }

    GraphManager getGraphManager() {
        return this.graphManager;
    }

    void trace() {
        Boolean details = TruffleCompilerOptions.getPolyglotOptionValue(this.request.options, PolyglotCompilerOptions.TraceInliningDetails);
        if (TruffleCompilerOptions.getPolyglotOptionValue(this.request.options, PolyglotCompilerOptions.TraceInlining).booleanValue() || details.booleanValue()) {
            TruffleCompilerRuntime runtime = TruffleCompilerRuntime.getRuntime();
            runtime.logEvent(this.root.getTruffleAST(), 0, "inline start", this.root.getName(), this.root.getStringProperties(), null);
            this.traceRecursive(runtime, this.root, details, 0);
            runtime.logEvent(this.root.getTruffleAST(), 0, "inline done", this.root.getName(), this.root.getStringProperties(), null);
        }
    }

    private void traceRecursive(TruffleCompilerRuntime runtime, CallNode node, boolean details, int depth) {
        if (depth != 0) {
            runtime.logEvent(this.root.getTruffleAST(), depth, node.getState().toString(), node.getName(), node.getStringProperties(), null);
        }
        if (node.getState() == CallNode.State.Inlined || details) {
            for (CallNode child : node.getChildren()) {
                this.traceRecursive(runtime, child, details, depth + 1);
            }
        }
    }

    @Override
    public String toString() {
        return "Call Tree";
    }

    void dumpBasic(String format) {
        this.getDebug().dump(1, (Object)this, format, "");
    }

    public void dumpInfo(String format, Object arg) {
        this.getDebug().dump(2, (Object)this, format, arg);
    }

    public void finalizeGraph() {
        this.root.finalizeGraph();
    }

    void collectTargetsToDequeue(TruffleMetaAccessProvider provider) {
        this.root.collectTargetsToDequeue(provider);
    }
}

