/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.compiler.truffle.compiler.hotspot.amd64;

import jdk.vm.ci.amd64.AMD64;
import jdk.vm.ci.code.CallingConvention;
import jdk.vm.ci.code.CodeCacheProvider;
import jdk.vm.ci.code.Register;
import jdk.vm.ci.hotspot.HotSpotCallingConventionType;
import jdk.vm.ci.meta.JavaKind;
import jdk.vm.ci.meta.MetaAccessProvider;
import org.graalvm.compiler.asm.Assembler;
import org.graalvm.compiler.asm.Label;
import org.graalvm.compiler.asm.amd64.AMD64Address;
import org.graalvm.compiler.asm.amd64.AMD64Assembler;
import org.graalvm.compiler.asm.amd64.AMD64MacroAssembler;
import org.graalvm.compiler.code.CompilationResult;
import org.graalvm.compiler.core.common.CompressEncoding;
import org.graalvm.compiler.core.common.spi.ForeignCallsProvider;
import org.graalvm.compiler.debug.DebugContext;
import org.graalvm.compiler.hotspot.GraalHotSpotVMConfig;
import org.graalvm.compiler.hotspot.meta.HotSpotRegistersProvider;
import org.graalvm.compiler.lir.amd64.AMD64Move;
import org.graalvm.compiler.lir.asm.CompilationResultBuilder;
import org.graalvm.compiler.lir.asm.CompilationResultBuilderFactory;
import org.graalvm.compiler.lir.asm.DataBuilder;
import org.graalvm.compiler.lir.asm.FrameContext;
import org.graalvm.compiler.lir.framemap.FrameMap;
import org.graalvm.compiler.options.OptionValues;
import org.graalvm.compiler.serviceprovider.ServiceProvider;
import org.graalvm.compiler.truffle.compiler.hotspot.TruffleCallBoundaryInstrumentation;
import org.graalvm.compiler.truffle.compiler.hotspot.TruffleCallBoundaryInstrumentationFactory;

@ServiceProvider(value=TruffleCallBoundaryInstrumentationFactory.class)
public class AMD64TruffleCallBoundaryInstrumentationFactory
extends TruffleCallBoundaryInstrumentationFactory {
    @Override
    public CompilationResultBuilderFactory create(MetaAccessProvider metaAccess, GraalHotSpotVMConfig config, HotSpotRegistersProvider registers) {
        return new TruffleCallBoundaryInstrumentationFactory.TruffleCompilationResultBuilderFactory(metaAccess, config, registers){

            @Override
            public CompilationResultBuilder createBuilder(CodeCacheProvider codeCache, ForeignCallsProvider foreignCalls, FrameMap frameMap, Assembler asm, DataBuilder dataBuilder, FrameContext frameContext, final OptionValues options, DebugContext debug, CompilationResult compilationResult, Register nullRegister) {
                return new TruffleCallBoundaryInstrumentation(this.metaAccess, codeCache, foreignCalls, frameMap, asm, dataBuilder, frameContext, options, debug, compilationResult, this.config, this.registers){

                    @Override
                    protected void injectTailCallCode(int installedCodeOffset, int entryPointOffset) {
                        AMD64MacroAssembler masm = (AMD64MacroAssembler)this.asm;
                        Register thisRegister = this.codeCache.getRegisterConfig().getCallingConventionRegisters((CallingConvention.Type)HotSpotCallingConventionType.JavaCall, JavaKind.Object).get(0);
                        Register spillRegister = AMD64.r10;
                        Label doProlog = new Label();
                        int pos = masm.position();
                        if (this.config.useCompressedOops) {
                            masm.movl(spillRegister, new AMD64Address(thisRegister, installedCodeOffset), true);
                            assert (masm.position() - pos >= 5);
                            CompressEncoding encoding = this.config.getOopEncoding();
                            Register heapBaseRegister = AMD64Move.UncompressPointerOp.hasBase(options, encoding) ? this.registers.getHeapBaseRegister() : Register.None;
                            AMD64Move.UncompressPointerOp.emitUncompressCode(masm, spillRegister, encoding.getShift(), heapBaseRegister, true);
                        } else {
                            masm.movq(spillRegister, new AMD64Address(thisRegister, installedCodeOffset), true);
                            assert (masm.position() - pos >= 5);
                        }
                        masm.movq(spillRegister, new AMD64Address(spillRegister, entryPointOffset));
                        masm.testqAndJcc(spillRegister, spillRegister, AMD64Assembler.ConditionFlag.Equal, doProlog, true);
                        masm.jmp(spillRegister);
                        masm.bind(doProlog);
                    }
                };
            }
        };
    }

    @Override
    public String getArchitecture() {
        return "AMD64";
    }
}

