/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.compiler.truffle.compiler.hotspot;

import java.io.PrintStream;
import java.util.ArrayList;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import jdk.vm.ci.code.BailoutException;
import jdk.vm.ci.code.CodeCacheProvider;
import jdk.vm.ci.code.CompiledCode;
import jdk.vm.ci.code.InstalledCode;
import jdk.vm.ci.hotspot.HotSpotCodeCacheProvider;
import jdk.vm.ci.hotspot.HotSpotCompilationRequest;
import jdk.vm.ci.hotspot.HotSpotCompiledCode;
import jdk.vm.ci.hotspot.HotSpotJVMCIRuntime;
import jdk.vm.ci.hotspot.HotSpotNmethod;
import jdk.vm.ci.hotspot.HotSpotResolvedJavaMethod;
import jdk.vm.ci.meta.Assumptions;
import jdk.vm.ci.meta.ResolvedJavaMethod;
import jdk.vm.ci.runtime.JVMCI;
import jdk.vm.ci.runtime.JVMCICompiler;
import org.graalvm.collections.EconomicMap;
import org.graalvm.compiler.api.replacements.SnippetReflectionProvider;
import org.graalvm.compiler.api.runtime.GraalJVMCICompiler;
import org.graalvm.compiler.code.CompilationResult;
import org.graalvm.compiler.core.CompilationWrapper;
import org.graalvm.compiler.core.GraalCompiler;
import org.graalvm.compiler.core.common.CancellationBailoutException;
import org.graalvm.compiler.core.common.CompilationIdentifier;
import org.graalvm.compiler.core.target.Backend;
import org.graalvm.compiler.debug.DebugCloseable;
import org.graalvm.compiler.debug.DebugContext;
import org.graalvm.compiler.debug.DebugHandlersFactory;
import org.graalvm.compiler.debug.DebugOptions;
import org.graalvm.compiler.debug.DiagnosticsOutputDirectory;
import org.graalvm.compiler.hotspot.CompilerConfigurationFactory;
import org.graalvm.compiler.hotspot.EconomyCompilerConfigurationFactory;
import org.graalvm.compiler.hotspot.HotSpotBackend;
import org.graalvm.compiler.hotspot.HotSpotBackendFactory;
import org.graalvm.compiler.hotspot.HotSpotCompilationIdentifier;
import org.graalvm.compiler.hotspot.HotSpotCompiledCodeBuilder;
import org.graalvm.compiler.hotspot.HotSpotGraalCompilerFactory;
import org.graalvm.compiler.hotspot.HotSpotGraalRuntimeProvider;
import org.graalvm.compiler.hotspot.HotSpotGraalServices;
import org.graalvm.compiler.hotspot.meta.HotSpotProviders;
import org.graalvm.compiler.hotspot.meta.HotSpotSuitesProvider;
import org.graalvm.compiler.java.GraphBuilderPhase;
import org.graalvm.compiler.lir.asm.CompilationResultBuilderFactory;
import org.graalvm.compiler.lir.phases.LIRSuites;
import org.graalvm.compiler.nodes.EncodedGraph;
import org.graalvm.compiler.nodes.StructuredGraph;
import org.graalvm.compiler.nodes.graphbuilderconf.GraphBuilderConfiguration;
import org.graalvm.compiler.nodes.graphbuilderconf.InvocationPlugins;
import org.graalvm.compiler.options.Option;
import org.graalvm.compiler.options.OptionKey;
import org.graalvm.compiler.options.OptionValues;
import org.graalvm.compiler.phases.BasePhase;
import org.graalvm.compiler.phases.OptimisticOptimizations;
import org.graalvm.compiler.phases.PhaseSuite;
import org.graalvm.compiler.phases.common.AbstractInliningPhase;
import org.graalvm.compiler.phases.tiers.CompilerConfiguration;
import org.graalvm.compiler.phases.tiers.HighTierContext;
import org.graalvm.compiler.phases.tiers.Suites;
import org.graalvm.compiler.phases.tiers.SuitesProvider;
import org.graalvm.compiler.phases.util.Providers;
import org.graalvm.compiler.printer.GraalDebugHandlersFactory;
import org.graalvm.compiler.serviceprovider.GraalServices;
import org.graalvm.compiler.truffle.common.CompilableTruffleAST;
import org.graalvm.compiler.truffle.common.TruffleCompilerRuntime;
import org.graalvm.compiler.truffle.common.hotspot.HotSpotTruffleCompiler;
import org.graalvm.compiler.truffle.common.hotspot.HotSpotTruffleCompilerRuntime;
import org.graalvm.compiler.truffle.compiler.TruffleCompilationIdentifier;
import org.graalvm.compiler.truffle.compiler.TruffleCompilerImpl;
import org.graalvm.compiler.truffle.compiler.TruffleCompilerOptions;
import org.graalvm.compiler.truffle.compiler.hotspot.HotSpotPartialEvaluator;
import org.graalvm.compiler.truffle.compiler.hotspot.HotSpotTruffleCompilationIdentifier;
import org.graalvm.compiler.truffle.compiler.hotspot.TruffleCallBoundaryInstrumentationFactory;

public final class HotSpotTruffleCompilerImpl
extends TruffleCompilerImpl
implements HotSpotTruffleCompiler {
    private final HotSpotGraalRuntimeProvider hotspotGraalRuntime;
    private volatile List<DebugHandlersFactory> factories;

    public static HotSpotTruffleCompilerImpl create(TruffleCompilerRuntime runtime) {
        OptionValues options = TruffleCompilerOptions.getOptions();
        HotSpotGraalRuntimeProvider hotspotGraalRuntime = (HotSpotGraalRuntimeProvider)HotSpotTruffleCompilerImpl.getCompiler(options).getGraalRuntime();
        HotSpotBackend backend = hotspotGraalRuntime.getHostBackend();
        Suites suites = ((Backend)backend).getSuites().getDefaultSuites(options);
        LIRSuites lirSuites = ((Backend)backend).getSuites().getDefaultLIRSuites(options);
        GraphBuilderPhase phase = (GraphBuilderPhase)((Backend)backend).getSuites().getDefaultGraphBuilderSuite().findPhase(GraphBuilderPhase.class).previous();
        GraphBuilderConfiguration.Plugins plugins = phase.getGraphBuilderConfig().getPlugins();
        SnippetReflectionProvider snippetReflection = hotspotGraalRuntime.getRequiredCapability(SnippetReflectionProvider.class);
        EconomyCompilerConfigurationFactory economyConfigurationFactory = new EconomyCompilerConfigurationFactory();
        CompilerConfiguration compilerConfiguration = economyConfigurationFactory.createCompilerConfiguration();
        HotSpotBackendFactory backendFactory = economyConfigurationFactory.createBackendMap().getBackendFactory(backend.getTarget().arch);
        HotSpotBackend firstTierBackend = backendFactory.createBackend(hotspotGraalRuntime, compilerConfiguration, HotSpotJVMCIRuntime.runtime(), null);
        Suites firstTierSuites = firstTierBackend.getSuites().getDefaultSuites(options);
        LIRSuites firstTierLirSuites = firstTierBackend.getSuites().getDefaultLIRSuites(options);
        HotSpotProviders firstTierProviders = firstTierBackend.getProviders();
        firstTierBackend.completeInitialization(HotSpotJVMCIRuntime.runtime(), options);
        return new HotSpotTruffleCompilerImpl(hotspotGraalRuntime, runtime, plugins, suites, lirSuites, backend, firstTierSuites, firstTierLirSuites, firstTierProviders, snippetReflection);
    }

    private static GraalJVMCICompiler getCompiler(OptionValues options) {
        JVMCICompiler compiler;
        if (!Options.TruffleCompilerConfiguration.hasBeenSet(options) && (compiler = JVMCI.getRuntime().getCompiler()) instanceof GraalJVMCICompiler) {
            return (GraalJVMCICompiler)compiler;
        }
        CompilerConfigurationFactory compilerConfigurationFactory = CompilerConfigurationFactory.selectFactory(Options.TruffleCompilerConfiguration.getValue(options), options);
        return HotSpotGraalCompilerFactory.createCompiler("Truffle", JVMCI.getRuntime(), options, compilerConfigurationFactory);
    }

    private HotSpotTruffleCompilerImpl(HotSpotGraalRuntimeProvider hotspotGraalRuntime, TruffleCompilerRuntime runtime, GraphBuilderConfiguration.Plugins plugins, Suites suites, LIRSuites lirSuites, Backend backend, Suites firstTierSuites, LIRSuites firstTierLirSuites, Providers firstTierProviders, SnippetReflectionProvider snippetReflection) {
        super(runtime, plugins, suites, lirSuites, backend, firstTierSuites, firstTierLirSuites, firstTierProviders, snippetReflection);
        this.hotspotGraalRuntime = hotspotGraalRuntime;
        this.installTruffleCallBoundaryMethods(null);
    }

    @Override
    public TruffleCompilationIdentifier createCompilationIdentifier(CompilableTruffleAST compilable) {
        ResolvedJavaMethod rootMethod = this.partialEvaluator.rootForCallTarget(compilable);
        HotSpotCompilationRequest request = new HotSpotCompilationRequest((HotSpotResolvedJavaMethod)rootMethod, -1, 0L);
        return new HotSpotTruffleCompilationIdentifier(request, compilable);
    }

    private List<DebugHandlersFactory> getDebugHandlerFactories() {
        if (this.factories == null) {
            ArrayList<DebugHandlersFactory> list = new ArrayList<DebugHandlersFactory>();
            list.add(new GraalDebugHandlersFactory(this.snippetReflection));
            for (DebugHandlersFactory factory : DebugHandlersFactory.LOADER) {
                if (factory instanceof GraalDebugHandlersFactory) continue;
                list.add(factory);
            }
            this.factories = list;
        }
        return this.factories;
    }

    @Override
    public String getCompilerConfigurationName() {
        return this.hotspotGraalRuntime.getCompilerConfigurationName();
    }

    @Override
    protected DebugContext createDebugContext(OptionValues options, CompilationIdentifier compilationId, CompilableTruffleAST compilable, PrintStream logStream) {
        return this.hotspotGraalRuntime.openDebugContext(options, compilationId, compilable, this.getDebugHandlerFactories(), logStream);
    }

    @Override
    protected HotSpotPartialEvaluator createPartialEvaluator() {
        return new HotSpotPartialEvaluator(this.lastTierProviders, this.config, this.snippetReflection, this.backend.getTarget().arch);
    }

    @Override
    public PhaseSuite<HighTierContext> createGraphBuilderSuite() {
        return this.backend.getSuites().getDefaultGraphBuilderSuite().copy();
    }

    @Override
    public void installTruffleCallBoundaryMethods(CompilableTruffleAST compilable) {
        HotSpotTruffleCompilerRuntime runtime = (HotSpotTruffleCompilerRuntime)TruffleCompilerRuntime.getRuntime();
        for (ResolvedJavaMethod method : runtime.getTruffleCallBoundaryMethods()) {
            HotSpotResolvedJavaMethod hotSpotMethod = (HotSpotResolvedJavaMethod)method;
            if (hotSpotMethod.hasCompiledCode()) {
                return;
            }
            HotSpotCompilationIdentifier compilationId = (HotSpotCompilationIdentifier)this.backend.getCompilationIdentifier(method);
            OptionValues options = TruffleCompilerOptions.getOptions();
            DebugContext debug = DebugOptions.DebugStubsAndSnippets.getValue(options) != false ? this.hotspotGraalRuntime.openDebugContext(options, compilationId, method, this.getDebugHandlerFactories(), DebugContext.getDefaultLogStream()) : DebugContext.disabled(options);
            Throwable throwable = null;
            try {
                DebugContext.Activation a = debug.activate();
                Throwable throwable2 = null;
                try {
                    DebugContext.Scope d = debug.scope("InstallingTruffleStub");
                    Throwable throwable3 = null;
                    try {
                        CompilationResult compResult = this.compileTruffleCallBoundaryMethod(method, compilationId, debug);
                        CodeCacheProvider codeCache = this.lastTierProviders.getCodeCache();
                        try {
                            DebugContext.Scope s = debug.scope("CodeInstall", codeCache, method, compResult);
                            Throwable throwable4 = null;
                            try {
                                HotSpotCompiledCode compiledCode = HotSpotCompiledCodeBuilder.createCompiledCode(codeCache, method, compilationId.getRequest(), compResult, TruffleCompilerOptions.getOptions());
                                codeCache.setDefaultCode(method, (CompiledCode)compiledCode);
                            }
                            catch (Throwable throwable5) {
                                throwable4 = throwable5;
                                throw throwable5;
                            }
                            finally {
                                if (s == null) continue;
                                if (throwable4 != null) {
                                    try {
                                        s.close();
                                    }
                                    catch (Throwable throwable6) {
                                        throwable4.addSuppressed(throwable6);
                                    }
                                    continue;
                                }
                                s.close();
                            }
                        }
                        catch (Throwable e) {
                            throw debug.handle(e);
                        }
                    }
                    catch (Throwable throwable7) {
                        throwable3 = throwable7;
                        throw throwable7;
                    }
                    finally {
                        if (d == null) continue;
                        if (throwable3 != null) {
                            try {
                                d.close();
                            }
                            catch (Throwable throwable8) {
                                throwable3.addSuppressed(throwable8);
                            }
                            continue;
                        }
                        d.close();
                    }
                }
                catch (Throwable throwable9) {
                    throwable2 = throwable9;
                    throw throwable9;
                }
                finally {
                    if (a == null) continue;
                    if (throwable2 != null) {
                        try {
                            a.close();
                        }
                        catch (Throwable throwable10) {
                            throwable2.addSuppressed(throwable10);
                        }
                        continue;
                    }
                    a.close();
                }
            }
            catch (Throwable throwable11) {
                throwable = throwable11;
                throw throwable11;
            }
            finally {
                if (debug == null) continue;
                if (throwable != null) {
                    try {
                        debug.close();
                    }
                    catch (Throwable throwable12) {
                        throwable.addSuppressed(throwable12);
                    }
                    continue;
                }
                debug.close();
            }
        }
    }

    @Override
    public int pendingTransferToInterpreterOffset(CompilableTruffleAST compilable) {
        return this.hotspotGraalRuntime.getVMConfig().pendingTransferToInterpreterOffset;
    }

    @Override
    protected DiagnosticsOutputDirectory getDebugOutputDirectory() {
        return this.hotspotGraalRuntime.getOutputDirectory();
    }

    @Override
    protected Map<CompilationWrapper.ExceptionAction, Integer> getCompilationProblemsPerAction() {
        return this.hotspotGraalRuntime.getCompilationProblemsPerAction();
    }

    private CompilationResultBuilderFactory getTruffleCallBoundaryInstrumentationFactory(String arch) {
        for (TruffleCallBoundaryInstrumentationFactory factory : GraalServices.load(TruffleCallBoundaryInstrumentationFactory.class)) {
            if (!factory.getArchitecture().equals(arch)) continue;
            return factory.create(this.lastTierProviders.getMetaAccess(), this.hotspotGraalRuntime.getVMConfig(), this.hotspotGraalRuntime.getHostProviders().getRegisters());
        }
        return CompilationResultBuilderFactory.Default;
    }

    private CompilationResult compileTruffleCallBoundaryMethod(ResolvedJavaMethod javaMethod, CompilationIdentifier compilationId, DebugContext debug) {
        Suites newSuites = this.lastTierSuites.copy();
        HotSpotTruffleCompilerImpl.removeInliningPhase(newSuites);
        OptionValues options = debug.getOptions();
        StructuredGraph graph = new StructuredGraph.Builder(options, debug, StructuredGraph.AllowAssumptions.NO).method(javaMethod).compilationId(compilationId).build();
        GraphBuilderConfiguration.Plugins plugins = new GraphBuilderConfiguration.Plugins(new InvocationPlugins());
        HotSpotCodeCacheProvider codeCache = (HotSpotCodeCacheProvider)this.lastTierProviders.getCodeCache();
        boolean infoPoints = codeCache.shouldDebugNonSafepoints();
        GraphBuilderConfiguration newConfig = GraphBuilderConfiguration.getDefault(plugins).withEagerResolving(true).withUnresolvedIsError(true).withNodeSourcePosition(infoPoints);
        new GraphBuilderPhase.Instance(this.lastTierProviders, newConfig, OptimisticOptimizations.ALL, null).apply(graph);
        PhaseSuite<HighTierContext> graphBuilderSuite = HotSpotTruffleCompilerImpl.getGraphBuilderSuite((CodeCacheProvider)codeCache, this.backend.getSuites());
        CompilationResultBuilderFactory factory = this.getTruffleCallBoundaryInstrumentationFactory(this.backend.getTarget().arch.getName());
        return GraalCompiler.compileGraph(graph, javaMethod, this.lastTierProviders, this.backend, graphBuilderSuite, OptimisticOptimizations.ALL, graph.getProfilingInfo(), newSuites, this.lastTierLirSuites, new CompilationResult(compilationId), factory, false);
    }

    private static PhaseSuite<HighTierContext> getGraphBuilderSuite(CodeCacheProvider codeCache, SuitesProvider suitesProvider) {
        PhaseSuite<HighTierContext> graphBuilderSuite = suitesProvider.getDefaultGraphBuilderSuite();
        if (codeCache.shouldDebugNonSafepoints()) {
            graphBuilderSuite = HotSpotSuitesProvider.withNodeSourcePosition(graphBuilderSuite);
        }
        return graphBuilderSuite;
    }

    private static void removeInliningPhase(Suites suites) {
        ListIterator<BasePhase<HighTierContext>> inliningPhase = suites.getHighTier().findPhase(AbstractInliningPhase.class);
        if (inliningPhase != null) {
            inliningPhase.remove();
        }
    }

    @Override
    protected InstalledCode createInstalledCode(CompilableTruffleAST compilable) {
        return null;
    }

    @Override
    protected boolean soleExecutionEntryPoint(InstalledCode installedCode) {
        HotSpotNmethod nmethod;
        return !(installedCode instanceof HotSpotNmethod) || !(nmethod = (HotSpotNmethod)installedCode).isDefault();
    }

    @Override
    protected void exitHostVM(int status) {
        HotSpotGraalServices.exit(-1);
    }

    @Override
    protected CompilationResult createCompilationResult(String name, CompilationIdentifier compilationIdentifier, CompilableTruffleAST compilable) {
        return new HotSpotTruffleCompilationResult(compilationIdentifier, name, compilable);
    }

    @Override
    protected void afterCodeInstallation(CompilationResult result, InstalledCode installedCode) {
        if (result instanceof HotSpotTruffleCompilationResult) {
            HotSpotTruffleCompilerRuntime runtime = (HotSpotTruffleCompilerRuntime)TruffleCompilerRuntime.getRuntime();
            runtime.onCodeInstallation(((HotSpotTruffleCompilationResult)result).compilable, installedCode);
        }
    }

    @Override
    protected CompilableTruffleAST getCompilable(CompilationResult result) {
        if (result instanceof HotSpotTruffleCompilationResult) {
            return ((HotSpotTruffleCompilationResult)result).compilable;
        }
        return null;
    }

    @Override
    public HotSpotPartialEvaluator getPartialEvaluator() {
        return (HotSpotPartialEvaluator)super.getPartialEvaluator();
    }

    @Override
    public void purgeCaches() {
        this.getPartialEvaluator().purgeEncodedGraphCache();
    }

    @Override
    protected void handleBailout(DebugContext debug, StructuredGraph graph, BailoutException bailout) {
        if (!this.getPartialEvaluator().isEncodedGraphCacheEnabled()) {
            return;
        }
        if (!(bailout instanceof CancellationBailoutException || bailout.isPermanent() || graph == null || graph.getAssumptions().isEmpty())) {
            try (DebugCloseable dummy = EncodedGraphCacheEvictionTime.start(debug);){
                assert (graph.method() != null);
                EconomicMap<ResolvedJavaMethod, EncodedGraph> graphCache = this.partialEvaluator.getOrCreateEncodedGraphCache();
                if (!graphCache.isEmpty()) {
                    debug.log(3, "Evict root %s", (Object)graph.method());
                    graphCache.removeKey((Object)graph.method());
                    for (ResolvedJavaMethod method : graph.getMethods()) {
                        Assumptions assumptions;
                        EncodedGraph encodedGraph = (EncodedGraph)graphCache.get((Object)method);
                        if (encodedGraph == null || (assumptions = encodedGraph.getAssumptions()) == null || assumptions.isEmpty()) continue;
                        debug.log(3, "\tEvict inlined %s", (Object)method);
                        graphCache.removeKey((Object)method);
                    }
                }
            }
        }
    }

    private static final class HotSpotTruffleCompilationResult
    extends CompilationResult {
        final CompilableTruffleAST compilable;

        HotSpotTruffleCompilationResult(CompilationIdentifier compilationId, String name, CompilableTruffleAST compilable) {
            super(compilationId, name);
            this.compilable = compilable;
        }
    }

    public static class Options {
        @Option(help={"Select a compiler configuration for Truffle compilation (default: use Graal system compiler configuration)."})
        public static final OptionKey<String> TruffleCompilerConfiguration = new OptionKey<Object>(null);
    }
}

