/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.compiler.truffle.compiler;

import java.util.EnumSet;
import java.util.Formatter;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import jdk.vm.ci.common.NativeImageReinitialize;
import org.graalvm.collections.EconomicMap;
import org.graalvm.collections.Equivalence;
import org.graalvm.collections.MapCursor;
import org.graalvm.collections.Pair;
import org.graalvm.collections.UnmodifiableEconomicMap;
import org.graalvm.compiler.options.Option;
import org.graalvm.compiler.options.OptionKey;
import org.graalvm.compiler.options.OptionType;
import org.graalvm.compiler.options.OptionValues;
import org.graalvm.compiler.truffle.common.CompilableTruffleAST;
import org.graalvm.compiler.truffle.common.SharedTruffleOptions;
import org.graalvm.compiler.truffle.common.TruffleCompilerRuntime;
import org.graalvm.compiler.truffle.compiler.SharedTruffleCompilerOptions;
import org.graalvm.compiler.truffle.options.OptionValuesImpl;
import org.graalvm.compiler.truffle.options.PolyglotCompilerOptions;
import org.graalvm.options.OptionDescriptor;
import org.graalvm.options.OptionDescriptors;

@SharedTruffleOptions(name="SharedTruffleCompilerOptions", runtime=false)
public final class TruffleCompilerOptions {
    @Option(help={"Exclude assertion code from Truffle compilations"}, type=OptionType.Debug, deprecated=true)
    static final OptionKey<Boolean> TruffleExcludeAssertions = new OptionKey<Object>(PolyglotCompilerOptions.ExcludeAssertions.getDefaultValue());
    @Option(help={"Enable inlining across Truffle boundary"}, type=OptionType.Expert, deprecated=true)
    static final OptionKey<Boolean> TruffleInlineAcrossTruffleBoundary = new OptionKey<Object>(PolyglotCompilerOptions.InlineAcrossTruffleBoundary.getDefaultValue());
    @Option(help={"Print potential performance problems"}, type=OptionType.Debug, deprecated=true)
    static final OptionKey<Boolean> TraceTrufflePerformanceWarnings = new OptionKey<Boolean>(false);
    @Option(help={"Prints a histogram of all expanded Java methods."}, type=OptionType.Debug, deprecated=true)
    static final OptionKey<Boolean> PrintTruffleExpansionHistogram = new OptionKey<Object>(PolyglotCompilerOptions.PrintExpansionHistogram.getDefaultValue());
    @Option(help={"Enable support for simple infopoints in truffle partial evaluations."}, type=OptionType.Expert, deprecated=true)
    static final OptionKey<Boolean> TruffleEnableInfopoints = new OptionKey<Object>(PolyglotCompilerOptions.NodeSourcePositions.getDefaultValue());
    @Option(help={"Run the partial escape analysis iteratively in Truffle compilation."}, type=OptionType.Debug, deprecated=true)
    static final OptionKey<Boolean> TruffleIterativePartialEscape = new OptionKey<Object>(PolyglotCompilerOptions.IterativePartialEscape.getDefaultValue());
    @Option(help={"Instrument branches and output profiling information to the standard output."}, deprecated=true)
    static final OptionKey<Boolean> TruffleInstrumentBranches = new OptionKey<Object>(PolyglotCompilerOptions.InstrumentBranches.getDefaultValue());
    @Option(help={"Instrument branches by considering different inlining sites as different branches."}, deprecated=true)
    static final OptionKey<Boolean> TruffleInstrumentBranchesPerInlineSite = new OptionKey<Object>(PolyglotCompilerOptions.InstrumentBranchesPerInlineSite.getDefaultValue());
    @Option(help={"Instrument Truffle boundaries and output profiling information to the standard output."}, deprecated=true)
    static final OptionKey<Boolean> TruffleInstrumentBoundaries = new OptionKey<Object>(PolyglotCompilerOptions.InstrumentBoundaries.getDefaultValue());
    @Option(help={"Instrument Truffle boundaries by considering different inlining sites as different branches."}, deprecated=true)
    static final OptionKey<Boolean> TruffleInstrumentBoundariesPerInlineSite = new OptionKey<Object>(PolyglotCompilerOptions.InstrumentBoundariesPerInlineSite.getDefaultValue());
    @Option(help={"Method filter for host methods in which to add instrumentation."}, deprecated=true)
    static final OptionKey<String> TruffleInstrumentFilter = new OptionKey<Object>(PolyglotCompilerOptions.InstrumentFilter.getDefaultValue());
    @Option(help={"Maximum number of instrumentation counters available."}, deprecated=true)
    static final OptionKey<Integer> TruffleInstrumentationTableSize = new OptionKey<Object>(PolyglotCompilerOptions.InstrumentationTableSize.getDefaultValue());
    @Option(help={"Stop partial evaluation when the graph exceeded this many nodes."}, deprecated=true)
    static final OptionKey<Integer> TruffleMaximumGraalNodeCount = new OptionKey<Object>(PolyglotCompilerOptions.MaximumGraalNodeCount.getDefaultValue());
    @Option(help={"Ignore further truffle inlining decisions when the graph exceeded this many nodes."}, deprecated=true)
    static final OptionKey<Integer> TruffleMaximumInlineNodeCount = new OptionKey<Object>(PolyglotCompilerOptions.MaximumInlineNodeCount.getDefaultValue());
    @Option(help={"Intrinsify get/set/is methods of FrameWithoutBoxing to improve Truffle compilation time"}, type=OptionType.Debug, deprecated=true)
    static final OptionKey<Boolean> TruffleIntrinsifyFrameAccess = new OptionKey<Boolean>(true);
    @Option(help={"Print detailed information for inlining (i.e. the entire explored call tree)."}, type=OptionType.Expert, deprecated=true)
    static final OptionKey<Boolean> TraceTruffleInliningDetails = new OptionKey<Object>(PolyglotCompilerOptions.TraceInliningDetails.getDefaultValue());
    @Option(help={"Explicitly pick a inlining policy by name. Highest priority chosen by default."}, type=OptionType.Expert, deprecated=true)
    static final OptionKey<String> TruffleInliningPolicy = new OptionKey<Object>(PolyglotCompilerOptions.InliningPolicy.getDefaultValue());
    @Option(help={"The base expansion budget for language-agnostic inlining."}, type=OptionType.Expert, deprecated=true)
    static final OptionKey<Integer> TruffleInliningExpansionBudget = new OptionKey<Object>(PolyglotCompilerOptions.InliningExpansionBudget.getDefaultValue());
    @Option(help={"The base inlining budget for language-agnostic inlining"}, type=OptionType.Expert, deprecated=true)
    static final OptionKey<Integer> TruffleInliningInliningBudget = new OptionKey<Object>(PolyglotCompilerOptions.InliningInliningBudget.getDefaultValue());
    @NativeImageReinitialize
    private static volatile OptionValues optionValues;

    private TruffleCompilerOptions() {
        throw new IllegalStateException("No instance allowed.");
    }

    public static <T> T getPolyglotOptionValue(org.graalvm.options.OptionValues options, org.graalvm.options.OptionKey<T> optionKey) {
        if (options != null && options.hasBeenSet(optionKey)) {
            return (T)options.get(optionKey);
        }
        Pair compilerOptionKeyPair = (Pair)Lazy.POLYGLOT_TO_COMPILER.get(optionKey);
        if (compilerOptionKeyPair != null) {
            return (T)((Function)compilerOptionKeyPair.getRight()).apply(((OptionKey)compilerOptionKeyPair.getLeft()).getValue(TruffleCompilerOptions.getOptions()));
        }
        return (T)optionKey.getDefaultValue();
    }

    public static boolean areTruffleCompilationExceptionsFatal(org.graalvm.options.OptionValues options) {
        boolean compilationExceptionsAreFatal = TruffleCompilerOptions.getPolyglotOptionValue(options, PolyglotCompilerOptions.CompilationExceptionsAreFatal);
        boolean performanceWarningsAreFatal = !TruffleCompilerOptions.getPolyglotOptionValue(options, PolyglotCompilerOptions.PerformanceWarningsAreFatal).isEmpty();
        boolean exitVM = TruffleCompilerOptions.getPolyglotOptionValue(options, PolyglotCompilerOptions.CompilationFailureAction) == PolyglotCompilerOptions.ExceptionAction.ExitVM;
        return compilationExceptionsAreFatal || performanceWarningsAreFatal || exitVM;
    }

    public static OptionValues getOptions() {
        OptionValues result = optionValues;
        if (result == null) {
            optionValues = result = TruffleCompilerRuntime.getRuntime().getOptions(OptionValues.class);
        }
        return result;
    }

    public static org.graalvm.options.OptionValues getOptionsForCompiler(Map<String, Object> options) {
        EconomicMap parsedOptions = EconomicMap.create((Equivalence)Equivalence.IDENTITY);
        OptionDescriptors descriptors = PolyglotCompilerOptions.getDescriptors();
        for (Map.Entry<String, Object> e : options.entrySet()) {
            OptionDescriptor descriptor = descriptors.get(e.getKey());
            org.graalvm.options.OptionKey k = descriptor != null ? descriptor.getKey() : null;
            if (k == null) continue;
            Object value = e.getValue();
            if (value.getClass() == String.class) {
                value = descriptor.getKey().getType().convert((String)e.getValue());
            }
            parsedOptions.put((Object)k, value);
        }
        return new OptionValuesImpl(descriptors, (UnmodifiableEconomicMap<org.graalvm.options.OptionKey<?>, Object>)parsedOptions);
    }

    static String[] checkDeprecation(CompilableTruffleAST compilable) {
        EconomicMap deprecatedToReplacement = EconomicMap.create((Equivalence)Equivalence.IDENTITY);
        OptionValues options = TruffleCompilerOptions.getOptions();
        MapCursor cursor = Lazy.POLYGLOT_TO_COMPILER.getEntries();
        while (cursor.advance()) {
            OptionKey deprecatedKey = (OptionKey)((Pair)cursor.getValue()).getLeft();
            if (!deprecatedKey.hasBeenSet(options)) continue;
            deprecatedToReplacement.put((Object)deprecatedKey, cursor.getKey());
        }
        if (!deprecatedToReplacement.isEmpty()) {
            EconomicMap polyglotOptionKeyToName = EconomicMap.create((Equivalence)Equivalence.IDENTITY);
            for (OptionDescriptor descriptor : PolyglotCompilerOptions.getDescriptors()) {
                polyglotOptionKeyToName.put((Object)descriptor.getKey(), (Object)descriptor.getName());
            }
            MapCursor deprecatedCursor = deprecatedToReplacement.getEntries();
            StringBuilder warning = new StringBuilder();
            Formatter formatter = new Formatter(warning);
            while (deprecatedCursor.advance()) {
                if (warning.length() > 0) {
                    formatter.format("%n", new Object[0]);
                }
                OptionKey deprecatedOptionKey = (OptionKey)deprecatedCursor.getKey();
                Object value = deprecatedOptionKey.getValue(options);
                String strValue = String.valueOf(value);
                String polyglotOptionName = (String)polyglotOptionKeyToName.get(deprecatedCursor.getValue());
                formatter.format("WARNING: The option '%s' was deprecated. Truffle runtime options are no longer specified as Graal options (-Dgraal.*).%n", deprecatedOptionKey.getName());
                formatter.format("Replace the Graal option usage with one of the following replacements:%n", new Object[0]);
                if (value instanceof Boolean && ((Boolean)value).booleanValue()) {
                    formatter.format("* '--%s' if the option is passed using a guest language launcher.%n", polyglotOptionName);
                } else {
                    formatter.format("* '--%s=%s' if the option is passed using a guest language launcher.%n", polyglotOptionName, strValue);
                }
                formatter.format("* '-Dpolyglot.%s=%s' if the option is passed using the host Java launcher.%n", polyglotOptionName, strValue);
                String quot = value instanceof String ? "\"" : "";
                formatter.format("* Using polyglot API: 'org.graalvm.polyglot.Context.newBuilder().option(\"%s\", " + quot + "%s" + quot + ")'", polyglotOptionName, strValue);
            }
            TruffleCompilerRuntime.getRuntime().log(compilable, warning.toString());
        }
        return new String[0];
    }

    private static Pair<OptionKey<?>, Function<Object, ?>> identity(OptionKey<?> key) {
        return Pair.create(key, Function.identity());
    }

    private static Pair<OptionKey<Boolean>, Function<Object, ?>> booleanToPerformanceWarningKind(OptionKey<Boolean> key) {
        return Pair.create(key, (Object)new Function<Object, Set<PolyglotCompilerOptions.PerformanceWarningKind>>(){

            @Override
            public Set<PolyglotCompilerOptions.PerformanceWarningKind> apply(Object t) {
                return (Boolean)t != false ? EnumSet.allOf(PolyglotCompilerOptions.PerformanceWarningKind.class) : EnumSet.noneOf(PolyglotCompilerOptions.PerformanceWarningKind.class);
            }
        });
    }

    private static final class Lazy {
        private static final EconomicMap<org.graalvm.options.OptionKey<?>, Pair<? extends OptionKey<?>, Function<Object, ?>>> POLYGLOT_TO_COMPILER = Lazy.initializePolyglotToGraalMapping();

        private Lazy() {
        }

        private static EconomicMap<org.graalvm.options.OptionKey<?>, Pair<? extends OptionKey<?>, Function<Object, ?>>> initializePolyglotToGraalMapping() {
            EconomicMap result = EconomicMap.create((Equivalence)Equivalence.IDENTITY);
            result.put(PolyglotCompilerOptions.InlineAcrossTruffleBoundary, (Object)TruffleCompilerOptions.identity(TruffleInlineAcrossTruffleBoundary));
            result.put(PolyglotCompilerOptions.TracePerformanceWarnings, (Object)TruffleCompilerOptions.booleanToPerformanceWarningKind(TraceTrufflePerformanceWarnings));
            result.put(PolyglotCompilerOptions.PrintExpansionHistogram, (Object)TruffleCompilerOptions.identity(PrintTruffleExpansionHistogram));
            result.put(PolyglotCompilerOptions.IterativePartialEscape, (Object)TruffleCompilerOptions.identity(TruffleIterativePartialEscape));
            result.put(PolyglotCompilerOptions.InstrumentFilter, (Object)TruffleCompilerOptions.identity(TruffleInstrumentFilter));
            result.put(PolyglotCompilerOptions.InstrumentationTableSize, (Object)TruffleCompilerOptions.identity(TruffleInstrumentationTableSize));
            result.put(PolyglotCompilerOptions.MaximumGraalNodeCount, (Object)TruffleCompilerOptions.identity(TruffleMaximumGraalNodeCount));
            result.put(PolyglotCompilerOptions.MaximumInlineNodeCount, (Object)TruffleCompilerOptions.identity(TruffleMaximumInlineNodeCount));
            result.put(PolyglotCompilerOptions.TraceInliningDetails, (Object)TruffleCompilerOptions.identity(TraceTruffleInliningDetails));
            result.put(PolyglotCompilerOptions.InliningPolicy, (Object)TruffleCompilerOptions.identity(TruffleInliningPolicy));
            result.put(PolyglotCompilerOptions.InliningExpansionBudget, (Object)TruffleCompilerOptions.identity(TruffleInliningExpansionBudget));
            result.put(PolyglotCompilerOptions.InliningInliningBudget, (Object)TruffleCompilerOptions.identity(TruffleInliningInliningBudget));
            result.put(PolyglotCompilerOptions.CompilationExceptionsAreFatal, (Object)TruffleCompilerOptions.identity(SharedTruffleCompilerOptions.TruffleCompilationExceptionsAreFatal));
            result.put(PolyglotCompilerOptions.PerformanceWarningsAreFatal, (Object)TruffleCompilerOptions.booleanToPerformanceWarningKind(SharedTruffleCompilerOptions.TrufflePerformanceWarningsAreFatal));
            result.put(PolyglotCompilerOptions.TraceInlining, (Object)TruffleCompilerOptions.identity(SharedTruffleCompilerOptions.TraceTruffleInlining));
            result.put(PolyglotCompilerOptions.TraceStackTraceLimit, (Object)TruffleCompilerOptions.identity(SharedTruffleCompilerOptions.TraceTruffleStackTraceLimit));
            result.put(PolyglotCompilerOptions.Inlining, (Object)TruffleCompilerOptions.identity(SharedTruffleCompilerOptions.TruffleFunctionInlining));
            result.put(PolyglotCompilerOptions.InliningRecursionDepth, (Object)TruffleCompilerOptions.identity(SharedTruffleCompilerOptions.TruffleMaximumRecursiveInlining));
            result.put(PolyglotCompilerOptions.LanguageAgnosticInlining, (Object)TruffleCompilerOptions.identity(SharedTruffleCompilerOptions.TruffleLanguageAgnosticInlining));
            result.put(PolyglotCompilerOptions.ExcludeAssertions, (Object)TruffleCompilerOptions.identity(TruffleExcludeAssertions));
            result.put(PolyglotCompilerOptions.NodeSourcePositions, (Object)TruffleCompilerOptions.identity(TruffleEnableInfopoints));
            result.put(PolyglotCompilerOptions.InstrumentBoundaries, (Object)TruffleCompilerOptions.identity(TruffleInstrumentBoundaries));
            result.put(PolyglotCompilerOptions.InstrumentBoundariesPerInlineSite, (Object)TruffleCompilerOptions.identity(TruffleInstrumentBoundariesPerInlineSite));
            result.put(PolyglotCompilerOptions.InstrumentBranches, (Object)TruffleCompilerOptions.identity(TruffleInstrumentBranches));
            result.put(PolyglotCompilerOptions.InstrumentBranchesPerInlineSite, (Object)TruffleCompilerOptions.identity(TruffleInstrumentBranchesPerInlineSite));
            result.put(PolyglotCompilerOptions.Compilation, (Object)TruffleCompilerOptions.identity(SharedTruffleCompilerOptions.TruffleCompilation));
            result.put(PolyglotCompilerOptions.CompileOnly, (Object)TruffleCompilerOptions.identity(SharedTruffleCompilerOptions.TruffleCompileOnly));
            result.put(PolyglotCompilerOptions.CompileImmediately, (Object)TruffleCompilerOptions.identity(SharedTruffleCompilerOptions.TruffleCompileImmediately));
            result.put(PolyglotCompilerOptions.BackgroundCompilation, (Object)TruffleCompilerOptions.identity(SharedTruffleCompilerOptions.TruffleBackgroundCompilation));
            result.put(PolyglotCompilerOptions.CompilerThreads, (Object)TruffleCompilerOptions.identity(SharedTruffleCompilerOptions.TruffleCompilerThreads));
            result.put(PolyglotCompilerOptions.CompilationThreshold, (Object)TruffleCompilerOptions.identity(SharedTruffleCompilerOptions.TruffleCompilationThreshold));
            result.put(PolyglotCompilerOptions.MinInvokeThreshold, (Object)TruffleCompilerOptions.identity(SharedTruffleCompilerOptions.TruffleMinInvokeThreshold));
            result.put(PolyglotCompilerOptions.InvalidationReprofileCount, (Object)TruffleCompilerOptions.identity(SharedTruffleCompilerOptions.TruffleInvalidationReprofileCount));
            result.put(PolyglotCompilerOptions.ReplaceReprofileCount, (Object)TruffleCompilerOptions.identity(SharedTruffleCompilerOptions.TruffleReplaceReprofileCount));
            result.put(PolyglotCompilerOptions.ArgumentTypeSpeculation, (Object)TruffleCompilerOptions.identity(SharedTruffleCompilerOptions.TruffleArgumentTypeSpeculation));
            result.put(PolyglotCompilerOptions.ReturnTypeSpeculation, (Object)TruffleCompilerOptions.identity(SharedTruffleCompilerOptions.TruffleReturnTypeSpeculation));
            result.put(PolyglotCompilerOptions.Profiling, (Object)TruffleCompilerOptions.identity(SharedTruffleCompilerOptions.TruffleProfilingEnabled));
            result.put(PolyglotCompilerOptions.MultiTier, (Object)TruffleCompilerOptions.identity(SharedTruffleCompilerOptions.TruffleMultiTier));
            result.put(PolyglotCompilerOptions.FirstTierCompilationThreshold, (Object)TruffleCompilerOptions.identity(SharedTruffleCompilerOptions.TruffleFirstTierCompilationThreshold));
            result.put(PolyglotCompilerOptions.FirstTierMinInvokeThreshold, (Object)TruffleCompilerOptions.identity(SharedTruffleCompilerOptions.TruffleFirstTierMinInvokeThreshold));
            result.put(PolyglotCompilerOptions.CompilationExceptionsArePrinted, (Object)TruffleCompilerOptions.identity(SharedTruffleCompilerOptions.TruffleCompilationExceptionsArePrinted));
            result.put(PolyglotCompilerOptions.CompilationExceptionsAreThrown, (Object)TruffleCompilerOptions.identity(SharedTruffleCompilerOptions.TruffleCompilationExceptionsAreThrown));
            result.put(PolyglotCompilerOptions.TraceCompilation, (Object)TruffleCompilerOptions.identity(SharedTruffleCompilerOptions.TraceTruffleCompilation));
            result.put(PolyglotCompilerOptions.TraceCompilationDetails, (Object)TruffleCompilerOptions.identity(SharedTruffleCompilerOptions.TraceTruffleCompilationDetails));
            result.put(PolyglotCompilerOptions.TraceCompilationPolymorphism, (Object)TruffleCompilerOptions.identity(SharedTruffleCompilerOptions.TraceTruffleCompilationPolymorphism));
            result.put(PolyglotCompilerOptions.TraceCompilationAST, (Object)TruffleCompilerOptions.identity(SharedTruffleCompilerOptions.TraceTruffleCompilationAST));
            result.put(PolyglotCompilerOptions.TraceCompilationCallTree, (Object)TruffleCompilerOptions.identity(SharedTruffleCompilerOptions.TraceTruffleCompilationCallTree));
            result.put(PolyglotCompilerOptions.TraceAssumptions, (Object)TruffleCompilerOptions.identity(SharedTruffleCompilerOptions.TraceTruffleAssumptions));
            result.put(PolyglotCompilerOptions.CompilationStatistics, (Object)TruffleCompilerOptions.identity(SharedTruffleCompilerOptions.TruffleCompilationStatistics));
            result.put(PolyglotCompilerOptions.CompilationStatisticDetails, (Object)TruffleCompilerOptions.identity(SharedTruffleCompilerOptions.TruffleCompilationStatisticDetails));
            result.put(PolyglotCompilerOptions.TraceTransferToInterpreter, (Object)TruffleCompilerOptions.identity(SharedTruffleCompilerOptions.TraceTruffleTransferToInterpreter));
            result.put(PolyglotCompilerOptions.TraceSplitting, (Object)TruffleCompilerOptions.identity(SharedTruffleCompilerOptions.TraceTruffleSplitting));
            result.put(PolyglotCompilerOptions.InliningNodeBudget, (Object)TruffleCompilerOptions.identity(SharedTruffleCompilerOptions.TruffleInliningMaxCallerSize));
            result.put(PolyglotCompilerOptions.Splitting, (Object)TruffleCompilerOptions.identity(SharedTruffleCompilerOptions.TruffleSplitting));
            result.put(PolyglotCompilerOptions.SplittingMaxCalleeSize, (Object)TruffleCompilerOptions.identity(SharedTruffleCompilerOptions.TruffleSplittingMaxCalleeSize));
            result.put(PolyglotCompilerOptions.SplittingGrowthLimit, (Object)TruffleCompilerOptions.identity(SharedTruffleCompilerOptions.TruffleSplittingGrowthLimit));
            result.put(PolyglotCompilerOptions.SplittingMaxNumberOfSplitNodes, (Object)TruffleCompilerOptions.identity(SharedTruffleCompilerOptions.TruffleSplittingMaxNumberOfSplitNodes));
            result.put(PolyglotCompilerOptions.SplittingMaxPropagationDepth, (Object)TruffleCompilerOptions.identity(SharedTruffleCompilerOptions.TruffleSplittingMaxPropagationDepth));
            result.put(PolyglotCompilerOptions.TraceSplittingSummary, (Object)TruffleCompilerOptions.identity(SharedTruffleCompilerOptions.TruffleTraceSplittingSummary));
            result.put(PolyglotCompilerOptions.SplittingTraceEvents, (Object)TruffleCompilerOptions.identity(SharedTruffleCompilerOptions.TruffleSplittingTraceEvents));
            result.put(PolyglotCompilerOptions.SplittingDumpDecisions, (Object)TruffleCompilerOptions.identity(SharedTruffleCompilerOptions.TruffleSplittingDumpDecisions));
            result.put(PolyglotCompilerOptions.SplittingAllowForcedSplits, (Object)TruffleCompilerOptions.identity(SharedTruffleCompilerOptions.TruffleSplittingAllowForcedSplits));
            result.put(PolyglotCompilerOptions.OSR, (Object)TruffleCompilerOptions.identity(SharedTruffleCompilerOptions.TruffleOSR));
            result.put(PolyglotCompilerOptions.OSRCompilationThreshold, (Object)TruffleCompilerOptions.identity(SharedTruffleCompilerOptions.TruffleOSRCompilationThreshold));
            return result;
        }
    }
}

