/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.compiler.truffle.compiler;

import java.io.Closeable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import jdk.vm.ci.meta.JavaConstant;
import jdk.vm.ci.meta.ResolvedJavaType;
import org.graalvm.collections.EconomicMap;
import org.graalvm.collections.Equivalence;
import org.graalvm.collections.MapCursor;
import org.graalvm.compiler.debug.DebugContext;
import org.graalvm.compiler.graph.Node;
import org.graalvm.compiler.nodes.StructuredGraph;
import org.graalvm.compiler.nodes.ValueNode;
import org.graalvm.compiler.nodes.java.InstanceOfNode;
import org.graalvm.compiler.nodes.java.MethodCallTargetNode;
import org.graalvm.compiler.nodes.util.GraphUtil;
import org.graalvm.compiler.truffle.common.CompilableTruffleAST;
import org.graalvm.compiler.truffle.common.TruffleCompilerRuntime;
import org.graalvm.compiler.truffle.common.TruffleInliningPlan;
import org.graalvm.compiler.truffle.compiler.TruffleCompilerOptions;
import org.graalvm.compiler.truffle.options.PolyglotCompilerOptions;
import org.graalvm.options.OptionValues;

public final class PerformanceInformationHandler
implements Closeable {
    private static final ThreadLocal<PerformanceInformationHandler> instance = new ThreadLocal();
    private final OptionValues options;
    private final Set<PolyglotCompilerOptions.PerformanceWarningKind> warningKinds = EnumSet.noneOf(PolyglotCompilerOptions.PerformanceWarningKind.class);

    private PerformanceInformationHandler(OptionValues options) {
        this.options = options;
    }

    private void addWarning(PolyglotCompilerOptions.PerformanceWarningKind warningKind) {
        this.warningKinds.add(warningKind);
    }

    private Set<PolyglotCompilerOptions.PerformanceWarningKind> getWarnings() {
        return this.warningKinds;
    }

    @Override
    public void close() {
        assert (instance.get() != null) : "No PerformanceInformationHandler installed";
        instance.remove();
    }

    static PerformanceInformationHandler install(OptionValues options) {
        assert (instance.get() == null) : "PerformanceInformationHandler already installed";
        PerformanceInformationHandler handler = new PerformanceInformationHandler(options);
        instance.set(handler);
        return handler;
    }

    public static boolean isWarningEnabled(PolyglotCompilerOptions.PerformanceWarningKind warningKind) {
        PerformanceInformationHandler handler = instance.get();
        return TruffleCompilerOptions.getPolyglotOptionValue(handler.options, PolyglotCompilerOptions.TracePerformanceWarnings).contains((Object)warningKind) || TruffleCompilerOptions.getPolyglotOptionValue(handler.options, PolyglotCompilerOptions.PerformanceWarningsAreFatal).contains((Object)warningKind) || TruffleCompilerOptions.getPolyglotOptionValue(handler.options, PolyglotCompilerOptions.TreatPerformanceWarningsAsErrors).contains((Object)warningKind);
    }

    public static void logPerformanceWarning(PolyglotCompilerOptions.PerformanceWarningKind warningKind, CompilableTruffleAST compilable, List<? extends Node> locations, String details, Map<String, Object> properties) {
        PerformanceInformationHandler handler = instance.get();
        handler.addWarning(warningKind);
        PerformanceInformationHandler.logPerformanceWarningImpl(compilable, "perf warn", details, properties, handler.getPerformanceStackTrace(locations));
    }

    private static void logInliningWarning(CompilableTruffleAST compilable, String details, Map<String, Object> properties) {
        PerformanceInformationHandler.logPerformanceWarningImpl(compilable, "inlining warn", details, properties, null);
    }

    private static void logPerformanceInfo(CompilableTruffleAST compilable, List<? extends Node> locations, String details, Map<String, Object> properties) {
        PerformanceInformationHandler.logPerformanceWarningImpl(compilable, "perf info", details, properties, instance.get().getPerformanceStackTrace(locations));
    }

    private static void logPerformanceWarningImpl(CompilableTruffleAST compilable, String event, String details, Map<String, Object> properties, String message) {
        TruffleCompilerRuntime runtime = TruffleCompilerRuntime.getRuntime();
        runtime.logEvent(compilable, 0, event, String.format("%-60s|%s", compilable.getName(), details), properties, message);
    }

    private String getPerformanceStackTrace(List<? extends Node> locations) {
        Object stackTrace;
        if (locations == null || locations.isEmpty()) {
            return null;
        }
        int limit = TruffleCompilerOptions.getPolyglotOptionValue(this.options, PolyglotCompilerOptions.TraceStackTraceLimit);
        if (limit <= 0) {
            return null;
        }
        EconomicMap groupedByStackTrace = EconomicMap.create((Equivalence)Equivalence.DEFAULT);
        for (Node node : locations) {
            String stackTraceAsString;
            stackTrace = GraphUtil.approxSourceStackTraceElement(node);
            StringBuilder sb = new StringBuilder();
            String indent = "    ";
            for (int i = 0; i < ((StackTraceElement[])stackTrace).length && i < limit; ++i) {
                if (i != 0) {
                    sb.append('\n');
                }
                sb.append(indent).append("at ").append(stackTrace[i]);
            }
            if (((StackTraceElement[])stackTrace).length > limit) {
                sb.append('\n').append(indent).append("...");
            }
            if (!groupedByStackTrace.containsKey((Object)(stackTraceAsString = sb.toString()))) {
                groupedByStackTrace.put((Object)stackTraceAsString, new ArrayList());
            }
            ((List)groupedByStackTrace.get((Object)stackTraceAsString)).add(node);
        }
        StringBuilder builder = new StringBuilder();
        MapCursor mapCursor = groupedByStackTrace.getEntries();
        while (mapCursor.advance()) {
            stackTrace = (String)mapCursor.getKey();
            List locationGroup = (List)mapCursor.getValue();
            if (builder.length() > 0) {
                builder.append(String.format("%n", new Object[0]));
            }
            if (((String)stackTrace).isEmpty()) {
                builder.append(String.format("  No stack trace available for %s.", locationGroup));
                continue;
            }
            builder.append(String.format("  Approximated stack trace for %s:", locationGroup));
            builder.append((String)stackTrace);
        }
        return builder.toString();
    }

    void reportPerformanceWarnings(CompilableTruffleAST target, StructuredGraph graph) {
        DebugContext debug = graph.getDebug();
        ArrayList<ValueNode> warnings = new ArrayList<ValueNode>();
        if (PerformanceInformationHandler.isWarningEnabled(PolyglotCompilerOptions.PerformanceWarningKind.VIRTUAL_RUNTIME_CALL)) {
            for (MethodCallTargetNode methodCallTargetNode : graph.getNodes(MethodCallTargetNode.TYPE)) {
                TruffleCompilerRuntime runtime;
                if (methodCallTargetNode.targetMethod().isNative() || !(runtime = TruffleCompilerRuntime.getRuntime()).getInlineKind(methodCallTargetNode.targetMethod(), true).allowsInlining()) continue;
                PerformanceInformationHandler.logPerformanceWarning(PolyglotCompilerOptions.PerformanceWarningKind.VIRTUAL_RUNTIME_CALL, target, Arrays.asList(methodCallTargetNode), String.format("Partial evaluation could not inline the virtual runtime call %s to %s (%s).", new Object[]{methodCallTargetNode.invokeKind(), methodCallTargetNode.targetMethod(), methodCallTargetNode}), null);
                warnings.add(methodCallTargetNode);
            }
        }
        if (PerformanceInformationHandler.isWarningEnabled(PolyglotCompilerOptions.PerformanceWarningKind.VIRTUAL_INSTANCEOF)) {
            EconomicMap groupedByType = EconomicMap.create((Equivalence)Equivalence.DEFAULT);
            for (InstanceOfNode instanceOf : graph.getNodes().filter(InstanceOfNode.class)) {
                ResolvedJavaType type;
                if (instanceOf.type().isExact() || !PerformanceInformationHandler.isSecondaryType(type = instanceOf.type().getType())) continue;
                warnings.add(instanceOf);
                if (!groupedByType.containsKey((Object)type)) {
                    groupedByType.put((Object)type, new ArrayList());
                }
                ((ArrayList)groupedByType.get((Object)type)).add(instanceOf);
            }
            MapCursor mapCursor = groupedByType.getEntries();
            while (mapCursor.advance()) {
                ResolvedJavaType type = (ResolvedJavaType)mapCursor.getKey();
                String reason = "Partial evaluation could not resolve virtual instanceof to an exact type due to: " + String.format(type.isInterface() ? "interface type check: %s" : "too deep in class hierarchy: %s", type);
                PerformanceInformationHandler.logPerformanceInfo(target, (List)mapCursor.getValue(), reason, Collections.singletonMap("Nodes", mapCursor.getValue()));
            }
        }
        if (debug.areScopesEnabled() && !warnings.isEmpty()) {
            try {
                Throwable throwable = null;
                try (DebugContext.Scope s = debug.scope((Object)"TrufflePerformanceWarnings", graph);){
                    debug.dump(1, (Object)graph, "performance warnings %s", warnings);
                }
                catch (Throwable throwable2) {
                    Throwable throwable3 = throwable2;
                    throw throwable2;
                }
            }
            catch (Throwable t) {
                debug.handle(t);
            }
        }
        if (!Collections.disjoint(this.getWarnings(), (Collection)TruffleCompilerOptions.getPolyglotOptionValue(this.options, PolyglotCompilerOptions.PerformanceWarningsAreFatal))) {
            throw new AssertionError((Object)"Performance warning detected and is fatal.");
        }
        if (!Collections.disjoint(this.getWarnings(), (Collection)TruffleCompilerOptions.getPolyglotOptionValue(this.options, PolyglotCompilerOptions.TreatPerformanceWarningsAsErrors))) {
            throw new AssertionError((Object)"Performance warning detected and is treated as a compilation error.");
        }
    }

    private static boolean isPrimarySupertype(ResolvedJavaType type) {
        if (type.isInterface()) {
            return false;
        }
        int depth = 0;
        for (ResolvedJavaType supr = type; supr != null; supr = supr.getSuperclass()) {
            ++depth;
        }
        return depth <= 8;
    }

    private static boolean isSecondaryType(ResolvedJavaType type) {
        return !PerformanceInformationHandler.isPrimarySupertype(type);
    }

    static void reportDecisionIsNull(CompilableTruffleAST compilable, JavaConstant callNode) {
        if (TruffleCompilerOptions.getPolyglotOptionValue(PerformanceInformationHandler.instance.get().options, PolyglotCompilerOptions.TraceInlining).booleanValue()) {
            LinkedHashMap<String, Object> properties = new LinkedHashMap<String, Object>();
            properties.put("callNode", callNode.toValueString());
            PerformanceInformationHandler.logInliningWarning(compilable, "A direct call within the Truffle AST is not reachable anymore. Call node could not be inlined.", properties);
        }
    }

    static void reportCallTargetChanged(CompilableTruffleAST compilable, JavaConstant callNode, TruffleInliningPlan.Decision decision) {
        if (TruffleCompilerOptions.getPolyglotOptionValue(PerformanceInformationHandler.instance.get().options, PolyglotCompilerOptions.TraceInlining).booleanValue()) {
            LinkedHashMap<String, Object> properties = new LinkedHashMap<String, Object>();
            properties.put("originalTarget", decision.getTargetName());
            properties.put("callNode", callNode.toValueString());
            PerformanceInformationHandler.logInliningWarning(compilable, "CallTarget changed during compilation. Call node could not be inlined.", properties);
        }
    }
}

