/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.compiler.truffle.compiler;

import java.net.URI;
import java.util.Objects;
import jdk.vm.ci.code.Architecture;
import jdk.vm.ci.meta.Assumptions;
import jdk.vm.ci.meta.JavaConstant;
import jdk.vm.ci.meta.MetaAccessProvider;
import jdk.vm.ci.meta.ResolvedJavaMethod;
import jdk.vm.ci.meta.ResolvedJavaType;
import jdk.vm.ci.meta.SpeculationLog;
import org.graalvm.collections.EconomicMap;
import org.graalvm.compiler.api.replacements.SnippetReflectionProvider;
import org.graalvm.compiler.core.common.CompilationIdentifier;
import org.graalvm.compiler.core.common.type.StampPair;
import org.graalvm.compiler.debug.DebugCloseable;
import org.graalvm.compiler.debug.DebugContext;
import org.graalvm.compiler.debug.TimerKey;
import org.graalvm.compiler.graph.SourceLanguagePosition;
import org.graalvm.compiler.graph.SourceLanguagePositionProvider;
import org.graalvm.compiler.nodes.Cancellable;
import org.graalvm.compiler.nodes.ConstantNode;
import org.graalvm.compiler.nodes.EncodedGraph;
import org.graalvm.compiler.nodes.StructuredGraph;
import org.graalvm.compiler.nodes.ValueNode;
import org.graalvm.compiler.nodes.calc.FloatingNode;
import org.graalvm.compiler.nodes.graphbuilderconf.GraphBuilderConfiguration;
import org.graalvm.compiler.nodes.graphbuilderconf.GraphBuilderContext;
import org.graalvm.compiler.nodes.graphbuilderconf.GraphBuilderTool;
import org.graalvm.compiler.nodes.graphbuilderconf.InlineInvokePlugin;
import org.graalvm.compiler.nodes.graphbuilderconf.InvocationPlugins;
import org.graalvm.compiler.nodes.graphbuilderconf.LoopExplosionPlugin;
import org.graalvm.compiler.nodes.graphbuilderconf.NodePlugin;
import org.graalvm.compiler.nodes.graphbuilderconf.ParameterPlugin;
import org.graalvm.compiler.nodes.java.MethodCallTargetNode;
import org.graalvm.compiler.nodes.virtual.VirtualInstanceNode;
import org.graalvm.compiler.nodes.virtual.VirtualObjectNode;
import org.graalvm.compiler.phases.OptimisticOptimizations;
import org.graalvm.compiler.phases.PhaseSuite;
import org.graalvm.compiler.phases.common.CanonicalizerPhase;
import org.graalvm.compiler.phases.common.inlining.InliningUtil;
import org.graalvm.compiler.phases.tiers.HighTierContext;
import org.graalvm.compiler.phases.util.Providers;
import org.graalvm.compiler.replacements.CachingPEGraphDecoder;
import org.graalvm.compiler.replacements.InlineDuringParsingPlugin;
import org.graalvm.compiler.replacements.PEGraphDecoder;
import org.graalvm.compiler.replacements.ReplacementsImpl;
import org.graalvm.compiler.serviceprovider.GraalServices;
import org.graalvm.compiler.serviceprovider.SpeculationReasonGroup;
import org.graalvm.compiler.truffle.common.CompilableTruffleAST;
import org.graalvm.compiler.truffle.common.TruffleCompilerRuntime;
import org.graalvm.compiler.truffle.common.TruffleInliningPlan;
import org.graalvm.compiler.truffle.common.TruffleSourceLanguagePosition;
import org.graalvm.compiler.truffle.compiler.PEInliningPlanInvokePlugin;
import org.graalvm.compiler.truffle.compiler.ParsingInlineInvokePlugin;
import org.graalvm.compiler.truffle.compiler.TruffleCompilerImpl;
import org.graalvm.compiler.truffle.compiler.TruffleCompilerOptions;
import org.graalvm.compiler.truffle.compiler.TruffleConstantFieldProvider;
import org.graalvm.compiler.truffle.compiler.debug.HistogramInlineInvokePlugin;
import org.graalvm.compiler.truffle.compiler.nodes.TruffleAssumption;
import org.graalvm.compiler.truffle.compiler.nodes.frame.AllowMaterializeNode;
import org.graalvm.compiler.truffle.compiler.phases.DeoptimizeOnExceptionPhase;
import org.graalvm.compiler.truffle.compiler.phases.InstrumentBranchesPhase;
import org.graalvm.compiler.truffle.compiler.phases.InstrumentPhase;
import org.graalvm.compiler.truffle.compiler.phases.InstrumentTruffleBoundariesPhase;
import org.graalvm.compiler.truffle.compiler.phases.inlining.AgnosticInliningPhase;
import org.graalvm.compiler.truffle.compiler.substitutions.KnownTruffleTypes;
import org.graalvm.compiler.truffle.compiler.substitutions.TruffleGraphBuilderPlugins;
import org.graalvm.compiler.truffle.compiler.substitutions.TruffleInvocationPluginProvider;
import org.graalvm.compiler.truffle.options.PolyglotCompilerOptions;
import org.graalvm.compiler.virtual.phases.ea.PartialEscapePhase;
import org.graalvm.options.OptionValues;

public abstract class PartialEvaluator {
    protected final Providers providers;
    protected final Architecture architecture;
    private final CanonicalizerPhase canonicalizer;
    private final SnippetReflectionProvider snippetReflection;
    final ResolvedJavaMethod callDirectMethod;
    protected final ResolvedJavaMethod callInlined;
    final ResolvedJavaMethod callIndirectMethod;
    private final ResolvedJavaMethod profiledPERoot;
    private final GraphBuilderConfiguration configPrototype;
    private final InvocationPlugins decodingInvocationPlugins;
    private final NodePlugin[] nodePlugins;
    final KnownTruffleTypes knownTruffleTypes;
    final ResolvedJavaMethod callBoundary;
    private volatile GraphBuilderConfiguration configForParsing;
    volatile InstrumentPhase.InstrumentationConfiguration instrumentationCfg;
    protected volatile InstrumentPhase.Instrumentation instrumentation;
    private static final TimerKey PartialEvaluationTimer = DebugContext.timer("PartialEvaluation").doc("Time spent in partial evaluation.");
    private static final SpeculationReasonGroup TRUFFLE_BOUNDARY_EXCEPTION_SPECULATIONS = new SpeculationReasonGroup("TruffleBoundaryWithoutException", ResolvedJavaMethod.class);

    public PartialEvaluator(Providers providers, GraphBuilderConfiguration configForRoot, SnippetReflectionProvider snippetReflection, Architecture architecture, KnownTruffleTypes knownFields) {
        this.providers = providers;
        this.architecture = architecture;
        this.canonicalizer = CanonicalizerPhase.create();
        this.snippetReflection = snippetReflection;
        this.knownTruffleTypes = knownFields;
        TruffleCompilerRuntime runtime = TruffleCompilerRuntime.getRuntime();
        MetaAccessProvider metaAccess = providers.getMetaAccess();
        ResolvedJavaType type = runtime.resolveType(metaAccess, "org.graalvm.compiler.truffle.runtime.OptimizedCallTarget");
        ResolvedJavaMethod[] methods = type.getDeclaredMethods();
        this.callDirectMethod = PartialEvaluator.findRequiredMethod(type, methods, "callDirect", "(Lcom/oracle/truffle/api/nodes/Node;[Ljava/lang/Object;)Ljava/lang/Object;");
        this.callInlined = PartialEvaluator.findRequiredMethod(type, methods, "callInlined", "(Lcom/oracle/truffle/api/nodes/Node;[Ljava/lang/Object;)Ljava/lang/Object;");
        this.callIndirectMethod = PartialEvaluator.findRequiredMethod(type, methods, "callIndirect", "(Lcom/oracle/truffle/api/nodes/Node;[Ljava/lang/Object;)Ljava/lang/Object;");
        this.profiledPERoot = PartialEvaluator.findRequiredMethod(type, methods, "profiledPERoot", "([Ljava/lang/Object;)Ljava/lang/Object;");
        this.callBoundary = PartialEvaluator.findRequiredMethod(type, methods, "callBoundary", "([Ljava/lang/Object;)Ljava/lang/Object;");
        this.configPrototype = this.createGraphBuilderConfig(configForRoot, true);
        this.decodingInvocationPlugins = this.createDecodingInvocationPlugins(configForRoot.getPlugins());
        this.nodePlugins = this.createNodePlugins(configForRoot.getPlugins());
    }

    protected void initialize(OptionValues options) {
        this.instrumentationCfg = new InstrumentPhase.InstrumentationConfiguration(options);
        boolean needSourcePositions = TruffleCompilerOptions.getPolyglotOptionValue(options, PolyglotCompilerOptions.NodeSourcePositions) != false || this.instrumentationCfg.instrumentBranches || this.instrumentationCfg.instrumentBoundaries || !TruffleCompilerOptions.getPolyglotOptionValue(options, PolyglotCompilerOptions.TracePerformanceWarnings).isEmpty();
        this.configForParsing = this.configPrototype.withNodeSourcePosition(this.configPrototype.trackNodeSourcePosition() || needSourcePositions).withOmitAssertions(TruffleCompilerOptions.getPolyglotOptionValue(options, PolyglotCompilerOptions.ExcludeAssertions));
    }

    public EconomicMap<ResolvedJavaMethod, EncodedGraph> getOrCreateEncodedGraphCache() {
        return EconomicMap.create();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private InstrumentPhase.Instrumentation getInstrumentation() {
        if (this.instrumentation == null) {
            PartialEvaluator partialEvaluator = this;
            synchronized (partialEvaluator) {
                if (this.instrumentation == null) {
                    if (this.instrumentationCfg == null) {
                        throw new IllegalStateException("PartialEvaluator is not yet initialized");
                    }
                    long[] accessTable = new long[this.instrumentationCfg.instrumentationTableSize];
                    this.instrumentation = new InstrumentPhase.Instrumentation(accessTable);
                }
            }
        }
        return this.instrumentation;
    }

    static ResolvedJavaMethod findRequiredMethod(ResolvedJavaType declaringClass, ResolvedJavaMethod[] methods, String name, String descriptor) {
        for (ResolvedJavaMethod method : methods) {
            if (!method.getName().equals(name) || !method.getSignature().toMethodDescriptor().equals(descriptor)) continue;
            return method;
        }
        throw new NoSuchMethodError(declaringClass.toJavaName() + "." + name + descriptor);
    }

    public static InlineInvokePlugin.InlineInfo asInlineInfo(ResolvedJavaMethod method) {
        TruffleCompilerRuntime.InlineKind inlineKind = TruffleCompilerRuntime.getRuntime().getInlineKind(method, true);
        switch (inlineKind) {
            case DO_NOT_INLINE_DEOPTIMIZE_ON_EXCEPTION: {
                return InlineInvokePlugin.InlineInfo.DO_NOT_INLINE_DEOPTIMIZE_ON_EXCEPTION;
            }
            case DO_NOT_INLINE_NO_EXCEPTION: {
                return InlineInvokePlugin.InlineInfo.DO_NOT_INLINE_NO_EXCEPTION;
            }
            case DO_NOT_INLINE_WITH_EXCEPTION: 
            case DO_NOT_INLINE_WITH_SPECULATIVE_EXCEPTION: {
                return InlineInvokePlugin.InlineInfo.DO_NOT_INLINE_WITH_EXCEPTION;
            }
            case INLINE: {
                return InlineInvokePlugin.InlineInfo.createStandardInlineInfo(method);
            }
        }
        throw new IllegalArgumentException(String.valueOf((Object)inlineKind));
    }

    public Providers getProviders() {
        return this.providers;
    }

    public GraphBuilderConfiguration getConfigPrototype() {
        return this.configPrototype;
    }

    public GraphBuilderConfiguration getConfig() {
        if (this.configForParsing == null) {
            throw new IllegalStateException("PartialEvaluator is not yet initialized");
        }
        return this.configForParsing;
    }

    public KnownTruffleTypes getKnownTruffleTypes() {
        return this.knownTruffleTypes;
    }

    public ResolvedJavaMethod[] getCompilationRootMethods() {
        return new ResolvedJavaMethod[]{this.profiledPERoot, this.callInlined, this.callDirectMethod};
    }

    public ResolvedJavaMethod[] getNeverInlineMethods() {
        return new ResolvedJavaMethod[]{this.callDirectMethod, this.callIndirectMethod};
    }

    public ResolvedJavaMethod getCallDirect() {
        return this.callDirectMethod;
    }

    public ResolvedJavaMethod getCallInlined() {
        return this.callInlined;
    }

    /*
     * Exception decompiling
     */
    public StructuredGraph evaluate(Request request) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private static void handleInliningAcrossTruffleBoundary(Request request, TruffleCompilerRuntime rt) {
        if (!TruffleCompilerOptions.getPolyglotOptionValue(request.options, PolyglotCompilerOptions.InlineAcrossTruffleBoundary).booleanValue()) {
            for (MethodCallTargetNode mct : request.graph.getNodes(MethodCallTargetNode.TYPE)) {
                TruffleCompilerRuntime.InlineKind inlineKind = rt.getInlineKind(mct.targetMethod(), false);
                if (inlineKind.allowsInlining()) continue;
                mct.invoke().setUseForInlining(false);
            }
        }
    }

    private static void setIdentityForValueTypes(Request request, TruffleCompilerRuntime rt) {
        for (VirtualObjectNode virtualObjectNode : request.graph.getNodes(VirtualObjectNode.TYPE)) {
            VirtualInstanceNode virtualInstanceNode;
            ResolvedJavaType type;
            if (!(virtualObjectNode instanceof VirtualInstanceNode) || !rt.isValueType(type = (virtualInstanceNode = (VirtualInstanceNode)virtualObjectNode).type())) continue;
            virtualInstanceNode.setIdentity(false);
        }
    }

    private static void materializeFrames(StructuredGraph graph) {
        for (AllowMaterializeNode materializeNode : graph.getNodes(AllowMaterializeNode.TYPE).snapshot()) {
            materializeNode.replaceAtUsages(materializeNode.getFrame());
            graph.removeFixed(materializeNode);
        }
    }

    private void partialEscape(Request request) {
        try (DebugContext.Scope pe = request.debug.scope((Object)"TrufflePartialEscape", request.graph);){
            new PartialEscapePhase(TruffleCompilerOptions.getPolyglotOptionValue(request.options, PolyglotCompilerOptions.IterativePartialEscape), this.canonicalizer, request.graph.getOptions()).apply(request.graph, request.highTierContext);
        }
        catch (Throwable t) {
            request.debug.handle(t);
        }
    }

    private void inlineReplacements(Request request) {
        for (MethodCallTargetNode methodCallTargetNode : request.graph.getNodes(MethodCallTargetNode.TYPE)) {
            StructuredGraph inlineGraph;
            if (!methodCallTargetNode.invoke().useForInlining() || (inlineGraph = this.providers.getReplacements().getSubstitution(methodCallTargetNode.targetMethod(), methodCallTargetNode.invoke().bci(), request.graph.trackNodeSourcePosition(), methodCallTargetNode.asNode().getNodeSourcePosition(), request.graph.allowAssumptions(), request.debug.getOptions())) == null) continue;
            InliningUtil.inline(methodCallTargetNode.invoke(), inlineGraph, true, methodCallTargetNode.targetMethod());
        }
    }

    protected StructuredGraph.Builder customizeStructuredGraphBuilder(StructuredGraph.Builder builder) {
        return builder;
    }

    public ResolvedJavaMethod rootForCallTarget(CompilableTruffleAST compilable) {
        return this.profiledPERoot;
    }

    public ResolvedJavaMethod inlineRootForCallTarget(CompilableTruffleAST compilable) {
        return this.callInlined;
    }

    protected PEGraphDecoder createGraphDecoder(Request request, LoopExplosionPlugin loopExplosionPlugin, InvocationPlugins invocationPlugins, InlineInvokePlugin[] inlineInvokePlugins, ParameterPlugin parameterPlugin, NodePlugin[] nodePluginList, SourceLanguagePositionProvider sourceLanguagePositionProvider, EconomicMap<ResolvedJavaMethod, EncodedGraph> graphCache) {
        GraphBuilderConfiguration newConfig = this.configForParsing.copy();
        InvocationPlugins parsingInvocationPlugins = newConfig.getPlugins().getInvocationPlugins();
        GraphBuilderConfiguration.Plugins plugins = newConfig.getPlugins();
        ReplacementsImpl replacements = (ReplacementsImpl)this.providers.getReplacements();
        plugins.clearInlineInvokePlugins();
        plugins.appendInlineInvokePlugin(replacements);
        plugins.appendInlineInvokePlugin(new ParsingInlineInvokePlugin(this, replacements, parsingInvocationPlugins, loopExplosionPlugin));
        if (!TruffleCompilerOptions.getPolyglotOptionValue(request.options, PolyglotCompilerOptions.PrintExpansionHistogram).booleanValue()) {
            plugins.appendInlineInvokePlugin(new InlineDuringParsingPlugin());
        }
        DeoptimizeOnExceptionPhase postParsingPhase = new DeoptimizeOnExceptionPhase(method -> TruffleCompilerRuntime.getRuntime().getInlineKind((ResolvedJavaMethod)method, true) == TruffleCompilerRuntime.InlineKind.DO_NOT_INLINE_WITH_SPECULATIVE_EXCEPTION);
        Providers compilationUnitProviders = this.providers.copyWith(new TruffleConstantFieldProvider(this.providers.getConstantFieldProvider(), this.providers.getMetaAccess()));
        return new CachingPEGraphDecoder(this.architecture, request.graph, compilationUnitProviders, newConfig, TruffleCompilerImpl.Optimizations, StructuredGraph.AllowAssumptions.ifNonNull(request.graph.getAssumptions()), loopExplosionPlugin, this.decodingInvocationPlugins, inlineInvokePlugins, parameterPlugin, nodePluginList, this.callInlined, sourceLanguagePositionProvider, postParsingPhase, graphCache);
    }

    public void doGraphPE(Request request, InlineInvokePlugin inlineInvokePlugin, EconomicMap<ResolvedJavaMethod, EncodedGraph> graphCache) {
        InlineInvokePlugin[] inlineInvokePlugins;
        PELoopExplosionPlugin loopExplosionPlugin = new PELoopExplosionPlugin();
        InterceptReceiverPlugin parameterPlugin = new InterceptReceiverPlugin(request.compilable);
        ReplacementsImpl replacements = (ReplacementsImpl)this.providers.getReplacements();
        HistogramInlineInvokePlugin histogramPlugin = null;
        NodeLimitControlPlugin nodeLimitControlPlugin = new NodeLimitControlPlugin((Integer)request.options.get(PolyglotCompilerOptions.MaximumGraalNodeCount));
        Boolean printTruffleExpansionHistogram = TruffleCompilerOptions.getPolyglotOptionValue(request.options, PolyglotCompilerOptions.PrintExpansionHistogram);
        if (printTruffleExpansionHistogram.booleanValue()) {
            histogramPlugin = new HistogramInlineInvokePlugin(request.graph);
            inlineInvokePlugins = new InlineInvokePlugin[]{replacements, nodeLimitControlPlugin, inlineInvokePlugin, histogramPlugin};
        } else {
            inlineInvokePlugins = new InlineInvokePlugin[]{replacements, nodeLimitControlPlugin, inlineInvokePlugin};
        }
        TruffleSourceLanguagePositionProvider sourceLanguagePosition = new TruffleSourceLanguagePositionProvider(request.inliningPlan);
        PEGraphDecoder decoder = this.createGraphDecoder(request, loopExplosionPlugin, this.decodingInvocationPlugins, inlineInvokePlugins, parameterPlugin, this.nodePlugins, sourceLanguagePosition, graphCache);
        decoder.decode(request.graph.method(), request.graph.isSubstitution(), request.graph.trackNodeSourcePosition());
        if (printTruffleExpansionHistogram.booleanValue()) {
            histogramPlugin.print(request.compilable);
        }
    }

    protected GraphBuilderConfiguration createGraphBuilderConfig(GraphBuilderConfiguration config, boolean canDelayIntrinsification) {
        GraphBuilderConfiguration newConfig = config.copy();
        InvocationPlugins invocationPlugins = newConfig.getPlugins().getInvocationPlugins();
        this.registerTruffleInvocationPlugins(invocationPlugins, canDelayIntrinsification);
        return newConfig;
    }

    protected NodePlugin[] createNodePlugins(GraphBuilderConfiguration.Plugins plugins) {
        return plugins.getNodePlugins();
    }

    protected void registerTruffleInvocationPlugins(InvocationPlugins invocationPlugins, boolean canDelayIntrinsification) {
        TruffleGraphBuilderPlugins.registerInvocationPlugins(invocationPlugins, canDelayIntrinsification, this.providers, this.knownTruffleTypes);
        for (TruffleInvocationPluginProvider p : GraalServices.load(TruffleInvocationPluginProvider.class)) {
            p.registerInvocationPlugins(this.providers, this.architecture, invocationPlugins, canDelayIntrinsification);
        }
    }

    protected InvocationPlugins createDecodingInvocationPlugins(GraphBuilderConfiguration.Plugins parent) {
        InvocationPlugins decodingInvocationPlugins = new InvocationPlugins(parent.getInvocationPlugins());
        this.registerTruffleInvocationPlugins(decodingInvocationPlugins, false);
        decodingInvocationPlugins.closeRegistration();
        return decodingInvocationPlugins;
    }

    private void inliningGraphPE(Request request) {
        try (DebugCloseable a = PartialEvaluationTimer.start(request.debug);){
            if (TruffleCompilerOptions.getPolyglotOptionValue(request.options, PolyglotCompilerOptions.LanguageAgnosticInlining).booleanValue()) {
                AgnosticInliningPhase agnosticInlining = new AgnosticInliningPhase(this, request);
                agnosticInlining.apply(request.graph, this.providers);
            } else {
                PEInliningPlanInvokePlugin plugin = new PEInliningPlanInvokePlugin(this, request.options, request.compilable, request.inliningPlan, request.graph);
                this.doGraphPE(request, plugin, this.getOrCreateEncodedGraphCache());
            }
        }
        request.debug.dump(1, request.graph, "After Partial Evaluation");
        request.graph.maybeCompress();
    }

    protected void applyInstrumentationPhases(Request request) {
        InstrumentPhase.InstrumentationConfiguration cfg = this.instrumentationCfg;
        if (cfg.instrumentBranches) {
            new InstrumentBranchesPhase(request.options, this.snippetReflection, this.getInstrumentation(), cfg.instrumentBranchesPerInlineSite).apply(request.graph, request.highTierContext);
        }
        if (cfg.instrumentBoundaries) {
            new InstrumentTruffleBoundariesPhase(request.options, this.snippetReflection, this.getInstrumentation(), cfg.instrumentBoundariesPerInlineSite).apply(request.graph, request.highTierContext);
        }
    }

    public static SpeculationLog.SpeculationReason createTruffleBoundaryExceptionSpeculation(ResolvedJavaMethod targetMethod) {
        return TRUFFLE_BOUNDARY_EXCEPTION_SPECULATIONS.createSpeculationReason(targetMethod);
    }

    private static final class NodeLimitControlPlugin
    implements InlineInvokePlugin {
        private final int nodeLimit;

        NodeLimitControlPlugin(int nodeLimit) {
            this.nodeLimit = nodeLimit;
        }

        @Override
        public InlineInvokePlugin.InlineInfo shouldInlineInvoke(GraphBuilderContext b, ResolvedJavaMethod method, ValueNode[] args) {
            StructuredGraph graph = b.getGraph();
            if (graph.getNodeCount() > this.nodeLimit) {
                throw b.bailout("Graph too big to safely compile. Node count: " + graph.getNodeCount() + ". Limit: " + this.nodeLimit);
            }
            return null;
        }
    }

    private static final class SourceLanguagePositionImpl
    implements SourceLanguagePosition {
        private final TruffleSourceLanguagePosition delegate;

        SourceLanguagePositionImpl(TruffleSourceLanguagePosition delegate) {
            this.delegate = delegate;
        }

        @Override
        public String toShortString() {
            return this.delegate.getDescription();
        }

        @Override
        public int getOffsetEnd() {
            return this.delegate.getOffsetEnd();
        }

        @Override
        public int getOffsetStart() {
            return this.delegate.getOffsetStart();
        }

        @Override
        public int getLineNumber() {
            return this.delegate.getLineNumber();
        }

        @Override
        public URI getURI() {
            return this.delegate.getURI();
        }

        @Override
        public String getLanguage() {
            return this.delegate.getLanguage();
        }
    }

    private class PELoopExplosionPlugin
    implements LoopExplosionPlugin {
        private PELoopExplosionPlugin() {
        }

        @Override
        public LoopExplosionPlugin.LoopExplosionKind loopExplosionKind(ResolvedJavaMethod method) {
            TruffleCompilerRuntime rt = TruffleCompilerRuntime.getRuntime();
            TruffleCompilerRuntime.LoopExplosionKind explosionKind = rt.getLoopExplosionKind(method);
            switch (explosionKind) {
                case NONE: {
                    return LoopExplosionPlugin.LoopExplosionKind.NONE;
                }
                case FULL_EXPLODE: {
                    return LoopExplosionPlugin.LoopExplosionKind.FULL_EXPLODE;
                }
                case FULL_EXPLODE_UNTIL_RETURN: {
                    return LoopExplosionPlugin.LoopExplosionKind.FULL_EXPLODE_UNTIL_RETURN;
                }
                case FULL_UNROLL: {
                    return LoopExplosionPlugin.LoopExplosionKind.FULL_UNROLL;
                }
                case MERGE_EXPLODE: {
                    return LoopExplosionPlugin.LoopExplosionKind.MERGE_EXPLODE;
                }
                case FULL_UNROLL_UNTIL_RETURN: {
                    return LoopExplosionPlugin.LoopExplosionKind.FULL_UNROLL_UNTIL_RETURN;
                }
            }
            throw new IllegalStateException("Unsupported TruffleCompilerRuntime.LoopExplosionKind: " + String.valueOf((Object)explosionKind));
        }
    }

    private static final class TruffleSourceLanguagePositionProvider
    implements SourceLanguagePositionProvider {
        private TruffleInliningPlan inliningPlan;

        private TruffleSourceLanguagePositionProvider(TruffleInliningPlan inliningPlan) {
            this.inliningPlan = inliningPlan;
        }

        @Override
        public SourceLanguagePosition getPosition(JavaConstant node) {
            TruffleSourceLanguagePosition position = this.inliningPlan.getPosition(node);
            return position == null ? null : new SourceLanguagePositionImpl(position);
        }
    }

    private class InterceptReceiverPlugin
    implements ParameterPlugin {
        private final CompilableTruffleAST compilable;

        InterceptReceiverPlugin(CompilableTruffleAST compilable) {
            this.compilable = compilable;
        }

        @Override
        public FloatingNode interceptParameter(GraphBuilderTool b, int index, StampPair stamp) {
            if (index == 0) {
                JavaConstant c = this.compilable.asJavaConstant();
                return ConstantNode.forConstant(c, PartialEvaluator.this.providers.getMetaAccess());
            }
            return null;
        }
    }

    public final class Request {
        public final OptionValues options;
        public final DebugContext debug;
        public final CompilableTruffleAST compilable;
        public final TruffleInliningPlan inliningPlan;
        public final CompilationIdentifier compilationId;
        public final SpeculationLog log;
        public final Cancellable cancellable;
        public final StructuredGraph graph;
        final HighTierContext highTierContext;

        public Request(OptionValues options, DebugContext debug, CompilableTruffleAST compilable, ResolvedJavaMethod method, TruffleInliningPlan inliningPlan, CompilationIdentifier compilationId, SpeculationLog log, Cancellable cancellable) {
            Objects.requireNonNull(options);
            Objects.requireNonNull(debug);
            Objects.requireNonNull(compilable);
            Objects.requireNonNull(inliningPlan);
            Objects.requireNonNull(compilationId);
            this.options = options;
            this.debug = debug;
            this.compilable = compilable;
            this.inliningPlan = inliningPlan;
            this.compilationId = compilationId;
            this.log = log;
            this.cancellable = cancellable;
            StructuredGraph.Builder builder = new StructuredGraph.Builder(TruffleCompilerOptions.getOptions(), this.debug, StructuredGraph.AllowAssumptions.YES).name(this.compilable.toString()).method(method).speculationLog(this.log).compilationId(this.compilationId).trackNodeSourcePosition(PartialEvaluator.this.configForParsing.trackNodeSourcePosition()).cancellable(this.cancellable);
            builder = PartialEvaluator.this.customizeStructuredGraphBuilder(builder);
            this.graph = builder.build();
            this.graph.getAssumptions().record((Assumptions.Assumption)new TruffleAssumption(compilable.getNodeRewritingAssumptionConstant()));
            this.highTierContext = new HighTierContext(PartialEvaluator.this.providers, new PhaseSuite<HighTierContext>(), OptimisticOptimizations.NONE);
        }
    }
}

