/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.compiler.truffle.compiler;

import java.util.ArrayDeque;
import java.util.Deque;
import java.util.HashMap;
import jdk.vm.ci.meta.Assumptions;
import jdk.vm.ci.meta.JavaConstant;
import jdk.vm.ci.meta.ResolvedJavaMethod;
import org.graalvm.compiler.debug.GraalError;
import org.graalvm.compiler.nodes.StructuredGraph;
import org.graalvm.compiler.nodes.ValueNode;
import org.graalvm.compiler.nodes.graphbuilderconf.GraphBuilderContext;
import org.graalvm.compiler.nodes.graphbuilderconf.InlineInvokePlugin;
import org.graalvm.compiler.truffle.common.CompilableTruffleAST;
import org.graalvm.compiler.truffle.common.TruffleCompilerRuntime;
import org.graalvm.compiler.truffle.common.TruffleInliningPlan;
import org.graalvm.compiler.truffle.compiler.PartialEvaluator;
import org.graalvm.compiler.truffle.compiler.PerformanceInformationHandler;
import org.graalvm.compiler.truffle.compiler.TruffleCompilerOptions;
import org.graalvm.compiler.truffle.compiler.nodes.TruffleAssumption;
import org.graalvm.compiler.truffle.options.PolyglotCompilerOptions;
import org.graalvm.options.OptionValues;

final class PEInliningPlanInvokePlugin
implements InlineInvokePlugin {
    private final PartialEvaluator partialEvaluator;
    private final Deque<TruffleInliningPlan> inlining;
    private final StructuredGraph graph;
    private final int inliningNodeLimit;
    private final OptionValues options;
    private final CompilableTruffleAST compilable;
    private boolean graphTooBigReported;

    PEInliningPlanInvokePlugin(PartialEvaluator partialEvaluator, OptionValues options, CompilableTruffleAST compilable, TruffleInliningPlan inlining, StructuredGraph graph) {
        this.partialEvaluator = partialEvaluator;
        this.options = options;
        this.compilable = compilable;
        this.inlining = new ArrayDeque<TruffleInliningPlan>();
        this.inlining.push(inlining);
        this.graph = graph;
        this.inliningNodeLimit = TruffleCompilerOptions.getPolyglotOptionValue(options, PolyglotCompilerOptions.MaximumInlineNodeCount);
    }

    @Override
    public InlineInvokePlugin.InlineInfo shouldInlineInvoke(GraphBuilderContext builder, ResolvedJavaMethod original, ValueNode[] arguments) {
        InlineInvokePlugin.InlineInfo inlineInfo = PartialEvaluator.asInlineInfo(original);
        if (!inlineInfo.allowsInlining()) {
            return inlineInfo;
        }
        assert (!builder.parsingIntrinsic());
        if (original.equals(this.partialEvaluator.callDirectMethod)) {
            ValueNode arg0 = arguments[1];
            if (!arg0.isConstant()) {
                GraalError.shouldNotReachHere("The direct call node does not resolve to a constant!");
            }
            if (this.graph.getNodeCount() > this.inliningNodeLimit) {
                this.logGraphTooBig();
                return inlineInfo;
            }
            TruffleInliningPlan.Decision decision = PEInliningPlanInvokePlugin.getDecision(this.inlining.peek(), (JavaConstant)arg0.asConstant());
            if (decision != null && decision.shouldInline()) {
                this.inlining.push(decision);
                JavaConstant assumption = decision.getNodeRewritingAssumption();
                builder.getAssumptions().record((Assumptions.Assumption)new TruffleAssumption(assumption));
                return InlineInvokePlugin.InlineInfo.createStandardInlineInfo(this.partialEvaluator.callInlined);
            }
        }
        return inlineInfo;
    }

    static TruffleInliningPlan.Decision getDecision(TruffleInliningPlan inlining, JavaConstant callNode) {
        TruffleInliningPlan.Decision decision = inlining.findDecision(callNode);
        if (decision == null) {
            TruffleCompilerRuntime rt = TruffleCompilerRuntime.getRuntime();
            JavaConstant target = rt.getCallTargetForCallNode(callNode);
            PerformanceInformationHandler.reportDecisionIsNull(rt.asCompilableTruffleAST(target), callNode);
        } else if (!decision.isTargetStable()) {
            TruffleCompilerRuntime rt = TruffleCompilerRuntime.getRuntime();
            JavaConstant target = rt.getCallTargetForCallNode(callNode);
            PerformanceInformationHandler.reportCallTargetChanged(rt.asCompilableTruffleAST(target), callNode, decision);
            return null;
        }
        return decision;
    }

    private void logGraphTooBig() {
        if (!this.graphTooBigReported && TruffleCompilerOptions.getPolyglotOptionValue(this.options, PolyglotCompilerOptions.TraceInlining).booleanValue()) {
            this.graphTooBigReported = true;
            HashMap<String, Object> properties = new HashMap<String, Object>();
            properties.put("graph node count", this.graph.getNodeCount());
            properties.put("graph node limit", this.inliningNodeLimit);
            TruffleCompilerRuntime.getRuntime().logEvent(this.compilable, 0, "Truffle inlining caused graal node count to be too big during partial evaluation.", properties);
        }
    }

    @Override
    public void notifyAfterInline(ResolvedJavaMethod inlinedTargetMethod) {
        if (inlinedTargetMethod.equals(this.partialEvaluator.callInlined)) {
            this.inlining.pop();
        }
    }
}

