/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.compiler.truffle.common.hotspot.libgraal;

import java.lang.annotation.ElementType;
import java.lang.annotation.Repeatable;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.util.function.Consumer;
import java.util.function.Supplier;
import org.graalvm.compiler.truffle.common.hotspot.libgraal.TruffleFromLibGraalRepeated;
import org.graalvm.libgraal.jni.annotation.FromLibGraalId;

@Repeatable(value=TruffleFromLibGraalRepeated.class)
@Retention(value=RetentionPolicy.RUNTIME)
@Target(value={ElementType.METHOD})
public @interface TruffleFromLibGraal {
    public Id value();

    public static enum Id implements FromLibGraalId
    {
        AddTargetToDequeue(Void.TYPE, Object.class, Object.class),
        AsCompilableTruffleAST(Object.class, Object.class, Long.TYPE),
        AsJavaConstant(Long.TYPE, Object.class),
        CallNodeHashCode(Integer.TYPE, Object.class),
        CancelCompilation(Boolean.TYPE, Object.class, String.class),
        CompilableToString(String.class, Object.class),
        ConsumeOptimizedAssumptionDependency(Void.TYPE, Consumer.class, Object.class),
        CreateInliningPlan(Object.class, Object.class, Object.class, Object.class),
        CreateStringSupplier(Supplier.class, Long.TYPE),
        DequeueTargets(Void.TYPE, Object.class),
        FindCallNode(Object.class, Object.class, Long.TYPE),
        FindDecision(Object.class, Object.class, Long.TYPE),
        GetCallCount(Integer.TYPE, Object.class),
        GetCallNodes(Object[].class, Object.class),
        GetCallTargetForCallNode(Long.TYPE, Object.class, Long.TYPE),
        GetCompilableCallCount(Integer.TYPE, Object.class),
        GetCompilableName(String.class, Object.class),
        GetConstantFieldInfo(Integer.TYPE, Object.class, Long.TYPE, Boolean.TYPE, Integer.TYPE),
        GetCurrentCallTarget(Object.class, Object.class),
        GetDescription(String.class, Object.class),
        GetFailedSpeculationsAddress(Long.TYPE, Object.class),
        GetFrameSlotKindTagForJavaKind(Integer.TYPE, Object.class, Integer.TYPE),
        GetFrameSlotKindTagsCount(Integer.TYPE, Object.class),
        GetInlineKind(Integer.TYPE, Object.class, Long.TYPE, Boolean.TYPE),
        GetJavaKindForFrameSlotKind(Integer.TYPE, Object.class, Integer.TYPE),
        GetKnownCallSiteCount(Integer.TYPE, Object.class),
        GetLanguage(String.class, Object.class),
        GetLineNumber(Integer.TYPE, Object.class),
        GetLoopExplosionKind(Integer.TYPE, Object.class, Long.TYPE),
        GetNodeRewritingAssumption(Long.TYPE, Object.class),
        GetNodeRewritingAssumptionConstant(Long.TYPE, Object.class),
        GetNonTrivialNodeCount(Integer.TYPE, Object.class),
        GetOffsetEnd(Integer.TYPE, Object.class),
        GetOffsetStart(Integer.TYPE, Object.class),
        GetPosition(Object.class, Object.class, Long.TYPE),
        GetSuppliedString(String.class, Supplier.class),
        GetTargetName(String.class, Object.class),
        GetTruffleCallBoundaryMethods(long[].class, Object.class),
        GetURI(String.class, Object.class),
        IsCancelled(Boolean.TYPE, Object.class),
        IsInliningForced(Boolean.TYPE, Object.class),
        IsLastTier(Boolean.TYPE, Object.class),
        IsSameOrSplit(Boolean.TYPE, Object.class, Object.class),
        IsTargetStable(Boolean.TYPE, Object.class),
        IsTruffleBoundary(Boolean.TYPE, Object.class, Long.TYPE),
        IsValueType(Boolean.TYPE, Object.class, Long.TYPE),
        Log(Void.TYPE, Object.class, Object.class, String.class),
        OnCodeInstallation(Void.TYPE, Object.class, Object.class, Long.TYPE),
        OnCompilationFailed(Void.TYPE, Object.class, Supplier.class, Boolean.TYPE, Boolean.TYPE),
        OnFailure(Void.TYPE, Object.class, Object.class, String.class, Boolean.TYPE, Boolean.TYPE),
        OnGraalTierFinished(Void.TYPE, Object.class, Object.class, Long.TYPE),
        OnSuccess(Void.TYPE, Object.class, Object.class, Object.class, Long.TYPE, Long.TYPE),
        OnTruffleTierFinished(Void.TYPE, Object.class, Object.class, Object.class, Long.TYPE),
        RegisterOptimizedAssumptionDependency(Consumer.class, Object.class, Long.TYPE),
        ShouldInline(Boolean.TYPE, Object.class);

        private final String signature;
        private final String methodName;
        private final Class<?> returnType;
        private final Class<?>[] parameterTypes;

        @Override
        public String getName() {
            return this.name();
        }

        @Override
        public String getSignature() {
            return this.signature;
        }

        @Override
        public String getMethodName() {
            return this.methodName;
        }

        @Override
        public Class<?>[] getParameterTypes() {
            return this.parameterTypes;
        }

        @Override
        public Class<?> getReturnType() {
            return this.returnType;
        }

        public String toString() {
            return this.methodName + this.signature;
        }

        private Id(Class<?> returnType, Class<?> ... parameterTypes) {
            this.returnType = returnType;
            this.parameterTypes = parameterTypes;
            this.signature = FromLibGraalId.encodeMethodSignature(returnType, parameterTypes);
            this.methodName = Character.toLowerCase(this.name().charAt(0)) + this.name().substring(1);
        }
    }
}

