/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.compiler.truffle.common;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.function.Supplier;
import jdk.vm.ci.meta.JavaConstant;
import jdk.vm.ci.meta.SpeculationLog;
import org.graalvm.compiler.truffle.common.TruffleCallNode;

public interface CompilableTruffleAST {
    public JavaConstant asJavaConstant();

    public SpeculationLog getCompilationSpeculationLog();

    public void onCompilationFailed(Supplier<String> var1, boolean var2, boolean var3);

    public String getName();

    default public void invalidateCode() {
    }

    public int getNonTrivialNodeCount();

    public TruffleCallNode[] getCallNodes();

    public int getCallCount();

    public boolean cancelCompilation(CharSequence var1);

    public boolean isSameOrSplit(CompilableTruffleAST var1);

    public int getKnownCallSiteCount();

    public JavaConstant getNodeRewritingAssumptionConstant();

    public static String serializeException(Throwable e) {
        StringWriter sw = new StringWriter();
        PrintWriter pw = new PrintWriter(sw);
        for (Class<?> c = e.getClass(); c != Throwable.class; c = c.getSuperclass()) {
            pw.print(c.getName() + ':');
        }
        pw.print('\n');
        e.printStackTrace(pw);
        return sw.toString();
    }
}

