/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.compiler.replacements.sparc;

import java.lang.reflect.Type;
import jdk.vm.ci.meta.JavaKind;
import jdk.vm.ci.meta.ResolvedJavaMethod;
import org.graalvm.compiler.nodes.ValueNode;
import org.graalvm.compiler.nodes.graphbuilderconf.GraphBuilderConfiguration;
import org.graalvm.compiler.nodes.graphbuilderconf.GraphBuilderContext;
import org.graalvm.compiler.nodes.graphbuilderconf.InvocationPlugin;
import org.graalvm.compiler.nodes.graphbuilderconf.InvocationPlugins;
import org.graalvm.compiler.nodes.spi.Replacements;
import org.graalvm.compiler.replacements.IntegerSubstitutions;
import org.graalvm.compiler.replacements.LongSubstitutions;
import org.graalvm.compiler.replacements.StandardGraphBuilderPlugins;
import org.graalvm.compiler.replacements.nodes.BinaryMathIntrinsicNode;
import org.graalvm.compiler.replacements.nodes.BitCountNode;
import org.graalvm.compiler.replacements.nodes.UnaryMathIntrinsicNode;

public class SPARCGraphBuilderPlugins {
    public static void register(GraphBuilderConfiguration.Plugins plugins, final Replacements replacements, final boolean explicitUnsafeNullChecks) {
        final InvocationPlugins invocationPlugins = plugins.getInvocationPlugins();
        invocationPlugins.defer(new Runnable(){

            @Override
            public void run() {
                SPARCGraphBuilderPlugins.registerIntegerLongPlugins(invocationPlugins, IntegerSubstitutions.class, JavaKind.Int, replacements);
                SPARCGraphBuilderPlugins.registerIntegerLongPlugins(invocationPlugins, LongSubstitutions.class, JavaKind.Long, replacements);
                SPARCGraphBuilderPlugins.registerMathPlugins(invocationPlugins);
                StandardGraphBuilderPlugins.registerPlatformSpecificUnsafePlugins(invocationPlugins, replacements, explicitUnsafeNullChecks, new JavaKind[]{JavaKind.Int, JavaKind.Long, JavaKind.Object});
            }
        });
    }

    private static void registerIntegerLongPlugins(InvocationPlugins plugins, Class<?> substituteDeclaringClass, JavaKind kind, Replacements replacements) {
        Class declaringClass = kind.toBoxedJavaClass();
        Class type = kind.toJavaClass();
        InvocationPlugins.Registration r = new InvocationPlugins.Registration(plugins, declaringClass, replacements);
        r.registerMethodSubstitution(substituteDeclaringClass, "numberOfLeadingZeros", type);
        r.registerMethodSubstitution(substituteDeclaringClass, "numberOfTrailingZeros", type);
        r.register1("bitCount", type, new InvocationPlugin(){

            @Override
            public boolean apply(GraphBuilderContext b, ResolvedJavaMethod targetMethod, InvocationPlugin.Receiver receiver, ValueNode value) {
                b.push(JavaKind.Int, b.append((ValueNode)new BitCountNode(value).canonical(null)));
                return true;
            }
        });
    }

    private static void registerMathPlugins(InvocationPlugins plugins) {
        InvocationPlugins.Registration r = new InvocationPlugins.Registration(plugins, (Type)((Object)Math.class));
        SPARCGraphBuilderPlugins.registerUnaryMath(r, "sin", UnaryMathIntrinsicNode.UnaryOperation.SIN);
        SPARCGraphBuilderPlugins.registerUnaryMath(r, "cos", UnaryMathIntrinsicNode.UnaryOperation.COS);
        SPARCGraphBuilderPlugins.registerUnaryMath(r, "tan", UnaryMathIntrinsicNode.UnaryOperation.TAN);
        SPARCGraphBuilderPlugins.registerUnaryMath(r, "exp", UnaryMathIntrinsicNode.UnaryOperation.EXP);
        SPARCGraphBuilderPlugins.registerUnaryMath(r, "log", UnaryMathIntrinsicNode.UnaryOperation.LOG);
        SPARCGraphBuilderPlugins.registerUnaryMath(r, "log10", UnaryMathIntrinsicNode.UnaryOperation.LOG10);
        r.register2("pow", Double.TYPE, Double.TYPE, new InvocationPlugin(){

            @Override
            public boolean inlineOnly() {
                return true;
            }

            @Override
            public boolean apply(GraphBuilderContext b, ResolvedJavaMethod targetMethod, InvocationPlugin.Receiver receiver, ValueNode x, ValueNode y) {
                b.push(JavaKind.Double, b.append(BinaryMathIntrinsicNode.create(x, y, BinaryMathIntrinsicNode.BinaryOperation.POW)));
                return true;
            }
        });
    }

    private static void registerUnaryMath(InvocationPlugins.Registration r, String name, final UnaryMathIntrinsicNode.UnaryOperation operation) {
        r.register1(name, Double.TYPE, new InvocationPlugin(){

            @Override
            public boolean inlineOnly() {
                return true;
            }

            @Override
            public boolean apply(GraphBuilderContext b, ResolvedJavaMethod targetMethod, InvocationPlugin.Receiver receiver, ValueNode value) {
                b.push(JavaKind.Double, b.append(UnaryMathIntrinsicNode.create(value, operation)));
                return true;
            }
        });
    }
}

