/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.compiler.replacements.nodes;

import org.graalvm.compiler.debug.GraalError;
import org.graalvm.compiler.graph.Node;
import org.graalvm.compiler.graph.NodeClass;
import org.graalvm.compiler.nodeinfo.InputType;
import org.graalvm.compiler.nodeinfo.NodeInfo;
import org.graalvm.compiler.nodes.FrameState;
import org.graalvm.compiler.nodes.Invoke;
import org.graalvm.compiler.nodes.InvokeNode;
import org.graalvm.compiler.nodes.StateSplit;
import org.graalvm.compiler.nodes.StructuredGraph;
import org.graalvm.compiler.nodes.java.MethodCallTargetNode;
import org.graalvm.compiler.nodes.memory.SingleMemoryKill;
import org.graalvm.compiler.replacements.nodes.MacroNode;
import org.graalvm.word.LocationIdentity;

@NodeInfo
public abstract class MacroStateSplitNode
extends MacroNode
implements StateSplit,
SingleMemoryKill {
    public static final NodeClass<MacroStateSplitNode> TYPE = NodeClass.create(MacroStateSplitNode.class);
    @Node.OptionalInput(value=InputType.State)
    protected FrameState stateAfter;

    protected MacroStateSplitNode(NodeClass<? extends MacroNode> c, MacroNode.MacroParams p) {
        super(c, p);
    }

    @Override
    public FrameState stateAfter() {
        return this.stateAfter;
    }

    @Override
    public void setStateAfter(FrameState x) {
        assert (x == null || x.isAlive()) : "frame state must be in a graph";
        this.updateUsages(this.stateAfter, x);
        this.stateAfter = x;
    }

    @Override
    public boolean hasSideEffect() {
        return true;
    }

    @Override
    public LocationIdentity getKilledLocationIdentity() {
        return LocationIdentity.any();
    }

    protected void replaceSnippetInvokes(StructuredGraph snippetGraph) {
        for (MethodCallTargetNode call : snippetGraph.getNodes(MethodCallTargetNode.TYPE)) {
            Invoke invoke = call.invoke();
            if (!call.targetMethod().equals(this.getTargetMethod())) {
                throw new GraalError("unexpected invoke %s in snippet", this.getClass().getSimpleName());
            }
            assert (invoke.stateAfter().bci == -3);
            InvokeNode newInvoke = snippetGraph.add(new InvokeNode(invoke.callTarget(), this.bci(), invoke.getKilledLocationIdentity()));
            newInvoke.setStateAfter(invoke.stateAfter());
            snippetGraph.replaceFixedWithFixed((InvokeNode)invoke.asNode(), newInvoke);
        }
    }
}

