/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.compiler.replacements.nodes;

import jdk.vm.ci.code.CodeUtil;
import jdk.vm.ci.meta.JavaConstant;
import jdk.vm.ci.meta.JavaKind;
import org.graalvm.compiler.core.common.type.IntegerStamp;
import org.graalvm.compiler.core.common.type.PrimitiveStamp;
import org.graalvm.compiler.core.common.type.Stamp;
import org.graalvm.compiler.core.common.type.StampFactory;
import org.graalvm.compiler.graph.Node;
import org.graalvm.compiler.graph.NodeClass;
import org.graalvm.compiler.graph.spi.CanonicalizerTool;
import org.graalvm.compiler.lir.gen.ArithmeticLIRGeneratorTool;
import org.graalvm.compiler.nodeinfo.NodeCycles;
import org.graalvm.compiler.nodeinfo.NodeInfo;
import org.graalvm.compiler.nodeinfo.NodeSize;
import org.graalvm.compiler.nodes.ConstantNode;
import org.graalvm.compiler.nodes.NodeView;
import org.graalvm.compiler.nodes.ValueNode;
import org.graalvm.compiler.nodes.calc.UnaryNode;
import org.graalvm.compiler.nodes.spi.ArithmeticLIRLowerable;
import org.graalvm.compiler.nodes.spi.NodeLIRBuilderTool;
import org.graalvm.compiler.replacements.nodes.BitScanForwardNode;

@NodeInfo(cycles=NodeCycles.CYCLES_2, size=NodeSize.SIZE_1)
public final class BitScanReverseNode
extends UnaryNode
implements ArithmeticLIRLowerable {
    public static final NodeClass<BitScanReverseNode> TYPE = NodeClass.create(BitScanReverseNode.class);

    public BitScanReverseNode(ValueNode value) {
        super(TYPE, StampFactory.forInteger(JavaKind.Int, 0L, (long)((PrimitiveStamp)value.stamp(NodeView.DEFAULT)).getBits()), value);
        assert (value.getStackKind() == JavaKind.Int || value.getStackKind() == JavaKind.Long);
    }

    @Override
    public Stamp foldStamp(Stamp newStamp) {
        int lastMaybeSetBit;
        int firstMaybeSetBit;
        assert (newStamp.isCompatible(this.getValue().stamp(NodeView.DEFAULT)));
        IntegerStamp valueStamp = (IntegerStamp)newStamp;
        long mask = CodeUtil.mask((int)valueStamp.getBits());
        int lastAlwaysSetBit = BitScanReverseNode.scan(valueStamp.downMask() & mask);
        int min = lastAlwaysSetBit == -1 ? (firstMaybeSetBit = BitScanForwardNode.scan(valueStamp.upMask() & mask)) : lastAlwaysSetBit;
        int max = lastMaybeSetBit = BitScanReverseNode.scan(valueStamp.upMask() & mask);
        return StampFactory.forInteger(JavaKind.Int, (long)min, (long)max);
    }

    public ValueNode canonical(CanonicalizerTool tool, ValueNode forValue) {
        JavaConstant c;
        if (forValue.isConstant() && (c = forValue.asJavaConstant()).asLong() != 0L) {
            return ConstantNode.forInt(forValue.getStackKind() == JavaKind.Int ? BitScanReverseNode.scan(c.asInt()) : BitScanReverseNode.scan(c.asLong()));
        }
        return this;
    }

    public static int scan(long v) {
        return 63 - Long.numberOfLeadingZeros(v);
    }

    public static int scan(int v) {
        return 31 - Integer.numberOfLeadingZeros(v);
    }

    @Node.NodeIntrinsic
    public static native int unsafeScan(int var0);

    @Node.NodeIntrinsic
    public static native int unsafeScan(long var0);

    @Override
    public void generate(NodeLIRBuilderTool builder, ArithmeticLIRGeneratorTool gen) {
        builder.setResult(this, gen.emitBitScanReverse(builder.operand(this.getValue())));
    }
}

