/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.compiler.replacements.arraycopy;

import java.util.EnumMap;
import jdk.vm.ci.code.TargetDescription;
import jdk.vm.ci.meta.DeoptimizationAction;
import jdk.vm.ci.meta.DeoptimizationReason;
import jdk.vm.ci.meta.JavaKind;
import jdk.vm.ci.meta.MetaAccessProvider;
import jdk.vm.ci.meta.ResolvedJavaMethod;
import jdk.vm.ci.meta.ResolvedJavaType;
import jdk.vm.ci.services.Services;
import org.graalvm.collections.UnmodifiableEconomicMap;
import org.graalvm.compiler.api.directives.GraalDirectives;
import org.graalvm.compiler.api.replacements.Snippet;
import org.graalvm.compiler.api.replacements.SnippetReflectionProvider;
import org.graalvm.compiler.core.common.GraalOptions;
import org.graalvm.compiler.debug.DebugHandlersFactory;
import org.graalvm.compiler.debug.GraalError;
import org.graalvm.compiler.graph.Node;
import org.graalvm.compiler.nodes.CallTargetNode;
import org.graalvm.compiler.nodes.DeoptimizeNode;
import org.graalvm.compiler.nodes.InvokeNode;
import org.graalvm.compiler.nodes.InvokeWithExceptionNode;
import org.graalvm.compiler.nodes.NamedLocationIdentity;
import org.graalvm.compiler.nodes.NodeView;
import org.graalvm.compiler.nodes.StructuredGraph;
import org.graalvm.compiler.nodes.extended.BranchProbabilityNode;
import org.graalvm.compiler.nodes.java.ArrayLengthNode;
import org.graalvm.compiler.nodes.spi.LoweringTool;
import org.graalvm.compiler.nodes.type.StampTool;
import org.graalvm.compiler.nodes.util.GraphUtil;
import org.graalvm.compiler.options.OptionValues;
import org.graalvm.compiler.phases.util.Providers;
import org.graalvm.compiler.replacements.ReplacementsUtil;
import org.graalvm.compiler.replacements.SnippetCounter;
import org.graalvm.compiler.replacements.SnippetIntegerHistogram;
import org.graalvm.compiler.replacements.SnippetTemplate;
import org.graalvm.compiler.replacements.Snippets;
import org.graalvm.compiler.replacements.arraycopy.ArrayCopy;
import org.graalvm.compiler.replacements.arraycopy.ArrayCopyCallNode;
import org.graalvm.compiler.replacements.arraycopy.ArrayCopyNode;
import org.graalvm.compiler.replacements.arraycopy.ArrayCopyWithDelayedLoweringNode;
import org.graalvm.compiler.replacements.arraycopy.GenericArrayCopyCallNode;
import org.graalvm.compiler.replacements.nodes.BasicArrayCopyNode;
import org.graalvm.word.LocationIdentity;

public abstract class ArrayCopySnippets
implements Snippets {
    static final MetaAccessProvider INJECTED_META_ACCESS = null;

    public abstract boolean hubsEqual(Object var1, Object var2);

    public abstract boolean layoutHelpersEqual(Object var1, Object var2);

    protected abstract int heapWordSize();

    protected boolean useOriginalArraycopy() {
        return true;
    }

    @Snippet
    public void arraycopyExactSnippet(Object src, int srcPos, Object dest, int destPos, int length, @Snippet.ConstantParameter ArrayCopyTypeCheck arrayTypeCheck, @Snippet.ConstantParameter SnippetTemplate.SnippetInfo workSnippet, @Snippet.ConstantParameter JavaKind elementKind, @Snippet.ConstantParameter LocationIdentity locationIdentity, @Snippet.ConstantParameter SnippetCounter elementKindCounter, @Snippet.ConstantParameter SnippetCounter elementKindCopiedCounter, @Snippet.ConstantParameter Counters counters) {
        Object nonNullSrc = GraalDirectives.guardingNonNull(src);
        Object nonNullDest = GraalDirectives.guardingNonNull(dest);
        this.checkArrayTypes(nonNullSrc, nonNullDest, arrayTypeCheck);
        ArrayCopySnippets.checkLimits(nonNullSrc, srcPos, nonNullDest, destPos, length, counters);
        ArrayCopySnippets.incrementLengthCounter(length, counters);
        elementKindCounter.inc();
        elementKindCopiedCounter.add(length);
        ArrayCopyWithDelayedLoweringNode.arraycopy(nonNullSrc, srcPos, nonNullDest, destPos, length, workSnippet, elementKind);
    }

    @Snippet
    public void arraycopyExactStubCallSnippet(Object src, int srcPos, Object dest, int destPos, int length, @Snippet.ConstantParameter ArrayCopyTypeCheck arrayTypeCheck, @Snippet.ConstantParameter SnippetTemplate.SnippetInfo workSnippet, @Snippet.ConstantParameter JavaKind elementKind, @Snippet.ConstantParameter LocationIdentity locationIdentity, @Snippet.ConstantParameter SnippetCounter elementKindCounter, @Snippet.ConstantParameter SnippetCounter elementKindCopiedCounter, @Snippet.ConstantParameter Counters counters) {
        Object nonNullSrc = GraalDirectives.guardingNonNull(src);
        Object nonNullDest = GraalDirectives.guardingNonNull(dest);
        this.checkArrayTypes(nonNullSrc, nonNullDest, arrayTypeCheck);
        ArrayCopySnippets.checkLimits(nonNullSrc, srcPos, nonNullDest, destPos, length, counters);
        ArrayCopySnippets.incrementLengthCounter(length, counters);
        elementKindCounter.inc();
        elementKindCopiedCounter.add(length);
        ArrayCopyCallNode.arraycopy(nonNullSrc, srcPos, nonNullDest, destPos, length, elementKind, locationIdentity, this.heapWordSize());
    }

    @Snippet
    public void arraycopyCheckcastSnippet(Object src, int srcPos, Object dest, int destPos, int length, @Snippet.ConstantParameter ArrayCopyTypeCheck arrayTypeCheck, @Snippet.ConstantParameter Counters counters, @Snippet.ConstantParameter SnippetTemplate.SnippetInfo workSnippet, @Snippet.ConstantParameter JavaKind elementKind) {
        Object nonNullSrc = GraalDirectives.guardingNonNull(src);
        Object nonNullDest = GraalDirectives.guardingNonNull(dest);
        this.checkArrayTypes(nonNullSrc, nonNullDest, arrayTypeCheck);
        ArrayCopySnippets.checkLimits(nonNullSrc, srcPos, nonNullDest, destPos, length, counters);
        ArrayCopySnippets.incrementLengthCounter(length, counters);
        ArrayCopyWithDelayedLoweringNode.arraycopy(nonNullSrc, srcPos, nonNullDest, destPos, length, workSnippet, elementKind);
    }

    @Snippet
    public void arraycopyGenericSnippet(Object src, int srcPos, Object dest, int destPos, int length, @Snippet.ConstantParameter ArrayCopyTypeCheck arrayTypeCheck, @Snippet.ConstantParameter Counters counters, @Snippet.ConstantParameter SnippetTemplate.SnippetInfo workSnippet, @Snippet.ConstantParameter JavaKind elementKind) {
        Object nonNullSrc = GraalDirectives.guardingNonNull(src);
        Object nonNullDest = GraalDirectives.guardingNonNull(dest);
        this.checkArrayTypes(nonNullSrc, nonNullDest, arrayTypeCheck);
        ArrayCopySnippets.checkLimits(nonNullSrc, srcPos, nonNullDest, destPos, length, counters);
        ArrayCopySnippets.incrementLengthCounter(length, counters);
        ArrayCopyWithDelayedLoweringNode.arraycopy(nonNullSrc, srcPos, nonNullDest, destPos, length, workSnippet, elementKind);
    }

    @Snippet
    public static void arraycopyNativeSnippet(Object src, int srcPos, Object dest, int destPos, int length, @Snippet.ConstantParameter Counters counters) {
        ArrayCopySnippets.incrementLengthCounter(length, counters);
        counters.systemArraycopyCounter.inc();
        counters.systemArraycopyCopiedCounter.add(length);
        System.arraycopy(src, srcPos, dest, destPos, length);
    }

    @Snippet(allowPartialIntrinsicArgumentMismatch=true)
    public void exactArraycopyWithSlowPathWork(Object src, int srcPos, Object dest, int destPos, int length, @Snippet.ConstantParameter JavaKind elementKind, @Snippet.ConstantParameter LocationIdentity arrayLocation, @Snippet.ConstantParameter Counters counters) {
        this.doExactArraycopyWithSlowPathWork(src, srcPos, dest, destPos, length, elementKind, arrayLocation, counters, INJECTED_META_ACCESS);
    }

    protected abstract void doExactArraycopyWithSlowPathWork(Object var1, int var2, Object var3, int var4, int var5, JavaKind var6, LocationIdentity var7, Counters var8, MetaAccessProvider var9);

    @Snippet(allowPartialIntrinsicArgumentMismatch=true)
    public void checkcastArraycopyWithSlowPathWork(Object src, int srcPos, Object dest, int destPos, int length, @Snippet.ConstantParameter JavaKind elementKind, @Snippet.ConstantParameter LocationIdentity arrayLocation, @Snippet.ConstantParameter Counters counters) {
        this.doCheckcastArraycopyWithSlowPathWork(src, srcPos, dest, destPos, length, elementKind, arrayLocation, counters);
    }

    protected abstract void doCheckcastArraycopyWithSlowPathWork(Object var1, int var2, Object var3, int var4, int var5, JavaKind var6, LocationIdentity var7, Counters var8);

    @Snippet(allowPartialIntrinsicArgumentMismatch=true)
    public void genericArraycopyWithSlowPathWork(Object src, int srcPos, Object dest, int destPos, int length, @Snippet.ConstantParameter JavaKind elementKind, @Snippet.ConstantParameter LocationIdentity arrayLocation, @Snippet.ConstantParameter Counters counters) {
        counters.genericArraycopyDifferentTypeCounter.inc();
        counters.genericArraycopyDifferentTypeCopiedCounter.add(length);
        int copiedElements = GenericArrayCopyCallNode.genericArraycopy(src, srcPos, dest, destPos, length);
        if (BranchProbabilityNode.probability(0.010000000000000009, copiedElements != 0)) {
            System.arraycopy(src, srcPos + (copiedElements ^= 0xFFFFFFFF), dest, destPos + copiedElements, length - copiedElements);
        }
    }

    private static void incrementLengthCounter(int length, Counters counters) {
        if (!Services.IS_BUILDING_NATIVE_IMAGE) {
            counters.lengthHistogram.inc(length);
        }
    }

    private static void checkLimits(Object src, int srcPos, Object dest, int destPos, int length, Counters counters) {
        if (BranchProbabilityNode.probability(0.0, srcPos < 0)) {
            counters.checkAIOOBECounter.inc();
            DeoptimizeNode.deopt(DeoptimizationAction.None, DeoptimizationReason.BoundsCheckException);
        }
        if (BranchProbabilityNode.probability(0.0, destPos < 0)) {
            counters.checkAIOOBECounter.inc();
            DeoptimizeNode.deopt(DeoptimizationAction.None, DeoptimizationReason.BoundsCheckException);
        }
        if (BranchProbabilityNode.probability(0.0, length < 0)) {
            counters.checkAIOOBECounter.inc();
            DeoptimizeNode.deopt(DeoptimizationAction.None, DeoptimizationReason.BoundsCheckException);
        }
        if (BranchProbabilityNode.probability(0.0, srcPos > ArrayLengthNode.arrayLength(src) - length)) {
            counters.checkAIOOBECounter.inc();
            DeoptimizeNode.deopt(DeoptimizationAction.None, DeoptimizationReason.BoundsCheckException);
        }
        if (BranchProbabilityNode.probability(0.0, destPos > ArrayLengthNode.arrayLength(dest) - length)) {
            counters.checkAIOOBECounter.inc();
            DeoptimizeNode.deopt(DeoptimizationAction.None, DeoptimizationReason.BoundsCheckException);
        }
        counters.checkSuccessCounter.inc();
    }

    private void checkArrayTypes(Object nonNullSrc, Object nonNullDest, ArrayCopyTypeCheck arrayTypeCheck) {
        if (arrayTypeCheck != ArrayCopyTypeCheck.NO_ARRAY_TYPE_CHECK) {
            if (arrayTypeCheck == ArrayCopyTypeCheck.HUB_BASED_ARRAY_TYPE_CHECK) {
                if (BranchProbabilityNode.probability(0.0, !this.hubsEqual(nonNullSrc, nonNullDest))) {
                    DeoptimizeNode.deopt(DeoptimizationAction.None, DeoptimizationReason.RuntimeConstraint);
                }
            } else if (arrayTypeCheck == ArrayCopyTypeCheck.LAYOUT_HELPER_BASED_ARRAY_TYPE_CHECK) {
                if (BranchProbabilityNode.probability(0.0, !this.layoutHelpersEqual(nonNullSrc, nonNullDest))) {
                    DeoptimizeNode.deopt(DeoptimizationAction.None, DeoptimizationReason.RuntimeConstraint);
                }
            } else {
                ReplacementsUtil.staticAssert(false, "unknown array type check ", (Object)arrayTypeCheck);
            }
        }
    }

    public static class Templates
    extends SnippetTemplate.AbstractTemplates {
        private final SnippetTemplate.SnippetInfo arraycopyGenericSnippet;
        private final SnippetTemplate.SnippetInfo arraycopyExactSnippet;
        private final SnippetTemplate.SnippetInfo arraycopyExactStubCallSnippet;
        private final SnippetTemplate.SnippetInfo arraycopyCheckcastSnippet;
        private final SnippetTemplate.SnippetInfo arraycopyNativeSnippet;
        private final SnippetTemplate.SnippetInfo checkcastArraycopyWithSlowPathWork;
        private final SnippetTemplate.SnippetInfo genericArraycopyWithSlowPathWork;
        private final SnippetTemplate.SnippetInfo exactArraycopyWithSlowPathWork;
        private final boolean useOriginalArraycopy;
        private ResolvedJavaMethod originalArraycopy;
        private final Counters counters;

        public Templates(ArrayCopySnippets receiver, OptionValues options, Iterable<DebugHandlersFactory> factories, SnippetCounter.Group.Factory factory, Providers providers, SnippetReflectionProvider snippetReflection, TargetDescription target) {
            super(options, factories, providers, snippetReflection, target);
            this.counters = new Counters(factory);
            this.useOriginalArraycopy = receiver.useOriginalArraycopy();
            this.arraycopyGenericSnippet = this.snippet(receiver, "arraycopyGenericSnippet");
            this.arraycopyExactSnippet = this.snippet(receiver, "arraycopyExactSnippet");
            this.arraycopyExactStubCallSnippet = this.snippet(receiver, "arraycopyExactStubCallSnippet");
            this.arraycopyCheckcastSnippet = this.snippet(receiver, "arraycopyCheckcastSnippet");
            this.arraycopyNativeSnippet = this.snippet(null, "arraycopyNativeSnippet");
            this.checkcastArraycopyWithSlowPathWork = this.snippet(receiver, "checkcastArraycopyWithSlowPathWork");
            this.genericArraycopyWithSlowPathWork = this.snippet(receiver, "genericArraycopyWithSlowPathWork");
            this.exactArraycopyWithSlowPathWork = this.snippet(receiver, "exactArraycopyWithSlowPathWork");
        }

        protected SnippetTemplate.SnippetInfo snippet(ArrayCopySnippets receiver, String methodName) {
            SnippetTemplate.SnippetInfo info = this.snippet(ArrayCopySnippets.class, methodName, this.originalArraycopy(), receiver, LocationIdentity.any());
            return info;
        }

        public void lower(ArrayCopyNode arraycopy, LoweringTool tool) {
            this.lower(arraycopy, false, tool);
        }

        public void lower(ArrayCopyNode arraycopy, boolean mayExpandThisArraycopy, LoweringTool tool) {
            LocationIdentity locationIdentity;
            ArrayCopyTypeCheck arrayTypeCheck;
            SnippetTemplate.SnippetInfo snippetInfo;
            JavaKind elementKind = ArrayCopy.selectComponentKind(arraycopy);
            ResolvedJavaType srcType = StampTool.typeOrNull(arraycopy.getSource().stamp(NodeView.DEFAULT));
            ResolvedJavaType destType = StampTool.typeOrNull(arraycopy.getDestination().stamp(NodeView.DEFAULT));
            if (!Templates.canBeArray(srcType) || !Templates.canBeArray(destType)) {
                snippetInfo = this.arraycopyNativeSnippet;
                arrayTypeCheck = ArrayCopyTypeCheck.UNDEFINED_ARRAY_TYPE_CHECK;
            } else {
                ResolvedJavaType destComponentType;
                ResolvedJavaType srcComponentType = srcType == null ? null : srcType.getComponentType();
                ResolvedJavaType resolvedJavaType = destComponentType = destType == null ? null : destType.getComponentType();
                if (arraycopy.isExact()) {
                    snippetInfo = this.arraycopyExactStubCallSnippet;
                    arrayTypeCheck = ArrayCopyTypeCheck.NO_ARRAY_TYPE_CHECK;
                } else if (srcComponentType == null && destComponentType == null) {
                    snippetInfo = this.arraycopyGenericSnippet;
                    arrayTypeCheck = ArrayCopyTypeCheck.NO_ARRAY_TYPE_CHECK;
                } else if (GraalOptions.GeneratePIC.getValue(this.options).booleanValue()) {
                    snippetInfo = this.arraycopyGenericSnippet;
                    arrayTypeCheck = ArrayCopyTypeCheck.NO_ARRAY_TYPE_CHECK;
                } else if (srcComponentType != null && destComponentType != null) {
                    if (!srcComponentType.isPrimitive() && !destComponentType.isPrimitive()) {
                        snippetInfo = this.arraycopyCheckcastSnippet;
                        arrayTypeCheck = ArrayCopyTypeCheck.NO_ARRAY_TYPE_CHECK;
                    } else {
                        assert (!srcComponentType.equals(destComponentType)) : "must be handled by arraycopy.isExact()";
                        snippetInfo = this.arraycopyNativeSnippet;
                        arrayTypeCheck = ArrayCopyTypeCheck.UNDEFINED_ARRAY_TYPE_CHECK;
                    }
                } else {
                    ResolvedJavaType nonNullComponentType;
                    ResolvedJavaType resolvedJavaType2 = nonNullComponentType = srcComponentType != null ? srcComponentType : destComponentType;
                    if (nonNullComponentType.isPrimitive()) {
                        snippetInfo = this.arraycopyExactStubCallSnippet;
                        arrayTypeCheck = ArrayCopyTypeCheck.HUB_BASED_ARRAY_TYPE_CHECK;
                        elementKind = nonNullComponentType.getJavaKind();
                    } else {
                        snippetInfo = this.arraycopyCheckcastSnippet;
                        arrayTypeCheck = ArrayCopyTypeCheck.LAYOUT_HELPER_BASED_ARRAY_TYPE_CHECK;
                    }
                }
            }
            if (mayExpandThisArraycopy && snippetInfo == this.arraycopyExactStubCallSnippet) {
                snippetInfo = this.arraycopyExactSnippet;
            }
            SnippetTemplate.Arguments args = new SnippetTemplate.Arguments(snippetInfo, arraycopy.graph().getGuardsStage(), tool.getLoweringStage());
            args.add("src", arraycopy.getSource());
            args.add("srcPos", arraycopy.getSourcePosition());
            args.add("dest", arraycopy.getDestination());
            args.add("destPos", arraycopy.getDestinationPosition());
            args.add("length", arraycopy.getLength());
            if (snippetInfo != this.arraycopyNativeSnippet) {
                assert (arrayTypeCheck != ArrayCopyTypeCheck.UNDEFINED_ARRAY_TYPE_CHECK);
                args.addConst("arrayTypeCheck", (Object)arrayTypeCheck);
            }
            LocationIdentity locationIdentity2 = locationIdentity = arraycopy.killsAnyLocation() ? LocationIdentity.any() : NamedLocationIdentity.getArrayLocation(elementKind);
            if (snippetInfo == this.arraycopyExactStubCallSnippet || snippetInfo == this.arraycopyExactSnippet) {
                assert (elementKind != null);
                args.addConst("workSnippet", this.exactArraycopyWithSlowPathWork);
                args.addConst("elementKind", elementKind);
                args.addConst("locationIdentity", locationIdentity);
                args.addConst("elementKindCounter", this.counters.arraycopyCallCounters.get(elementKind));
                args.addConst("elementKindCopiedCounter", this.counters.arraycopyCallCopiedCounters.get(elementKind));
            }
            args.addConst("counters", this.counters);
            if (snippetInfo == this.arraycopyCheckcastSnippet) {
                args.addConst("workSnippet", this.checkcastArraycopyWithSlowPathWork);
                args.addConst("elementKind", JavaKind.Illegal);
            }
            if (snippetInfo == this.arraycopyGenericSnippet) {
                args.addConst("workSnippet", this.genericArraycopyWithSlowPathWork);
                args.addConst("elementKind", JavaKind.Illegal);
            }
            this.instantiate(args, arraycopy);
        }

        public void lower(ArrayCopyWithDelayedLoweringNode arraycopy, LoweringTool tool) {
            this.lower(arraycopy, false, tool);
        }

        public void lower(ArrayCopyWithDelayedLoweringNode arraycopy, boolean mayExpandArraycopyLoops, LoweringTool tool) {
            StructuredGraph graph = arraycopy.graph();
            if (arraycopy.getSnippet() == this.exactArraycopyWithSlowPathWork && mayExpandArraycopyLoops ? !graph.getGuardsStage().areDeoptsFixed() : !graph.getGuardsStage().areFrameStatesAtDeopts()) {
                return;
            }
            SnippetTemplate.SnippetInfo snippetInfo = arraycopy.getSnippet();
            SnippetTemplate.Arguments args = new SnippetTemplate.Arguments(snippetInfo, graph.getGuardsStage(), tool.getLoweringStage());
            args.add("src", arraycopy.getSource());
            args.add("srcPos", arraycopy.getSourcePosition());
            args.add("dest", arraycopy.getDestination());
            args.add("destPos", arraycopy.getDestinationPosition());
            args.add("length", arraycopy.getLength());
            JavaKind elementKind = arraycopy.getElementKind();
            args.addConst("elementKind", elementKind == null ? JavaKind.Illegal : elementKind);
            LocationIdentity locationIdentity = elementKind == null ? LocationIdentity.any() : NamedLocationIdentity.getArrayLocation(arraycopy.getElementKind());
            args.addConst("arrayLocation", locationIdentity);
            args.addConst("counters", this.counters);
            this.instantiate(args, arraycopy);
        }

        private static boolean canBeArray(ResolvedJavaType type) {
            return type == null || type.isJavaLangObject() || type.isArray();
        }

        private void instantiate(SnippetTemplate.Arguments args, BasicArrayCopyNode arraycopy) {
            StructuredGraph graph = arraycopy.graph();
            SnippetTemplate template = this.template(arraycopy, args);
            UnmodifiableEconomicMap<Node, Node> replacements = template.instantiate(this.providers.getMetaAccess(), arraycopy, SnippetTemplate.DEFAULT_REPLACER, args, false);
            for (Node originalNode : replacements.getKeys()) {
                if (originalNode instanceof InvokeNode) {
                    InvokeNode invoke = (InvokeNode)replacements.get((Object)originalNode);
                    assert (invoke.asNode().graph() == graph);
                    CallTargetNode call = invoke.callTarget();
                    if (!call.targetMethod().equals(this.originalArraycopy)) {
                        throw new GraalError("unexpected invoke %s in snippet", call.targetMethod());
                    }
                    invoke.setBci(arraycopy.getBci());
                    invoke.setStateDuring(null);
                    invoke.setStateAfter(null);
                    if (arraycopy.stateDuring() != null) {
                        invoke.setStateDuring(arraycopy.stateDuring());
                        continue;
                    }
                    assert (arraycopy.stateAfter() != null) : arraycopy;
                    invoke.setStateAfter(arraycopy.stateAfter());
                    continue;
                }
                if (originalNode instanceof InvokeWithExceptionNode) {
                    throw new GraalError("unexpected invoke with exception %s in snippet", originalNode);
                }
                if (!(originalNode instanceof ArrayCopyWithDelayedLoweringNode)) continue;
                ArrayCopyWithDelayedLoweringNode slowPath = (ArrayCopyWithDelayedLoweringNode)replacements.get((Object)originalNode);
                assert (arraycopy.stateAfter() != null) : arraycopy;
                assert (slowPath.stateAfter() == arraycopy.stateAfter()) : "States do not match for slowpath=" + slowPath + " and array copy=" + arraycopy + " slowPathState=" + slowPath.stateAfter() + " and arraycopyState=" + arraycopy.stateAfter();
                slowPath.setBci(arraycopy.getBci());
            }
            GraphUtil.killCFG(arraycopy);
        }

        private ResolvedJavaMethod originalArraycopy() throws GraalError {
            if (!this.useOriginalArraycopy) {
                return null;
            }
            if (this.originalArraycopy == null) {
                try {
                    this.originalArraycopy = Templates.findMethod(this.providers.getMetaAccess(), System.class, "arraycopy");
                }
                catch (SecurityException e) {
                    throw new GraalError(e);
                }
            }
            return this.originalArraycopy;
        }
    }

    protected static class Counters {
        public final SnippetCounter checkSuccessCounter;
        public final SnippetCounter checkAIOOBECounter;
        public final SnippetCounter zeroLengthStaticCounter;
        public final SnippetIntegerHistogram lengthHistogram;
        public final SnippetCounter systemArraycopyCounter;
        public final SnippetCounter systemArraycopyCopiedCounter;
        public final SnippetCounter genericArraycopyDifferentTypeCopiedCounter;
        public final SnippetCounter genericArraycopyDifferentTypeCounter;
        public final SnippetCounter objectCheckcastSameTypeCopiedCounter;
        public final SnippetCounter objectCheckcastSameTypeCounter;
        public final SnippetCounter objectCheckcastDifferentTypeCopiedCounter;
        public final SnippetCounter objectCheckcastDifferentTypeCounter;
        public final EnumMap<JavaKind, SnippetCounter> arraycopyCallCounters = new EnumMap(JavaKind.class);
        public final EnumMap<JavaKind, SnippetCounter> arraycopyCallCopiedCounters = new EnumMap(JavaKind.class);

        Counters(SnippetCounter.Group.Factory factory) {
            SnippetCounter.Group checkCounters = factory.createSnippetCounterGroup("System.arraycopy checkInputs");
            SnippetCounter.Group callCounters = factory.createSnippetCounterGroup("System.arraycopy calls");
            SnippetCounter.Group copiedElementsCounters = factory.createSnippetCounterGroup("System.arraycopy copied elements");
            SnippetCounter.Group lengthCounters = factory.createSnippetCounterGroup("System.arraycopy with 0-length");
            this.checkSuccessCounter = new SnippetCounter(checkCounters, "checkSuccess", "checkSuccess");
            this.checkAIOOBECounter = new SnippetCounter(checkCounters, "checkAIOOBE", "checkAIOOBE");
            this.zeroLengthStaticCounter = new SnippetCounter(lengthCounters, "0-length copy static", "calls where the length is statically 0");
            this.lengthHistogram = new SnippetIntegerHistogram(lengthCounters, 2, "length", "length");
            this.systemArraycopyCounter = new SnippetCounter(callCounters, "native System.arraycopy", "JNI-based System.arraycopy call");
            this.systemArraycopyCopiedCounter = new SnippetCounter(copiedElementsCounters, "native System.arraycopy", "JNI-based System.arraycopy call");
            this.genericArraycopyDifferentTypeCounter = new SnippetCounter(callCounters, "generic[] stub", "generic arraycopy stub");
            this.genericArraycopyDifferentTypeCopiedCounter = new SnippetCounter(copiedElementsCounters, "generic[] stub", "generic arraycopy stub");
            this.objectCheckcastSameTypeCounter = new SnippetCounter(callCounters, "checkcast object[] (same-type)", "checkcast object[] stub but src.klass == dest.klass Object[] arrays");
            this.objectCheckcastSameTypeCopiedCounter = new SnippetCounter(copiedElementsCounters, "checkcast object[] (same-type)", "checkcast object[] stub but src.klass == dest.klass Object[] arrays");
            this.objectCheckcastDifferentTypeCounter = new SnippetCounter(callCounters, "checkcast object[] (store-check)", "checkcast object[] stub with store check");
            this.objectCheckcastDifferentTypeCopiedCounter = new SnippetCounter(copiedElementsCounters, "checkcast object[] (store-check)", "checkcast object[] stub with store check");
            this.createArraycopyCounter(JavaKind.Byte, callCounters, copiedElementsCounters);
            this.createArraycopyCounter(JavaKind.Boolean, callCounters, copiedElementsCounters);
            this.createArraycopyCounter(JavaKind.Char, callCounters, copiedElementsCounters);
            this.createArraycopyCounter(JavaKind.Short, callCounters, copiedElementsCounters);
            this.createArraycopyCounter(JavaKind.Int, callCounters, copiedElementsCounters);
            this.createArraycopyCounter(JavaKind.Long, callCounters, copiedElementsCounters);
            this.createArraycopyCounter(JavaKind.Float, callCounters, copiedElementsCounters);
            this.createArraycopyCounter(JavaKind.Double, callCounters, copiedElementsCounters);
            this.createArraycopyCounter(JavaKind.Object, callCounters, copiedElementsCounters);
        }

        void createArraycopyCounter(JavaKind kind, SnippetCounter.Group counters, SnippetCounter.Group copiedCounters) {
            this.arraycopyCallCounters.put(kind, new SnippetCounter(counters, kind + "[] stub", "arraycopy call for " + kind + "[] arrays"));
            this.arraycopyCallCopiedCounters.put(kind, new SnippetCounter(copiedCounters, kind + "[] stub", "arraycopy call for " + kind + "[] arrays"));
        }
    }

    private static enum ArrayCopyTypeCheck {
        UNDEFINED_ARRAY_TYPE_CHECK,
        NO_ARRAY_TYPE_CHECK,
        HUB_BASED_ARRAY_TYPE_CHECK,
        LAYOUT_HELPER_BASED_ARRAY_TYPE_CHECK;

    }
}

