/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.compiler.replacements.amd64;

import jdk.vm.ci.meta.DeoptimizationAction;
import jdk.vm.ci.meta.DeoptimizationReason;
import jdk.vm.ci.meta.JavaKind;
import jdk.vm.ci.meta.MetaAccessProvider;
import org.graalvm.compiler.api.directives.GraalDirectives;
import org.graalvm.compiler.api.replacements.ClassSubstitution;
import org.graalvm.compiler.api.replacements.MethodSubstitution;
import org.graalvm.compiler.nodes.DeoptimizeNode;
import org.graalvm.compiler.replacements.ReplacementsUtil;
import org.graalvm.compiler.replacements.amd64.AMD64ArrayIndexOf;
import org.graalvm.compiler.replacements.amd64.AMD64StringLatin1InflateNode;
import org.graalvm.compiler.replacements.nodes.ArrayRegionEqualsNode;
import org.graalvm.compiler.word.Word;

@ClassSubstitution(className={"java.lang.StringLatin1"}, optional=true)
public class AMD64StringLatin1Substitutions {
    static final MetaAccessProvider INJECTED = null;

    private static Word pointer(byte[] target) {
        return Word.objectToTrackedPointer(target).add(ReplacementsUtil.byteArrayBaseOffset(INJECTED));
    }

    private static Word byteOffsetPointer(byte[] source, int offset) {
        return AMD64StringLatin1Substitutions.pointer(source).add(offset * ReplacementsUtil.byteArrayIndexScale(INJECTED));
    }

    @MethodSubstitution
    public static int indexOf(byte[] value, int ch, int origFromIndex) {
        int fromIndex = origFromIndex;
        if (GraalDirectives.injectBranchProbability(0.25, ch >>> 8 != 0)) {
            return -1;
        }
        int length = value.length;
        if (GraalDirectives.injectBranchProbability(0.25, fromIndex < 0)) {
            fromIndex = 0;
        } else if (GraalDirectives.injectBranchProbability(0.25, fromIndex >= length)) {
            return -1;
        }
        return AMD64ArrayIndexOf.indexOf1Byte(value, length, fromIndex, (byte)ch);
    }

    @MethodSubstitution
    public static int indexOf(byte[] source, int sourceCount, byte[] target, int targetCount, int origFromIndex) {
        int fromIndex = origFromIndex;
        if (GraalDirectives.injectBranchProbability(0.25, fromIndex >= sourceCount)) {
            return targetCount == 0 ? sourceCount : -1;
        }
        if (GraalDirectives.injectBranchProbability(0.25, fromIndex < 0)) {
            fromIndex = 0;
        }
        if (GraalDirectives.injectBranchProbability(0.25, targetCount == 0)) {
            return fromIndex;
        }
        if (GraalDirectives.injectBranchProbability(0.25, sourceCount - fromIndex < targetCount)) {
            return -1;
        }
        if (GraalDirectives.injectBranchProbability(0.25, targetCount == 1)) {
            return AMD64ArrayIndexOf.indexOf1Byte(source, sourceCount, fromIndex, target[0]);
        }
        int haystackLength = sourceCount - (targetCount - 2);
        int offset = fromIndex;
        while (GraalDirectives.injectBranchProbability(0.75, offset < haystackLength)) {
            Word targetPointer;
            int indexOfResult = AMD64ArrayIndexOf.indexOfTwoConsecutiveBytes(source, haystackLength, offset, target[0], target[1]);
            if (GraalDirectives.injectBranchProbability(0.25, indexOfResult < 0)) {
                return -1;
            }
            offset = indexOfResult;
            if (GraalDirectives.injectBranchProbability(0.25, targetCount == 2)) {
                return offset;
            }
            Word cmpSourcePointer = AMD64StringLatin1Substitutions.byteOffsetPointer(source, offset);
            if (GraalDirectives.injectBranchProbability(0.25, ArrayRegionEqualsNode.regionEquals(cmpSourcePointer, targetPointer = AMD64StringLatin1Substitutions.pointer(target), targetCount, JavaKind.Byte))) {
                return offset;
            }
            ++offset;
        }
        return -1;
    }

    @MethodSubstitution
    public static void inflate(byte[] src, int srcIndex, char[] dest, int destIndex, int len) {
        if (GraalDirectives.injectBranchProbability(1.0E-4, len < 0) || GraalDirectives.injectBranchProbability(1.0E-4, srcIndex < 0) || GraalDirectives.injectBranchProbability(1.0E-4, srcIndex + len > src.length) || GraalDirectives.injectBranchProbability(1.0E-4, destIndex < 0) || GraalDirectives.injectBranchProbability(1.0E-4, destIndex + len > dest.length)) {
            DeoptimizeNode.deopt(DeoptimizationAction.None, DeoptimizationReason.BoundsCheckException);
        }
        Word srcPointer = Word.objectToTrackedPointer(src).add(ReplacementsUtil.byteArrayBaseOffset(INJECTED)).add(srcIndex * ReplacementsUtil.byteArrayIndexScale(INJECTED));
        Word destPointer = Word.objectToTrackedPointer(dest).add(ReplacementsUtil.charArrayBaseOffset(INJECTED)).add(destIndex * ReplacementsUtil.charArrayIndexScale(INJECTED));
        AMD64StringLatin1InflateNode.inflate(srcPointer, destPointer, len, JavaKind.Char);
    }

    @MethodSubstitution
    public static void inflate(byte[] src, int srcIndex, byte[] dest, int destIndex, int len) {
        if (GraalDirectives.injectBranchProbability(1.0E-4, len < 0) || GraalDirectives.injectBranchProbability(1.0E-4, srcIndex < 0) || GraalDirectives.injectBranchProbability(1.0E-4, srcIndex + len > src.length) || GraalDirectives.injectBranchProbability(1.0E-4, destIndex < 0) || GraalDirectives.injectBranchProbability(1.0E-4, destIndex * 2 + len * 2 > dest.length)) {
            DeoptimizeNode.deopt(DeoptimizationAction.None, DeoptimizationReason.BoundsCheckException);
        }
        Word srcPointer = Word.objectToTrackedPointer(src).add(ReplacementsUtil.byteArrayBaseOffset(INJECTED)).add(srcIndex * ReplacementsUtil.byteArrayIndexScale(INJECTED));
        Word destPointer = Word.objectToTrackedPointer(dest).add(ReplacementsUtil.byteArrayBaseOffset(INJECTED)).add(destIndex * 2 * ReplacementsUtil.byteArrayIndexScale(INJECTED));
        AMD64StringLatin1InflateNode.inflate(srcPointer, destPointer, len, JavaKind.Byte);
    }
}

