/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.compiler.replacements;

import org.graalvm.compiler.core.common.type.Stamp;
import org.graalvm.compiler.graph.Node;
import org.graalvm.compiler.graph.NodeClass;
import org.graalvm.compiler.graph.NodeInputList;
import org.graalvm.compiler.nodeinfo.InputType;
import org.graalvm.compiler.nodeinfo.NodeCycles;
import org.graalvm.compiler.nodeinfo.NodeInfo;
import org.graalvm.compiler.nodeinfo.NodeSize;
import org.graalvm.compiler.nodes.FixedWithNextNode;
import org.graalvm.compiler.nodes.ValueNode;
import org.graalvm.compiler.nodes.ValueNodeUtil;
import org.graalvm.compiler.nodes.memory.MemoryAccess;
import org.graalvm.compiler.nodes.memory.MemoryKill;
import org.graalvm.compiler.nodes.spi.Lowerable;
import org.graalvm.compiler.nodes.spi.LoweringTool;
import org.graalvm.word.LocationIdentity;

@NodeInfo(cycles=NodeCycles.CYCLES_IGNORED, size=NodeSize.SIZE_IGNORED)
public class SnippetLowerableMemoryNode
extends FixedWithNextNode
implements Lowerable,
MemoryAccess {
    public static final NodeClass<SnippetLowerableMemoryNode> TYPE = NodeClass.create(SnippetLowerableMemoryNode.class);
    @Node.Input
    protected NodeInputList<ValueNode> arguments;
    @Node.OptionalInput(value=InputType.Memory)
    protected MemoryKill lastLocationAccess;
    private final LocationIdentity locationIdentity;
    SnippetLowering lowering;

    public SnippetLowerableMemoryNode(SnippetLowering lowering, LocationIdentity locationIdentity, Stamp stamp, ValueNode ... arguments) {
        super((NodeClass<? extends FixedWithNextNode>)TYPE, stamp);
        this.arguments = new NodeInputList((Node)this, (Node[])arguments);
        this.lowering = lowering;
        this.locationIdentity = locationIdentity;
    }

    public ValueNode getArgument(int i) {
        return (ValueNode)this.arguments.get(i);
    }

    public int getArgumentCount() {
        return this.arguments.size();
    }

    @Override
    public void lower(LoweringTool tool) {
        this.lowering.lower(this, tool);
    }

    @Override
    public LocationIdentity getLocationIdentity() {
        return this.locationIdentity;
    }

    @Override
    public MemoryKill getLastLocationAccess() {
        return this.lastLocationAccess;
    }

    @Override
    public void setLastLocationAccess(MemoryKill lla) {
        this.updateUsages(ValueNodeUtil.asNode(this.lastLocationAccess), ValueNodeUtil.asNode(lla));
        this.lastLocationAccess = lla;
    }

    public static interface SnippetLowering {
        public void lower(SnippetLowerableMemoryNode var1, LoweringTool var2);
    }
}

