/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.compiler.replacements;

import java.net.URI;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Formatter;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import jdk.vm.ci.code.Architecture;
import jdk.vm.ci.code.BailoutException;
import jdk.vm.ci.code.BytecodeFrame;
import jdk.vm.ci.meta.Assumptions;
import jdk.vm.ci.meta.ConstantReflectionProvider;
import jdk.vm.ci.meta.DeoptimizationAction;
import jdk.vm.ci.meta.DeoptimizationReason;
import jdk.vm.ci.meta.JavaConstant;
import jdk.vm.ci.meta.JavaKind;
import jdk.vm.ci.meta.JavaType;
import jdk.vm.ci.meta.MetaAccessProvider;
import jdk.vm.ci.meta.ResolvedJavaField;
import jdk.vm.ci.meta.ResolvedJavaMethod;
import jdk.vm.ci.meta.ResolvedJavaType;
import org.graalvm.collections.EconomicMap;
import org.graalvm.collections.Equivalence;
import org.graalvm.compiler.bytecode.Bytecode;
import org.graalvm.compiler.bytecode.BytecodeProvider;
import org.graalvm.compiler.core.common.PermanentBailoutException;
import org.graalvm.compiler.core.common.cfg.CFGVerifier;
import org.graalvm.compiler.core.common.spi.ConstantFieldProvider;
import org.graalvm.compiler.core.common.type.Stamp;
import org.graalvm.compiler.core.common.type.StampFactory;
import org.graalvm.compiler.core.common.type.StampPair;
import org.graalvm.compiler.debug.DebugCloseable;
import org.graalvm.compiler.debug.DebugContext;
import org.graalvm.compiler.debug.GraalError;
import org.graalvm.compiler.graph.IterableNodeType;
import org.graalvm.compiler.graph.Node;
import org.graalvm.compiler.graph.NodeClass;
import org.graalvm.compiler.graph.NodeSourcePosition;
import org.graalvm.compiler.graph.SourceLanguagePosition;
import org.graalvm.compiler.graph.SourceLanguagePositionProvider;
import org.graalvm.compiler.nodeinfo.InputType;
import org.graalvm.compiler.nodeinfo.NodeCycles;
import org.graalvm.compiler.nodeinfo.NodeInfo;
import org.graalvm.compiler.nodeinfo.NodeSize;
import org.graalvm.compiler.nodes.AbstractBeginNode;
import org.graalvm.compiler.nodes.AbstractMergeNode;
import org.graalvm.compiler.nodes.CallTargetNode;
import org.graalvm.compiler.nodes.ControlSinkNode;
import org.graalvm.compiler.nodes.DeoptBciSupplier;
import org.graalvm.compiler.nodes.DeoptimizeNode;
import org.graalvm.compiler.nodes.DeoptimizingFixedWithNextNode;
import org.graalvm.compiler.nodes.EncodedGraph;
import org.graalvm.compiler.nodes.FixedNode;
import org.graalvm.compiler.nodes.FixedWithNextNode;
import org.graalvm.compiler.nodes.FrameState;
import org.graalvm.compiler.nodes.GraphDecoder;
import org.graalvm.compiler.nodes.Invoke;
import org.graalvm.compiler.nodes.InvokeWithExceptionNode;
import org.graalvm.compiler.nodes.MergeNode;
import org.graalvm.compiler.nodes.NodeView;
import org.graalvm.compiler.nodes.ParameterNode;
import org.graalvm.compiler.nodes.PluginReplacementNode;
import org.graalvm.compiler.nodes.ReturnNode;
import org.graalvm.compiler.nodes.SimplifyingGraphDecoder;
import org.graalvm.compiler.nodes.StateSplit;
import org.graalvm.compiler.nodes.StructuredGraph;
import org.graalvm.compiler.nodes.UnwindNode;
import org.graalvm.compiler.nodes.ValueNode;
import org.graalvm.compiler.nodes.calc.FloatingNode;
import org.graalvm.compiler.nodes.cfg.ControlFlowGraph;
import org.graalvm.compiler.nodes.extended.AnchoringNode;
import org.graalvm.compiler.nodes.extended.GuardingNode;
import org.graalvm.compiler.nodes.graphbuilderconf.GeneratedInvocationPlugin;
import org.graalvm.compiler.nodes.graphbuilderconf.GraphBuilderContext;
import org.graalvm.compiler.nodes.graphbuilderconf.InlineInvokePlugin;
import org.graalvm.compiler.nodes.graphbuilderconf.IntrinsicContext;
import org.graalvm.compiler.nodes.graphbuilderconf.InvocationPlugin;
import org.graalvm.compiler.nodes.graphbuilderconf.InvocationPlugins;
import org.graalvm.compiler.nodes.graphbuilderconf.LoopExplosionPlugin;
import org.graalvm.compiler.nodes.graphbuilderconf.MethodSubstitutionPlugin;
import org.graalvm.compiler.nodes.graphbuilderconf.NodePlugin;
import org.graalvm.compiler.nodes.graphbuilderconf.ParameterPlugin;
import org.graalvm.compiler.nodes.java.AbstractNewArrayNode;
import org.graalvm.compiler.nodes.java.LoadFieldNode;
import org.graalvm.compiler.nodes.java.LoadIndexedNode;
import org.graalvm.compiler.nodes.java.MethodCallTargetNode;
import org.graalvm.compiler.nodes.java.MonitorIdNode;
import org.graalvm.compiler.nodes.java.NewArrayNode;
import org.graalvm.compiler.nodes.java.NewInstanceNode;
import org.graalvm.compiler.nodes.java.NewMultiArrayNode;
import org.graalvm.compiler.nodes.java.StoreFieldNode;
import org.graalvm.compiler.nodes.java.StoreIndexedNode;
import org.graalvm.compiler.nodes.spi.CoreProviders;
import org.graalvm.compiler.nodes.spi.Replacements;
import org.graalvm.compiler.nodes.spi.StampProvider;
import org.graalvm.compiler.nodes.type.StampTool;
import org.graalvm.compiler.nodes.util.GraphUtil;
import org.graalvm.compiler.options.Option;
import org.graalvm.compiler.options.OptionKey;
import org.graalvm.compiler.options.OptionType;
import org.graalvm.compiler.options.OptionValues;
import org.graalvm.compiler.phases.common.inlining.InliningUtil;

public abstract class PEGraphDecoder
extends SimplifyingGraphDecoder {
    private static final Object CACHED_NULL_VALUE = new Object();
    private final LoopExplosionPlugin loopExplosionPlugin;
    private final InvocationPlugins invocationPlugins;
    private final InlineInvokePlugin[] inlineInvokePlugins;
    private final ParameterPlugin parameterPlugin;
    private final NodePlugin[] nodePlugins;
    private final EconomicMap<SpecialCallTargetCacheKey, Object> specialCallTargetCache;
    private final EconomicMap<ResolvedJavaMethod, Object> invocationPluginCache;
    private final ResolvedJavaMethod peRootForInlining;
    protected final SourceLanguagePositionProvider sourceLanguagePositionProvider;

    protected IntrinsicContext getIntrinsic() {
        return null;
    }

    public PEGraphDecoder(Architecture architecture, StructuredGraph graph, CoreProviders providers, LoopExplosionPlugin loopExplosionPlugin, InvocationPlugins invocationPlugins, InlineInvokePlugin[] inlineInvokePlugins, ParameterPlugin parameterPlugin, NodePlugin[] nodePlugins, ResolvedJavaMethod peRootForInlining, SourceLanguagePositionProvider sourceLanguagePositionProvider) {
        super(architecture, graph, providers, true);
        this.loopExplosionPlugin = loopExplosionPlugin;
        this.invocationPlugins = invocationPlugins;
        this.inlineInvokePlugins = inlineInvokePlugins;
        this.parameterPlugin = parameterPlugin;
        this.nodePlugins = nodePlugins;
        this.specialCallTargetCache = EconomicMap.create((Equivalence)Equivalence.DEFAULT);
        this.invocationPluginCache = EconomicMap.create((Equivalence)Equivalence.DEFAULT);
        this.peRootForInlining = peRootForInlining;
        this.sourceLanguagePositionProvider = sourceLanguagePositionProvider;
    }

    protected static LoopExplosionPlugin.LoopExplosionKind loopExplosionKind(ResolvedJavaMethod method, LoopExplosionPlugin loopExplosionPlugin) {
        if (loopExplosionPlugin == null) {
            return LoopExplosionPlugin.LoopExplosionKind.NONE;
        }
        return loopExplosionPlugin.loopExplosionKind(method);
    }

    public void decode(ResolvedJavaMethod method, boolean isSubstitution, boolean trackNodeSourcePosition) {
        try (DebugContext.Scope scope = this.debug.scope((Object)"PEGraphDecode", this.graph);){
            EncodedGraph encodedGraph = this.lookupEncodedGraph(method, null, null, isSubstitution, trackNodeSourcePosition);
            this.recordGraphElements(encodedGraph);
            PEMethodScope methodScope = new PEMethodScope(this.graph, null, null, encodedGraph, method, null, 0, this.loopExplosionPlugin, null);
            this.decode(this.createInitialLoopScope(methodScope, null));
            this.cleanupGraph(methodScope);
            this.debug.dump(3, this.graph, "After graph cleanup");
            assert (this.graph.verify());
        }
        catch (Throwable t) {
            throw this.debug.handle(t);
        }
        try {
            assert (CFGVerifier.verify(ControlFlowGraph.compute(this.graph, true, true, true, true)));
        }
        catch (Throwable ex) {
            throw GraalError.shouldNotReachHere(ex, "Control flow graph not valid after partial evaluation");
        }
    }

    private void recordGraphElements(EncodedGraph encodedGraph) {
        List<ResolvedJavaMethod> inlinedMethods = encodedGraph.getInlinedMethods();
        if (inlinedMethods != null) {
            for (ResolvedJavaMethod other : inlinedMethods) {
                this.graph.recordMethod(other);
            }
        }
        Assumptions assumptions = this.graph.getAssumptions();
        Assumptions inlinedAssumptions = encodedGraph.getAssumptions();
        if (assumptions != null) {
            if (inlinedAssumptions != null) {
                assumptions.record(inlinedAssumptions);
            }
        } else assert (inlinedAssumptions == null) : String.format("cannot inline graph (%s) which makes assumptions into a graph (%s) that doesn't", encodedGraph, this.graph);
        if (encodedGraph.getFields() != null) {
            for (ResolvedJavaField field : encodedGraph.getFields()) {
                this.graph.recordField(field);
            }
        }
        if (encodedGraph.hasUnsafeAccess()) {
            this.graph.markUnsafeAccess();
        }
    }

    @Override
    protected void cleanupGraph(GraphDecoder.MethodScope methodScope) {
        super.cleanupGraph(methodScope);
        for (FrameState frameState : this.graph.getNodes(FrameState.TYPE)) {
            if (frameState.bci != -1) continue;
            PEMethodScope peMethodScope = (PEMethodScope)methodScope;
            Invoke invoke = peMethodScope.invokeData != null ? peMethodScope.invokeData.invoke : null;
            InliningUtil.handleMissingAfterExceptionFrameState(frameState, invoke, null, true);
            assert (frameState.isDeleted());
        }
        for (FixedAnchorNode anchor : this.graph.getNodes(FixedAnchorNode.TYPE).snapshot()) {
            AbstractBeginNode newAnchor = AbstractBeginNode.prevBegin(anchor);
            assert (newAnchor != null) : "Must find prev begin node";
            anchor.replaceAtUsages((Node)newAnchor, InputType.Guard, InputType.Anchor);
            anchor.replaceAtUsages(anchor.value);
            assert (anchor.hasNoUsages());
            GraphUtil.unlinkFixedNode(anchor);
            anchor.safeDelete();
        }
    }

    @Override
    protected void checkLoopExplosionIteration(GraphDecoder.MethodScope s, GraphDecoder.LoopScope loopScope) {
        PEMethodScope methodScope = (PEMethodScope)s;
        if (loopScope.loopIteration > Options.MaximumLoopExplosionCount.getValue(this.options)) {
            throw PEGraphDecoder.tooManyLoopExplosionIterations(methodScope, this.options);
        }
    }

    private static RuntimeException tooManyLoopExplosionIterations(PEMethodScope methodScope, OptionValues options) {
        String message = "too many loop explosion iterations - does the explosion not terminate for method " + methodScope.method + "?";
        Object bailout = Options.FailedLoopExplosionIsFatal.getValue(options) != false ? new RuntimeException(message) : new PermanentBailoutException(message);
        throw GraphUtil.createBailoutException(message, (Throwable)bailout, methodScope.getCallStack());
    }

    @Override
    protected GraphDecoder.LoopScope handleInvoke(GraphDecoder.MethodScope s, GraphDecoder.LoopScope loopScope, GraphDecoder.InvokeData invokeData) {
        PEMethodScope methodScope = (PEMethodScope)s;
        assert (invokeData.invoke.callTarget() == null) : "callTarget edge is ignored during decoding of Invoke";
        CallTargetNode callTarget = (CallTargetNode)this.decodeFloatingNode(methodScope, loopScope, invokeData.callTargetOrderId);
        if (callTarget instanceof MethodCallTargetNode) {
            GraphDecoder.LoopScope inlineLoopScope;
            MethodCallTargetNode methodCall = (MethodCallTargetNode)callTarget;
            if (methodCall.invokeKind().hasReceiver()) {
                invokeData.constantReceiver = ((ValueNode)methodCall.arguments().get(0)).asJavaConstant();
            }
            if ((inlineLoopScope = this.trySimplifyInvoke(methodScope, loopScope, invokeData, (MethodCallTargetNode)(callTarget = this.trySimplifyCallTarget(methodScope, invokeData, (MethodCallTargetNode)callTarget)))) != null) {
                return inlineLoopScope;
            }
        }
        this.graph.add(callTarget);
        this.registerNode(loopScope, invokeData.callTargetOrderId, callTarget, false, false);
        return super.handleInvoke(methodScope, loopScope, invokeData);
    }

    protected MethodCallTargetNode trySimplifyCallTarget(PEMethodScope methodScope, GraphDecoder.InvokeData invokeData, MethodCallTargetNode callTarget) {
        ResolvedJavaMethod specialCallTarget = this.getSpecialCallTarget(invokeData, callTarget);
        if (specialCallTarget != null) {
            callTarget.setTargetMethod(specialCallTarget);
            callTarget.setInvokeKind(CallTargetNode.InvokeKind.Special);
            return callTarget;
        }
        if (callTarget.invokeKind().isInterface()) {
            Invoke invoke = invokeData.invoke;
            ResolvedJavaType contextType = methodScope.method.getDeclaringClass();
            return MethodCallTargetNode.tryDevirtualizeInterfaceCall(callTarget.receiver(), callTarget.targetMethod(), null, this.graph.getAssumptions(), contextType, callTarget, invoke.asNode());
        }
        return callTarget;
    }

    protected GraphDecoder.LoopScope trySimplifyInvoke(PEMethodScope methodScope, GraphDecoder.LoopScope loopScope, GraphDecoder.InvokeData invokeData, MethodCallTargetNode callTarget) {
        if (this.tryInvocationPlugin(methodScope, loopScope, invokeData, callTarget)) {
            return loopScope;
        }
        GraphDecoder.LoopScope inlineLoopScope = this.tryInline(methodScope, loopScope, invokeData, callTarget);
        if (inlineLoopScope != null) {
            return inlineLoopScope;
        }
        for (InlineInvokePlugin plugin : this.inlineInvokePlugins) {
            plugin.notifyNotInlined(new PENonAppendGraphBuilderContext(methodScope, invokeData.invoke), callTarget.targetMethod(), invokeData.invoke);
        }
        return null;
    }

    private ResolvedJavaMethod getSpecialCallTarget(GraphDecoder.InvokeData invokeData, MethodCallTargetNode callTarget) {
        if (callTarget.invokeKind().isDirect()) {
            return null;
        }
        if (callTarget.targetMethod().canBeStaticallyBound()) {
            return callTarget.targetMethod();
        }
        SpecialCallTargetCacheKey key = new SpecialCallTargetCacheKey(callTarget.invokeKind(), callTarget.targetMethod(), invokeData.contextType, callTarget.receiver().stamp(NodeView.DEFAULT));
        Object specialCallTarget = this.specialCallTargetCache.get((Object)key);
        if (specialCallTarget == null) {
            specialCallTarget = MethodCallTargetNode.devirtualizeCall(key.invokeKind, key.targetMethod, key.contextType, this.graph.getAssumptions(), key.receiverStamp);
            if (specialCallTarget == null) {
                specialCallTarget = CACHED_NULL_VALUE;
            }
            this.specialCallTargetCache.put((Object)key, specialCallTarget);
        }
        return specialCallTarget == CACHED_NULL_VALUE ? null : (ResolvedJavaMethod)specialCallTarget;
    }

    protected boolean tryInvocationPlugin(PEMethodScope methodScope, GraphDecoder.LoopScope loopScope, GraphDecoder.InvokeData invokeData, MethodCallTargetNode callTarget) {
        if (this.invocationPlugins == null || this.invocationPlugins.isEmpty()) {
            return false;
        }
        Invoke invoke = invokeData.invoke;
        ResolvedJavaMethod targetMethod = callTarget.targetMethod();
        if (loopScope.methodScope.encodedGraph.isCallToOriginal(targetMethod)) {
            return false;
        }
        InvocationPlugin invocationPlugin = this.getInvocationPlugin(targetMethod);
        if (invocationPlugin == null) {
            return false;
        }
        if (loopScope.methodScope.encodedGraph.isCallToOriginal(targetMethod)) {
            return false;
        }
        ValueNode[] arguments = callTarget.arguments().toArray((A[])new ValueNode[0]);
        FixedWithNextNode invokePredecessor = (FixedWithNextNode)invoke.asNode().predecessor();
        invoke.asNode().replaceAtPredecessor(null);
        PEMethodScope inlineScope = new PEMethodScope(this.graph, methodScope, loopScope, null, targetMethod, invokeData, methodScope.inliningDepth + 1, this.loopExplosionPlugin, arguments);
        JavaType returnType = targetMethod.getSignature().getReturnType(methodScope.method.getDeclaringClass());
        PEAppendGraphBuilderContext graphBuilderContext = new PEAppendGraphBuilderContext(inlineScope, invokePredecessor, callTarget.invokeKind(), returnType);
        InvocationPlugins.InvocationPluginReceiver invocationPluginReceiver = new InvocationPlugins.InvocationPluginReceiver(graphBuilderContext);
        if (invocationPlugin.execute(graphBuilderContext, targetMethod, invocationPluginReceiver.init(targetMethod, arguments), arguments)) {
            if (!graphBuilderContext.invokeConsumed) {
                if (graphBuilderContext.lastInstr != null) {
                    if (graphBuilderContext.lastInstr instanceof DeoptBciSupplier && !BytecodeFrame.isPlaceholderBci((int)invokeData.invoke.bci()) && BytecodeFrame.isPlaceholderBci((int)((DeoptBciSupplier)((Object)graphBuilderContext.lastInstr)).bci())) {
                        ((DeoptBciSupplier)((Object)graphBuilderContext.lastInstr)).setBci(invokeData.invoke.bci());
                    }
                    this.registerNode(loopScope, invokeData.invokeOrderId, graphBuilderContext.pushedNode, true, true);
                    invoke.asNode().replaceAtUsages(graphBuilderContext.pushedNode);
                    graphBuilderContext.lastInstr.setNext(this.nodeAfterInvoke(methodScope, loopScope, invokeData, AbstractBeginNode.prevBegin(graphBuilderContext.lastInstr)));
                    PEGraphDecoder.deleteInvoke(invoke);
                } else {
                    assert (graphBuilderContext.pushedNode == null) : "Why push a node when the invoke does not return anyway?";
                    invoke.asNode().replaceAtUsages(null);
                    PEGraphDecoder.deleteInvoke(invoke);
                }
            }
            return true;
        }
        invokePredecessor.setNext(invoke.asNode());
        return false;
    }

    private InvocationPlugin getInvocationPlugin(ResolvedJavaMethod targetMethod) {
        Object invocationPlugin = this.invocationPluginCache.get((Object)targetMethod);
        if (invocationPlugin == null) {
            invocationPlugin = this.invocationPlugins.lookupInvocation(targetMethod);
            if (invocationPlugin == null) {
                invocationPlugin = CACHED_NULL_VALUE;
            }
            this.invocationPluginCache.put((Object)targetMethod, invocationPlugin);
        }
        return invocationPlugin == CACHED_NULL_VALUE ? null : (InvocationPlugin)invocationPlugin;
    }

    protected GraphDecoder.LoopScope tryInline(PEMethodScope methodScope, GraphDecoder.LoopScope loopScope, GraphDecoder.InvokeData invokeData, MethodCallTargetNode callTarget) {
        if (!callTarget.invokeKind().isDirect()) {
            return null;
        }
        ResolvedJavaMethod targetMethod = callTarget.targetMethod();
        if (targetMethod.hasNeverInlineDirective()) {
            return null;
        }
        ValueNode[] arguments = callTarget.arguments().toArray((A[])new ValueNode[0]);
        PENonAppendGraphBuilderContext graphBuilderContext = new PENonAppendGraphBuilderContext(methodScope, invokeData.invoke);
        for (InlineInvokePlugin plugin : this.inlineInvokePlugins) {
            InlineInvokePlugin.InlineInfo inlineInfo = plugin.shouldInlineInvoke(graphBuilderContext, targetMethod, arguments);
            if (inlineInfo == null) continue;
            if (inlineInfo.allowsInlining()) {
                return this.doInline(methodScope, loopScope, invokeData, inlineInfo, arguments);
            }
            return null;
        }
        return null;
    }

    protected GraphDecoder.LoopScope doInline(PEMethodScope methodScope, GraphDecoder.LoopScope loopScope, GraphDecoder.InvokeData invokeData, InlineInvokePlugin.InlineInfo inlineInfo, ValueNode[] arguments) {
        if (!invokeData.invoke.useForInlining()) {
            return null;
        }
        ResolvedJavaMethod inlineMethod = inlineInfo.getMethodToInline();
        EncodedGraph graphToInline = this.lookupEncodedGraph(inlineMethod, inlineInfo.getPlugin(), inlineInfo.getIntrinsicBytecodeProvider(), inlineInfo.isSubstitution(), this.graph.trackNodeSourcePosition());
        if (graphToInline == null) {
            return null;
        }
        assert (!this.graph.trackNodeSourcePosition() || graphToInline.trackNodeSourcePosition()) : this.graph + " " + graphToInline;
        if (methodScope.inliningDepth > Options.InliningDepthError.getValue(this.options)) {
            throw PEGraphDecoder.tooDeepInlining(methodScope);
        }
        for (InlineInvokePlugin plugin : this.inlineInvokePlugins) {
            plugin.notifyBeforeInline(inlineMethod);
        }
        Invoke invoke = invokeData.invoke;
        FixedNode invokeNode = invoke.asNode();
        FixedWithNextNode predecessor = (FixedWithNextNode)invokeNode.predecessor();
        invokeNode.replaceAtPredecessor(null);
        PEMethodScope inlineScope = new PEMethodScope(this.graph, methodScope, loopScope, graphToInline, inlineMethod, invokeData, methodScope.inliningDepth + 1, this.loopExplosionPlugin, arguments);
        if (!inlineMethod.isStatic()) {
            if (StampTool.isPointerAlwaysNull(arguments[0])) {
                DeoptimizeNode deoptimizeNode = this.graph.add(new DeoptimizeNode(DeoptimizationAction.InvalidateReprofile, DeoptimizationReason.NullCheckException));
                predecessor.setNext(deoptimizeNode);
                this.finishInlining(inlineScope);
                return loopScope;
            }
            if (!StampTool.isPointerNonNull(arguments[0])) {
                PEAppendGraphBuilderContext graphBuilderContext = new PEAppendGraphBuilderContext(inlineScope, predecessor);
                arguments[0] = graphBuilderContext.nullCheckedValue(arguments[0]);
                predecessor = graphBuilderContext.lastInstr;
            }
        }
        GraphDecoder.LoopScope inlineLoopScope = this.createInitialLoopScope(inlineScope, predecessor);
        int firstArgumentNodeId = inlineScope.maxFixedNodeOrderId + 1;
        for (int i = 0; i < arguments.length; ++i) {
            inlineLoopScope.createdNodes[firstArgumentNodeId + i] = arguments[i];
        }
        this.recordGraphElements(graphToInline);
        return inlineLoopScope;
    }

    @Override
    protected void finishInlining(GraphDecoder.MethodScope is) {
        FixedNode n;
        ValueNode returnValue;
        PEMethodScope inlineScope = (PEMethodScope)is;
        ResolvedJavaMethod inlineMethod = inlineScope.method;
        PEMethodScope methodScope = inlineScope.caller;
        GraphDecoder.LoopScope loopScope = inlineScope.callerLoopScope;
        GraphDecoder.InvokeData invokeData = inlineScope.invokeData;
        Invoke invoke = invokeData.invoke;
        FixedNode invokeNode = invoke.asNode();
        ValueNode exceptionValue = null;
        int returnNodeCount = 0;
        int unwindNodeCount = 0;
        List returnAndUnwindNodes = inlineScope.returnAndUnwindNodes;
        for (int i = 0; i < returnAndUnwindNodes.size(); ++i) {
            FixedNode fixedNode = (FixedNode)returnAndUnwindNodes.get(i);
            if (fixedNode instanceof ReturnNode) {
                ++returnNodeCount;
                continue;
            }
            if (!fixedNode.isAlive()) continue;
            assert (fixedNode instanceof UnwindNode);
            ++unwindNodeCount;
        }
        if (unwindNodeCount > 0) {
            FixedNode unwindReplacement = invoke instanceof InvokeWithExceptionNode ? this.makeStubNode(methodScope, loopScope, invokeData.exceptionNextOrderId) : (FixedNode)this.graph.add(new DeoptimizeNode(DeoptimizationAction.InvalidateRecompile, DeoptimizationReason.NotCompiledExceptionHandler));
            if (unwindNodeCount == 1) {
                UnwindNode unwindNode2 = PEGraphDecoder.getSingleMatchingNode(returnAndUnwindNodes, returnNodeCount > 0, UnwindNode.class);
                exceptionValue = unwindNode2.exception();
                unwindNode2.replaceAndDelete(unwindReplacement);
            } else {
                MergeNode unwindMergeNode = this.graph.add(new MergeNode());
                exceptionValue = InliningUtil.mergeValueProducers(unwindMergeNode, PEGraphDecoder.getMatchingNodes(returnAndUnwindNodes, returnNodeCount > 0, UnwindNode.class, unwindNodeCount), null, unwindNode -> unwindNode.exception());
                unwindMergeNode.setNext(unwindReplacement);
                this.ensureExceptionStateDecoded(inlineScope);
                unwindMergeNode.setStateAfter(inlineScope.exceptionState.duplicateModified(JavaKind.Object, JavaKind.Object, exceptionValue));
            }
            if (invoke instanceof InvokeWithExceptionNode) {
                assert (unwindReplacement != exceptionValue) : "Unschedulable unwind replacement";
                FixedAnchorNode anchor = this.graph.add(new FixedAnchorNode(exceptionValue));
                this.graph.addBeforeFixed(unwindReplacement, anchor);
                exceptionValue = anchor;
                assert (anchor.predecessor() != null);
            }
        }
        assert (invoke.next() == null);
        assert (!(invoke instanceof InvokeWithExceptionNode) || ((InvokeWithExceptionNode)invoke).exceptionEdge() == null);
        if (returnNodeCount == 0) {
            returnValue = null;
        } else if (returnNodeCount == 1) {
            ReturnNode returnNode = PEGraphDecoder.getSingleMatchingNode(returnAndUnwindNodes, unwindNodeCount > 0, ReturnNode.class);
            returnValue = returnNode.result();
            n = this.nodeAfterInvoke(methodScope, loopScope, invokeData, AbstractBeginNode.prevBegin(returnNode));
            returnNode.replaceAndDelete(n);
        } else {
            AbstractMergeNode merge = this.graph.add(new MergeNode());
            merge.setStateAfter((FrameState)this.ensureNodeCreated(methodScope, loopScope, invokeData.stateAfterOrderId));
            returnValue = InliningUtil.mergeReturns(merge, PEGraphDecoder.getMatchingNodes(returnAndUnwindNodes, unwindNodeCount > 0, ReturnNode.class, returnNodeCount));
            n = this.nodeAfterInvoke(methodScope, loopScope, invokeData, merge);
            merge.setNext(n);
        }
        invokeNode.replaceAtUsages(returnValue);
        this.registerNode(loopScope, invokeData.invokeOrderId, returnValue, true, true);
        if (invoke instanceof InvokeWithExceptionNode) {
            this.registerNode(loopScope, invokeData.exceptionOrderId, exceptionValue, true, true);
        }
        if (inlineScope.exceptionPlaceholderNode != null) {
            inlineScope.exceptionPlaceholderNode.replaceAtUsagesAndDelete(exceptionValue);
        }
        PEGraphDecoder.deleteInvoke(invoke);
        assert (exceptionValue == null || exceptionValue instanceof FixedAnchorNode && exceptionValue.predecessor() != null);
        for (InlineInvokePlugin plugin : this.inlineInvokePlugins) {
            plugin.notifyAfterInline(inlineMethod);
        }
    }

    private static <T> T getSingleMatchingNode(List<ControlSinkNode> returnAndUnwindNodes, boolean hasNonMatchingEntries, Class<T> clazz) {
        if (!hasNonMatchingEntries) {
            assert (returnAndUnwindNodes.size() == 1);
            return (T)returnAndUnwindNodes.get(0);
        }
        for (int i = 0; i < returnAndUnwindNodes.size(); ++i) {
            ControlSinkNode node = returnAndUnwindNodes.get(i);
            if (!clazz.isInstance(node)) continue;
            return (T)node;
        }
        throw GraalError.shouldNotReachHere();
    }

    private static <T> List<T> getMatchingNodes(List<ControlSinkNode> returnAndUnwindNodes, boolean hasNonMatchingEntries, Class<T> clazz, int resultCount) {
        if (!hasNonMatchingEntries) {
            return returnAndUnwindNodes;
        }
        ArrayList<ControlSinkNode> result = new ArrayList<ControlSinkNode>(resultCount);
        for (int i = 0; i < returnAndUnwindNodes.size(); ++i) {
            ControlSinkNode node = returnAndUnwindNodes.get(i);
            if (!clazz.isInstance(node)) continue;
            result.add(node);
        }
        assert (result.size() == resultCount);
        return result;
    }

    /*
     * WARNING - void declaration
     */
    private static RuntimeException tooDeepInlining(PEMethodScope methodScope) {
        void var5_8;
        HashMap<ResolvedJavaMethod, Integer> methodCounts = new HashMap<ResolvedJavaMethod, Integer>();
        PEMethodScope cur = methodScope;
        while (cur != null) {
            Integer oldCount = (Integer)methodCounts.get(cur.method);
            methodCounts.put(cur.method, oldCount == null ? 1 : oldCount + 1);
            cur = cur.caller;
        }
        ArrayList methods = new ArrayList(methodCounts.entrySet());
        methods.sort((e1, e2) -> -Integer.compare((Integer)e1.getValue(), (Integer)e2.getValue()));
        StringBuilder msg = new StringBuilder("Too deep inlining, probably caused by recursive inlining.").append(System.lineSeparator()).append("== Inlined methods ordered by inlining frequency:");
        for (Map.Entry entry : methods) {
            msg.append(System.lineSeparator()).append(((ResolvedJavaMethod)entry.getKey()).format("%H.%n(%p) [")).append(entry.getValue()).append("]");
        }
        msg.append(System.lineSeparator()).append("== Complete stack trace of inlined methods:");
        int lastBci = 0;
        PEMethodScope pEMethodScope = methodScope;
        while (var5_8 != null) {
            msg.append(System.lineSeparator()).append(var5_8.method.asStackTraceElement(lastBci));
            lastBci = var5_8.invokeData != null ? var5_8.invokeData.invoke.bci() : 0;
            PEMethodScope pEMethodScope2 = var5_8.caller;
        }
        throw new PermanentBailoutException(msg.toString());
    }

    public FixedNode nodeAfterInvoke(PEMethodScope methodScope, GraphDecoder.LoopScope loopScope, GraphDecoder.InvokeData invokeData, AbstractBeginNode lastBlock) {
        FixedNode n;
        assert (lastBlock.isAlive());
        if (invokeData.invoke instanceof InvokeWithExceptionNode) {
            this.registerNode(loopScope, invokeData.nextOrderId, lastBlock, false, false);
            n = this.makeStubNode(methodScope, loopScope, invokeData.nextNextOrderId);
        } else {
            n = this.makeStubNode(methodScope, loopScope, invokeData.nextOrderId);
        }
        return n;
    }

    private static void deleteInvoke(Invoke invoke) {
        FrameState frameState = invoke.stateAfter();
        invoke.asNode().safeDelete();
        assert (invoke.callTarget() == null) : "must not have been added to the graph yet";
        if (frameState != null && frameState.hasNoUsages()) {
            frameState.safeDelete();
        }
    }

    protected abstract EncodedGraph lookupEncodedGraph(ResolvedJavaMethod var1, MethodSubstitutionPlugin var2, BytecodeProvider var3, boolean var4, boolean var5);

    @Override
    protected Node canonicalizeFixedNode(GraphDecoder.MethodScope s, Node node) {
        PENonAppendGraphBuilderContext graphBuilderContext;
        PEMethodScope methodScope = (PEMethodScope)s;
        Node replacedNode = node;
        if (this.nodePlugins != null && this.nodePlugins.length > 0) {
            ResolvedJavaType elementType;
            DeoptimizingFixedWithNextNode newArrayNode;
            ValueNode array;
            ResolvedJavaField field;
            if (node instanceof LoadFieldNode) {
                LoadFieldNode loadFieldNode = (LoadFieldNode)node;
                graphBuilderContext = new PEAppendGraphBuilderContext(methodScope, loadFieldNode);
                field = loadFieldNode.field();
                if (loadFieldNode.isStatic()) {
                    for (NodePlugin nodePlugin : this.nodePlugins) {
                        if (!nodePlugin.handleLoadStaticField(graphBuilderContext, field)) continue;
                        replacedNode = ((PEAppendGraphBuilderContext)graphBuilderContext).pushedNode;
                        break;
                    }
                } else {
                    ValueNode object = loadFieldNode.object();
                    for (NodePlugin nodePlugin : this.nodePlugins) {
                        if (!nodePlugin.handleLoadField(graphBuilderContext, object, field)) continue;
                        replacedNode = ((PEAppendGraphBuilderContext)graphBuilderContext).pushedNode;
                        break;
                    }
                }
            } else if (node instanceof StoreFieldNode) {
                StoreFieldNode storeFieldNode = (StoreFieldNode)node;
                graphBuilderContext = new PEAppendGraphBuilderContext(methodScope, storeFieldNode);
                field = storeFieldNode.field();
                if (storeFieldNode.isStatic()) {
                    ValueNode value = storeFieldNode.value();
                    for (NodePlugin nodePlugin : this.nodePlugins) {
                        if (!nodePlugin.handleStoreStaticField(graphBuilderContext, field, value)) continue;
                        replacedNode = ((PEAppendGraphBuilderContext)graphBuilderContext).pushedNode;
                        break;
                    }
                } else {
                    ValueNode object = storeFieldNode.object();
                    ValueNode value = storeFieldNode.value();
                    for (NodePlugin nodePlugin : this.nodePlugins) {
                        if (!nodePlugin.handleStoreField(graphBuilderContext, object, field, value)) continue;
                        replacedNode = ((PEAppendGraphBuilderContext)graphBuilderContext).pushedNode;
                        break;
                    }
                }
            } else if (node instanceof LoadIndexedNode) {
                LoadIndexedNode loadIndexedNode = (LoadIndexedNode)node;
                graphBuilderContext = new PEAppendGraphBuilderContext(methodScope, loadIndexedNode);
                array = loadIndexedNode.array();
                ValueNode index = loadIndexedNode.index();
                for (NodePlugin nodePlugin : this.nodePlugins) {
                    if (!nodePlugin.handleLoadIndexed(graphBuilderContext, array, index, loadIndexedNode.getBoundsCheck(), loadIndexedNode.elementKind())) continue;
                    replacedNode = ((PEAppendGraphBuilderContext)graphBuilderContext).pushedNode;
                    break;
                }
            } else if (node instanceof StoreIndexedNode) {
                StoreIndexedNode storeIndexedNode = (StoreIndexedNode)node;
                graphBuilderContext = new PEAppendGraphBuilderContext(methodScope, storeIndexedNode);
                array = storeIndexedNode.array();
                ValueNode index = storeIndexedNode.index();
                ValueNode value = storeIndexedNode.value();
                for (NodePlugin nodePlugin : this.nodePlugins) {
                    if (!nodePlugin.handleStoreIndexed(graphBuilderContext, array, index, storeIndexedNode.getBoundsCheck(), storeIndexedNode.getStoreCheck(), storeIndexedNode.elementKind(), value)) continue;
                    replacedNode = ((PEAppendGraphBuilderContext)graphBuilderContext).pushedNode;
                    break;
                }
            } else if (node instanceof NewInstanceNode) {
                NewInstanceNode newInstanceNode = (NewInstanceNode)node;
                graphBuilderContext = new PEAppendGraphBuilderContext(methodScope, newInstanceNode);
                ResolvedJavaType type = newInstanceNode.instanceClass();
                for (NodePlugin nodePlugin : this.nodePlugins) {
                    if (!nodePlugin.handleNewInstance(graphBuilderContext, type)) continue;
                    replacedNode = ((PEAppendGraphBuilderContext)graphBuilderContext).pushedNode;
                    break;
                }
            } else if (node instanceof NewArrayNode) {
                newArrayNode = (NewArrayNode)node;
                graphBuilderContext = new PEAppendGraphBuilderContext(methodScope, newArrayNode);
                elementType = ((NewArrayNode)newArrayNode).elementType();
                ValueNode length = ((AbstractNewArrayNode)newArrayNode).length();
                for (NodePlugin nodePlugin : this.nodePlugins) {
                    if (!nodePlugin.handleNewArray(graphBuilderContext, elementType, length)) continue;
                    replacedNode = ((PEAppendGraphBuilderContext)graphBuilderContext).pushedNode;
                    break;
                }
            } else if (node instanceof NewMultiArrayNode) {
                newArrayNode = (NewMultiArrayNode)node;
                graphBuilderContext = new PEAppendGraphBuilderContext(methodScope, newArrayNode);
                elementType = ((NewMultiArrayNode)newArrayNode).type();
                ValueNode[] dimensions = ((NewMultiArrayNode)newArrayNode).dimensions().toArray((A[])new ValueNode[0]);
                for (NodePlugin nodePlugin : this.nodePlugins) {
                    if (!nodePlugin.handleNewMultiArray(graphBuilderContext, elementType, dimensions)) continue;
                    replacedNode = ((PEAppendGraphBuilderContext)graphBuilderContext).pushedNode;
                    break;
                }
            }
        }
        if (node instanceof PluginReplacementNode) {
            PluginReplacementNode pluginReplacementNode = (PluginReplacementNode)node;
            graphBuilderContext = new PEPluginGraphBuilderContext(methodScope, pluginReplacementNode);
            boolean success = pluginReplacementNode.replace(graphBuilderContext, this.providers.getReplacements());
            if (success) {
                replacedNode = graphBuilderContext.pushedNode;
            } else if (this.pluginReplacementMustSucceed()) {
                throw new GraalError("Plugin failed:" + node);
            }
        }
        return super.canonicalizeFixedNode(methodScope, replacedNode);
    }

    protected boolean pluginReplacementMustSucceed() {
        return false;
    }

    @Override
    protected Node handleFloatingNodeBeforeAdd(GraphDecoder.MethodScope s, GraphDecoder.LoopScope loopScope, Node n) {
        PEMethodScope methodScope = (PEMethodScope)s;
        Node node = n;
        if (node instanceof ParameterNode) {
            ParameterNode param = (ParameterNode)node;
            if (methodScope.isInlinedMethod()) {
                throw GraalError.shouldNotReachHere("Parameter nodes are already registered when the inlined scope is created");
            }
            if (this.parameterPlugin != null) {
                assert (!methodScope.isInlinedMethod());
                PENonAppendGraphBuilderContext graphBuilderContext = new PENonAppendGraphBuilderContext(methodScope, null);
                FloatingNode result = this.parameterPlugin.interceptParameter(graphBuilderContext, param.index(), StampPair.create(param.stamp(NodeView.DEFAULT), param.uncheckedStamp()));
                if (result != null) {
                    return result;
                }
            }
            node = param.copyWithInputs();
        }
        return super.handleFloatingNodeBeforeAdd(methodScope, loopScope, node);
    }

    protected void ensureOuterStateDecoded(PEMethodScope methodScope) {
        if (methodScope.outerState == null && methodScope.caller != null) {
            FrameState stateAtReturn = methodScope.invokeData.invoke.stateAfter();
            if (stateAtReturn == null) {
                stateAtReturn = (FrameState)this.decodeFloatingNode(methodScope.caller, methodScope.callerLoopScope, methodScope.invokeData.stateAfterOrderId);
            }
            JavaKind invokeReturnKind = methodScope.invokeData.invoke.asNode().getStackKind();
            FrameState outerState = stateAtReturn.duplicateModified(this.graph, methodScope.invokeData.invoke.bci(), stateAtReturn.rethrowException(), true, invokeReturnKind, null, null);
            if (outerState.outerFrameState() == null && methodScope.caller != null) {
                this.ensureOuterStateDecoded(methodScope.caller);
                outerState.setOuterFrameState(methodScope.caller.outerState);
            }
            methodScope.outerState = outerState;
        }
    }

    protected void ensureStateAfterDecoded(PEMethodScope methodScope) {
        if (methodScope.invokeData.invoke.stateAfter() == null) {
            methodScope.invokeData.invoke.setStateAfter((FrameState)this.ensureNodeCreated(methodScope.caller, methodScope.callerLoopScope, methodScope.invokeData.stateAfterOrderId));
        }
    }

    protected void ensureExceptionStateDecoded(PEMethodScope methodScope) {
        if (methodScope.exceptionState == null && methodScope.caller != null && methodScope.invokeData.invoke instanceof InvokeWithExceptionNode) {
            this.ensureStateAfterDecoded(methodScope);
            assert (methodScope.exceptionPlaceholderNode == null);
            methodScope.exceptionPlaceholderNode = this.graph.add(new ExceptionPlaceholderNode());
            this.registerNode(methodScope.callerLoopScope, methodScope.invokeData.exceptionOrderId, methodScope.exceptionPlaceholderNode, false, false);
            FrameState exceptionState = (FrameState)this.ensureNodeCreated(methodScope.caller, methodScope.callerLoopScope, methodScope.invokeData.exceptionStateOrderId);
            if (exceptionState.outerFrameState() == null && methodScope.caller != null) {
                this.ensureOuterStateDecoded(methodScope.caller);
                exceptionState.setOuterFrameState(methodScope.caller.outerState);
            }
            methodScope.exceptionState = exceptionState;
        }
    }

    @Override
    protected Node handleFloatingNodeAfterAdd(GraphDecoder.MethodScope s, GraphDecoder.LoopScope loopScope, Node node) {
        PEMethodScope methodScope = (PEMethodScope)s;
        if (methodScope.isInlinedMethod()) {
            if (node instanceof FrameState) {
                FrameState frameState = (FrameState)node;
                this.ensureOuterStateDecoded(methodScope);
                if (frameState.bci < 0) {
                    this.ensureExceptionStateDecoded(methodScope);
                }
                List<ValueNode> invokeArgsList = null;
                if (frameState.bci == -2) {
                    invokeArgsList = Arrays.asList(methodScope.arguments);
                }
                return InliningUtil.processFrameState(frameState, methodScope.invokeData.invoke, null, methodScope.method, methodScope.exceptionState, methodScope.outerState, true, methodScope.method, invokeArgsList);
            }
            if (node instanceof MonitorIdNode) {
                this.ensureOuterStateDecoded(methodScope);
                InliningUtil.processMonitorId(methodScope.outerState, (MonitorIdNode)node);
                return node;
            }
        }
        return node;
    }

    protected static class SpecialCallTargetCacheKey {
        private final CallTargetNode.InvokeKind invokeKind;
        private final ResolvedJavaMethod targetMethod;
        private final ResolvedJavaType contextType;
        private final Stamp receiverStamp;

        public SpecialCallTargetCacheKey(CallTargetNode.InvokeKind invokeKind, ResolvedJavaMethod targetMethod, ResolvedJavaType contextType, Stamp receiverStamp) {
            this.invokeKind = invokeKind;
            this.targetMethod = targetMethod;
            this.contextType = contextType;
            this.receiverStamp = receiverStamp;
        }

        public int hashCode() {
            return this.invokeKind.hashCode() ^ this.targetMethod.hashCode() ^ this.contextType.hashCode() ^ this.receiverStamp.hashCode();
        }

        public boolean equals(Object obj) {
            if (obj instanceof SpecialCallTargetCacheKey) {
                SpecialCallTargetCacheKey key = (SpecialCallTargetCacheKey)obj;
                return key.invokeKind.equals((Object)this.invokeKind) && key.targetMethod.equals(this.targetMethod) && key.contextType.equals(this.contextType) && key.receiverStamp.equals(this.receiverStamp);
            }
            return false;
        }
    }

    @NodeInfo(allowedUsageTypes={InputType.Anchor, InputType.Guard, InputType.Value}, cycles=NodeCycles.CYCLES_0, size=NodeSize.SIZE_0)
    static final class FixedAnchorNode
    extends FixedWithNextNode
    implements AnchoringNode,
    GuardingNode,
    IterableNodeType {
        public static final NodeClass<FixedAnchorNode> TYPE = NodeClass.create(FixedAnchorNode.class);
        @Node.Input
        ValueNode value;

        protected FixedAnchorNode(ValueNode value) {
            super((NodeClass<? extends FixedWithNextNode>)TYPE, value.stamp(NodeView.DEFAULT));
            this.value = value;
        }
    }

    @NodeInfo(cycles=NodeCycles.CYCLES_IGNORED, size=NodeSize.SIZE_IGNORED, allowedUsageTypes={InputType.Value, InputType.Guard, InputType.Anchor})
    static class ExceptionPlaceholderNode
    extends ValueNode {
        public static final NodeClass<ExceptionPlaceholderNode> TYPE = NodeClass.create(ExceptionPlaceholderNode.class);

        protected ExceptionPlaceholderNode() {
            super(TYPE, StampFactory.object());
        }
    }

    protected class PEPluginGraphBuilderContext
    extends PENonAppendGraphBuilderContext {
        protected FixedWithNextNode insertBefore;
        protected ValueNode pushedNode;

        public PEPluginGraphBuilderContext(PEMethodScope inlineScope, FixedWithNextNode insertBefore) {
            super(inlineScope, inlineScope.invokeData != null ? inlineScope.invokeData.invoke : null);
            this.insertBefore = insertBefore;
        }

        @Override
        public void push(JavaKind kind, ValueNode value) {
            if (this.pushedNode != null) {
                throw GraalError.unimplemented("Only one push is supported");
            }
            this.pushedNode = value;
        }

        @Override
        public void setStateAfter(StateSplit sideEffect) {
            assert (sideEffect.hasSideEffect());
            FrameState stateAfter = this.getGraph().add(new FrameState(-2));
            sideEffect.setStateAfter(stateAfter);
        }

        @Override
        public <T extends ValueNode> T append(T v) {
            if (v.graph() != null) {
                return v;
            }
            try (DebugCloseable position = this.withNodeSoucePosition();){
                T added = this.getGraph().addOrUniqueWithInputs(v);
                if (added == v) {
                    this.updateLastInstruction(v);
                }
                T t = added;
                return t;
            }
        }

        private DebugCloseable withNodeSoucePosition() {
            NodeSourcePosition callerBytecodePosition;
            if (this.getGraph().trackNodeSourcePosition() && (callerBytecodePosition = this.methodScope.getCallerBytecodePosition()) != null) {
                return this.getGraph().withNodeSourcePosition(callerBytecodePosition);
            }
            return null;
        }

        private <T extends ValueNode> void updateLastInstruction(T value) {
            if (value instanceof FixedWithNextNode) {
                FixedWithNextNode fixed = (FixedWithNextNode)value;
                PEGraphDecoder.this.graph.addBeforeFixed(this.insertBefore, fixed);
            } else if (value instanceof FixedNode) {
                throw GraalError.shouldNotReachHere();
            }
        }
    }

    protected class PEAppendGraphBuilderContext
    extends PENonAppendGraphBuilderContext {
        protected FixedWithNextNode lastInstr;
        protected ValueNode pushedNode;
        protected boolean invokeConsumed;
        protected final CallTargetNode.InvokeKind invokeKind;
        protected final JavaType invokeReturnType;

        public PEAppendGraphBuilderContext(PEMethodScope inlineScope, FixedWithNextNode lastInstr) {
            this(inlineScope, lastInstr, null, null);
        }

        public PEAppendGraphBuilderContext(PEMethodScope inlineScope, FixedWithNextNode lastInstr, CallTargetNode.InvokeKind invokeKind, JavaType invokeReturnType) {
            super(inlineScope, inlineScope.invokeData != null ? inlineScope.invokeData.invoke : null);
            this.lastInstr = lastInstr;
            this.invokeKind = invokeKind;
            this.invokeReturnType = invokeReturnType;
        }

        @Override
        public void push(JavaKind kind, ValueNode value) {
            if (this.pushedNode != null) {
                throw GraalError.unimplemented("Only one push is supported");
            }
            this.pushedNode = value;
        }

        @Override
        public void setStateAfter(StateSplit stateSplit) {
            Node stateAfter = PEGraphDecoder.this.decodeFloatingNode(this.methodScope.caller, this.methodScope.callerLoopScope, this.methodScope.invokeData.stateAfterOrderId);
            this.getGraph().add(stateAfter);
            FrameState fs = (FrameState)PEGraphDecoder.this.handleFloatingNodeAfterAdd(this.methodScope.caller, this.methodScope.callerLoopScope, stateAfter);
            stateSplit.setStateAfter(fs);
        }

        @Override
        public <T extends ValueNode> T append(T v) {
            if (v.graph() != null) {
                return v;
            }
            try (DebugCloseable position = this.withNodeSoucePosition();){
                T added = this.getGraph().addOrUniqueWithInputs(v);
                if (added == v) {
                    this.updateLastInstruction(v);
                }
                T t = added;
                return t;
            }
        }

        private DebugCloseable withNodeSoucePosition() {
            NodeSourcePosition callerBytecodePosition;
            if (this.getGraph().trackNodeSourcePosition() && (callerBytecodePosition = this.methodScope.getCallerBytecodePosition()) != null) {
                return this.getGraph().withNodeSourcePosition(callerBytecodePosition);
            }
            return null;
        }

        private <T extends ValueNode> void updateLastInstruction(T v) {
            if (v instanceof FixedNode) {
                FixedNode fixedNode = (FixedNode)v;
                if (this.lastInstr != null) {
                    this.lastInstr.setNext(fixedNode);
                }
                if (fixedNode instanceof FixedWithNextNode) {
                    FixedWithNextNode fixedWithNextNode = (FixedWithNextNode)fixedNode;
                    assert (fixedWithNextNode.next() == null) : "cannot append instruction to instruction which isn't end";
                    this.lastInstr = fixedWithNextNode;
                } else {
                    this.lastInstr = null;
                }
            }
        }

        @Override
        public CallTargetNode.InvokeKind getInvokeKind() {
            if (this.invokeKind != null) {
                return this.invokeKind;
            }
            return super.getInvokeKind();
        }

        @Override
        public JavaType getInvokeReturnType() {
            if (this.invokeReturnType != null) {
                return this.invokeReturnType;
            }
            return super.getInvokeReturnType();
        }

        @Override
        public void handleReplacedInvoke(CallTargetNode callTarget, JavaKind resultType) {
            if (this.invokeConsumed) {
                throw GraalError.unimplemented("handleReplacedInvoke can be called only once");
            }
            this.invokeConsumed = true;
            PEGraphDecoder.this.appendInvoke(this.methodScope.caller, this.methodScope.callerLoopScope, this.methodScope.invokeData, callTarget);
            this.updateLastInstruction(this.invoke.asNode());
        }

        @Override
        public GraphBuilderContext getNonIntrinsicAncestor() {
            return null;
        }
    }

    protected class PENonAppendGraphBuilderContext
    implements GraphBuilderContext {
        protected final PEMethodScope methodScope;
        protected final Invoke invoke;

        @Override
        public GraphBuilderContext.ExternalInliningContext getExternalInliningContext() {
            return new GraphBuilderContext.ExternalInliningContext(){

                @Override
                public int getInlinedDepth() {
                    int count = 0;
                    PEMethodScope scope = PENonAppendGraphBuilderContext.this.methodScope;
                    while (scope != null) {
                        if (scope.method.equals(PEGraphDecoder.this.peRootForInlining)) {
                            ++count;
                        }
                        scope = scope.caller;
                    }
                    return count;
                }
            };
        }

        public PENonAppendGraphBuilderContext(PEMethodScope methodScope, Invoke invoke) {
            this.methodScope = methodScope;
            this.invoke = invoke;
        }

        @Override
        public boolean canDeferPlugin(GeneratedInvocationPlugin plugin) {
            return plugin.isGeneratedFromFoldOrNodeIntrinsic();
        }

        @Override
        public BailoutException bailout(String string) {
            PermanentBailoutException bailout = new PermanentBailoutException(string);
            throw GraphUtil.createBailoutException(string, (Throwable)((Object)bailout), this.methodScope.getCallStack());
        }

        @Override
        public StampProvider getStampProvider() {
            return PEGraphDecoder.this.providers.getStampProvider();
        }

        @Override
        public MetaAccessProvider getMetaAccess() {
            return PEGraphDecoder.this.providers.getMetaAccess();
        }

        @Override
        public ConstantReflectionProvider getConstantReflection() {
            return PEGraphDecoder.this.providers.getConstantReflection();
        }

        @Override
        public ConstantFieldProvider getConstantFieldProvider() {
            return PEGraphDecoder.this.providers.getConstantFieldProvider();
        }

        @Override
        public Replacements getReplacements() {
            return PEGraphDecoder.this.providers.getReplacements();
        }

        @Override
        public StructuredGraph getGraph() {
            return PEGraphDecoder.this.graph;
        }

        @Override
        public int getDepth() {
            return this.methodScope.inliningDepth;
        }

        @Override
        public IntrinsicContext getIntrinsic() {
            return PEGraphDecoder.this.getIntrinsic();
        }

        @Override
        public <T extends ValueNode> T append(T value) {
            throw GraalError.unimplemented();
        }

        @Override
        public void push(JavaKind kind, ValueNode value) {
            throw GraalError.unimplemented();
        }

        @Override
        public Invoke handleReplacedInvoke(CallTargetNode.InvokeKind invokeKind, ResolvedJavaMethod targetMethod, ValueNode[] args, boolean inlineEverything) {
            throw GraalError.unimplemented();
        }

        @Override
        public void handleReplacedInvoke(CallTargetNode callTarget, JavaKind resultType) {
            throw GraalError.unimplemented();
        }

        @Override
        public boolean intrinsify(BytecodeProvider bytecodeProvider, ResolvedJavaMethod targetMethod, ResolvedJavaMethod substitute, InvocationPlugin.Receiver receiver, ValueNode[] args) {
            return false;
        }

        @Override
        public boolean intrinsify(ResolvedJavaMethod targetMethod, StructuredGraph substituteGraph, InvocationPlugin.Receiver receiver, ValueNode[] argsIncludingReceiver) {
            return false;
        }

        @Override
        public void setStateAfter(StateSplit stateSplit) {
            throw GraalError.unimplemented();
        }

        @Override
        public GraphBuilderContext getParent() {
            throw GraalError.unimplemented();
        }

        @Override
        public Bytecode getCode() {
            throw GraalError.unimplemented();
        }

        @Override
        public ResolvedJavaMethod getMethod() {
            return this.methodScope.method;
        }

        @Override
        public int bci() {
            return -1;
        }

        @Override
        public CallTargetNode.InvokeKind getInvokeKind() {
            throw GraalError.unimplemented();
        }

        @Override
        public JavaType getInvokeReturnType() {
            throw GraalError.unimplemented();
        }

        public String toString() {
            Formatter fmt = new Formatter();
            fmt.format("Decoding %s", this.methodScope.method.format("%H.%n(%p)"));
            for (StackTraceElement e : this.methodScope.getCallStack()) {
                fmt.format("%n\tat %s", e);
            }
            return fmt.toString();
        }
    }

    private static final class UnresolvedSourceLanguagePosition
    implements SourceLanguagePosition {
        static final SourceLanguagePosition INSTANCE = new UnresolvedSourceLanguagePosition();

        private UnresolvedSourceLanguagePosition() {
        }

        @Override
        public String toShortString() {
            throw new IllegalStateException(this.getClass().getSimpleName() + " should not be reachable.");
        }

        @Override
        public int getOffsetEnd() {
            throw new IllegalStateException(this.getClass().getSimpleName() + " should not be reachable.");
        }

        @Override
        public int getOffsetStart() {
            throw new IllegalStateException(this.getClass().getSimpleName() + " should not be reachable.");
        }

        @Override
        public int getLineNumber() {
            throw new IllegalStateException(this.getClass().getSimpleName() + " should not be reachable.");
        }

        @Override
        public URI getURI() {
            throw new IllegalStateException(this.getClass().getSimpleName() + " should not be reachable.");
        }

        @Override
        public String getLanguage() {
            throw new IllegalStateException(this.getClass().getSimpleName() + " should not be reachable.");
        }
    }

    protected class PEMethodScope
    extends GraphDecoder.MethodScope {
        protected final PEMethodScope caller;
        protected final ResolvedJavaMethod method;
        protected final GraphDecoder.InvokeData invokeData;
        protected final int inliningDepth;
        protected final ValueNode[] arguments;
        private SourceLanguagePosition sourceLanguagePosition;
        protected FrameState outerState;
        protected FrameState exceptionState;
        protected ExceptionPlaceholderNode exceptionPlaceholderNode;
        protected NodeSourcePosition callerBytecodePosition;

        protected PEMethodScope(StructuredGraph targetGraph, PEMethodScope caller, GraphDecoder.LoopScope callerLoopScope, EncodedGraph encodedGraph, ResolvedJavaMethod method, GraphDecoder.InvokeData invokeData, int inliningDepth, LoopExplosionPlugin loopExplosionPlugin, ValueNode[] arguments) {
            super(callerLoopScope, targetGraph, encodedGraph, PEGraphDecoder.loopExplosionKind(method, loopExplosionPlugin));
            this.sourceLanguagePosition = UnresolvedSourceLanguagePosition.INSTANCE;
            this.caller = caller;
            this.method = method;
            this.invokeData = invokeData;
            this.inliningDepth = inliningDepth;
            this.arguments = arguments;
        }

        @Override
        public boolean isInlinedMethod() {
            return this.caller != null;
        }

        public StackTraceElement[] getCallStack() {
            StackTraceElement[] stack = new StackTraceElement[this.inliningDepth + 1];
            PEMethodScope frame = this;
            int index = 0;
            int bci = -1;
            while (frame != null) {
                stack[index++] = frame.method.asStackTraceElement(bci);
                bci = frame.invokeData == null ? 0 : frame.invokeData.invoke.bci();
                frame = frame.caller;
            }
            assert (index == stack.length) : index + " != " + stack.length;
            return stack;
        }

        @Override
        public NodeSourcePosition getCallerBytecodePosition(NodeSourcePosition position) {
            if (this.caller == null) {
                return position;
            }
            if (this.callerBytecodePosition == null) {
                NodeSourcePosition invokePosition = this.invokeData.invoke.asNode().getNodeSourcePosition();
                if (invokePosition == null) {
                    assert (position == null) : "should only happen when tracking is disabled";
                    return null;
                }
                this.callerBytecodePosition = invokePosition;
            }
            if (position != null) {
                return position.addCaller(this.caller.resolveSourceLanguagePosition(), this.callerBytecodePosition);
            }
            SourceLanguagePosition pos = this.caller.resolveSourceLanguagePosition();
            if (pos != null && this.callerBytecodePosition != null) {
                return new NodeSourcePosition(pos, this.callerBytecodePosition.getCaller(), this.callerBytecodePosition.getMethod(), this.callerBytecodePosition.getBCI());
            }
            return this.callerBytecodePosition;
        }

        private SourceLanguagePosition resolveSourceLanguagePosition() {
            SourceLanguagePosition res = this.sourceLanguagePosition;
            if (res == UnresolvedSourceLanguagePosition.INSTANCE) {
                res = null;
                if (this.arguments != null && this.method.hasReceiver() && this.arguments.length > 0 && this.arguments[0].isJavaConstant()) {
                    JavaConstant constantArgument = this.arguments[0].asJavaConstant();
                    res = PEGraphDecoder.this.sourceLanguagePositionProvider.getPosition(constantArgument);
                }
                this.sourceLanguagePosition = res;
            }
            return res;
        }

        public String toString() {
            return this.getClass().getSimpleName() + '[' + this.method.format("%H.%n(%p)") + ']';
        }
    }

    public static class Options {
        @Option(help={"Maximum inlining depth during partial evaluation before reporting an infinite recursion"})
        public static final OptionKey<Integer> InliningDepthError = new OptionKey<Integer>(1000);
        @Option(help={"Max number of loop explosions per method."}, type=OptionType.Debug)
        public static final OptionKey<Integer> MaximumLoopExplosionCount = new OptionKey<Integer>(10000);
        @Option(help={"Do not bail out but throw an exception on failed loop explosion."}, type=OptionType.Debug)
        public static final OptionKey<Boolean> FailedLoopExplosionIsFatal = new OptionKey<Boolean>(false);
    }
}

