/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.compiler.replacements;

import jdk.vm.ci.code.TargetDescription;
import jdk.vm.ci.meta.JavaConstant;
import jdk.vm.ci.meta.JavaKind;
import jdk.vm.ci.meta.MetaAccessProvider;
import org.graalvm.compiler.api.replacements.Snippet;
import org.graalvm.compiler.api.replacements.SnippetReflectionProvider;
import org.graalvm.compiler.debug.DebugHandlersFactory;
import org.graalvm.compiler.nodes.StructuredGraph;
import org.graalvm.compiler.nodes.spi.LoweringTool;
import org.graalvm.compiler.nodes.util.ConstantReflectionUtil;
import org.graalvm.compiler.options.OptionValues;
import org.graalvm.compiler.phases.util.Providers;
import org.graalvm.compiler.replacements.ReplacementsUtil;
import org.graalvm.compiler.replacements.SnippetLowerableMemoryNode;
import org.graalvm.compiler.replacements.SnippetTemplate;
import org.graalvm.compiler.replacements.Snippets;
import org.graalvm.compiler.replacements.nodes.ExplodeLoopNode;
import org.graalvm.compiler.serviceprovider.GraalUnsafeAccess;
import org.graalvm.word.LocationIdentity;
import sun.misc.Unsafe;

public class ConstantStringIndexOfSnippets
implements Snippets {
    private static final Unsafe UNSAFE = GraalUnsafeAccess.getUnsafe();
    static final MetaAccessProvider INJECTED = null;

    static int md2(char[] target) {
        int c = target.length;
        if (c == 0) {
            return 0;
        }
        char lastChar = target[c - 1];
        int md2 = c;
        for (int i = 0; i < c - 1; ++i) {
            if (target[i] != lastChar) continue;
            md2 = c - 1 - i;
        }
        return md2;
    }

    static long computeCache(char[] s) {
        int c = s.length;
        int cache = 0;
        for (int i = 0; i < c - 1; ++i) {
            cache |= 1 << (s[i] & 0x3F);
        }
        return cache;
    }

    static int md2(byte[] target) {
        int c = target.length;
        if (c == 0) {
            return 0;
        }
        byte lastByte = target[c - 1];
        int md2 = c;
        for (int i = 0; i < c - 1; ++i) {
            if (target[i] != lastByte) continue;
            md2 = c - 1 - i;
        }
        return md2;
    }

    static long computeCache(byte[] s) {
        int c = s.length;
        int cache = 0;
        for (int i = 0; i < c - 1; ++i) {
            cache |= 1 << (s[i] & 0x3F);
        }
        return cache;
    }

    static int md2Utf16(MetaAccessProvider metaAccess, byte[] target) {
        int c = target.length / 2;
        if (c == 0) {
            return 0;
        }
        long base = metaAccess.getArrayBaseOffset(JavaKind.Byte);
        char lastChar = UNSAFE.getChar(target, base + (long)((c - 1) * 2));
        int md2 = c;
        for (int i = 0; i < c - 1; ++i) {
            char currChar = UNSAFE.getChar(target, base + (long)(i * 2));
            if (currChar != lastChar) continue;
            md2 = c - 1 - i;
        }
        return md2;
    }

    static long computeCacheUtf16(MetaAccessProvider metaAccess, byte[] s) {
        int c = s.length / 2;
        int cache = 0;
        long base = metaAccess.getArrayBaseOffset(JavaKind.Byte);
        for (int i = 0; i < c - 1; ++i) {
            char currChar = UNSAFE.getChar(s, base + (long)(i * 2));
            cache |= 1 << (currChar & 0x3F);
        }
        return cache;
    }

    @Snippet
    public static int indexOfConstant(char[] source, int sourceOffset, int sourceCount, @Snippet.ConstantParameter char[] target, int targetOffset, int targetCount, int origFromIndex, @Snippet.ConstantParameter int md2, @Snippet.ConstantParameter long cache) {
        int fromIndex = origFromIndex;
        if (fromIndex >= sourceCount) {
            return targetCount == 0 ? sourceCount : -1;
        }
        if (fromIndex < 0) {
            fromIndex = 0;
        }
        if (targetCount == 0) {
            return fromIndex;
        }
        int targetCountLess1 = targetCount - 1;
        int sourceEnd = sourceCount - targetCountLess1;
        long base = ReplacementsUtil.charArrayBaseOffset(INJECTED);
        char lastChar = UNSAFE.getChar(target, base + (long)(targetCountLess1 * 2));
        long i = sourceOffset + fromIndex;
        block0: while (i < (long)sourceEnd) {
            char src = UNSAFE.getChar(source, base + (i + (long)targetCountLess1) * 2L);
            if (src == lastChar) {
                if (targetCount <= 8) {
                    ExplodeLoopNode.explodeLoop();
                }
                for (long j = 0L; j < (long)targetCountLess1; ++j) {
                    char sourceChar = UNSAFE.getChar(source, base + (i + j) * 2L);
                    if (UNSAFE.getChar(target, base + ((long)targetOffset + j) * 2L) == sourceChar) continue;
                    if ((cache & (long)('\u0001' << sourceChar)) == 0L && (long)md2 < j + 1L) {
                        i += j + 1L;
                        continue block0;
                    }
                    i += (long)md2;
                    continue block0;
                }
                return (int)(i - (long)sourceOffset);
            }
            if ((cache & (long)('\u0001' << src)) == 0L) {
                i += (long)targetCountLess1;
            }
            ++i;
        }
        return -1;
    }

    @Snippet
    public static int utf16IndexOfConstant(byte[] source, int sourceCount, @Snippet.ConstantParameter byte[] target, int targetCount, int origFromIndex, @Snippet.ConstantParameter int md2, @Snippet.ConstantParameter long cache) {
        int fromIndex = origFromIndex;
        if (fromIndex >= sourceCount) {
            return targetCount == 0 ? sourceCount : -1;
        }
        if (fromIndex < 0) {
            fromIndex = 0;
        }
        if (targetCount == 0) {
            return fromIndex;
        }
        int targetCountLess1 = targetCount - 1;
        int sourceEnd = sourceCount - targetCountLess1;
        long base = ReplacementsUtil.byteArrayBaseOffset(INJECTED);
        char lastChar = UNSAFE.getChar(target, base + (long)(targetCountLess1 * 2));
        long i = fromIndex;
        block0: while (i < (long)sourceEnd) {
            char src = UNSAFE.getChar(source, base + (i + (long)targetCountLess1) * 2L);
            if (src == lastChar) {
                if (targetCount <= 8) {
                    ExplodeLoopNode.explodeLoop();
                }
                for (long j = 0L; j < (long)targetCountLess1; ++j) {
                    char sourceChar = UNSAFE.getChar(source, base + (i + j) * 2L);
                    if (UNSAFE.getChar(target, base + j * 2L) == sourceChar) continue;
                    if ((cache & (long)('\u0001' << sourceChar)) == 0L && (long)md2 < j + 1L) {
                        i += j + 1L;
                        continue block0;
                    }
                    i += (long)md2;
                    continue block0;
                }
                return (int)i;
            }
            if ((cache & (long)('\u0001' << src)) == 0L) {
                i += (long)targetCountLess1;
            }
            ++i;
        }
        return -1;
    }

    @Snippet
    public static int latin1IndexOfConstant(byte[] source, int sourceCount, @Snippet.ConstantParameter byte[] target, int targetCount, int origFromIndex, @Snippet.ConstantParameter int md2, @Snippet.ConstantParameter long cache) {
        int fromIndex = origFromIndex;
        if (fromIndex >= sourceCount) {
            return targetCount == 0 ? sourceCount : -1;
        }
        if (fromIndex < 0) {
            fromIndex = 0;
        }
        if (targetCount == 0) {
            return fromIndex;
        }
        int targetCountLess1 = targetCount - 1;
        int sourceEnd = sourceCount - targetCountLess1;
        long base = ReplacementsUtil.byteArrayBaseOffset(INJECTED);
        byte lastByte = UNSAFE.getByte(target, base + (long)targetCountLess1);
        long i = fromIndex;
        block0: while (i < (long)sourceEnd) {
            byte src = UNSAFE.getByte(source, base + i + (long)targetCountLess1);
            if (src == lastByte) {
                if (targetCount <= 8) {
                    ExplodeLoopNode.explodeLoop();
                }
                for (long j = 0L; j < (long)targetCountLess1; ++j) {
                    byte sourceByte = UNSAFE.getByte(source, base + i + j);
                    if (UNSAFE.getByte(target, base + j) == sourceByte) continue;
                    if ((cache & (long)(1 << sourceByte)) == 0L && (long)md2 < j + 1L) {
                        i += j + 1L;
                        continue block0;
                    }
                    i += (long)md2;
                    continue block0;
                }
                return (int)i;
            }
            if ((cache & (long)(1 << src)) == 0L) {
                i += (long)targetCountLess1;
            }
            ++i;
        }
        return -1;
    }

    public static class Templates
    extends SnippetTemplate.AbstractTemplates {
        private final SnippetTemplate.SnippetInfo indexOfConstant = this.snippet(ConstantStringIndexOfSnippets.class, "indexOfConstant", new LocationIdentity[0]);
        private final SnippetTemplate.SnippetInfo latin1IndexOfConstant = this.snippet(ConstantStringIndexOfSnippets.class, "latin1IndexOfConstant", new LocationIdentity[0]);
        private final SnippetTemplate.SnippetInfo utf16IndexOfConstant = this.snippet(ConstantStringIndexOfSnippets.class, "utf16IndexOfConstant", new LocationIdentity[0]);

        public Templates(OptionValues options, Iterable<DebugHandlersFactory> factories, Providers providers, SnippetReflectionProvider snippetReflection, TargetDescription target) {
            super(options, factories, providers, snippetReflection, target);
        }

        public void lower(SnippetLowerableMemoryNode stringIndexOf, LoweringTool tool) {
            StructuredGraph graph = stringIndexOf.graph();
            SnippetTemplate.Arguments args = new SnippetTemplate.Arguments(this.indexOfConstant, graph.getGuardsStage(), tool.getLoweringStage());
            args.add("source", stringIndexOf.getArgument(0));
            args.add("sourceOffset", stringIndexOf.getArgument(1));
            args.add("sourceCount", stringIndexOf.getArgument(2));
            args.addConst("target", stringIndexOf.getArgument(3));
            args.add("targetOffset", stringIndexOf.getArgument(4));
            args.add("targetCount", stringIndexOf.getArgument(5));
            args.add("origFromIndex", stringIndexOf.getArgument(6));
            JavaConstant targetArg = stringIndexOf.getArgument(3).asJavaConstant();
            char[] targetCharArray = ConstantReflectionUtil.loadCharArrayConstant(this.providers.getConstantReflection(), targetArg, Integer.MAX_VALUE);
            args.addConst("md2", ConstantStringIndexOfSnippets.md2(targetCharArray));
            args.addConst("cache", ConstantStringIndexOfSnippets.computeCache(targetCharArray));
            this.template(stringIndexOf, args).instantiate(this.providers.getMetaAccess(), stringIndexOf, SnippetTemplate.DEFAULT_REPLACER, args);
        }

        public void lowerLatin1(SnippetLowerableMemoryNode latin1IndexOf, LoweringTool tool) {
            StructuredGraph graph = latin1IndexOf.graph();
            SnippetTemplate.Arguments args = new SnippetTemplate.Arguments(this.latin1IndexOfConstant, graph.getGuardsStage(), tool.getLoweringStage());
            args.add("source", latin1IndexOf.getArgument(0));
            args.add("sourceCount", latin1IndexOf.getArgument(1));
            args.addConst("target", latin1IndexOf.getArgument(2));
            args.add("targetCount", latin1IndexOf.getArgument(3));
            args.add("origFromIndex", latin1IndexOf.getArgument(4));
            JavaConstant targetArg = latin1IndexOf.getArgument(2).asJavaConstant();
            byte[] targetByteArray = ConstantReflectionUtil.loadByteArrayConstant(this.providers.getConstantReflection(), targetArg, Integer.MAX_VALUE);
            args.addConst("md2", ConstantStringIndexOfSnippets.md2(targetByteArray));
            args.addConst("cache", ConstantStringIndexOfSnippets.computeCache(targetByteArray));
            this.template(latin1IndexOf, args).instantiate(this.providers.getMetaAccess(), latin1IndexOf, SnippetTemplate.DEFAULT_REPLACER, args);
        }

        public void lowerUTF16(SnippetLowerableMemoryNode utf16IndexOf, LoweringTool tool) {
            StructuredGraph graph = utf16IndexOf.graph();
            SnippetTemplate.Arguments args = new SnippetTemplate.Arguments(this.utf16IndexOfConstant, graph.getGuardsStage(), tool.getLoweringStage());
            args.add("source", utf16IndexOf.getArgument(0));
            args.add("sourceCount", utf16IndexOf.getArgument(1));
            args.addConst("target", utf16IndexOf.getArgument(2));
            args.add("targetCount", utf16IndexOf.getArgument(3));
            args.add("origFromIndex", utf16IndexOf.getArgument(4));
            JavaConstant targetArg = utf16IndexOf.getArgument(2).asJavaConstant();
            byte[] targetByteArray = ConstantReflectionUtil.loadByteArrayConstant(this.providers.getConstantReflection(), targetArg, Integer.MAX_VALUE);
            args.addConst("md2", ConstantStringIndexOfSnippets.md2Utf16(tool.getMetaAccess(), targetByteArray));
            args.addConst("cache", ConstantStringIndexOfSnippets.computeCacheUtf16(tool.getMetaAccess(), targetByteArray));
            this.template(utf16IndexOf, args).instantiate(this.providers.getMetaAccess(), utf16IndexOf, SnippetTemplate.DEFAULT_REPLACER, args);
        }
    }
}

