/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.compiler.replacements;

import jdk.vm.ci.code.Architecture;
import jdk.vm.ci.meta.ResolvedJavaMethod;
import jdk.vm.ci.services.Services;
import org.graalvm.collections.EconomicMap;
import org.graalvm.compiler.bytecode.BytecodeProvider;
import org.graalvm.compiler.core.common.GraalOptions;
import org.graalvm.compiler.debug.DebugCloseable;
import org.graalvm.compiler.debug.DebugContext;
import org.graalvm.compiler.debug.TimerKey;
import org.graalvm.compiler.graph.SourceLanguagePositionProvider;
import org.graalvm.compiler.java.GraphBuilderPhase;
import org.graalvm.compiler.loop.phases.ConvertDeoptimizeToGuardPhase;
import org.graalvm.compiler.nodes.EncodedGraph;
import org.graalvm.compiler.nodes.GraphEncoder;
import org.graalvm.compiler.nodes.StructuredGraph;
import org.graalvm.compiler.nodes.graphbuilderconf.GraphBuilderConfiguration;
import org.graalvm.compiler.nodes.graphbuilderconf.InlineInvokePlugin;
import org.graalvm.compiler.nodes.graphbuilderconf.IntrinsicContext;
import org.graalvm.compiler.nodes.graphbuilderconf.InvocationPlugins;
import org.graalvm.compiler.nodes.graphbuilderconf.LoopExplosionPlugin;
import org.graalvm.compiler.nodes.graphbuilderconf.MethodSubstitutionPlugin;
import org.graalvm.compiler.nodes.graphbuilderconf.NodePlugin;
import org.graalvm.compiler.nodes.graphbuilderconf.ParameterPlugin;
import org.graalvm.compiler.nodes.spi.CoreProviders;
import org.graalvm.compiler.phases.BasePhase;
import org.graalvm.compiler.phases.OptimisticOptimizations;
import org.graalvm.compiler.phases.common.CanonicalizerPhase;
import org.graalvm.compiler.phases.util.Providers;
import org.graalvm.compiler.replacements.PEGraphDecoder;

public class CachingPEGraphDecoder
extends PEGraphDecoder {
    protected final Providers providers;
    protected final GraphBuilderConfiguration graphBuilderConfig;
    protected final OptimisticOptimizations optimisticOpts;
    private final StructuredGraph.AllowAssumptions allowAssumptions;
    private final EconomicMap<ResolvedJavaMethod, EncodedGraph> graphCache;
    private final BasePhase<? super CoreProviders> postParsingPhase;
    private static final TimerKey buildGraphTime = DebugContext.timer("TruffleBuildGraphTime");

    public CachingPEGraphDecoder(Architecture architecture, StructuredGraph graph, Providers providers, GraphBuilderConfiguration graphBuilderConfig, OptimisticOptimizations optimisticOpts, StructuredGraph.AllowAssumptions allowAssumptions, LoopExplosionPlugin loopExplosionPlugin, InvocationPlugins invocationPlugins, InlineInvokePlugin[] inlineInvokePlugins, ParameterPlugin parameterPlugin, NodePlugin[] nodePlugins, ResolvedJavaMethod peRootForInlining, SourceLanguagePositionProvider sourceLanguagePositionProvider, BasePhase<? super CoreProviders> postParsingPhase, EconomicMap<ResolvedJavaMethod, EncodedGraph> graphCache) {
        super(architecture, graph, providers, loopExplosionPlugin, invocationPlugins, inlineInvokePlugins, parameterPlugin, nodePlugins, peRootForInlining, sourceLanguagePositionProvider);
        this.providers = providers;
        this.graphBuilderConfig = graphBuilderConfig;
        this.optimisticOpts = optimisticOpts;
        this.allowAssumptions = allowAssumptions;
        this.graphCache = graphCache;
        this.postParsingPhase = postParsingPhase;
    }

    protected GraphBuilderPhase.Instance createGraphBuilderPhaseInstance(IntrinsicContext initialIntrinsicContext) {
        return new GraphBuilderPhase.Instance(this.providers, this.graphBuilderConfig, this.optimisticOpts, initialIntrinsicContext);
    }

    private EncodedGraph createGraph(ResolvedJavaMethod method, MethodSubstitutionPlugin plugin, BytecodeProvider intrinsicBytecodeProvider, boolean isSubstitution) {
        StructuredGraph graphToEncode = isSubstitution && (GraalOptions.UseEncodedGraphs.getValue(this.options) != false || Services.IS_IN_NATIVE_IMAGE) ? this.providers.getReplacements().getMethodSubstitution(plugin, method, IntrinsicContext.CompilationContext.INLINE_AFTER_PARSING, this.allowAssumptions, null, this.options) : this.buildGraph(method, plugin, intrinsicBytecodeProvider, isSubstitution);
        try (DebugContext.Scope scope = this.debug.scope((Object)"createGraph", graphToEncode);){
            new ConvertDeoptimizeToGuardPhase().apply(graphToEncode, this.providers);
        }
        catch (Throwable t) {
            throw this.debug.handle(t);
        }
        EncodedGraph encodedGraph = GraphEncoder.encodeSingleGraph(graphToEncode, this.architecture);
        this.graphCache.put((Object)method, (Object)encodedGraph);
        return encodedGraph;
    }

    private StructuredGraph buildGraph(ResolvedJavaMethod method, MethodSubstitutionPlugin plugin, BytecodeProvider intrinsicBytecodeProvider, boolean isSubstitution) {
        StructuredGraph graphToEncode = new StructuredGraph.Builder(this.options, this.debug, this.allowAssumptions).useProfilingInfo(false).trackNodeSourcePosition(this.graphBuilderConfig.trackNodeSourcePosition()).method(plugin != null ? plugin.getSubstitute(this.providers.getMetaAccess()) : method).setIsSubstitution(isSubstitution).cancellable(this.graph.getCancellable()).build();
        try (DebugContext.Scope scope = this.debug.scope((Object)"buildGraph", graphToEncode);
             DebugCloseable a = buildGraphTime.start(this.debug);){
            IntrinsicContext initialIntrinsicContext = intrinsicBytecodeProvider != null ? new IntrinsicContext(method, plugin.getSubstitute(this.providers.getMetaAccess()), intrinsicBytecodeProvider, IntrinsicContext.CompilationContext.INLINE_AFTER_PARSING) : null;
            GraphBuilderPhase.Instance graphBuilderPhaseInstance = this.createGraphBuilderPhaseInstance(initialIntrinsicContext);
            graphBuilderPhaseInstance.apply(graphToEncode);
            CanonicalizerPhase.create().apply(graphToEncode, this.providers);
            if (this.postParsingPhase != null) {
                this.postParsingPhase.apply(graphToEncode, this.providers);
            }
        }
        catch (Throwable ex) {
            throw this.debug.handle(ex);
        }
        return graphToEncode;
    }

    @Override
    protected EncodedGraph lookupEncodedGraph(ResolvedJavaMethod method, MethodSubstitutionPlugin plugin, BytecodeProvider intrinsicBytecodeProvider, boolean isSubstitution, boolean trackNodeSourcePosition) {
        EncodedGraph result = (EncodedGraph)this.graphCache.get((Object)method);
        if (result == null && method.hasBytecodes()) {
            result = this.createGraph(method, plugin, intrinsicBytecodeProvider, isSubstitution);
        }
        return result;
    }
}

