/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.compiler.phases.util;

import java.util.ArrayList;
import java.util.List;
import org.graalvm.collections.EconomicMap;
import org.graalvm.collections.Equivalence;
import org.graalvm.compiler.core.common.cfg.Loop;
import org.graalvm.compiler.debug.DebugContext;
import org.graalvm.compiler.debug.GraalError;
import org.graalvm.compiler.graph.GraalGraphError;
import org.graalvm.compiler.graph.Node;
import org.graalvm.compiler.graph.NodeBitMap;
import org.graalvm.compiler.graph.Position;
import org.graalvm.compiler.nodes.AbstractEndNode;
import org.graalvm.compiler.nodes.AbstractMergeNode;
import org.graalvm.compiler.nodes.ConstantNode;
import org.graalvm.compiler.nodes.EndNode;
import org.graalvm.compiler.nodes.FixedNode;
import org.graalvm.compiler.nodes.FrameState;
import org.graalvm.compiler.nodes.FullInfopointNode;
import org.graalvm.compiler.nodes.LoopBeginNode;
import org.graalvm.compiler.nodes.LoopExitNode;
import org.graalvm.compiler.nodes.PhiNode;
import org.graalvm.compiler.nodes.ProxyNode;
import org.graalvm.compiler.nodes.StateSplit;
import org.graalvm.compiler.nodes.StructuredGraph;
import org.graalvm.compiler.nodes.ValueNode;
import org.graalvm.compiler.nodes.VirtualState;
import org.graalvm.compiler.nodes.cfg.Block;
import org.graalvm.compiler.nodes.virtual.VirtualObjectNode;
import org.graalvm.compiler.phases.graph.ReentrantBlockIterator;
import org.graalvm.compiler.phases.graph.StatelessPostOrderNodeIterator;
import org.graalvm.compiler.phases.schedule.SchedulePhase;

public final class GraphOrder {
    private GraphOrder() {
    }

    public static boolean assertNonCyclicGraph(StructuredGraph graph) {
        List<Node> order = GraphOrder.createOrder(graph);
        NodeBitMap visited = graph.createNodeBitMap();
        visited.clearAll();
        for (Node node : order) {
            if (node instanceof PhiNode && ((PhiNode)node).merge() instanceof LoopBeginNode) {
                assert (visited.isMarked(((PhiNode)node).valueAt(0)));
            } else {
                for (Node input : node.inputs()) {
                    if (!visited.isMarked(input) && !(input instanceof FrameState)) assert (false) : "unexpected cycle detected at input " + node + " -> " + input;
                }
            }
            visited.mark(node);
        }
        return true;
    }

    private static List<Node> createOrder(StructuredGraph graph) {
        final ArrayList<Node> nodes = new ArrayList<Node>();
        final NodeBitMap visited = graph.createNodeBitMap();
        new StatelessPostOrderNodeIterator(graph.start()){

            @Override
            protected void node(FixedNode node) {
                GraphOrder.visitForward(nodes, visited, node, false);
            }
        }.apply();
        return nodes;
    }

    private static void visitForward(ArrayList<Node> nodes, NodeBitMap visited, Node node, boolean floatingOnly) {
        try {
            assert (node == null || node.isAlive()) : node + " not alive";
            if (node != null && !visited.isMarked(node)) {
                if (floatingOnly && node instanceof FixedNode) {
                    throw new GraalError("unexpected reference to fixed node: %s (this indicates an unexpected cycle)", node);
                }
                visited.mark(node);
                FrameState stateAfter = null;
                if (node instanceof StateSplit) {
                    stateAfter = ((StateSplit)((Object)node)).stateAfter();
                }
                for (Node node2 : node.inputs()) {
                    if (node2 == stateAfter) continue;
                    GraphOrder.visitForward(nodes, visited, node2, true);
                }
                if (node instanceof EndNode) {
                    EndNode end = (EndNode)node;
                    for (PhiNode phi : end.merge().phis()) {
                        GraphOrder.visitForward(nodes, visited, phi.valueAt(end), true);
                    }
                }
                nodes.add(node);
                if (node instanceof AbstractMergeNode) {
                    for (PhiNode phiNode : ((AbstractMergeNode)node).phis()) {
                        visited.mark(phiNode);
                        nodes.add(phiNode);
                    }
                }
                if (stateAfter != null) {
                    GraphOrder.visitForward(nodes, visited, stateAfter, true);
                }
            }
        }
        catch (GraalError e) {
            throw GraalGraphError.transformAndAddContext(e, node);
        }
    }

    public static boolean assertSchedulableGraph(final StructuredGraph graph) {
        assert (graph.getGuardsStage() != StructuredGraph.GuardsStage.AFTER_FSA) : "Cannot use the BlockIteratorClosure after FrameState Assignment, HIR Loop Data Structures are no longer valid.";
        try (DebugContext.Scope s = graph.getDebug().scope("AssertSchedulableGraph");){
            SchedulePhase schedulePhase = new SchedulePhase(GraphOrder.getSchedulingPolicy(graph), true);
            final EconomicMap loopEntryStates = EconomicMap.create((Equivalence)Equivalence.IDENTITY);
            schedulePhase.apply(graph, false);
            StructuredGraph.ScheduleResult schedule = graph.getLastSchedule();
            ReentrantBlockIterator.BlockIteratorClosure<NodeBitMap> closure = new ReentrantBlockIterator.BlockIteratorClosure<NodeBitMap>(){

                @Override
                protected List<NodeBitMap> processLoop(Loop<Block> loop, NodeBitMap initialState) {
                    return ReentrantBlockIterator.processLoop(this, loop, initialState).exitStates;
                }

                @Override
                protected NodeBitMap processBlock(final Block block, final NodeBitMap currentState) {
                    final List<Node> list = graph.getLastSchedule().getBlockToNodesMap().get(block);
                    FrameState pendingStateAfter = null;
                    for (final Node node : list) {
                        FrameState stateAfter;
                        if (!(node instanceof ValueNode)) continue;
                        FrameState frameState = stateAfter = node instanceof StateSplit ? ((StateSplit)((Object)node)).stateAfter() : null;
                        if (node instanceof FullInfopointNode) {
                            stateAfter = ((FullInfopointNode)node).getState();
                        }
                        if (pendingStateAfter != null && node instanceof FixedNode) {
                            pendingStateAfter.applyToNonVirtual((VirtualState.NodePositionClosure<? super Node>)new VirtualState.NodePositionClosure<Node>(){

                                @Override
                                public void apply(Node from, Position p) {
                                    Node usage = from;
                                    Node nonVirtualNode = p.get(from);
                                    assert (currentState.isMarked(nonVirtualNode) || nonVirtualNode instanceof VirtualObjectNode || nonVirtualNode instanceof ConstantNode) : nonVirtualNode + " not available at virtualstate " + usage + " before " + node + " in block " + block + " \n" + list;
                                }
                            });
                            pendingStateAfter = null;
                        }
                        if (node instanceof AbstractMergeNode) {
                            currentState.markAll(((AbstractMergeNode)node).phis());
                            if (node instanceof LoopBeginNode) {
                                loopEntryStates.put((Object)((LoopBeginNode)node), (Object)currentState.copy());
                            }
                        } else if (node instanceof ProxyNode) {
                            assert (false) : "proxy nodes should not be in the schedule";
                        } else if (node instanceof LoopExitNode) {
                            if (graph.hasValueProxies()) {
                                for (ProxyNode proxy : ((LoopExitNode)node).proxies()) {
                                    for (Node input : proxy.inputs()) {
                                        if (input != proxy.proxyPoint()) assert (currentState.isMarked(input)) : input + " not available at " + proxy + " in block " + block + "\n" + list;
                                    }
                                }
                                currentState.clearAll();
                                currentState.markAll((Iterable)loopEntryStates.get((Object)((LoopExitNode)node).loopBegin()));
                            }
                            currentState.markAll(((LoopExitNode)node).proxies());
                        } else {
                            for (Node input : node.inputs()) {
                                if (input == stateAfter) continue;
                                if (input instanceof FrameState) {
                                    ((FrameState)input).applyToNonVirtual((VirtualState.NodePositionClosure<? super Node>)new VirtualState.NodePositionClosure<Node>(){

                                        @Override
                                        public void apply(Node from, Position p) {
                                            Node nonVirtual = p.get(from);
                                            assert (currentState.isMarked(nonVirtual)) : nonVirtual + " not available at " + node + " in block " + block + "\n" + list;
                                        }
                                    });
                                    continue;
                                }
                                assert (currentState.isMarked(input) || input instanceof VirtualObjectNode || input instanceof ConstantNode) : input + " not available at " + node + " in block " + block + "\n" + list;
                            }
                        }
                        if (node instanceof AbstractEndNode) {
                            AbstractMergeNode merge = ((AbstractEndNode)node).merge();
                            for (PhiNode phi : merge.phis()) {
                                ValueNode phiValue = phi.valueAt((AbstractEndNode)node);
                                assert (phiValue == null || currentState.isMarked(phiValue) || phiValue instanceof ConstantNode) : phiValue + " not available at phi " + phi + " / end " + node + " in block " + block;
                            }
                        }
                        if (stateAfter != null) {
                            assert (pendingStateAfter == null);
                            pendingStateAfter = stateAfter;
                        }
                        currentState.mark(node);
                    }
                    if (pendingStateAfter != null) {
                        pendingStateAfter.applyToNonVirtual((VirtualState.NodePositionClosure<? super Node>)new VirtualState.NodePositionClosure<Node>(){

                            @Override
                            public void apply(Node from, Position p) {
                                Node usage = from;
                                Node nonVirtualNode = p.get(from);
                                assert (currentState.isMarked(nonVirtualNode) || nonVirtualNode instanceof VirtualObjectNode || nonVirtualNode instanceof ConstantNode) : nonVirtualNode + " not available at virtualstate " + usage + " at end of block " + block + " \n" + list;
                            }
                        });
                    }
                    return currentState;
                }

                @Override
                protected NodeBitMap merge(Block merge, List<NodeBitMap> states) {
                    NodeBitMap result = states.get(0);
                    for (int i = 1; i < states.size(); ++i) {
                        result.intersect(states.get(i));
                    }
                    return result;
                }

                @Override
                protected NodeBitMap getInitialState() {
                    NodeBitMap ret = graph.createNodeBitMap();
                    ret.markAll(graph.getNodes().filter(ConstantNode.class));
                    return ret;
                }

                @Override
                protected NodeBitMap cloneState(NodeBitMap oldState) {
                    return oldState.copy();
                }
            };
            ReentrantBlockIterator.apply(closure, schedule.getCFG().getStartBlock());
        }
        catch (Throwable t) {
            graph.getDebug().handle(t);
        }
        return true;
    }

    private static SchedulePhase.SchedulingStrategy getSchedulingPolicy(StructuredGraph graph) {
        return graph.hasValueProxies() ? SchedulePhase.SchedulingStrategy.EARLIEST : SchedulePhase.SchedulingStrategy.LATEST_OUT_OF_LOOPS;
    }
}

