/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.compiler.phases.common.inlining.info;

import java.util.ArrayList;
import java.util.List;
import jdk.vm.ci.meta.ConstantReflectionProvider;
import jdk.vm.ci.meta.DeoptimizationAction;
import jdk.vm.ci.meta.DeoptimizationReason;
import jdk.vm.ci.meta.JavaKind;
import jdk.vm.ci.meta.JavaTypeProfile;
import jdk.vm.ci.meta.ResolvedJavaMethod;
import jdk.vm.ci.meta.ResolvedJavaType;
import org.graalvm.collections.EconomicSet;
import org.graalvm.collections.Equivalence;
import org.graalvm.compiler.core.common.type.StampFactory;
import org.graalvm.compiler.graph.Node;
import org.graalvm.compiler.nodes.AbstractBeginNode;
import org.graalvm.compiler.nodes.AbstractMergeNode;
import org.graalvm.compiler.nodes.BeginNode;
import org.graalvm.compiler.nodes.CallTargetNode;
import org.graalvm.compiler.nodes.DeoptimizeNode;
import org.graalvm.compiler.nodes.EndNode;
import org.graalvm.compiler.nodes.FixedNode;
import org.graalvm.compiler.nodes.FixedWithNextNode;
import org.graalvm.compiler.nodes.FrameState;
import org.graalvm.compiler.nodes.Invoke;
import org.graalvm.compiler.nodes.InvokeWithExceptionNode;
import org.graalvm.compiler.nodes.MergeNode;
import org.graalvm.compiler.nodes.NodeView;
import org.graalvm.compiler.nodes.PhiNode;
import org.graalvm.compiler.nodes.PiNode;
import org.graalvm.compiler.nodes.StructuredGraph;
import org.graalvm.compiler.nodes.ValueNode;
import org.graalvm.compiler.nodes.ValuePhiNode;
import org.graalvm.compiler.nodes.extended.LoadHubNode;
import org.graalvm.compiler.nodes.java.ExceptionObjectNode;
import org.graalvm.compiler.nodes.java.MethodCallTargetNode;
import org.graalvm.compiler.nodes.java.TypeSwitchNode;
import org.graalvm.compiler.nodes.spi.CoreProviders;
import org.graalvm.compiler.nodes.spi.StampProvider;
import org.graalvm.compiler.nodes.util.GraphUtil;
import org.graalvm.compiler.phases.common.inlining.InliningUtil;
import org.graalvm.compiler.phases.common.inlining.info.AbstractInlineInfo;
import org.graalvm.compiler.phases.common.inlining.info.elem.Inlineable;
import org.graalvm.compiler.phases.util.Providers;

public class MultiTypeGuardInlineInfo
extends AbstractInlineInfo {
    private final List<ResolvedJavaMethod> concretes;
    private final double[] methodProbabilities;
    private final double maximumMethodProbability;
    private final ArrayList<Integer> typesToConcretes;
    private final ArrayList<JavaTypeProfile.ProfiledType> ptypes;
    private final double notRecordedTypeProbability;
    private final Inlineable[] inlineableElements;

    public MultiTypeGuardInlineInfo(Invoke invoke, ArrayList<ResolvedJavaMethod> concretes, ArrayList<JavaTypeProfile.ProfiledType> ptypes, ArrayList<Integer> typesToConcretes, double notRecordedTypeProbability) {
        super(invoke);
        assert (concretes.size() > 0) : "must have at least one method";
        assert (ptypes.size() == typesToConcretes.size()) : "array lengths must match";
        this.concretes = concretes;
        this.ptypes = ptypes;
        this.typesToConcretes = typesToConcretes;
        this.notRecordedTypeProbability = notRecordedTypeProbability;
        this.inlineableElements = new Inlineable[concretes.size()];
        this.methodProbabilities = this.computeMethodProbabilities();
        this.maximumMethodProbability = this.maximumMethodProbability();
        assert (this.maximumMethodProbability > 0.0);
        assert (MultiTypeGuardInlineInfo.assertUniqueTypes(ptypes));
    }

    private static boolean assertUniqueTypes(ArrayList<JavaTypeProfile.ProfiledType> ptypes) {
        EconomicSet set = EconomicSet.create((Equivalence)Equivalence.DEFAULT);
        for (JavaTypeProfile.ProfiledType ptype : ptypes) {
            set.add((Object)ptype.getType());
        }
        return set.size() == ptypes.size();
    }

    private double[] computeMethodProbabilities() {
        double[] result = new double[this.concretes.size()];
        for (int i = 0; i < this.typesToConcretes.size(); ++i) {
            int concrete = this.typesToConcretes.get(i);
            double probability = this.ptypes.get(i).getProbability();
            int n = concrete;
            result[n] = result[n] + probability;
        }
        return result;
    }

    private double maximumMethodProbability() {
        double max = 0.0;
        for (int i = 0; i < this.methodProbabilities.length; ++i) {
            max = Math.max(max, this.methodProbabilities[i]);
        }
        return max;
    }

    @Override
    public int numberOfMethods() {
        return this.concretes.size();
    }

    @Override
    public ResolvedJavaMethod methodAt(int index) {
        assert (index >= 0 && index < this.concretes.size());
        return this.concretes.get(index);
    }

    @Override
    public Inlineable inlineableElementAt(int index) {
        assert (index >= 0 && index < this.concretes.size());
        return this.inlineableElements[index];
    }

    @Override
    public double probabilityAt(int index) {
        return this.methodProbabilities[index];
    }

    @Override
    public double relevanceAt(int index) {
        return this.probabilityAt(index) / this.maximumMethodProbability;
    }

    @Override
    public void setInlinableElement(int index, Inlineable inlineableElement) {
        assert (index >= 0 && index < this.concretes.size());
        this.inlineableElements[index] = inlineableElement;
    }

    @Override
    public EconomicSet<Node> inline(CoreProviders providers, String reason) {
        if (this.hasSingleMethod()) {
            return this.inlineSingleMethod(this.graph(), providers.getStampProvider(), providers.getConstantReflection(), reason);
        }
        return this.inlineMultipleMethods(this.graph(), providers, reason);
    }

    @Override
    public boolean shouldInline() {
        for (ResolvedJavaMethod method : this.concretes) {
            if (!method.shouldBeInlined()) continue;
            return true;
        }
        return false;
    }

    private boolean hasSingleMethod() {
        return this.concretes.size() == 1 && !this.shouldFallbackToInvoke();
    }

    private boolean shouldFallbackToInvoke() {
        return this.notRecordedTypeProbability > 0.0;
    }

    private EconomicSet<Node> inlineMultipleMethods(StructuredGraph graph, CoreProviders providers, String reason) {
        Invoke invokeForInlining;
        int numberOfMethods = this.concretes.size();
        FixedNode continuation = this.invoke.next();
        AbstractMergeNode returnMerge = graph.add(new MergeNode());
        returnMerge.setStateAfter(this.invoke.stateAfter());
        PhiNode returnValuePhi = null;
        if (this.invoke.asNode().getStackKind() != JavaKind.Void) {
            returnValuePhi = graph.addWithoutUnique(new ValuePhiNode(this.invoke.asNode().stamp(NodeView.DEFAULT).unrestricted(), returnMerge));
        }
        AbstractMergeNode exceptionMerge = null;
        PhiNode exceptionObjectPhi = null;
        if (this.invoke instanceof InvokeWithExceptionNode) {
            InvokeWithExceptionNode invokeWithException = (InvokeWithExceptionNode)this.invoke;
            ExceptionObjectNode exceptionEdge = (ExceptionObjectNode)invokeWithException.exceptionEdge();
            exceptionMerge = graph.add(new MergeNode());
            FixedNode exceptionSux = exceptionEdge.next();
            graph.addBeforeFixed(exceptionSux, exceptionMerge);
            exceptionObjectPhi = graph.addWithoutUnique(new ValuePhiNode(StampFactory.forKind(JavaKind.Object), exceptionMerge));
            assert (exceptionEdge.stateAfter().bci == this.invoke.bci());
            assert (exceptionEdge.stateAfter().rethrowException());
            exceptionMerge.setStateAfter(exceptionEdge.stateAfter().duplicateModified(JavaKind.Object, JavaKind.Object, exceptionObjectPhi));
        }
        AbstractBeginNode[] successors = new AbstractBeginNode[numberOfMethods + 1];
        for (int i = 0; i < numberOfMethods; ++i) {
            successors[i] = MultiTypeGuardInlineInfo.createInvocationBlock(graph, this.invoke, returnMerge, returnValuePhi, exceptionMerge, exceptionObjectPhi, true);
        }
        FixedNode unknownTypeSux = this.shouldFallbackToInvoke() ? MultiTypeGuardInlineInfo.createInvocationBlock(graph, this.invoke, returnMerge, returnValuePhi, exceptionMerge, exceptionObjectPhi, false) : (FixedNode)graph.add(new DeoptimizeNode(DeoptimizationAction.InvalidateReprofile, DeoptimizationReason.TypeCheckedInliningViolated));
        successors[successors.length - 1] = BeginNode.begin(unknownTypeSux);
        if (this.invoke instanceof InvokeWithExceptionNode) {
            InvokeWithExceptionNode invokeWithExceptionNode = (InvokeWithExceptionNode)this.invoke;
            ExceptionObjectNode exceptionEdge = (ExceptionObjectNode)invokeWithExceptionNode.exceptionEdge();
            exceptionEdge.replaceAtUsages(exceptionObjectPhi);
            exceptionEdge.setNext(null);
            GraphUtil.killCFG(invokeWithExceptionNode.exceptionEdge());
        }
        assert (this.invoke.asNode().isAlive());
        boolean methodDispatch = this.createDispatchOnTypeBeforeInvoke(graph, successors, false, providers.getStampProvider(), providers.getConstantReflection());
        assert (this.invoke.next() == continuation);
        this.invoke.setNext(null);
        returnMerge.setNext(continuation);
        if (returnValuePhi != null) {
            this.invoke.asNode().replaceAtUsages(returnValuePhi);
        }
        this.invoke.asNode().safeDelete();
        ArrayList<PiNode> replacementNodes = new ArrayList<PiNode>();
        for (int i = 0; i < numberOfMethods; ++i) {
            AbstractBeginNode node = successors[i];
            invokeForInlining = (Invoke)((Object)node.next());
            ResolvedJavaType commonType = methodDispatch ? this.concretes.get(i).getDeclaringClass() : this.getLeastCommonType(i);
            ValueNode receiver = ((MethodCallTargetNode)invokeForInlining.callTarget()).receiver();
            boolean exact = this.getTypeCount(i) == 1 && !methodDispatch;
            PiNode anchoredReceiver = InliningUtil.createAnchoredReceiver(graph, node, commonType, receiver, exact);
            invokeForInlining.callTarget().replaceFirstInput(receiver, anchoredReceiver);
            assert (!anchoredReceiver.isDeleted()) : anchoredReceiver;
            replacementNodes.add(anchoredReceiver);
        }
        if (this.shouldFallbackToInvoke()) {
            replacementNodes.add(null);
        }
        EconomicSet canonicalizeNodes = EconomicSet.create((Equivalence)Equivalence.DEFAULT);
        for (int i = 0; i < numberOfMethods; ++i) {
            invokeForInlining = (Invoke)((Object)successors[i].next());
            canonicalizeNodes.addAll(this.doInline(i, invokeForInlining, reason));
        }
        if (returnValuePhi != null) {
            canonicalizeNodes.add((Object)returnValuePhi);
        }
        return canonicalizeNodes;
    }

    protected EconomicSet<Node> doInline(int index, Invoke invokeForInlining, String reason) {
        return MultiTypeGuardInlineInfo.inline(invokeForInlining, this.methodAt(index), this.inlineableElementAt(index), false, reason);
    }

    private int getTypeCount(int concreteMethodIndex) {
        int count = 0;
        for (int i = 0; i < this.typesToConcretes.size(); ++i) {
            if (this.typesToConcretes.get(i) != concreteMethodIndex) continue;
            ++count;
        }
        return count;
    }

    private ResolvedJavaType getLeastCommonType(int concreteMethodIndex) {
        ResolvedJavaType commonType = null;
        for (int i = 0; i < this.typesToConcretes.size(); ++i) {
            if (this.typesToConcretes.get(i) != concreteMethodIndex) continue;
            commonType = commonType == null ? this.ptypes.get(i).getType() : commonType.findLeastCommonAncestor(this.ptypes.get(i).getType());
        }
        assert (commonType != null);
        return commonType;
    }

    private ResolvedJavaType getLeastCommonType() {
        ResolvedJavaType result = this.getLeastCommonType(0);
        for (int i = 1; i < this.concretes.size(); ++i) {
            result = result.findLeastCommonAncestor(this.getLeastCommonType(i));
        }
        return result;
    }

    private EconomicSet<Node> inlineSingleMethod(StructuredGraph graph, StampProvider stampProvider, ConstantReflectionProvider constantReflection, String reason) {
        assert (this.concretes.size() == 1 && this.inlineableElements.length == 1 && this.ptypes.size() > 1 && !this.shouldFallbackToInvoke() && this.notRecordedTypeProbability == 0.0);
        AbstractBeginNode calleeEntryNode = graph.add(new BeginNode());
        AbstractBeginNode unknownTypeSux = MultiTypeGuardInlineInfo.createUnknownTypeSuccessor(graph);
        AbstractBeginNode[] successors = new AbstractBeginNode[]{calleeEntryNode, unknownTypeSux};
        this.createDispatchOnTypeBeforeInvoke(graph, successors, false, stampProvider, constantReflection);
        calleeEntryNode.setNext(this.invoke.asNode());
        return MultiTypeGuardInlineInfo.inline(this.invoke, this.methodAt(0), this.inlineableElementAt(0), false, reason);
    }

    private boolean createDispatchOnTypeBeforeInvoke(StructuredGraph graph, AbstractBeginNode[] successors, boolean invokeIsOnlySuccessor, StampProvider stampProvider, ConstantReflectionProvider constantReflection) {
        int i;
        assert (this.ptypes.size() >= 1);
        ValueNode nonNullReceiver = InliningUtil.nonNullReceiver(this.invoke);
        LoadHubNode hub = graph.unique(new LoadHubNode(stampProvider, nonNullReceiver));
        graph.getDebug().log("Type switch with %d types", this.concretes.size());
        ResolvedJavaType[] keys = new ResolvedJavaType[this.ptypes.size()];
        double[] keyProbabilities = new double[this.ptypes.size() + 1];
        int[] keySuccessors = new int[this.ptypes.size() + 1];
        double totalProbability = this.notRecordedTypeProbability;
        for (i = 0; i < this.ptypes.size(); ++i) {
            keys[i] = this.ptypes.get(i).getType();
            keyProbabilities[i] = this.ptypes.get(i).getProbability();
            totalProbability += keyProbabilities[i];
            int n = keySuccessors[i] = invokeIsOnlySuccessor ? 0 : this.typesToConcretes.get(i);
            assert (keySuccessors[i] < successors.length - 1) : "last successor is the unknownTypeSux";
        }
        keyProbabilities[keyProbabilities.length - 1] = this.notRecordedTypeProbability;
        keySuccessors[keySuccessors.length - 1] = successors.length - 1;
        i = 0;
        while (i < keyProbabilities.length) {
            int n = i++;
            keyProbabilities[n] = keyProbabilities[n] / totalProbability;
        }
        TypeSwitchNode typeSwitch = graph.add(new TypeSwitchNode(hub, successors, keys, keyProbabilities, keySuccessors, constantReflection));
        FixedWithNextNode pred = (FixedWithNextNode)this.invoke.asNode().predecessor();
        pred.setNext(typeSwitch);
        return false;
    }

    private static AbstractBeginNode createInvocationBlock(StructuredGraph graph, Invoke invoke, AbstractMergeNode returnMerge, PhiNode returnValuePhi, AbstractMergeNode exceptionMerge, PhiNode exceptionObjectPhi, boolean useForInlining) {
        Invoke duplicatedInvoke = MultiTypeGuardInlineInfo.duplicateInvokeForInlining(graph, invoke, exceptionMerge, exceptionObjectPhi, useForInlining);
        AbstractBeginNode calleeEntryNode = graph.add(new BeginNode());
        calleeEntryNode.setNext(duplicatedInvoke.asNode());
        EndNode endNode = graph.add(new EndNode());
        duplicatedInvoke.setNext(endNode);
        returnMerge.addForwardEnd(endNode);
        if (returnValuePhi != null) {
            returnValuePhi.addInput(duplicatedInvoke.asNode());
        }
        return calleeEntryNode;
    }

    private static Invoke duplicateInvokeForInlining(StructuredGraph graph, Invoke invoke, AbstractMergeNode exceptionMerge, PhiNode exceptionObjectPhi, boolean useForInlining) {
        Invoke result = (Invoke)((Object)invoke.asNode().copyWithInputs());
        Node callTarget = result.callTarget().copyWithInputs();
        result.asNode().replaceFirstInput(result.callTarget(), callTarget);
        result.setUseForInlining(useForInlining);
        JavaKind kind = invoke.asNode().getStackKind();
        if (kind != JavaKind.Void) {
            FrameState stateAfter = invoke.stateAfter();
            stateAfter = stateAfter.duplicate();
            stateAfter.replaceFirstInput(invoke.asNode(), result.asNode());
            result.setStateAfter(stateAfter);
        }
        if (invoke instanceof InvokeWithExceptionNode) {
            assert (exceptionMerge != null && exceptionObjectPhi != null);
            InvokeWithExceptionNode invokeWithException = (InvokeWithExceptionNode)invoke;
            ExceptionObjectNode exceptionEdge = (ExceptionObjectNode)invokeWithException.exceptionEdge();
            FrameState stateAfterException = exceptionEdge.stateAfter();
            ExceptionObjectNode newExceptionEdge = (ExceptionObjectNode)exceptionEdge.copyWithInputs();
            newExceptionEdge.setStateAfter(stateAfterException.duplicateModified(JavaKind.Object, JavaKind.Object, newExceptionEdge));
            EndNode endNode = graph.add(new EndNode());
            newExceptionEdge.setNext(endNode);
            exceptionMerge.addForwardEnd(endNode);
            exceptionObjectPhi.addInput(newExceptionEdge);
            ((InvokeWithExceptionNode)result).setExceptionEdge(newExceptionEdge);
        }
        return result;
    }

    @Override
    public void tryToDevirtualizeInvoke(Providers providers) {
        if (this.hasSingleMethod()) {
            this.devirtualizeWithTypeSwitch(this.graph(), CallTargetNode.InvokeKind.Special, this.concretes.get(0), providers.getStampProvider(), providers.getConstantReflection());
        } else {
            this.tryToDevirtualizeMultipleMethods(this.graph(), providers.getStampProvider(), providers.getConstantReflection());
        }
    }

    private void tryToDevirtualizeMultipleMethods(StructuredGraph graph, StampProvider stampProvider, ConstantReflectionProvider constantReflection) {
        MethodCallTargetNode methodCallTarget = (MethodCallTargetNode)this.invoke.callTarget();
        if (methodCallTarget.invokeKind() == CallTargetNode.InvokeKind.Interface) {
            ResolvedJavaMethod baseClassTargetMethod;
            ResolvedJavaMethod targetMethod = methodCallTarget.targetMethod();
            ResolvedJavaType leastCommonType = this.getLeastCommonType();
            ResolvedJavaType contextType = this.invoke.getContextType();
            if (!leastCommonType.isInterface() && targetMethod.getDeclaringClass().isAssignableFrom(leastCommonType) && (baseClassTargetMethod = leastCommonType.resolveConcreteMethod(targetMethod, contextType)) != null) {
                this.devirtualizeWithTypeSwitch(graph, CallTargetNode.InvokeKind.Virtual, leastCommonType.resolveConcreteMethod(targetMethod, contextType), stampProvider, constantReflection);
            }
        }
    }

    private void devirtualizeWithTypeSwitch(StructuredGraph graph, CallTargetNode.InvokeKind kind, ResolvedJavaMethod target, StampProvider stampProvider, ConstantReflectionProvider constantReflection) {
        AbstractBeginNode invocationEntry = graph.add(new BeginNode());
        AbstractBeginNode unknownTypeSux = MultiTypeGuardInlineInfo.createUnknownTypeSuccessor(graph);
        AbstractBeginNode[] successors = new AbstractBeginNode[]{invocationEntry, unknownTypeSux};
        this.createDispatchOnTypeBeforeInvoke(graph, successors, true, stampProvider, constantReflection);
        invocationEntry.setNext(this.invoke.asNode());
        ValueNode receiver = ((MethodCallTargetNode)this.invoke.callTarget()).receiver();
        PiNode anchoredReceiver = InliningUtil.createAnchoredReceiver(graph, invocationEntry, target.getDeclaringClass(), receiver, false);
        this.invoke.callTarget().replaceFirstInput(receiver, anchoredReceiver);
        InliningUtil.replaceInvokeCallTarget(this.invoke, graph, kind, target);
    }

    private static AbstractBeginNode createUnknownTypeSuccessor(StructuredGraph graph) {
        return BeginNode.begin(graph.add(new DeoptimizeNode(DeoptimizationAction.InvalidateReprofile, DeoptimizationReason.TypeCheckedInliningViolated)));
    }

    public String toString() {
        int i;
        StringBuilder builder = new StringBuilder(this.shouldFallbackToInvoke() ? "megamorphic" : "polymorphic");
        builder.append(", ");
        builder.append(this.concretes.size());
        builder.append(" methods [ ");
        for (i = 0; i < this.concretes.size(); ++i) {
            builder.append(this.concretes.get(i).format("  %H.%n(%p):%r"));
        }
        builder.append(" ], ");
        builder.append(this.ptypes.size());
        builder.append(" type checks [ ");
        for (i = 0; i < this.ptypes.size(); ++i) {
            builder.append("  ");
            builder.append(this.ptypes.get(i).getType().getName());
            builder.append(this.ptypes.get(i).getProbability());
        }
        builder.append(" ]");
        return builder.toString();
    }
}

