/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.compiler.phases.common;

import java.util.List;
import org.graalvm.collections.EconomicMap;
import org.graalvm.collections.MapCursor;
import org.graalvm.compiler.debug.GraalError;
import org.graalvm.compiler.graph.Node;
import org.graalvm.compiler.graph.NodeMap;
import org.graalvm.compiler.nodes.AbstractBeginNode;
import org.graalvm.compiler.nodes.AbstractMergeNode;
import org.graalvm.compiler.nodes.FixedNode;
import org.graalvm.compiler.nodes.LoopBeginNode;
import org.graalvm.compiler.nodes.LoopEndNode;
import org.graalvm.compiler.nodes.LoopExitNode;
import org.graalvm.compiler.nodes.StartNode;
import org.graalvm.compiler.nodes.StateSplit;
import org.graalvm.compiler.nodes.StructuredGraph;
import org.graalvm.compiler.phases.graph.ReentrantNodeIterator;

public class SnippetFrameStateAssignment {

    public static class SnippetFrameStateAssignmentClosure
    extends ReentrantNodeIterator.NodeIteratorClosure<NodeStateAssignment> {
        private final NodeMap<NodeStateAssignment> stateMapping;
        private static final boolean RUN_WITH_LOG_ON_ERROR = false;
        private final boolean logOnInvalid;

        public NodeMap<NodeStateAssignment> getStateMapping() {
            return this.stateMapping;
        }

        public boolean verify() {
            MapCursor<Node, NodeStateAssignment> stateAssignments = this.stateMapping.getEntries();
            while (stateAssignments.advance()) {
                Node nodeWithState = (Node)stateAssignments.getKey();
                NodeStateAssignment fsRequirements = (NodeStateAssignment)((Object)stateAssignments.getValue());
                switch (fsRequirements) {
                    case INVALID: {
                        throw GraalError.shouldNotReachHere("Invalid snippet replacing a node before FS assignment with node " + nodeWithState + " for graph " + nodeWithState.graph() + " other assignments=" + this.stateMapping);
                    }
                }
            }
            return true;
        }

        public SnippetFrameStateAssignmentClosure(StructuredGraph graph) {
            this(graph, false);
        }

        public SnippetFrameStateAssignmentClosure(StructuredGraph graph, boolean logOnInvalid) {
            this.stateMapping = new NodeMap(graph);
            this.logOnInvalid = logOnInvalid;
        }

        @Override
        protected NodeStateAssignment processNode(FixedNode node, NodeStateAssignment stateAssignment) {
            NodeStateAssignment nextStateAssignment = stateAssignment;
            if (node instanceof LoopExitNode) {
                this.stateMapping.put(node, stateAssignment);
            }
            if (node instanceof StateSplit && ((StateSplit)((Object)node)).hasSideEffect() && !(node instanceof StartNode) && !(node instanceof AbstractMergeNode)) {
                if (stateAssignment == NodeStateAssignment.BEFORE_BCI) {
                    nextStateAssignment = NodeStateAssignment.AFTER_BCI;
                } else {
                    if (this.logOnInvalid) {
                        node.getDebug().log(5, "Node %s creating invalid assignment", (Object)node);
                    }
                    nextStateAssignment = NodeStateAssignment.INVALID;
                }
            }
            return nextStateAssignment;
        }

        @Override
        protected NodeStateAssignment merge(AbstractMergeNode merge, List<NodeStateAssignment> states) {
            int beforeCount = 0;
            int afterCount = 0;
            int invalidCount = 0;
            for (int i = 0; i < states.size(); ++i) {
                if (states.get(i) == NodeStateAssignment.BEFORE_BCI) {
                    ++beforeCount;
                    continue;
                }
                if (states.get(i) == NodeStateAssignment.AFTER_BCI) {
                    ++afterCount;
                    continue;
                }
                ++invalidCount;
            }
            if (invalidCount > 0) {
                this.stateMapping.put(merge, NodeStateAssignment.INVALID);
                return NodeStateAssignment.INVALID;
            }
            if (afterCount == 0) {
                assert (beforeCount == states.size());
                this.stateMapping.put(merge, NodeStateAssignment.BEFORE_BCI);
                return NodeStateAssignment.BEFORE_BCI;
            }
            assert (afterCount > 0);
            this.stateMapping.put(merge, NodeStateAssignment.AFTER_BCI);
            return NodeStateAssignment.AFTER_BCI;
        }

        @Override
        protected NodeStateAssignment afterSplit(AbstractBeginNode node, NodeStateAssignment oldState) {
            return oldState;
        }

        @Override
        protected EconomicMap<LoopExitNode, NodeStateAssignment> processLoop(LoopBeginNode loop, NodeStateAssignment initialState) {
            ReentrantNodeIterator.LoopInfo<NodeStateAssignment> loopInfo = ReentrantNodeIterator.processLoop(this, loop, initialState);
            int afterCount = 0;
            int invalidCount = 0;
            for (LoopEndNode loopEnd : loop.loopEnds()) {
                if (loopInfo.endStates.get((Object)loopEnd) == NodeStateAssignment.INVALID) {
                    ++invalidCount;
                    continue;
                }
                if (loopInfo.endStates.get((Object)loopEnd) != NodeStateAssignment.AFTER_BCI) continue;
                ++afterCount;
            }
            if (invalidCount > 0) {
                this.stateMapping.put(loop, NodeStateAssignment.INVALID);
            } else if (afterCount > 0) {
                this.stateMapping.put(loop, NodeStateAssignment.AFTER_BCI);
            } else {
                this.stateMapping.put(loop, NodeStateAssignment.BEFORE_BCI);
            }
            return loopInfo.exitStates;
        }
    }

    public static enum NodeStateAssignment {
        BEFORE_BCI,
        AFTER_BCI,
        INVALID;

    }
}

