/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.compiler.phases.common;

import org.graalvm.collections.EconomicMap;
import org.graalvm.collections.EconomicSet;
import org.graalvm.collections.Equivalence;
import org.graalvm.collections.MapCursor;
import org.graalvm.compiler.graph.NodeStack;
import org.graalvm.compiler.nodes.AbstractBeginNode;
import org.graalvm.compiler.nodes.AbstractDeoptimizeNode;
import org.graalvm.compiler.nodes.AbstractEndNode;
import org.graalvm.compiler.nodes.AbstractMergeNode;
import org.graalvm.compiler.nodes.ControlSplitNode;
import org.graalvm.compiler.nodes.FixedNode;
import org.graalvm.compiler.nodes.StructuredGraph;
import org.graalvm.compiler.nodes.spi.CoreProviders;
import org.graalvm.compiler.phases.BasePhase;

public class PropagateDeoptimizeProbabilityPhase
extends BasePhase<CoreProviders> {
    @Override
    protected void run(StructuredGraph graph, CoreProviders context) {
        assert (!graph.hasValueProxies()) : "ConvertDeoptimizeToGuardPhase always creates proxies";
        if (graph.hasNode(AbstractDeoptimizeNode.TYPE)) {
            NodeStack stack = new NodeStack();
            EconomicMap reachableSplits = EconomicMap.create((Equivalence)Equivalence.IDENTITY);
            for (AbstractDeoptimizeNode d : graph.getNodes(AbstractDeoptimizeNode.TYPE)) {
                stack.push(AbstractBeginNode.prevBegin(d));
                while (!stack.isEmpty()) {
                    AbstractBeginNode beginNode = (AbstractBeginNode)stack.pop();
                    FixedNode fixedNode = (FixedNode)beginNode.predecessor();
                    if (fixedNode == null) continue;
                    if (fixedNode instanceof AbstractMergeNode) {
                        AbstractMergeNode mergeNode = (AbstractMergeNode)fixedNode;
                        for (AbstractEndNode abstractEndNode : mergeNode.forwardEnds()) {
                            AbstractBeginNode newBeginNode = AbstractBeginNode.prevBegin(abstractEndNode);
                            stack.push(newBeginNode);
                        }
                        continue;
                    }
                    if (fixedNode instanceof ControlSplitNode) {
                        ControlSplitNode controlSplitNode = (ControlSplitNode)fixedNode;
                        EconomicSet reachableSuccessors = (EconomicSet)reachableSplits.get((Object)controlSplitNode);
                        if (reachableSuccessors == null) {
                            reachableSuccessors = EconomicSet.create();
                            reachableSplits.put((Object)controlSplitNode, (Object)reachableSuccessors);
                        }
                        if (controlSplitNode.getSuccessorCount() == reachableSuccessors.size() - 1) {
                            reachableSplits.removeKey((Object)controlSplitNode);
                            stack.push(AbstractBeginNode.prevBegin((FixedNode)controlSplitNode.predecessor()));
                            continue;
                        }
                        reachableSuccessors.add((Object)beginNode);
                        continue;
                    }
                    stack.push(AbstractBeginNode.prevBegin(fixedNode));
                }
            }
            MapCursor entries = reachableSplits.getEntries();
            while (entries.advance()) {
                ControlSplitNode controlSplitNode = (ControlSplitNode)entries.getKey();
                EconomicSet value = (EconomicSet)entries.getValue();
                for (AbstractBeginNode begin : value) {
                    double probability = controlSplitNode.probability(begin);
                    if (probability == 0.0) continue;
                    controlSplitNode.setProbability(begin, 0.0);
                }
            }
        }
    }
}

