/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.compiler.options;

import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.stream.Collectors;
import org.graalvm.collections.EconomicMap;
import org.graalvm.collections.Equivalence;
import org.graalvm.collections.UnmodifiableEconomicMap;
import org.graalvm.collections.UnmodifiableMapCursor;
import org.graalvm.compiler.options.EnumOptionKey;
import org.graalvm.compiler.options.OptionDescriptor;
import org.graalvm.compiler.options.OptionDescriptors;
import org.graalvm.compiler.options.OptionKey;

public class OptionValues {
    private final UnmodifiableEconomicMap<OptionKey<?>, Object> values;
    private static final Object NULL = new Object();
    private static final int PROPERTY_LINE_WIDTH = 80;
    private static final int PROPERTY_HELP_INDENT = 10;

    protected boolean containsKey(OptionKey<?> key) {
        return this.values.containsKey(key);
    }

    public OptionValues(OptionValues initialValues, UnmodifiableEconomicMap<OptionKey<?>, Object> extraPairs) {
        EconomicMap<OptionKey<?>, Object> map = OptionValues.newOptionMap();
        if (initialValues != null) {
            map.putAll(initialValues.getMap());
        }
        OptionValues.initMap(map, extraPairs);
        this.values = map;
    }

    public OptionValues(OptionValues initialValues, OptionKey<?> key1, Object value1, Object ... extraPairs) {
        this(initialValues, (UnmodifiableEconomicMap<OptionKey<?>, Object>)OptionValues.asMap(key1, value1, extraPairs));
    }

    public static EconomicMap<OptionKey<?>, Object> newOptionMap() {
        return EconomicMap.create((Equivalence)Equivalence.IDENTITY);
    }

    public UnmodifiableEconomicMap<OptionKey<?>, Object> getMap() {
        return this.values;
    }

    public static EconomicMap<OptionKey<?>, Object> asMap(OptionKey<?> key1, Object value1, Object ... extraPairs) {
        EconomicMap<OptionKey<?>, Object> map = OptionValues.newOptionMap();
        map.put(key1, value1);
        for (int i = 0; i < extraPairs.length; i += 2) {
            OptionKey key = (OptionKey)extraPairs[i];
            Object value = extraPairs[i + 1];
            map.put((Object)key, value);
        }
        return map;
    }

    public OptionValues(UnmodifiableEconomicMap<OptionKey<?>, Object> values) {
        EconomicMap<OptionKey<?>, Object> map = OptionValues.newOptionMap();
        OptionValues.initMap(map, values);
        this.values = map;
    }

    protected static void initMap(EconomicMap<OptionKey<?>, Object> map, UnmodifiableEconomicMap<OptionKey<?>, Object> values) {
        UnmodifiableMapCursor cursor = values.getEntries();
        while (cursor.advance()) {
            map.put(cursor.getKey(), OptionValues.encodeNull(cursor.getValue()));
        }
    }

    protected <T> T get(OptionKey<T> key) {
        return OptionValues.get(this.values, key);
    }

    protected static <T> T get(UnmodifiableEconomicMap<OptionKey<?>, Object> values, OptionKey<T> key) {
        Object value = values.get(key);
        if (value == null) {
            return key.getDefaultValue();
        }
        return (T)OptionValues.decodeNull(value);
    }

    protected static Object encodeNull(Object value) {
        return value == null ? NULL : value;
    }

    public static Object decodeNull(Object value) {
        return value == NULL ? null : value;
    }

    public String toString() {
        return OptionValues.toString(this.getMap());
    }

    public static String toString(UnmodifiableEconomicMap<OptionKey<?>, Object> values) {
        Comparator comparator = new Comparator<OptionKey<?>>(){

            @Override
            public int compare(OptionKey<?> o1, OptionKey<?> o2) {
                return o1.getName().compareTo(o2.getName());
            }
        };
        TreeMap<Object, Object> sorted = new TreeMap<Object, Object>(comparator);
        UnmodifiableMapCursor cursor = values.getEntries();
        while (cursor.advance()) {
            sorted.put(cursor.getKey(), OptionValues.decodeNull(cursor.getValue()));
        }
        return ((Object)sorted).toString();
    }

    private static List<String> wrap(String text, int width) {
        ArrayList<String> lines = new ArrayList<String>();
        if (text.length() > width) {
            String[] chunks = text.split("\\s+");
            StringBuilder line = new StringBuilder();
            for (String chunk : chunks) {
                if (line.length() + chunk.length() > width) {
                    lines.add(line.toString());
                    line.setLength(0);
                }
                if (line.length() != 0) {
                    line.append(' ');
                }
                line.append(chunk);
            }
            if (line.length() != 0) {
                lines.add(line.toString());
            }
        } else {
            lines.add(text);
        }
        return lines;
    }

    public void printHelp(Iterable<OptionDescriptors> loader, PrintStream out, String namePrefix) {
        String name;
        TreeMap<String, OptionDescriptor> sortedOptions = new TreeMap<String, OptionDescriptor>();
        for (OptionDescriptors optionDescriptors : loader) {
            for (OptionDescriptor desc : optionDescriptors) {
                name = desc.getName();
                OptionDescriptor existing = sortedOptions.put(name, desc);
                assert (existing == null || existing == desc) : "Option named \"" + name + "\" has multiple definitions: " + existing.getLocation() + " and " + desc.getLocation();
            }
        }
        for (Map.Entry entry : sortedOptions.entrySet()) {
            List<String> helpLines;
            OptionDescriptor desc = (OptionDescriptor)entry.getValue();
            Object value = desc.getOptionKey().getValue(this);
            if (value instanceof String) {
                value = '\"' + String.valueOf(value) + '\"';
            } else if (value instanceof String[]) {
                value = '\"' + Arrays.stream((String[])value).collect(Collectors.joining(",")) + '\"';
            }
            name = namePrefix + (String)entry.getKey();
            String assign = this.containsKey(desc.getOptionKey()) ? ":=" : "=";
            String typeName = desc.getOptionKey() instanceof EnumOptionKey ? "String" : desc.getOptionValueType().getSimpleName();
            String linePrefix = String.format("%s %s %s ", name, assign, value);
            int typeStartPos = 80 - typeName.length();
            int linePad = typeStartPos - linePrefix.length();
            if (linePad > 0) {
                out.printf("%s%-" + linePad + "s[%s]%n", linePrefix, "", typeName);
            } else {
                out.printf("%s[%s]%n", linePrefix, typeName);
            }
            String help = desc.getHelp();
            if (help.length() != 0) {
                helpLines = OptionValues.wrap(help, 70);
                helpLines.addAll(desc.getExtraHelp());
            } else {
                helpLines = desc.getExtraHelp();
            }
            for (String line : helpLines) {
                out.printf("%10s%s%n", "", line);
            }
        }
    }
}

