/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.compiler.nodes.type;

import java.util.Iterator;
import jdk.vm.ci.code.CodeUtil;
import jdk.vm.ci.meta.JavaKind;
import jdk.vm.ci.meta.MetaAccessProvider;
import jdk.vm.ci.meta.ResolvedJavaType;
import org.graalvm.compiler.core.common.type.AbstractObjectStamp;
import org.graalvm.compiler.core.common.type.AbstractPointerStamp;
import org.graalvm.compiler.core.common.type.IntegerStamp;
import org.graalvm.compiler.core.common.type.Stamp;
import org.graalvm.compiler.core.common.type.StampFactory;
import org.graalvm.compiler.core.common.type.TypeReference;
import org.graalvm.compiler.nodes.NodeView;
import org.graalvm.compiler.nodes.ValueNode;

public class StampTool {
    public static Stamp meet(Iterable<? extends ValueNode> values) {
        Stamp stamp = StampTool.meetOrNull(values, null);
        if (stamp == null) {
            return StampFactory.forVoid();
        }
        return stamp;
    }

    public static Stamp meetOrNull(Iterable<? extends ValueNode> values, ValueNode selfValue) {
        Iterator<? extends ValueNode> iterator = values.iterator();
        Stamp stamp = null;
        while (iterator.hasNext()) {
            ValueNode nextValue = iterator.next();
            if (nextValue == selfValue) continue;
            if (stamp == null) {
                stamp = nextValue.stamp(NodeView.DEFAULT);
                continue;
            }
            stamp = stamp.meet(nextValue.stamp(NodeView.DEFAULT));
        }
        return stamp;
    }

    public static Stamp unsignedCompare(Stamp stamp, Stamp stamp2) {
        IntegerStamp x = (IntegerStamp)stamp;
        IntegerStamp y = (IntegerStamp)stamp2;
        if (x.isUnrestricted() && y.isUnrestricted()) {
            return null;
        }
        if (x.lowerBound() == x.upperBound()) {
            if (y.isPositive()) {
                if (x.lowerBound() == (long)((1 << x.getBits()) - 1)) {
                    return null;
                }
                if (x.lowerBound() <= y.lowerBound()) {
                    return null;
                }
                return StampFactory.forInteger(x.getBits(), x.lowerBound() + 1L, y.upperBound());
            }
            return null;
        }
        if (y.lowerBound() == y.upperBound() && y.isStrictlyPositive()) {
            return StampFactory.forInteger(y.getBits(), 0L, y.lowerBound() - 1L);
        }
        return null;
    }

    public static Stamp stampForLeadingZeros(IntegerStamp valueStamp) {
        long mask = CodeUtil.mask((int)valueStamp.getBits());
        int adjust = Long.numberOfLeadingZeros(mask);
        assert (adjust == 0 || adjust == 32);
        int min = Long.numberOfLeadingZeros(valueStamp.upMask() & mask) - adjust;
        int max = Long.numberOfLeadingZeros(valueStamp.downMask() & mask) - adjust;
        return StampFactory.forInteger(JavaKind.Int, (long)min, (long)max);
    }

    public static Stamp stampForTrailingZeros(IntegerStamp valueStamp) {
        int bits = valueStamp.getBits();
        long mask = CodeUtil.mask((int)bits);
        int min = Math.min(Long.numberOfTrailingZeros(valueStamp.upMask() & mask), bits);
        int max = Math.min(Long.numberOfTrailingZeros(valueStamp.downMask() & mask), bits);
        return StampFactory.forInteger(JavaKind.Int, (long)min, (long)max);
    }

    public static boolean isPointerAlwaysNull(ValueNode node) {
        return StampTool.isPointerAlwaysNull(node.stamp(NodeView.DEFAULT));
    }

    public static boolean isPointerAlwaysNull(Stamp stamp) {
        if (stamp instanceof AbstractPointerStamp && stamp.hasValues()) {
            return ((AbstractPointerStamp)stamp).alwaysNull();
        }
        return false;
    }

    public static boolean isPointerNonNull(ValueNode node) {
        return StampTool.isPointerNonNull(node.stamp(NodeView.DEFAULT));
    }

    public static boolean isPointerNonNull(Stamp stamp) {
        if (stamp instanceof AbstractPointerStamp) {
            return ((AbstractPointerStamp)stamp).nonNull();
        }
        return false;
    }

    public static TypeReference typeReferenceOrNull(ValueNode node) {
        return StampTool.typeReferenceOrNull(node.stamp(NodeView.DEFAULT));
    }

    public static ResolvedJavaType typeOrNull(ValueNode node) {
        return StampTool.typeOrNull(node.stamp(NodeView.DEFAULT));
    }

    public static ResolvedJavaType typeOrNull(Stamp stamp) {
        TypeReference type = StampTool.typeReferenceOrNull(stamp);
        return type == null ? null : type.getType();
    }

    public static ResolvedJavaType typeOrNull(Stamp stamp, MetaAccessProvider metaAccess) {
        if (stamp instanceof AbstractObjectStamp && stamp.hasValues()) {
            AbstractObjectStamp abstractObjectStamp = (AbstractObjectStamp)stamp;
            ResolvedJavaType type = abstractObjectStamp.type();
            if (type == null) {
                return metaAccess.lookupJavaType(Object.class);
            }
            return type;
        }
        return null;
    }

    public static ResolvedJavaType typeOrNull(ValueNode node, MetaAccessProvider metaAccess) {
        return StampTool.typeOrNull(node.stamp(NodeView.DEFAULT), metaAccess);
    }

    public static TypeReference typeReferenceOrNull(Stamp stamp) {
        if (stamp instanceof AbstractObjectStamp && stamp.hasValues()) {
            AbstractObjectStamp abstractObjectStamp = (AbstractObjectStamp)stamp;
            if (abstractObjectStamp.isExactType()) {
                return TypeReference.createExactTrusted(abstractObjectStamp.type());
            }
            return TypeReference.createTrustedWithoutAssumptions(abstractObjectStamp.type());
        }
        return null;
    }

    public static boolean isExactType(ValueNode node) {
        return StampTool.isExactType(node.stamp(NodeView.DEFAULT));
    }

    public static boolean isExactType(Stamp stamp) {
        if (stamp instanceof AbstractObjectStamp && stamp.hasValues()) {
            return ((AbstractObjectStamp)stamp).isExactType();
        }
        return false;
    }
}

