/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.compiler.nodes.memory.address;

import jdk.vm.ci.meta.JavaKind;
import org.graalvm.compiler.graph.Node;
import org.graalvm.compiler.graph.NodeClass;
import org.graalvm.compiler.nodeinfo.InputType;
import org.graalvm.compiler.nodeinfo.NodeInfo;
import org.graalvm.compiler.nodes.ValueNode;
import org.graalvm.compiler.nodes.memory.address.AddressNode;
import org.graalvm.compiler.nodes.spi.Lowerable;

@NodeInfo(allowedUsageTypes={InputType.Association})
public class IndexAddressNode
extends AddressNode
implements Lowerable {
    public static final NodeClass<IndexAddressNode> TYPE = NodeClass.create(IndexAddressNode.class);
    @Node.Input
    ValueNode array;
    @Node.Input
    ValueNode index;
    private final JavaKind arrayKind;
    private final JavaKind elementKind;

    public IndexAddressNode(ValueNode array, ValueNode index, JavaKind elementKind) {
        this(array, index, elementKind, elementKind);
    }

    public IndexAddressNode(ValueNode array, ValueNode index, JavaKind arrayKind, JavaKind elementKind) {
        super((NodeClass<? extends AddressNode>)TYPE);
        this.array = array;
        this.index = index;
        this.arrayKind = arrayKind;
        this.elementKind = elementKind;
    }

    @Override
    public ValueNode getBase() {
        return this.array;
    }

    public ValueNode getArray() {
        return this.array;
    }

    @Override
    public ValueNode getIndex() {
        return this.index;
    }

    @Override
    public long getMaxConstantDisplacement() {
        return Long.MAX_VALUE;
    }

    public JavaKind getArrayKind() {
        return this.arrayKind;
    }

    public JavaKind getElementKind() {
        return this.elementKind;
    }
}

