/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.compiler.nodes.memory;

import org.graalvm.compiler.core.common.type.StampFactory;
import org.graalvm.compiler.graph.Node;
import org.graalvm.compiler.graph.NodeClass;
import org.graalvm.compiler.graph.NodeInputList;
import org.graalvm.compiler.nodeinfo.InputType;
import org.graalvm.compiler.nodeinfo.NodeInfo;
import org.graalvm.compiler.nodeinfo.NodeSize;
import org.graalvm.compiler.nodes.AbstractMergeNode;
import org.graalvm.compiler.nodes.PhiNode;
import org.graalvm.compiler.nodes.ValueNode;
import org.graalvm.compiler.nodes.memory.SingleMemoryKill;
import org.graalvm.word.LocationIdentity;

@NodeInfo(nameTemplate="Phi({i#values}) {p#locationIdentity/s}", allowedUsageTypes={InputType.Memory}, size=NodeSize.SIZE_0)
public final class MemoryPhiNode
extends PhiNode
implements SingleMemoryKill {
    public static final NodeClass<MemoryPhiNode> TYPE = NodeClass.create(MemoryPhiNode.class);
    @Node.Input(value=InputType.Memory)
    NodeInputList<ValueNode> values;
    protected final LocationIdentity locationIdentity;

    public MemoryPhiNode(AbstractMergeNode merge, LocationIdentity locationIdentity) {
        super(TYPE, StampFactory.forVoid(), merge);
        this.locationIdentity = locationIdentity;
        this.values = new NodeInputList(this);
    }

    public MemoryPhiNode(AbstractMergeNode merge, LocationIdentity locationIdentity, ValueNode[] values) {
        super(TYPE, StampFactory.forVoid(), merge);
        this.locationIdentity = locationIdentity;
        this.values = new NodeInputList((Node)this, (Node[])values);
    }

    public LocationIdentity getLocationIdentity() {
        return this.locationIdentity;
    }

    @Override
    public NodeInputList<ValueNode> values() {
        return this.values;
    }

    @Override
    protected String valueDescription() {
        return this.locationIdentity.toString();
    }

    @Override
    public LocationIdentity getKilledLocationIdentity() {
        return this.getLocationIdentity();
    }
}

