/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.compiler.nodes.java;

import org.graalvm.compiler.graph.NodeClass;
import org.graalvm.compiler.lir.gen.LIRGeneratorTool;
import org.graalvm.compiler.nodeinfo.NodeCycles;
import org.graalvm.compiler.nodeinfo.NodeInfo;
import org.graalvm.compiler.nodeinfo.NodeSize;
import org.graalvm.compiler.nodes.NodeView;
import org.graalvm.compiler.nodes.ValueNode;
import org.graalvm.compiler.nodes.java.AbstractCompareAndSwapNode;
import org.graalvm.compiler.nodes.memory.OnHeapMemoryAccess;
import org.graalvm.compiler.nodes.memory.address.AddressNode;
import org.graalvm.compiler.nodes.spi.NodeLIRBuilderTool;
import org.graalvm.word.LocationIdentity;

@NodeInfo(cycles=NodeCycles.CYCLES_8, size=NodeSize.SIZE_8)
public final class ValueCompareAndSwapNode
extends AbstractCompareAndSwapNode {
    public static final NodeClass<ValueCompareAndSwapNode> TYPE = NodeClass.create(ValueCompareAndSwapNode.class);

    public ValueCompareAndSwapNode(ValueNode address, ValueNode expectedValue, ValueNode newValue, LocationIdentity location) {
        this((AddressNode)address, expectedValue, newValue, location, OnHeapMemoryAccess.BarrierType.NONE);
    }

    public ValueCompareAndSwapNode(AddressNode address, ValueNode expectedValue, ValueNode newValue, LocationIdentity location, OnHeapMemoryAccess.BarrierType barrierType) {
        super(TYPE, address, location, expectedValue, newValue, barrierType, expectedValue.stamp(NodeView.DEFAULT).meet(newValue.stamp(NodeView.DEFAULT)).unrestricted());
    }

    @Override
    public void generate(NodeLIRBuilderTool gen) {
        assert (this.getNewValue().stamp(NodeView.DEFAULT).isCompatible(this.getExpectedValue().stamp(NodeView.DEFAULT)));
        LIRGeneratorTool tool = gen.getLIRGeneratorTool();
        assert (!this.canDeoptimize());
        gen.setResult(this, tool.emitValueCompareAndSwap(tool.getLIRKind(this.getAccessStamp(NodeView.DEFAULT)), gen.operand(this.getAddress()), gen.operand(this.getExpectedValue()), gen.operand(this.getNewValue())));
    }
}

