/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.compiler.nodes.java;

import jdk.vm.ci.meta.Assumptions;
import org.graalvm.compiler.core.common.spi.ForeignCallLinkage;
import org.graalvm.compiler.core.common.type.ObjectStamp;
import org.graalvm.compiler.core.common.type.StampFactory;
import org.graalvm.compiler.graph.Node;
import org.graalvm.compiler.graph.NodeClass;
import org.graalvm.compiler.graph.spi.Canonicalizable;
import org.graalvm.compiler.graph.spi.CanonicalizerTool;
import org.graalvm.compiler.nodeinfo.InputType;
import org.graalvm.compiler.nodeinfo.NodeCycles;
import org.graalvm.compiler.nodeinfo.NodeInfo;
import org.graalvm.compiler.nodeinfo.NodeSize;
import org.graalvm.compiler.nodes.AbstractStateSplit;
import org.graalvm.compiler.nodes.DeoptimizingNode;
import org.graalvm.compiler.nodes.FrameState;
import org.graalvm.compiler.nodes.NodeView;
import org.graalvm.compiler.nodes.ValueNode;
import org.graalvm.compiler.nodes.java.ForeignCallDescriptors;
import org.graalvm.compiler.nodes.spi.LIRLowerable;
import org.graalvm.compiler.nodes.spi.NodeLIRBuilderTool;
import org.graalvm.compiler.nodes.spi.Virtualizable;
import org.graalvm.compiler.nodes.spi.VirtualizerTool;
import org.graalvm.compiler.nodes.virtual.VirtualObjectNode;

@NodeInfo(cycles=NodeCycles.CYCLES_UNKNOWN, cyclesRationale="We cannot estimate the time of a runtime call.", size=NodeSize.SIZE_8, sizeRationale="Rough estimation for register handling & calling")
public final class RegisterFinalizerNode
extends AbstractStateSplit
implements Canonicalizable.Unary<ValueNode>,
LIRLowerable,
Virtualizable,
DeoptimizingNode.DeoptAfter {
    public static final NodeClass<RegisterFinalizerNode> TYPE = NodeClass.create(RegisterFinalizerNode.class);
    @Node.OptionalInput(value=InputType.State)
    FrameState deoptState;
    @Node.Input
    ValueNode value;

    public RegisterFinalizerNode(ValueNode value) {
        super((NodeClass<? extends AbstractStateSplit>)TYPE, StampFactory.forVoid());
        this.value = value;
    }

    @Override
    public ValueNode getValue() {
        return this.value;
    }

    @Override
    public void generate(NodeLIRBuilderTool gen) {
        ForeignCallLinkage linkage = gen.getLIRGeneratorTool().getForeignCalls().lookupForeignCall(ForeignCallDescriptors.REGISTER_FINALIZER);
        gen.getLIRGeneratorTool().emitForeignCall(linkage, gen.state(this), gen.operand(this.getValue()));
    }

    public static boolean mayHaveFinalizer(ValueNode object, Assumptions assumptions) {
        Assumptions.AssumptionResult result;
        ObjectStamp objectStamp = (ObjectStamp)object.stamp(NodeView.DEFAULT);
        if (objectStamp.isExactType()) {
            return objectStamp.type().hasFinalizer();
        }
        if (objectStamp.type() != null && (result = objectStamp.type().hasFinalizableSubclass()).canRecordTo(assumptions)) {
            result.recordTo(assumptions);
            return (Boolean)result.getResult();
        }
        return true;
    }

    public ValueNode canonical(CanonicalizerTool tool, ValueNode forValue) {
        NodeView view = NodeView.from(tool);
        if (!(forValue.stamp(view) instanceof ObjectStamp)) {
            return this;
        }
        if (!RegisterFinalizerNode.mayHaveFinalizer(forValue, this.graph().getAssumptions())) {
            return null;
        }
        return this;
    }

    @Override
    public void virtualize(VirtualizerTool tool) {
        ValueNode alias = tool.getAlias(this.getValue());
        if (alias instanceof VirtualObjectNode && !((VirtualObjectNode)alias).type().hasFinalizer()) {
            tool.delete();
        }
    }

    @Override
    public boolean canDeoptimize() {
        return true;
    }
}

