/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.compiler.nodes.java;

import java.lang.ref.Reference;
import java.util.Collections;
import jdk.vm.ci.meta.ResolvedJavaField;
import jdk.vm.ci.meta.ResolvedJavaType;
import org.graalvm.compiler.core.common.type.StampFactory;
import org.graalvm.compiler.core.common.type.TypeReference;
import org.graalvm.compiler.graph.NodeClass;
import org.graalvm.compiler.nodeinfo.NodeInfo;
import org.graalvm.compiler.nodes.ConstantNode;
import org.graalvm.compiler.nodes.FrameState;
import org.graalvm.compiler.nodes.ValueNode;
import org.graalvm.compiler.nodes.java.AbstractNewObjectNode;
import org.graalvm.compiler.nodes.spi.VirtualizableAllocation;
import org.graalvm.compiler.nodes.spi.VirtualizerTool;
import org.graalvm.compiler.nodes.virtual.VirtualInstanceNode;

@NodeInfo(nameTemplate="New {p#instanceClass/s}")
public class NewInstanceNode
extends AbstractNewObjectNode
implements VirtualizableAllocation {
    public static final NodeClass<NewInstanceNode> TYPE = NodeClass.create(NewInstanceNode.class);
    protected final ResolvedJavaType instanceClass;

    public NewInstanceNode(ResolvedJavaType type, boolean fillContents) {
        this(TYPE, type, fillContents, null);
    }

    public NewInstanceNode(ResolvedJavaType type, boolean fillContents, FrameState stateBefore) {
        this(TYPE, type, fillContents, stateBefore);
    }

    protected NewInstanceNode(NodeClass<? extends NewInstanceNode> c, ResolvedJavaType type, boolean fillContents, FrameState stateBefore) {
        super(c, StampFactory.objectNonNull(TypeReference.createExactTrusted(type)), fillContents, stateBefore);
        assert (!(type.isArray() || type.isInterface() || type.isPrimitive() || type.isAbstract())) : type;
        this.instanceClass = type;
    }

    public ResolvedJavaType instanceClass() {
        return this.instanceClass;
    }

    @Override
    public void virtualize(VirtualizerTool tool) {
        if (!tool.getMetaAccess().lookupJavaType(Reference.class).isAssignableFrom(this.instanceClass)) {
            VirtualInstanceNode virtualObject = new VirtualInstanceNode(this.instanceClass(), true);
            ResolvedJavaField[] fields = virtualObject.getFields();
            ValueNode[] state = new ValueNode[fields.length];
            for (int i = 0; i < state.length; ++i) {
                state[i] = ConstantNode.defaultForKind(tool.getMetaAccessExtensionProvider().getStorageKind(fields[i].getType()), this.graph());
            }
            tool.createVirtualObject(virtualObject, state, Collections.emptyList(), false);
            tool.replaceWithVirtual(virtualObject);
        }
    }
}

