/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.compiler.nodes.java;

import jdk.vm.ci.meta.Assumptions;
import jdk.vm.ci.meta.ConstantReflectionProvider;
import jdk.vm.ci.meta.DeoptimizationAction;
import jdk.vm.ci.meta.DeoptimizationReason;
import jdk.vm.ci.meta.JavaConstant;
import jdk.vm.ci.meta.JavaKind;
import jdk.vm.ci.meta.MetaAccessProvider;
import jdk.vm.ci.meta.ResolvedJavaType;
import org.graalvm.compiler.core.common.calc.CanonicalCondition;
import org.graalvm.compiler.core.common.type.ObjectStamp;
import org.graalvm.compiler.core.common.type.Stamp;
import org.graalvm.compiler.core.common.type.StampFactory;
import org.graalvm.compiler.core.common.type.TypeReference;
import org.graalvm.compiler.graph.Node;
import org.graalvm.compiler.graph.NodeClass;
import org.graalvm.compiler.graph.spi.Canonicalizable;
import org.graalvm.compiler.graph.spi.CanonicalizerTool;
import org.graalvm.compiler.graph.spi.Simplifiable;
import org.graalvm.compiler.graph.spi.SimplifierTool;
import org.graalvm.compiler.nodeinfo.NodeCycles;
import org.graalvm.compiler.nodeinfo.NodeInfo;
import org.graalvm.compiler.nodeinfo.NodeSize;
import org.graalvm.compiler.nodes.ConstantNode;
import org.graalvm.compiler.nodes.DeoptimizeNode;
import org.graalvm.compiler.nodes.FixedGuardNode;
import org.graalvm.compiler.nodes.FixedWithNextNode;
import org.graalvm.compiler.nodes.LogicNode;
import org.graalvm.compiler.nodes.NodeView;
import org.graalvm.compiler.nodes.ValueNode;
import org.graalvm.compiler.nodes.calc.CompareNode;
import org.graalvm.compiler.nodes.extended.GuardingNode;
import org.graalvm.compiler.nodes.java.AccessIndexedNode;
import org.graalvm.compiler.nodes.java.ArrayLengthNode;
import org.graalvm.compiler.nodes.spi.Virtualizable;
import org.graalvm.compiler.nodes.spi.VirtualizerTool;
import org.graalvm.compiler.nodes.type.StampTool;
import org.graalvm.compiler.nodes.virtual.VirtualArrayNode;
import org.graalvm.compiler.nodes.virtual.VirtualObjectNode;

@NodeInfo(cycles=NodeCycles.CYCLES_8, size=NodeSize.SIZE_8)
public class LoadIndexedNode
extends AccessIndexedNode
implements Virtualizable,
Canonicalizable,
Simplifiable {
    public static final NodeClass<LoadIndexedNode> TYPE = NodeClass.create(LoadIndexedNode.class);

    public LoadIndexedNode(Assumptions assumptions, ValueNode array, ValueNode index, GuardingNode boundsCheck, JavaKind elementKind) {
        this((NodeClass<? extends LoadIndexedNode>)TYPE, LoadIndexedNode.createStamp(assumptions, array, elementKind), array, index, boundsCheck, elementKind);
    }

    public static ValueNode create(Assumptions assumptions, ValueNode array, ValueNode index, GuardingNode boundsCheck, JavaKind elementKind, MetaAccessProvider metaAccess, ConstantReflectionProvider constantReflection) {
        ValueNode constant = LoadIndexedNode.tryConstantFold(array, index, metaAccess, constantReflection);
        if (constant != null) {
            return constant;
        }
        return new LoadIndexedNode(assumptions, array, index, boundsCheck, elementKind);
    }

    protected LoadIndexedNode(NodeClass<? extends LoadIndexedNode> c, Stamp stamp, ValueNode array, ValueNode index, GuardingNode boundsCheck, JavaKind elementKind) {
        super(c, stamp, array, index, boundsCheck, elementKind);
    }

    private static Stamp createStamp(Assumptions assumptions, ValueNode array, JavaKind kind) {
        ResolvedJavaType type = StampTool.typeOrNull(array);
        if (kind == JavaKind.Object && type != null && type.isArray()) {
            return StampFactory.object(TypeReference.createTrusted(assumptions, type.getComponentType()));
        }
        JavaKind preciseKind = LoadIndexedNode.determinePreciseArrayElementType(array, kind);
        return StampFactory.forKind(preciseKind);
    }

    private static JavaKind determinePreciseArrayElementType(ValueNode array, JavaKind kind) {
        ResolvedJavaType javaType;
        if (kind == JavaKind.Byte && (javaType = ((ObjectStamp)array.stamp(NodeView.DEFAULT)).type()) != null && javaType.isArray() && javaType.getComponentType() != null && javaType.getComponentType().getJavaKind() == JavaKind.Boolean) {
            return JavaKind.Boolean;
        }
        return kind;
    }

    @Override
    public boolean inferStamp() {
        return this.updateStamp(this.stamp.improveWith(LoadIndexedNode.createStamp(this.graph().getAssumptions(), this.array(), this.elementKind())));
    }

    @Override
    public void virtualize(VirtualizerTool tool) {
        ValueNode alias = tool.getAlias(this.array());
        if (alias instanceof VirtualObjectNode) {
            int idx;
            VirtualArrayNode virtual = (VirtualArrayNode)alias;
            ValueNode indexValue = tool.getAlias(this.index());
            int n = idx = indexValue.isConstant() ? indexValue.asJavaConstant().asInt() : -1;
            if (idx >= 0 && idx < virtual.entryCount()) {
                ValueNode entry = tool.getEntry(virtual, idx);
                if (virtual.isVirtualByteArrayAccess(tool.getMetaAccessExtensionProvider(), this.elementKind())) {
                    if (virtual.canVirtualizeLargeByteArrayUnsafeRead(entry, idx, this.elementKind(), tool)) {
                        tool.replaceWith(VirtualArrayNode.virtualizeByteArrayRead(entry, this.elementKind(), this.stamp));
                    }
                } else if (this.stamp.isCompatible(entry.stamp(NodeView.DEFAULT))) {
                    tool.replaceWith(entry);
                } else assert (this.stamp(NodeView.DEFAULT).getStackKind() == JavaKind.Int && (entry.stamp(NodeView.DEFAULT).getStackKind() == JavaKind.Long || entry.getStackKind() == JavaKind.Double || entry.getStackKind() == JavaKind.Illegal)) : "Can only allow different stack kind two slot marker writes on one stot fields.";
            }
        }
    }

    @Override
    public Node canonical(CanonicalizerTool tool) {
        if (this.array().isNullConstant()) {
            return new DeoptimizeNode(DeoptimizationAction.InvalidateReprofile, DeoptimizationReason.NullCheckException);
        }
        ValueNode constant = LoadIndexedNode.tryConstantFold(this.array(), this.index(), tool.getMetaAccess(), tool.getConstantReflection());
        if (constant != null) {
            return constant;
        }
        return this;
    }

    @Override
    public void simplify(SimplifierTool tool) {
        if (tool.allUsagesAvailable() && this.hasNoUsages()) {
            NodeView view = NodeView.from(tool);
            ValueNode arrayLength = ArrayLengthNode.create(this.array, tool.getConstantReflection());
            LogicNode boundsCheck = CompareNode.createCompareNode(CanonicalCondition.BT, this.index, arrayLength, tool.getConstantReflection(), view);
            if (boundsCheck.isTautology()) {
                return;
            }
            if (this.graph().getGuardsStage().allowsGuardInsertion()) {
                if (!arrayLength.isAlive() && (arrayLength = this.graph().addOrUniqueWithInputs(arrayLength)) instanceof FixedWithNextNode) {
                    FixedWithNextNode fixedArrayLength = (FixedWithNextNode)arrayLength;
                    this.graph().addBeforeFixed(this, fixedArrayLength);
                }
                boundsCheck = this.graph().addOrUniqueWithInputs(boundsCheck);
                FixedGuardNode fixedGuard = new FixedGuardNode(boundsCheck, DeoptimizationReason.BoundsCheckException, DeoptimizationAction.InvalidateReprofile, false, this.getNodeSourcePosition());
                this.graph().replaceFixedWithFixed(this, this.graph().add(fixedGuard));
            }
        }
    }

    private static ValueNode tryConstantFold(ValueNode array, ValueNode index, MetaAccessProvider metaAccess, ConstantReflectionProvider constantReflection) {
        int stableDimension;
        JavaConstant arrayConstant;
        if (array.isConstant() && !array.isNullConstant() && index.isConstant() && (arrayConstant = array.asJavaConstant()) != null && (stableDimension = ((ConstantNode)array).getStableDimension()) > 0) {
            JavaConstant constant = constantReflection.readArrayElement(arrayConstant, index.asJavaConstant().asInt());
            boolean isDefaultStable = ((ConstantNode)array).isDefaultStable();
            if (constant != null && (isDefaultStable || !constant.isDefaultForKind())) {
                return ConstantNode.forConstant(constant, stableDimension - 1, isDefaultStable, metaAccess);
            }
        }
        return null;
    }
}

